/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2010-2012 Michael Koch
*/


var ViewMarksHistory = {

	dbConn: null,
	
	history: Components.classes["@mozilla.org/browser/nav-history-service;1"]
		.getService(Components.interfaces.nsINavHistoryService),


	open: function()
	{
		ViewMarksUtil.openInNewTab("about:viewmarks?folder=history", false);
	},


	openDatabase: function()
	{
		var file = ViewMarksData.getLocalFile("history.sqlite");  
		var storageService = Components.classes["@mozilla.org/storage/service;1"]  
			.getService(Components.interfaces.mozIStorageService);  
		var dbConn = storageService.openDatabase(file); 
		if (!dbConn.tableExists("history")) {
			dbConn.executeSimpleSQL("CREATE TABLE history (url TEXT, title TEXT, date INTEGER, description TEXT, keywords TEXT, accesscount INTEGER, data, width INTEGER, height INTEGER)");  
		}
		return dbConn;
	},


	closeDatabase: function()
	{
		if (this.dbConn.asyncClose) {
			this.dbConn.asyncClose();
		} else {
			this.dbConn.close();
		}
	},


	isKnownURL: function(url)
	{
		var statement = this.dbConn.createStatement("SELECT * FROM history WHERE [url]=:url");
		var isKnown = false;
		try{
			statement.params.url = url;
			if (statement.executeStep()) isKnown = true;
		} catch(e) {}
		statement.reset();
		statement.finalize();
		return isKnown;
	},


	getFirstIndexByURL: function(url)
	{
		for (var i=0; i<ViewMarksGlobal.historyList.length; i++) {
			if (ViewMarksGlobal.historyList[i].uri == url) return i;
		}
		return -1;
	},


	putHash: function(itemId, data, width, height, transparent)
	{
		if (typeof transparent === "undefined") transparent = false;
		var thumbnail = {};
		thumbnail.data = data;
		thumbnail.width = width;
		thumbnail.height = height;
		thumbnail.transparent = transparent;
		ViewMarksGlobal.historyHash.put(itemId, thumbnail);
	},


	createHistoryItem: function(win)
	{
		if (this.dbConn == null) return false;
		if (this.pbservice && this.pbservice.privateBrowsingEnabled == true) return true;

		try {
			// Firefox 20
			Components.utils.import("resource://gre/modules/PrivateBrowsingUtils.jsm");
		  if (PrivateBrowsingUtils.isWindowPrivate(win)) return true;
		} catch (e) {
			try {
				let pbservice = ViewMarksHistory.pbservice = Components.classes["@mozilla.org/privatebrowsing;1"].
					getService(Components.interfaces.nsIPrivateBrowsingService);
				if (pbservice.privateBrowsingEnabled == true) return true;
			} catch (e) {};
		}

		var url = win.location.href;

		if (ViewMarksGlobal.historyList.length > 0 && ViewMarksGlobal.historyList[0].uri == url) {
			ViewMarksGlobal.historyList[0].accessCount++;
			var now = (new Date()).getTime()/1000;
			ViewMarksGlobal.historyList[0].time = now;
/*
			this.dbConn.executeSimpleSQL(
				"UPDATE history SET [accesscount]="+ViewMarksGlobal.historyList[0].accessCount+", [date]="+now+" WHERE [url]='"+url+"'"
			);  
*/
			let statement = this.dbConn.createStatement("UPDATE history SET [accesscount]=:count, [date]=:now WHERE [url]=:url");
			statement.params.count = ViewMarksGlobal.historyList[0].accessCount;
			statement.params.now = now;
			statement.params.url = url;
			statement.execute();
			return false;
		}

		var elapsed = window.performance.now();

		var title = win.document.title;
		var description = ViewMarksData.getPageMeta(win, "description");		  
		var keywords = ViewMarksData.getPageMeta(win, "keywords");
		var data = "";
		var width = 0;
		var height = 0;
		if (win.document.body != undefined) {
			var tmpCanvas = document.createElementNS("http://www.w3.org/1999/xhtml", "html:canvas");
			var doCrop = ViewMarksGlobal.cropBitmapData != undefined;
			if (ViewMarksCapture.snapshot(tmpCanvas, win, doCrop)) {
				var canvas = document.createElementNS("http://www.w3.org/1999/xhtml","html:canvas");
			  canvas.width = ViewMarksData.TN_DEFAULT_WIDTH;
				if (ViewMarksGlobal.resizeBitmapData != undefined) {
				  canvas.height = ViewMarksData.TN_DEFAULT_HEIGHT;
					ViewMarksEdit.paintThumbnail(canvas, tmpCanvas, 0);
				} else {
				  canvas.height = Math.round(canvas.width*tmpCanvas.sh/tmpCanvas.sw);
					canvas.getContext('2d').drawImage(tmpCanvas, 
						tmpCanvas.sx, tmpCanvas.sy, tmpCanvas.sw, tmpCanvas.sh, 
						0, 0, canvas.width, canvas.height);
					canvas.written = true;
				}
				if (canvas.written) {
					data = canvas.toDataURL();
					width = canvas.width;
					height = canvas.height;
				}
			} 
			if (data.length == 0) {
				var type = ViewMarksUtil.getDocumentMimeType(win.document);
				if (type) {
					data = type;
					width = ViewMarksData.TN_DEFAULT_WIDTH;
					height = ViewMarksData.TN_DEFAULT_HEIGHT;
				}
			}
		}

		var entry = {
			itemId:0,
			itemType:ViewMarksData.bookmarks.TYPE_BOOKMARK,
			title:title,
			uri:url,
			accessCount:1,
			time:(new Date()).getTime()/1000,
			description: description,
			keywords: keywords
		};

		var index = this.getFirstIndexByURL(url);
		
		if (index >= 0) {

			entry.accessCount = ViewMarksGlobal.historyList[index].accessCount + 1;
			let statement = this.dbConn.createStatement(
				"UPDATE history SET "
				+"[url]=:url,"
				+"[title]=:title,"
				+"[date]=strftime('%s','now'),"
				+"[description]=:desc,"
				+"[keywords]=:keys,"
				+"[accesscount]=:count,"
				+"[data]=:data,"
				+"[width]=:width,"
				+"[height]=:height "
				+"WHERE [url]=:url"
			);
			statement.params.url = url;
			statement.params.title = title;
			statement.params.desc = escape(description);
			statement.params.keys = escape(keywords);
			statement.params.count = entry.accessCount;
			statement.params.data = data;
			statement.params.width = width;
			statement.params.height = height;
			try {
				statement.execute();
			} catch (e) {
				ViewMarksUtil.logmsg(e+" "+statement);
			}

			entry.itemId = ViewMarksGlobal.historyList[index].itemId;
			ViewMarksGlobal.historyList.splice(index, 1);
			ViewMarksGlobal.historyList.splice(0, 0, entry);
			
			ViewMarksGlobal.historyHash.remove(entry.itemId);

		} else {
			let statement = this.dbConn.createStatement(
				"INSERT INTO history VALUES (:url,:title,strftime('%s','now'),:desc,:keys,:count,:data,:width,:height)"
			);
			statement.params.url = url;
			statement.params.title = escape(title);
			statement.params.desc = escape(description);
			statement.params.keys = escape(keywords);
			statement.params.count = entry.accessCount;
			statement.params.data = data;
			statement.params.width = width;
			statement.params.height = height;
			try {
				//this.dbConn.executeSimpleSQL(stmt);
				statement.execute();
			} catch (e) {
				ViewMarksUtil.logmsg(e+" "+stmt);
			}

			entry.itemId = this.dbConn.lastInsertRowID;
			ViewMarksGlobal.historyList.splice(0, 0, entry);
		}

		if (ViewMarksPref.history_sort_order > 1) {
			this.setSortOrder(ViewMarksPref.history_sort_order);
		}

		elapsed = window.performance.now() - elapsed;
		ViewMarksUtil.logmsg("createHistoryItem: "+Math.floor(elapsed+0.5)+"ms");
		
		return true;
	},


	createBookmark: function(itemId)
	{
		let entry = null;
		for (var i=0; i<ViewMarksGlobal.historyList.length; i++) {
			if (ViewMarksGlobal.historyList[i].itemId == itemId) {
				entry = ViewMarksGlobal.historyList[i];
				break;
			}
		}
		if (entry == null) return;
		
		var argObj = {};
		argObj.action = ViewMarksEdit.DF_CREATE_BOOKMARK;
		argObj.win = {};
		let thumbnail = this.getItemThumbnail(itemId);
		if (thumbnail) argObj.win.thumbnail = thumbnail.data;
		argObj.win.document = {};
		argObj.win.document.title = entry.title;
		argObj.win.document.getElementsByTagName = function() {
			return [{name:"description",content:entry.description},{name:"keywords",content:entry.keywords}];
		};
		argObj.win.location = {};
		argObj.win.location.href = entry.uri;
		
		window.openDialog("chrome://viewmarks/content/editmark.xul", "dlgViewMarksEdit", "centerscreen,chrome,modal", argObj).focus();
	},


	setThumbnailFromMimeType: function(data, itemId, obj, callback)
	{
		var canvas = document.createElementNS("http://www.w3.org/1999/xhtml","html:canvas");
	  canvas.width = ViewMarksData.TN_DEFAULT_WIDTH;
	  canvas.height = ViewMarksData.TN_DEFAULT_HEIGHT;
	  var context = canvas.getContext("2d");
		var img = new Image();
		img.onload = function() {
			context.drawImage(img, 0, 0);
			var data = canvas.toDataURL();
			ViewMarksHistory.putHash(itemId, data, img.width, img.height, true);
			callback(obj, data, img.width, img.height, true);
		}
		img.src = "chrome://viewmarks/skin/docs/doc_"+data.replace("/", "_")+".png";
	},


	getItemThumbnail: function(itemId, obj, callback)
	{
		var value = ViewMarksGlobal.historyHash.get(itemId);
		if (value) {
			if (callback === undefined || callback == null) {
				return value;
			} else {
				callback(obj, value.data, value.width, value.height, value.transparent);
				return null;
			}
		}

		if (this.dbConn == null) return null;
		if (itemId == 0) return null;
		var statement = this.dbConn.createStatement("SELECT * FROM history WHERE rowid=:id");
		try{statement.params.id = itemId;} catch(e) {/*ViewMarksUtil.alert("itemId="+itemId);*/}
		if (callback === undefined || callback == null) {
			var thumbnail = {};
			if (statement.executeStep()) {
				thumbnail.data = statement.row.data;
				thumbnail.width = statement.row.width;
				thumbnail.height = statement.row.height;
			} else {
				thumbnail = null;
			}
			statement.reset();
			statement.finalize();
			ViewMarksGlobal.historyHash.put(itemId, thumbnail);
			return thumbnail;
		} else {
			statement.executeAsync({
				handleResult: function(aResultSet) {
					var row = aResultSet.getNextRow(); 
					while (row) {
						var data = row.getResultByName("data");
						if (data == "" || data.substr(0, 5) == "data:") {						
							var width = row.getResultByName("width");
							var height = row.getResultByName("height");
							ViewMarksHistory.putHash(itemId, data, width, height);
							callback(obj, data, width, height);
						} else {
							ViewMarksHistory.setThumbnailFromMimeType(data, itemId, obj, callback);
						}
						row = aResultSet.getNextRow();
					} 
				},
				handleError: function(aError) {
					ViewMarksUtil.logmsg("handleError "+aReason);
				},
				handleCompletion: function(aReason) {
					if (aReason != 0) ViewMarksUtil.logmsg("handleCompletion "+aReason);
				}
			});
			return null;
		}
	},	

	
	setItemThumbnail: function(itemId, data, width, height)
	{
		if (this.dbConn == null) return;
		//this.dbConn.executeSimpleSQL("UPDATE history SET data='"+data+"',width="+width+",height="+height+" WHERE id='"+itemId+"'");  
		let statement = this.dbConn.createStatement(
			"UPDATE history SET data=:data,width=:width,height=:height WHERE id=:id"
		);
		statement.params.data = data;
		statement.params.width = width;
		statement.params.height = height;
		statement.params.id = itemId;
		statement.execute();
	},	


	deleteItemThumbnail: function(itemId)
	{
		if (this.dbConn == null) return;
		//this.dbConn.executeSimpleSQL("DELETE FROM history WHERE id='"+itemId+"'");  
		let statement = this.dbConn.createStatement("DELETE FROM history WHERE id=:id");
		statement.params.id = itemId;
		statement.execute();
	},

/*
	onTabPopup: function(event)
	{
		try {
		var tooltip = event.target;
		var tab = document.tooltipNode;
		//tooltip.anchorNode = tab;
		var tabbrowser = document.getElementById("content");
		var browser = tabbrowser.getBrowserForTab(tab);
		if (browser) {
			var doc = browser.contentDocument;
			
		}
	} catch(e) {ViewMarksUtil.alert(e);}
	},
*/

	setSortOrder: function(order)
	{
		ViewMarksGlobal.historyList.sort(
			function(a, b) {
				if (order == 2) {
					var diff = b.accessCount - a.accessCount;
					if (diff != 0) return diff;
				}
				return b.time - a.time;
			}
		);
	},


	clearHistory: function(dontask)
	{
		if (this.dbConn == null) return;
		if (!dontask && ViewMarksPopup.open(
			ViewMarksUtil.getString("delete_history"), 
			ViewMarksUtil.getString("ask_delete_history"),
			ViewMarksPopup.MB_OK|ViewMarksPopup.MB_CANCEL|ViewMarksPopup.MB_ICON_WARNING) == false) return;
		ViewMarksGlobal.historyHash = new ViewMarksHashtable();
		ViewMarksGlobal.historyList = new Array();
		this.dbConn.executeSimpleSQL("DELETE FROM history");
	},


	deleteOutdatedHistoryItems: function()
	{
		if (this.dbConn == null) return;

		if (ViewMarksPref.create_history == false) {
			this.dbConn.executeSimpleSQL("DELETE FROM history");
			return;
		}

		let duration = ViewMarksPref.history_duration * 24 * 60 * 60;
		let now = new Date();
		let midnight = new Date(now.getFullYear(), now.getMonth(), now.getDate(), 0, 0, 0, 0);
		let unixdate = Math.floor(midnight.getTime() / 1000) - duration;
		let count = 0;
		if (ViewMarksGlobal.historyList != null) {
			for (var index = 0; index < ViewMarksGlobal.historyList.length; index++) {
				if (ViewMarksGlobal.historyList[index].time < unixdate) {
					ViewMarksGlobal.historyList.splice(index, 1);
					index--;
					count++;
				}
			}
			ViewMarksUtil.logmsg("removed "+count+" outdated history items");
		}
		try {
			let statement = this.dbConn.createStatement("DELETE FROM history WHERE (CAST([date] AS INTEGER) < :limit)");
			statement.params.limit = unixdate;
			statement.executeAsync({
				handleResult: function(aResultSet) {},
				handleError: function(aError) {
					ViewMarksUtil.logmsg("deleteOutdatedHistoryItems: db error "+aReason);
				},
				handleCompletion: function(aReason) {}
			});
		} catch (e) {
			ViewMarksUtil.logerror(e);
		}
	},


	initHistoryList: function()
	{
		if (this.dbConn == null) return;
		if (ViewMarksGlobal.historyList != null) return;
		var elapsed = window.performance.now();
		ViewMarksPref.init();
		ViewMarksGlobal.historyHash = new ViewMarksHashtable();
		ViewMarksGlobal.historyList = new Array();
		let stmt = "SELECT rowid,* FROM history ORDER BY ";
		let order = ViewMarksPref.history_sort_order;
		if (order == 2) stmt += "CAST([accesscount] AS INTEGER) DESC"
			else stmt += "CAST([date] AS INTEGER) DESC";
		let statement = this.dbConn.createStatement(stmt);
		statement.executeAsync({
			handleResult: function(aResultSet) {
				var row = aResultSet.getNextRow(); 
				while (row) {
					var entry = {
						itemId:row.getResultByName("rowid"),
						itemType:ViewMarksData.bookmarks.TYPE_BOOKMARK,
						title:unescape(row.getResultByName("title")),
						uri:row.getResultByName("url"),
						accessCount:row.getResultByName("accesscount"),
						time:row.getResultByName("date"),
						description: unescape(row.getResultByName("description")),
						keywords: unescape(row.getResultByName("keywords"))
					};
					ViewMarksGlobal.historyList.push(entry);
					row = aResultSet.getNextRow();
				} 
			},
			handleError: function(aError) {
				ViewMarksUtil.logmsg("handleError "+aReason);
			},
			handleCompletion: function(aReason) {
				if (aReason != 0) ViewMarksUtil.logmsg("handleCompletion "+aReason);
				elapsed = window.performance.now() - elapsed;
				ViewMarksUtil.logmsg("initHistoryList: "+Math.floor(elapsed+0.5)+"ms");
				ViewMarksHistory.deleteOutdatedHistoryItems();
				ViewMarksUtil.logmsg("history list: "+ViewMarksGlobal.historyList.length+" items");
				if (order == 1) {
					let oldest = ViewMarksGlobal.historyList[ViewMarksGlobal.historyList.length-1].time;
					ViewMarksUtil.logmsg("history list: oldest item from " + new Date(oldest*1000).toLocaleString());
				}
			}
		});
	},


	showHistory: function()
	{
		if (ViewMarksPref.create_history && ViewMarksPref.replace_history_sidebar) {
			ViewMarksUtil.openInNewTab("about:viewmarks?folder=history", false);
		} else {
			toggleSidebar('viewHistorySidebar');
		}
	},


	init: function() 
	{
		ViewMarksHistory.dbConn = ViewMarksHistory.openDatabase();
		if (ViewMarksGlobal.historyList == null) {
			ViewMarksHistory.initHistoryList();
		}
	}

};


ViewMarksHistory.init();
