/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2009-2013 Michael Koch
*/

var ViewMarksImport = {

	doStat: function(file)
	{
		var argObj = {file: file, fResult: true};
		window.openDialog("chrome://viewmarks/content/import.xul", "dlgViewMarksImport", "centerscreen,chrome,modal", argObj).focus();
		return argObj.fResult;
	},

	doImport: function(file)
	{
		var argObj = {file: file, fResult: true};
		window.openDialog("chrome://viewmarks/content/progress.xul", "dlgViewMarksProgress", "centerscreen,chrome,modal", argObj).focus();
		return argObj.fResult;
	},

	tn_array: null,
	tn_index: 0,

	onImportTimer: function()
	{
		var overwrite = ViewMarksPref.overwrite_on_import;
		var progress = document.getElementById("vmks_progress_bar");

		if (ViewMarksImport.tn_array == null) return;
		if (ViewMarksImport.tn_index >= ViewMarksImport.tn_array.length) {
			ViewMarksImport.tn_array = null;
			ViewMarksImport.tn_index = 0;
			window.close();
		}

		var impobj = ViewMarksImport.tn_array[ViewMarksImport.tn_index];
		var idlist = ViewMarksData.getBookmarksByURL(impobj.url);
		if (idlist) {
			for (var j=0; j<idlist.length; j++) {
				var itemId = idlist[j];
				var thumbnail = ViewMarksData.getItemThumbnail(itemId);
				if (thumbnail) {
					if (thumbnail.data != impobj.data && overwrite == true) {
						ViewMarksData.setItemThumbnail(itemId, impobj.data, impobj.width, impobj.height);
					}
				} else {
					ViewMarksData.setItemThumbnail(itemId, impobj.data, impobj.width, impobj.height);
				}
			}
		}

		if (progress) {
			var value = Math.floor(100*(ViewMarksImport.tn_index+1)/ViewMarksImport.tn_array.length);
			if (value != progress.value) {
				progress.value = value;
			}
		}

		ViewMarksImport.tn_index++;
	},



	getDatabaseStat: function(file)
	{
		var tn_array = ViewMarksData.readObjectFromFile(file);
		if (tn_array == null) return;

		var stat = {};
		stat.cnt_new = 0;		
		stat.cnt_present = 0;		
		stat.cnt_change = 0;		

		for (var i=0; i<tn_array.length; i++) {
			var impobj = tn_array[i];
			var idlist = ViewMarksData.getBookmarksByURL(impobj.url);
			if (idlist) {
				for (var j=0; j<idlist.length; j++) {
					var itemId = idlist[j];
					var thumbnail = ViewMarksData.getItemThumbnail(itemId);
					if (thumbnail) {
						if (thumbnail.data == impobj.data) {
							stat.cnt_present++;
						} else {
							stat.cnt_change++;
						}
					} else {
						stat.cnt_new++;
					}
				}
			}
		}

		document.getElementById("vmks_import_tnnew").value = stat.cnt_new;
		document.getElementById("vmks_import_tnpresent").value = stat.cnt_present;
		document.getElementById("vmks_import_tnchange").value = stat.cnt_change;
		if (stat.cnt_change == 0) {
			document.getElementById("vmks_overwrite_on_import").setAttribute("disabled", true);
		}
		if (stat.cnt_new == 0 && stat.cnt_change == 0) {
			document.getElementById("dlgViewMarksImport").setAttribute("buttondisabledaccept", true);
		}
		
	},

	
	initStat: function()
	{
		ViewMarksPref.init();
		var overwrite = ViewMarksPref.overwrite_on_import;
		document.getElementById("vmks_overwrite_on_import").checked = overwrite;
		window.sizeToContent();
		this.getDatabaseStat(window.arguments[0].file);
	},
	
	onStatAccept: function()
	{
		var checkbox = document.getElementById("vmks_overwrite_on_import").checked;
		//ViewMarksUtil.alert(checkbox);
		ViewMarksPref.prefs.setBoolPref("overwrite_on_import", checkbox == true);
		window.arguments[0].fResult = true;
		return true;
	},
	
	onStatCancel: function()
	{
		window.arguments[0].fResult = false;
		return true;
	},

	initImport: function()
	{
		try {
			ViewMarksPref.init();
			var overwrite = ViewMarksPref.overwrite_on_import;
			window.sizeToContent();

			ViewMarksImport.tn_array = ViewMarksData.readObjectFromFile(window.arguments[0].file);
			if (ViewMarksImport.tn_array == null) {window.close();return;}
			ViewMarksImport.tn_index = 0;
			window.setInterval(function(){ViewMarksImport.onImportTimer();}, 0);

		} catch(e) {ViewMarksUtil.alert(e);}
	}
	


};

