﻿/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2010-2013 Michael Koch
*/


var ViewMarks = {

	bookmarks: Components.classes["@mozilla.org/browser/nav-bookmarks-service;1"]
		.getService(Components.interfaces.nsINavBookmarksService),


	createBookmark: function() 
	{
		if (ViewMarksPref.replace_add) {
			ViewMarksEdit.open(ViewMarksEdit.DF_CREATE_BOOKMARK, 0);
		} else {
			PlacesCommandHook.bookmarkCurrentPage(true, PlacesUtils.bookmarksMenuFolderId);
		}
	},


	createLinkBookmark: function() 
	{
		if (ViewMarksPref.replace_add) {
			// tbd
			gContextMenu.bookmarkLink();
		} else {
			gContextMenu.bookmarkLink();
		}
	},


	onToolbarButton: function()
	{
		switch (ViewMarksPref.toolbar_action) {
			case 0: ViewMarksView.open(); break;
			case 1: ViewMarksEdit.open(ViewMarksEdit.DF_CREATE_BOOKMARK, 0); break;
			default: ViewMarksView.open(); break;
		}
	},


	onPopup: function(event, id)
	{
		var itemId = ViewMarksData.getBookmarkByURL(content.document.location.href);
		var elem = document.getElementById(id);
		if (itemId > 0) {
			elem.setAttribute("image", "chrome://viewmarks/skin/edit_grey.png");
			elem.setAttribute("label", ViewMarksUtil.getString("menu_edit_viewmark"));
		} else {
			elem.setAttribute("image", "chrome://viewmarks/skin/add.png");
			elem.setAttribute("label", ViewMarksUtil.getString("menu_add_viewmark"));
		}
	},


	setOpenCommand: function(id, itemId)
	{
		ViewMarksUtil.setElementAttribute(id, "oncommand", "ViewMarksUtil.openInNewTab('about:viewmarks?folder="+Math.floor(itemId)+"', false);");
	},
	

	onToolbarPopup: function(event)
	{
		ViewMarksData.refreshFolderCount();
		ViewMarksUtil.showElement("vmks_menupopup_toolbar_open_toolbar", ViewMarksData.toolbarCount > 0);
		ViewMarks.setOpenCommand("vmks_menupopup_toolbar_open_toolbar", ViewMarks.bookmarks.toolbarFolder);
		ViewMarksUtil.showElement("vmks_menupopup_toolbar_open_unsorted", ViewMarksData.unfiledCount > 0);
		ViewMarks.setOpenCommand("vmks_menupopup_toolbar_open_unsorted", ViewMarks.bookmarks.unfiledBookmarksFolder);
		ViewMarksUtil.showElement("vmks_menupopup_toolbar_open_most_visited", ViewMarksPref.show_most_visited);
		ViewMarks.setOpenCommand("vmks_menupopup_toolbar_open_most_visited", ViewMarksData.mostVisitedFolder);
		ViewMarksUtil.showElement("vmks_menupopup_toolbar_open_last_visited", ViewMarksPref.show_last_visited);
		ViewMarks.setOpenCommand("vmks_menupopup_toolbar_open_last_visited", ViewMarksData.lastVisitedFolder);
		ViewMarksUtil.showElement("vmks_menupopup_toolbar_open_history", ViewMarksPref.create_history);
		ViewMarksUtil.showElement("vmks_menupopup_toolbar_open_trash", ViewMarksPref.create_trash);

		ViewMarks.onPopup(event, "vmks_menupopup_toolbar_add");

		document.getElementById("vmks_menupopup_toolbar_open").setAttribute("default", ViewMarksPref.toolbar_action == 0);
		document.getElementById("vmks_menupopup_toolbar_add").setAttribute("default", ViewMarksPref.toolbar_action == 1);
	},

	onToolsPopup: function(event)
	{
		ViewMarks.onPopup(event, "vmks_menupopup_tools_add");
	},

	onStatusPopup: function(event)
	{
		ViewMarks.onPopup(event, "vmks_status_popup_add");
	},

	onToolbarButtonTooltip: function(event)
	{
		//ViewMarksUtil.logmsg("onToolbarButtonTooltip: "+document.tooltipNode.childNodes[0].tagName)
		let node = document.getElementById("vmks_button_tooltip");
		if (ViewMarksPref.toolbar_action == 0) {
			node.setAttribute("label", ViewMarksUtil.getString("menu_open_viewmarks"));
		}
		if (ViewMarksPref.toolbar_action == 1) {
			let itemId = ViewMarksData.getBookmarkByURL(content.document.location.href);
			if (itemId > 0) {
				node.setAttribute("label", ViewMarksUtil.getString("menu_edit_viewmark"));
			} else {
				node.setAttribute("label", ViewMarksUtil.getString("menu_add_viewmark"));
			}
		}
	},

	onStarButton: function(event)
	{
		if (ViewMarksPref.replace_edit) {
			if (document.getElementById("star-button").getAttribute("starred") || ViewMarksPref.menu_for_unfiled) {
				ViewMarksEdit.open(ViewMarksEdit.DF_CREATE_BOOKMARK, 0);
			} else {
				ViewMarksEdit.setQuickBookmark(ViewMarksUtil.getBrowser().contentWindow, null, 
					this.bookmarks.unfiledBookmarksFolder);
			}
		} else {
			PlacesStarButton.onClick(event);
		}
	},


	winOuterHeight: 0,

	onDOMLoad: function(event)
	{
		if (event.originalTarget instanceof HTMLDocument) {  
			try {
			var win = event.originalTarget.defaultView;  
			if (win.frameElement) return;  
			let href_uri = 	ViewMarksUtil.getURIFromString(win.location.href);
			let newtab_uri = 	ViewMarksUtil.getURIFromString(ViewMarksPref.getBrowserCharPref("newtab.url"));
			if (href_uri.equals(newtab_uri)) {
				win.focus();
			}
			if (win.location.href == "about:blank") {
				if (ViewMarksPref.empty_tab_url != "" && ViewMarksPref.empty_tab_url != "about:blank") {
					win.location.href = ViewMarksPref.empty_tab_url;
					win.focus();
				}
			}
		} catch (e) {alert(e);}
		}  
	},


	once: false,

	onPageLoad: function(event)
	{
		try {
			if (typeof HTMLDocument == 'undefined') return;
			if (event.originalTarget instanceof HTMLDocument) {  
				var win = event.originalTarget.defaultView;  
				if (win.frameElement) return;  
				ViewMarksUtil.logmsg(win.location.href);
				if (ViewMarksPref.autofetch_thumbnail == true) {
					var itemIdList = ViewMarksData.getBookmarkIdsForURL(win.location.href);
					if (itemIdList.length > 0) {
						//ViewMarksUtil.logmsg("ViewMarks: create thumbnail(s) for "+win.location.href);
						try {
							setTimeout(function() {
								for (var i=0; i<itemIdList.length; i++) {
									ViewMarksEdit.setQuickBookmark(win, itemIdList[i], null); 
								}
							}, 900);
						} catch (e) {/* Bug 580570 */}
					}
				}
				if (ViewMarksPref.create_history) {
					setTimeout(
						function() {
							if (ViewMarksHistory.createHistoryItem(win)) {
								ViewMarksUtil.dispatchGlobalEvent("history-changed");
							}
						}, 1200);
				}
			}  
/*
			if (ViewMarksGlobal.once === undefined) {
				ViewMarksGlobal.once = true;
				try {
					ViewMarksAdvice.open("title", "message", 0);
				} catch (e) {ViewMarksUtil.alert(e);}
			}
*/ 
		} catch (e) {
			ViewMarksUtil.logerror(e);
		}
	},


	bookmarkObserver: {
	  inBatch: false,
	  onBeginUpdateBatch: function() {
	  	//ViewMarksUtil.logmsg("bookmarkObserver:onBeginUpdateBatch");
	  	this.inBatch = true;
	  },
	  onEndUpdateBatch: function() {
	  	//ViewMarksUtil.logmsg("bookmarkObserver:onEndUpdateBatch");
	  	ViewMarksTrash.relinkTrash();
	  	this.inBatch = false;
	  },
	  onBeforeItemRemoved: function(id, type, parentId, guid, parentGuid) {
	  },
	  onItemAdded: function(id, folder, index) {},
	  onItemRemoved: function(id, folder, index) {
/*
	  	if (ViewMarksPref.create_trash) {
		  	//ViewMarksUtil.logmsg("bookmarkObserver:onItemRemoved id="+id+" type="+ViewMarksData.getItemType(id));
	  		ViewMarksTrash.moveItemToTrash(id, ViewMarksData.getItemType(id));
	  	} 
*/
  		ViewMarksData.deleteItemThumbnail(id);
	  },
	  onItemChanged: function(id, property, isAnnotationProperty, value, aLastModified, aItemType, aParentId, aGUID, aParentGUID) {
	  	//ViewMarksUtil.logmsg("bookmarkObserver:onItemChanged");
/*
	  	if (property == "" && ViewMarksPref.create_trash) {
	  		ViewMarksTrash.moveItemToTrash(id, aItemType);
	  	} 
*/
	  },
	  onItemVisited: function(id, visitID, time) {},
	  onItemMoved: function(id, oldParent, oldIndex, newParent, newIndex) {
	  	//ViewMarksUtil.alert("moved '"+ViewMarksData.getItemTitle(id)+"' ("+id+") from '"+ViewMarksData.getItemPath(oldParent)+" » "+ViewMarksData.getItemTitle(oldParent)+"' ("+oldParent+"/"+oldIndex+") to '"+ViewMarksData.getItemPath(newParent)+" » "+ViewMarksData.getItemTitle(newParent)+"' ("+newParent+"/"+newIndex+")");
	  },
	  QueryInterface: function(iid) {
	    if (iid.equals(Components.interfaces.nsINavBookmarkObserver) ||
	        iid.equals(Components.interfaces.nsISupports)) {
	      return this;
	    }
	    throw Components.results.NS_ERROR_NO_INTERFACE;
	  },
	},


	init: function(event)
	{
		ViewMarksPref.init();
		setTimeout(function(){ViewMarksView.init();}, 1000);
		ViewMarks.bookmarks.addObserver(ViewMarks.bookmarkObserver, false);		
		ViewMarksUtil.getBrowser().addEventListener("load", ViewMarks.onPageLoad, true);
		ViewMarksUtil.getBrowser().addEventListener("DOMContentLoaded", ViewMarks.onDOMLoad, true);
		//ViewMarksUtil.getBrowser().tabContainer.addEventListener("TabOpen", ViewMarks.onTabOpen, true);
		setTimeout(function() {ViewMarksUtil.checkForUpdate();}, 3000);

		ViewMarksTrash.createTrashFolder();
		ViewMarksTrash.update();
		ViewMarksTrash.deleteOutdatedTrashItems();
		
		ViewMarksData.refreshFolderCount();
		
		if (ViewMarksPref.getBoolPref("installed") == false) {
			ViewMarksPref.prefs.setBoolPref("installed", true);
			document.getElementById("nav-bar").insertItem("vmks_button");
			var currentset = document.getElementById("nav-bar").currentSet;
			document.getElementById("nav-bar").setAttribute("currentset", currentset);
			document.persist("nav-bar", "currentset"); 	
		}

		if (ViewMarksPref.getCharPref("ref").length == 0) {
			let uuid = ViewMarksData.uuidGenerator.generateUUID().toString();	
			ViewMarksPref.prefs.setCharPref("ref", uuid)	
		}

		ViewMarksUtil.showElement("vmks_qrcode_button", ViewMarksPref.getBoolPref("show_qrcode_urlbar"));

		let node = document.getElementById("placesCmd_delete");
		if (node) {
			node.setAttribute("oncommand", "ViewMarks.deleteBookmark();"+node.getAttribute("oncommand"));
		}

		document.getElementById("vmks_menupopup_tools").addEventListener("popupshowing", ViewMarks.onToolsPopup, false);
		document.getElementById("vmks_menupopup_toolbar").addEventListener("popupshowing", ViewMarks.onToolbarPopup, false);
		document.getElementById("vmks_status_popup").addEventListener("popupshowing", ViewMarks.onStatusPopup, false);
	
		ViewMarksUtil.addSystemInfoAttributes("main-window");
		ViewMarksUtil.showElement("vmks_status", ViewMarksPref.getBoolPref("statusbar"));

		if (ViewMarksPref.update) {
			setTimeout(function() {ViewMarksUpdate.update()}, 60*1000);
		}

	},

};


window.addEventListener('load', ViewMarks.init, false);

