/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2009-2012 Michael Koch
*/

var ViewMarksPopup = {

	MB_MASK: 0xff, 
	MB_OK: 1, 
	MB_CANCEL: 2,
	
	MB_ICON_MASK: 0xff00, 
	MB_ICON_INFO: 0, 
	MB_ICON_WARNING: 0x0100, 
	MB_ICON_ERROR: 0x0200, 
	MB_ICON_ASK: 0x0300,


	open: function(title, msg, flags)
	{
		var argObj = {title: title, msg: msg, flags: flags, fResult: true};
		window.openDialog("chrome://viewmarks/content/messagebox.xul", "dlgViewMarksPopup", "centerscreen,chrome,modal", argObj).focus();
		return argObj.fResult;
	},
	
	init: function()
	{
		var title = window.arguments[0].title;
		if (title == null || title == "") title = "ViewMarks";
		document.getElementById("dlgViewMarksPopup").setAttribute("title", title);
		var msg_node = document.createTextNode(window.arguments[0].msg);
		document.getElementById("vmks_mb_msg").appendChild(msg_node);
		var flags = window.arguments[0].flags;
		if ((flags & this.MB_MASK) == 0) flags |= this.MB_OK; // default button
		if ((flags & this.MB_OK) == 0) document.documentElement.getButton("accept").collapsed = true;
		if ((flags & this.MB_CANCEL) == 0) document.documentElement.getButton("cancel").collapsed = true;
		var cssclass = "message-icon";
		switch (flags & this.MB_ICON_MASK) {
			case this.MB_ICON_ERROR: cssclass = "error-icon"; break;
			case this.MB_ICON_WARNING: cssclass = "alert-icon"; break;
			case this.MB_ICON_ASK: cssclass = "question-icon"; break;
			case this.MB_ICON_INFO: cssclass = "message-icon"; break;
		}
		document.getElementById("vmks_mb_icon").setAttribute("class", cssclass);
		window.sizeToContent();
	},
	
	onAccept: function()
	{
		window.arguments[0].fResult = true;
		return true;
	},
	
	onCancel: function()
	{
		window.arguments[0].fResult = false;
		return true;
	}

};

