/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2010-2011 Michael Koch
*/

var ViewMarksModel = {

	bookmarks: Components.classes["@mozilla.org/browser/nav-bookmarks-service;1"]
		.getService(Components.interfaces.nsINavBookmarksService),

	history: Components.classes["@mozilla.org/browser/nav-history-service;1"]
		.getService(Components.interfaces.nsINavHistoryService),

	stopwords: [
		"and", "the", "this", "that", "with", "for", "own", "all", "our", "are", "your",
		"und", "der", "die", "das", "den", "mit", "ber", "bei", "sie", "ihr", "sein", "ist"
	],


	split: function(s)
	{
		var sep = " ,;.:+-*~_+&?/#$()!<>";
		var result = new Array();
		var part = "";
		var fEscape = false;
		for (var i=0; i<s.length; i++) {
			var c = s.charAt(i);
			if (sep.indexOf(c) >= 0) {
				if (fEscape == false && part.length > 0) {
					if (result.indexOf(part) < 0) {
						result.push(part);
					}
					part = "";
				}
				fEscape = true;
			} else {
				part += c;
				fEscape = false;
			}
		}		
		if (part.length > 0 && result.indexOf(part) < 0) {
			result.push(part);
		}
		return result;
	},


	createKeywordList: function(hash)
	{
		var bookmarks = ViewMarksData.readBookmarkList(null, null);	
		var keywords = [];
		for (var i=0; i<bookmarks.length; i++) {
			var data = 
				bookmarks[i].title + " " + 
				ViewMarksData.getItemKeywords(bookmarks[i].itemId) + " " +
				ViewMarksData.getItemDescription(bookmarks[i].itemId);
			var splitlist = this.split(data.toLowerCase());
			try {
				var host = ViewMarksUtil.getURIFromString(bookmarks[i].uri).host;
				splitlist.push(host.toLowerCase());
			} catch (e) {}
			var parentId = ViewMarksData.getParentFolderId(bookmarks[i].itemId);

			for (var j=0; j<splitlist.length; j++) {
				if (splitlist[j].length < 3) continue;
				if (splitlist[j].length > 32) continue;
				var arrFolder = hash.get(splitlist[j]);
				if (arrFolder) {
					if (arrFolder.indexOf(parentId) < 0) {
						arrFolder.push(parentId);
					}
				} else {
					hash.put(splitlist[j], [parentId]);
				}
			}

		}

	},


	getRelatedFolderList: function(filterList, url, title, description) 
	{
		if (ViewMarksGlobal.indexHash == null) {
			ViewMarksGlobal.indexHash = new ViewMarksHashtable();
			this.createKeywordList(ViewMarksGlobal.indexHash);
		}

		var list = new Array();
		if (filterList == null) filterList = [this.bookmarks.bookmarksMenuFolder];

		var splitlist = this.split(title.toLowerCase()+" "+description.toLowerCase());
		try {
			var host = ViewMarksUtil.getURIFromString(url).host;	
		} catch (e) {
			var host = "";
		}
		splitlist.push(host);	

		var pattern = new Array();
		for (var i=0; i<splitlist.length; i++) {
			if (splitlist[i].length < 3) continue;
			if (splitlist[i].length > 32) continue;
			if (this.stopwords.indexOf(splitlist[i]) >= 0) continue;
			pattern.push(splitlist[i]);
		}

		ViewMarksUtil.logmsg("ViewMarks: search patterns: "+pattern);

		for (var i=0; i<pattern.length; i++) {
			var arrFolder = ViewMarksGlobal.indexHash.get(pattern[i]);
			if (arrFolder) {
				//ViewMarksUtil.logmsg("match "+pattern[i]);
				var score = 1;
				if (pattern[i] == host) score = 2; 
				for (var t=0; t<arrFolder.length; t++) {
					if (filterList.indexOf(arrFolder[t]) >= 0) continue;
					var found = -1;
					for (var k=0; k<list.length; k++) {
						if (list[k][0] == arrFolder[t]) {
							list[k][1] += score;
							list[k][2].push(pattern[i]);
							found = k;
							break;
						}
					}
					if (found < 0) {
						list.push([arrFolder[t], score, [pattern[i]]]);	
					}
				}
			}
		}

		list.sort(function(a,b){return (b[1] - a[1])});


		var result = new Array();
		for (var i=0; i<list.length; i++)	{
			if (i<6) {
				var keys = "";
				for (var j=0; j<list[i][2].length; j++) {
					if (j > 0) keys += "/";
					keys += list[i][2][j];
				}
				ViewMarksUtil.logmsg(ViewMarksData.getItemTitle(list[i][0])+": "+list[i][1]+" ("+keys+")");
			}
			if (list[i][1] > 1) {
				result.push(list[i][0]);
			}
		}

		return result;
	}


};



