﻿/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2010-2013 Michael Koch
*/


var ViewMarksPlaces = {

	getPlacesNode: function(node)
	{
    while (node instanceof Components.interfaces.nsIDOMElement) {
      if (node._placesNode) return node._placesNode;
      if (node.localName == "tree" && node.getAttribute("type") == "places") {
				return node.view;
      }
      node = node.parentNode;
    }
		return null;
	},


	onPlacesPopup: function(event)
	{
		try {
		let label = document.getElementById("vmks_places_context_open");
		label.setAttribute("collapsed", true);
		let del = document.getElementById("placesContext_delete");
		del.setAttribute("label", ViewMarksUtil.getString("delete"));
		if (document.popupNode) {
			let view = null;
			try {
				Components.utils.import("resource://gre/modules/PlacesUIUtils.jsm");
			} catch(e) {}
			try {
				Components.utils.import("resource://app/modules/PlacesUIUtils.jsm");
			} catch(e) {}
			try {
				view = PlacesUIUtils.getViewForNode(document.popupNode);
			} catch(e) {}
			if (view) {
				var placesNode = view.selectedNode;
			} else {
				var placesNode = ViewMarksPlaces.getPlacesNode(document.popupNode);
			}
			if (placesNode && placesNode.itemId && placesNode.uri) {
				if (ViewMarksData.isFolder(placesNode.itemId)) {
					label.removeAttribute("collapsed");
					label.setAttribute("oncommand", "ViewMarksUtil.openInNewTab('about:viewmarks?folder="+Math.floor(placesNode.itemId)+"', false);");
				}
				if (ViewMarksPref.create_trash) {
					del.setAttribute("label", ViewMarksUtil.getString("move_to_trash"));
					del.removeAttribute("command");
					del.setAttribute("oncommand", "ViewMarksTrash.deleteBookmark("+Math.floor(placesNode.itemId)+")");
				}
			}
		} 
		} catch(e) {ViewMarksUtil.alert(e);}
	},


	init: function(event)
	{
		//ViewMarksPref.init();
		let node = document.getElementById("placesContext");
		if (node) node.addEventListener("popupshowing", ViewMarksPlaces.onPlacesPopup, false);
	},
	
};

window.addEventListener('load', ViewMarksPlaces.init, false);
