/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2010-2011 Michael Koch
*/

var ViewMarksPref = {

	xulAppInfo: Components.classes["@mozilla.org/xre/app-info;1"]
		.getService(Components.interfaces.nsIXULAppInfo),

	prefs: null,
	browserPrefs: null,
	
	getPrefObj: function(branch)
	{
		var obj = Components.classes["@mozilla.org/preferences-service;1"];
		obj = obj.getService(Components.interfaces.nsIPrefService);
		if (branch) obj = obj.getBranch(branch+"."); else obj.getBranch(null);
		obj.QueryInterface(Components.interfaces.nsIPrefBranch2);
		return obj;
	},
	
	getCharPref: function(name)
	{
		try {
			return this.prefs.getCharPref(name);
		} catch (e) {
			return "";
		}
	},

	getBrowserCharPref: function(name)
	{
		try {
			return this.browserPrefs.getCharPref(name);
		} catch (e) {
			return "";
		}
	},
	
	getIntPref: function(name)
	{
		try {
			return this.prefs.getIntPref(name);
		} catch (e) {
			return 0;
		}
	},
	
	getBoolPref: function(name)
	{
		try {
			return this.prefs.getBoolPref(name);
		} catch (e) {
			return false;
		}
	},
	
	loadPrefs: function()
	{
		this.data_strategy = this.getIntPref("data_strategy");
		if (this.data_strategy == 0) {
			this.data_strategy = ViewMarksData.SAVE_TO_DATABASE | ViewMarksData.LOAD_FROM_DATABASE;
		}
		
		this.debug = this.getBoolPref("debug");
		this.zoom = this.getIntPref("zoom");
		ViewMarksUtil.showElement("vmks_status", this.getBoolPref("statusbar"));
		this.replace_add = this.getBoolPref("replace_add");
		this.replace_edit = this.getBoolPref("replace_edit");
		this.replace_history_sidebar = this.getBoolPref("replace_history_sidebar");
		this.allow_unnamed = this.getBoolPref("allow_unnamed");
		this.last_edit_extended = this.getBoolPref("last_edit_extended");
		this.last_edit_quicksave = this.getBoolPref("last_edit_quicksave");
		this.fetch_description = this.getBoolPref("fetch_description");
		this.fetch_keywords = this.getBoolPref("fetch_keywords");
		this.tn_border = this.getBoolPref("tn_border");
		this.tn_shadow = this.getBoolPref("tn_shadow");
		this.insert_folder_before_bookmarks = this.getBoolPref("insert_folder_before_bookmarks");
		this.autofetch_thumbnail = this.getBoolPref("autofetch_thumbnail");
		this.menu_for_unfiled = this.getBoolPref("menu_for_unfiled");
		this.zoom_smart = this.getBoolPref("zoom_smart");
		this.most_visited_count = this.getIntPref("most_visited_count");
		if (this.most_visited_count <= 0 || this.most_visited_count > 100) this.most_visited_count = 10;
		this.last_visited_count = this.getIntPref("last_visited_count");
		if (this.last_visited_count <= 0 || this.last_visited_count > 100) this.last_visited_count = 10;
		this.skin = this.getCharPref("skin");
		this.show_most_visited = this.getBoolPref("show_most_visited");
		this.show_last_visited = this.getBoolPref("show_last_visited");
		this.recently_used_folder = this.getCharPref("recently_used_folder");
		this.show_related_folder = this.getBoolPref("show_related_folder");
		this.instant_quicksave = this.getBoolPref("instant_quicksave");
		this.load_tabs_in_background = this.getBoolPref("load_tabs_in_background");
		this.show_qrcode_context_menu = this.getBoolPref("show_qrcode_context_menu");
		this.show_qrcode_urlbar = this.getBoolPref("show_qrcode_urlbar");
		this.qrcode_cell_size = this.getIntPref("qrcode_cell_size");
		this.overwrite_on_import = this.getBoolPref("overwrite_on_import");
		this.create_history = this.getBoolPref("create_history");
		this.history_duration = this.getIntPref("history_duration");
		this.history_sort_order = this.getIntPref("history_sort_order")
		this.view_alignment = this.getIntPref("view_alignment");
		this.advice_mask = this.getIntPref("advice_mask");
		this.create_trash = this.getBoolPref("create_trash");
		this.trash_folder_id = this.getIntPref("trash_folder_id");
		this.autodelete_trash = this.getBoolPref("autodelete_trash");
		this.trash_duration = this.getIntPref("trash_duration");
		this.standard_click_action = this.getIntPref("standard_click_action");
		this.toolbar_action = this.getIntPref("toolbar_action");
		this.show_rating = this.getBoolPref("show_rating");
		this.search_flags = this.getIntPref("search.flags");
		this.search_value = this.getCharPref("search.value");
		this.tn_tooltips = this.getBoolPref("tn_tooltips");
		this.update = this.getBoolPref("update");
		this.update_period = this.getIntPref("update_period");
		if (this.update_period < 10) this.prefs.setIntPref("update_period", 10);
		this.send_reports = this.getBoolPref("send_reports");
		this.load_all = this.getBoolPref("load_all");
		this.sort_order = this.getIntPref("sort_order");
			
		this.empty_tab_url = this.getCharPref("empty_tab_url");
		if (this.empty_tab_url != "" && this.empty_tab_url != "about:blank") {
			this.browserPrefs.setCharPref("newtab.url", this.empty_tab_url);
			this.browserPrefs.setBoolPref("newtabpage.enabled", true);
			this.prefs.setCharPref("empty_tab_url", "");
		}
	},
	
	prefObserver: {
		observe: function(subject, topic, data) {
			if (topic != "nsPref:changed") return;
			//ViewMarksUtil.logmsg("changed "+data);
			ViewMarksPref.loadPrefs();
		}
	},

	allPrefObserver: {
		observe: function(subject, topic, data) {
			if (topic != "nsPref:changed") return;
			//ViewMarksUtil.logmsg("changed "+data);
		}
	},

	init: function()
	{
		if (this.browserPrefs) return;
		this.browserPrefs = this.getPrefObj("browser");
		this.prefs = this.getPrefObj("extensions.viewmarks");
		this.prefs.addObserver("", ViewMarksPref.prefObserver, false);
		this.loadPrefs();
/*
		if (this.debug) {
			var allPrefs = this.getPrefObj(null);
			allPrefs.addObserver("", ViewMarksPref.allPrefObserver, false);
		}
*/
	}

};

ViewMarksPref.init();
