/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2010-2012 Michael Koch
*/


var ViewMarksQRCode = {

	maxDataLength: 2048,

	qrcode_size: [
		[21,"L",17],[21,"M",14],[21,"Q",11],[21,"H",7],
		[25,"L",32],[25,"M",26],[25,"Q",20],[25,"H",14],
		[29,"L",53],[29,"M",42],[29,"Q",32],[29,"H",24],
		[33,"L",78],[33,"M",62],[33,"Q",46],[33,"H",34],
		[37,"L",106],[37,"M",84],[37,"Q",60],[37,"H",44],
		[41,"L",134],[41,"M",106],[41,"Q",74],[41,"H",58],
		[45,"L",154],[45,"M",122],[45,"Q",86],[45,"H",64],
		[49,"L",192],[49,"M",152],[49,"Q",108],[49,"H",84],
		[53,"L",230],[53,"M",180],[53,"Q",130],[53,"H",98],
		[57,"L",271],[57,"M",213],[57,"Q",151],[57,"H",119],
		[61,"L",321],[61,"M",251],[61,"Q",177],[61,"H",137],
		[65,"L",367],[65,"M",287],[65,"Q",203],[65,"H",155],
		[69,"L",425],[69,"M",331],[69,"Q",241],[69,"H",177],
		[73,"L",458],[73,"M",362],[73,"Q",258],[73,"H",194],
		[77,"L",520],[77,"M",412],[77,"Q",292],[77,"H",220],
		[81,"L",586],[81,"M",450],[81,"Q",322],[81,"H",250],
		[85,"L",644],[85,"M",504],[85,"Q",364],[85,"H",280],
		[89,"L",718],[89,"M",560],[89,"Q",394],[89,"H",310],
		[93,"L",792],[93,"M",624],[93,"Q",442],[93,"H",338],
		[97,"L",858],[97,"M",666],[97,"Q",482],[97,"H",382],
		[101,"L",929],[101,"M",711],[101,"Q",509],[101,"H",403],
		[105,"L",1003],[105,"M",779],[105,"Q",565],[105,"H",439],
		[109,"L",1091],[109,"M",857],[109,"Q",611],[109,"H",461],
		[113,"L",1171],[113,"M",911],[113,"Q",661],[113,"H",511],
		[117,"L",1273],[117,"M",997],[117,"Q",715],[117,"H",535],
		[121,"L",1367],[121,"M",1059],[121,"Q",751],[121,"H",593],
		[125,"L",1465],[125,"M",1125],[125,"Q",805],[125,"H",625],
		[129,"L",1528],[129,"M",119],[129,"Q",868],[129,"H",658],
		[133,"L",1628],[133,"M",1264],[133,"Q",908],[133,"H",698],
		[137,"L",1732],[137,"M",137],[137,"Q",982],[137,"H",742],
		[141,"L",184],[141,"M",1452],[141,"Q",103],[141,"H",790],
		[145,"L",1952],[145,"M",1538],[145,"Q",1112],[145,"H",842],
		[149,"L",2068],[149,"M",1628],[149,"Q",1168],[149,"H",898],
		[153,"L",2188],[153,"M",1722],[153,"Q",1228],[153,"H",958],
		[157,"L",2303],[157,"M",1809],[157,"Q",1283],[157,"H",983],
		[161,"L",2431],[161,"M",1911],[161,"Q",1351],[161,"H",1051],
		[165,"L",2563],[165,"M",1989],[165,"Q",1423],[165,"H",1093],
		[169,"L",2699],[169,"M",2099],[169,"Q",1499],[169,"H",1139],
		[173,"L",2809],[173,"M",2213],[173,"Q",1579],[173,"H",1219],
		[177,"L",2953],[177,"M",2331],[177,"Q",1663],[177,"H",1273]
	],

	createQRCodeLink: function(text)
	{
		var rdcy = "L";
		var border = 0;
		var size = this.qrcode_size[0][0];

		if (text.length > ViewMarksQRCode.maxDataLength) return "chrome://viewmarks/skin/qrcode_error.png";

		for (var i=1; i<this.qrcode_size.length; i++) {
			if (this.qrcode_size[i][1] != rdcy) continue;
			size = this.qrcode_size[i][0];
			if (this.qrcode_size[i][2] > text.length+1) break;
		}

		var cellsize = ViewMarksPref.qrcode_cell_size;
		if (cellsize < 4) cellsize = 4;
		if (cellsize > 32) cellsize = 32;
		
		size = (size + 2*border) * cellsize;
		if (size > 547) size = 547;

		text = encodeURIComponent(text);
		//let host = "chart.apis.google.com";
		let host = "chart.googleapis.com";
		var link = "http://"+host+"/chart?chs=" +
			size + "x" + size + "&cht=qr&chld=" + rdcy + "|" + border + "&chl=" + text;
			
		return link;
	},

	getParentLink: function(node)
	{
		if (node.tagName && node.tagName.toLowerCase() == "a") {
			if (node.href) return node.href;
			return null;
		}
		if (node.parentNode) return ViewMarksQRCode.getParentLink(node.parentNode);
		return null;
	},

	getParentFrame: function(node)
	{
		if (node.parentNode) return ViewMarksQRCode.getParentFrame(node.parentNode);
		if (node instanceof HTMLDocument && node.location && node.location.href != content.document.location.href) {
			return node.location.href;
		}
		return null;
	},


	modifyToolbarTooltip: function(event)
	{
		let url = content.document.location.href
		let code = document.getElementById("vmks_main_button_link_code");
		code.setAttribute("src", ViewMarksQRCode.createQRCodeLink(url));
		code.style.padding = (4*ViewMarksPref.qrcode_cell_size)+"px";
	},


	modifyMainContext: function(event)
	{
		var idlist = [
			"vmks_main_context_link", 
			"vmks_main_context_frame", 
			"vmks_main_context_image", 
			"vmks_main_context_selected", 
			"vmks_main_context_document"
		];

		if (event.target.id != "contentAreaContextMenu") return;

		if (ViewMarksPref.show_qrcode_context_menu == true) {
			document.getElementById("vmks_main_context_code").removeAttribute("collapsed");
		} else {
			document.getElementById("vmks_main_context_code").setAttribute("collapsed", true);
			return;
		}

		try {
		var selText = document.commandDispatcher.focusedWindow.getSelection().toString();
		var href = content.document.location.href;  

		for (var i=0; i<idlist.length; i++) {
			var node = document.getElementById(idlist[i]);
			node.setAttribute("collapsed", true);
			node.setAttribute("disabled", true);
		}
	
		if (document.popupNode) {
			var url = ViewMarksQRCode.getParentLink(document.popupNode);
			if (url) {
				var label = document.getElementById("vmks_main_context_link");
				if (url.length <= ViewMarksQRCode.maxDataLength) {
					label.removeAttribute("disabled");
					var code = document.getElementById("vmks_main_context_link_code");
					code.setAttribute("src", ViewMarksQRCode.createQRCodeLink(url));
					code.setAttribute("tooltiptext", url);
					code.style.padding = (4*ViewMarksPref.qrcode_cell_size)+"px";
				}
				label.removeAttribute("collapsed");
			}
			url = ViewMarksQRCode.getParentFrame(document.popupNode);
			if (url) {
				var label = document.getElementById("vmks_main_context_frame");
				if (url.length <= ViewMarksQRCode.maxDataLength) {
					label.removeAttribute("disabled");
					var code = document.getElementById("vmks_main_context_frame_code");
					code.setAttribute("src", ViewMarksQRCode.createQRCodeLink(url));
					code.setAttribute("tooltiptext", url);
					code.style.padding = (4*ViewMarksPref.qrcode_cell_size)+"px";
				}
				label.removeAttribute("collapsed");
			}
		} 
		if (document.popupNode && document.popupNode.tagName.toLowerCase() == "img") {
			var label = document.getElementById("vmks_main_context_image");
			var text = document.popupNode.src;
			if (text.length <= ViewMarksQRCode.maxDataLength) {
				label.removeAttribute("disabled");
				var code = document.getElementById("vmks_main_context_image_code");
				code.setAttribute("src", ViewMarksQRCode.createQRCodeLink(document.popupNode.src));
				code.setAttribute("tooltiptext", document.popupNode.src);
				code.style.padding = (4*ViewMarksPref.qrcode_cell_size)+"px";
			}
			label.removeAttribute("collapsed");
		} 
		if (selText.length > 0) {
			var label = document.getElementById("vmks_main_context_selected");
			if (selText.length < ViewMarksQRCode.maxDataLength) {
				label.removeAttribute("disabled");
				var code = document.getElementById("vmks_main_context_selected_code");
				code.setAttribute("src", ViewMarksQRCode.createQRCodeLink(selText));
				code.setAttribute("tooltiptext", selText);
				code.style.padding = (4*ViewMarksPref.qrcode_cell_size)+"px";
			}
			label.removeAttribute("collapsed");
		} 
		if (ViewMarksUtil.startsWith(href, "http")) {
			var label = document.getElementById("vmks_main_context_document");
			if (href.length <= ViewMarksQRCode.maxDataLength) {
				label.removeAttribute("disabled");
				var code = document.getElementById("vmks_main_context_document_code");
				code.setAttribute("src", ViewMarksQRCode.createQRCodeLink(href));
				code.setAttribute("tooltiptext", href);
				code.style.padding = (4*ViewMarksPref.qrcode_cell_size)+"px";
			}
			label.removeAttribute("collapsed");
		}
		} catch(e) {ViewMarksUtil.logerror(e);}
	},

	getPlacesNode: function(node)
	{
    while (node instanceof Components.interfaces.nsIDOMElement) {
      if (node._placesNode) return node._placesNode;
      if (node.localName == "tree" && node.getAttribute("type") == "places") {
				return node.view;
      }
      node = node.parentNode;
    }
		return null;
	},

	modifyPlacesContext: function(event)
	{
		try {
		ViewMarksTrash.update();
		var label = document.getElementById("vmks_places_context_code");
		label.setAttribute("collapsed", true);
		if (ViewMarksPref.show_qrcode_context_menu == true) {
			//label.removeAttribute("collapsed");
			//label.setAttribute("disabled", true);
			if (document.popupNode) {
				let view = null;
				try {
					Components.utils.import("resource://gre/modules/PlacesUIUtils.jsm");
				} catch(e) {}
				try {
					Components.utils.import("resource://app/modules/PlacesUIUtils.jsm");
				} catch(e) {}
				try {
					view = PlacesUIUtils.getViewForNode(document.popupNode);
				} catch(e) {}
				if (view) {
					var placesNode = view.selectedNode;
				} else {
					var placesNode = ViewMarksQRCode.getPlacesNode(document.popupNode);
				}
				if (placesNode && placesNode.uri && placesNode.uri.length <= ViewMarksQRCode.maxDataLength) {
					if (ViewMarksUtil.startsWith(placesNode.uri, "place:")) return;
					var code = document.getElementById("vmks_places_context_code_image");
					code.setAttribute("src", ViewMarksQRCode.createQRCodeLink(placesNode.uri));
					code.setAttribute("tooltiptext", placesNode.uri);
					code.style.padding = (4*ViewMarksPref.qrcode_cell_size)+"px";
					label.removeAttribute("collapsed");
					//label.removeAttribute("disabled");
				}
			} 
		} 
		} catch(e) {ViewMarksUtil.alert(e);/*logerror(e);*/}
	},

	onCopy: function(id)
	{
		var node = document.getElementById(id);
		ViewMarksData.copyImageFromData(node.getAttribute("src"));
	},

	onSave: function(id)
	{
		try {
		var node = document.getElementById("vmks_view_context");
		if (node) node.hidePopup();
		node = document.getElementById("contentAreaContextMenu");
		if (node) node.hidePopup();
		node = document.getElementById("placesContext");
		if (node) node.hidePopup();
		node = document.getElementById(id);
		ViewMarksData.saveImageFromData(node.getAttribute("src"));
	} catch (e) {ViewMarksUtil.logerror(e);}
	},

	init: function(event)
	{
		ViewMarksPref.init();
		var node = document.getElementById("contentAreaContextMenu");
		if (node) node.addEventListener("popupshowing", ViewMarksQRCode.modifyMainContext, false);
		node = document.getElementById("placesContext");
		if (node) node.addEventListener("popupshowing", ViewMarksQRCode.modifyPlacesContext, false);
	},
	
};

window.addEventListener('load', ViewMarksQRCode.init, false);


