/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2012-2013 Michael Koch
*/

var ViewMarksReport = {

	openDialog: function(e)
	{
		let features = "chrome,titlebar,toolbar,centerscreen,dialog=yes,modal";
		let argObj = {};
		argObj.e = e;
		argObj.fResult = false;
		window.openDialog("chrome://viewmarks/content/report.xul", "dlgViewMarksReport", features, argObj).focus();
		return argObj.fResult;
	},


	upload: function()
	{
	  let formData = new FormData();
	  let file = ViewMarksData.getLocalFile("error.log");
	  formData.append("report", new File(file), ViewMarksPref.getCharPref("ref"));
	  let req = Components.classes["@mozilla.org/xmlextras/xmlhttprequest;1"].createInstance();
	  req.open("POST", "http://www.codepad.de/upload/");
	  req.onload = function(event) { ViewMarksUtil.logmsg("error report sent"); };
	  req.onerror = function(event) { ViewMarksUtil.logerror(event); };
	  req.send(formData);
	},

	
	onAccept: function()
	{
		try {
			let send_reports = document.getElementById("vmks_report_allow_send").checked;
			ViewMarksPref.prefs.setBoolPref("send_reports", send_reports);
			if (send_reports) this.upload();
			window.arguments[0].fResult = true;
			return true;
		} catch(e) {
			alert(e);
			window.arguments[0].fResult = false;
			ViewMarksUtil.logerror(e);
			return true;
		}
	},


	init: function() {
		ViewMarksPref.init();
		document.getElementById("vmks_report_allow_send").checked = ViewMarksPref.send_reports;
		
		let desc = document.getElementById("vmks_report_desc");
		let msg = ViewMarksUtil.dumpError(window.arguments[0].e);
		desc.value = msg.trim();
		desc.setSelectionRange(0, 0);
		

	}
	
};



