/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2012-2013 Michael Koch
*/

var ViewMarksSearch = {

	bookmarks: Components.classes["@mozilla.org/browser/nav-bookmarks-service;1"]
		.getService(Components.interfaces.nsINavBookmarksService),

	history: Components.classes["@mozilla.org/browser/nav-history-service;1"]
		.getService(Components.interfaces.nsINavHistoryService),

	tagging: Components.classes["@mozilla.org/browser/tagging-service;1"]
		.getService(Components.interfaces.nsITaggingService),		

	SF_TITLE: 1,
	SF_URL: 2,
	SF_KEYWORDS: 4,
	SF_DESCRIPTION: 8,
	SF_TAGS: 16,

	SF_ANY: 256,

	SF_LOCAL: 512,
	SF_SUBFOLDER: 1024,

	SF_BOOKMARKS: 2048,
	SF_FOLDER: 4096,

	SF_RATING_MASK: (7<<16),
	SF_RATING_SHIFT: 16,


	getDefaultFlags: function()
	{
		return this.SF_TITLE | this.SF_URL | this.SF_KEYWORDS | this.SF_DESCRIPTION | this.SF_TAGS | this.SF_SUBFOLDER | this.SF_BOOKMARKS | this.SF_FOLDER;
	},


	getBookmarksSearchResultArray: function(aParentId, results, patterns, flags, depth)
	{
		if (aParentId == null) {
			aParentId = this.bookmarks.placesRoot;
		}

		if (aParentId == this.bookmarks.tagsFolder) return null;

		if (depth === undefined) depth = 0;

		if (results == null) {
			results = new Array();
			for (var j=0; j < patterns.length; j++) patterns[j] = patterns[j].toLowerCase();
			if (flags == null || flags == 0) flags = this.getDefaultFlags();
		}

		let rating = (flags & this.SF_RATING_MASK) >> this.SF_RATING_SHIFT;

		let query = this.history.getNewQuery();
		query.setFolders([aParentId], 1);

		let result = this.history.executeQuery(query, this.history.getNewQueryOptions());
		let folderNode = result.root;
		folderNode.containerOpen = true;
	
		for (var i=0; i<folderNode.childCount; i++) {
			let childNode = folderNode.getChild(i);
			let itemType = ViewMarksData.getItemType(childNode.itemId);
			if (itemType == this.bookmarks.TYPE_BOOKMARK && ViewMarksUtil.startsWith(childNode.uri, "place:")) continue;
			if (itemType != this.bookmarks.TYPE_FOLDER && itemType != this.bookmarks.TYPE_BOOKMARK) continue;
			if (itemType == this.bookmarks.TYPE_FOLDER && (flags & this.SF_SUBFOLDER) && childNode.itemId != ViewMarksPref.trash_folder_id) {
				this.getBookmarksSearchResultArray(childNode.itemId, results, patterns, flags, depth+1);
			}

			if (itemType == this.bookmarks.TYPE_BOOKMARK && (flags & this.SF_BOOKMARKS) == 0) continue;
			if (itemType == this.bookmarks.TYPE_FOLDER && (flags & this.SF_FOLDER) == 0) continue;

			var count;

			let tmpChildNode = childNode;
			childNode = {};
			childNode.title = tmpChildNode.title;
			childNode.uri = tmpChildNode.uri;
			childNode.itemId = tmpChildNode.itemId;
			childNode.itemType = itemType;
			childNode.accessCount = tmpChildNode.accessCount;
			if (rating > 0) {
				childNode.rating = ViewMarksData.getItemAnnotation(childNode.itemId, "bookmarkProperties/vmksRating");
				if (childNode.rating < rating) continue;
			}
		
			if ((flags & this.SF_TITLE) && childNode.title) {
				var title = childNode.title.toLowerCase();
				for (var j=0, count=0; j<patterns.length; j++) {
					if (title.indexOf(patterns[j]) >= 0) count++;
				}
				if (flags & this.SF_ANY) {
					if (count > 0) {results.push(childNode); continue;}
				} else {
					if (count == patterns.length) {results.push(childNode); continue;}
				}
			}
			if (itemType == this.bookmarks.TYPE_FOLDER) continue;
			if (flags & this.SF_URL) {
				var uri = childNode.uri.toLowerCase();
				for (var j=0, count=0; j<patterns.length; j++) {
					if (uri.indexOf(patterns[j]) >= 0) count++;
				}
				if (flags & this.SF_ANY) {
					if (count > 0) {results.push(childNode); continue;}
				} else {
					if (count == patterns.length) {results.push(childNode); continue;}
				}
			}
			if (flags & this.SF_DESCRIPTION) {
				var description = ViewMarksData.getItemDescription(childNode.itemId);
				if (description && description.length) {
					description = description.toLowerCase();
					for (var j=0, count=0; j<patterns.length; j++) {
						if (description.indexOf(patterns[j]) >= 0) count++;
					}
					if (flags & this.SF_ANY) {
						if (count > 0) {results.push(childNode); continue;}
					} else {
						if (count == patterns.length) {results.push(childNode); continue;}
					}
				}
			}
			if (flags & this.SF_KEYWORDS) {
				var keywords = this.bookmarks.getKeywordForBookmark(childNode.itemId);
				if (keywords) {
					keywords = keywords.toLowerCase();
					for (var j=0, count=0; j<patterns.length; j++) {
						if (keywords.indexOf(patterns[j]) >= 0) count++;
					}
					if (flags & this.SF_ANY) {
						if (count > 0) {results.push(childNode); continue;}
					} else {
						if (count == patterns.length) {results.push(childNode); continue;}
					}
				}
			}
			if (flags & this.SF_TAGS) {
				let uri = ViewMarksUtil.getURIFromString(childNode.uri);
				let tags = this.tagging.getTagsForURI(uri, {});	
				if (tags.length) {
					for (var k=0, count=0; k<tags.length; k++) {
						var tag = tags[k].toLowerCase();
						for (var j=0; j<patterns.length; j++) {
							if (tag == patterns[j]) count++;
						}
					}
					if (flags & this.SF_ANY) {
						if (count > 0) {results.push(childNode); continue;}
					} else {
						if (count == patterns.length) {results.push(childNode); continue;}
					}
				}
			}
		}

		if (rating > 0 && depth == 0) {
			results.sort(
				function(a,b) {
					return b.rating - a.rating;
				}
			);
		}

		return results;
	},


	openDialog: function()
	{
		let features = "chrome,titlebar,toolbar,centerscreen,dialog=yes,modal";
		let argObj = {};
		let box = document.getElementById("vmks_searchbox");
		if (box) argObj.value = box.value;
		argObj.fResult = false;
		window.openDialog("chrome://viewmarks/content/search.xul", "dlgViewMarksSearch", features, argObj).focus();
		return argObj.fResult;
	},

	
	onAccept: function()
	{
		try {
			let flags = 0;
			switch (document.getElementById("vmks_search_scope").selectedIndex) {
				case 0: flags |= this.SF_SUBFOLDER; break;
				case 1: flags |= this.SF_LOCAL; break;
				case 2: flags |= this.SF_LOCAL|this.SF_SUBFOLDER; break;
			}
			if (document.getElementById("vmks_search_bookmarks").checked) flags |= this.SF_BOOKMARKS;
			if (document.getElementById("vmks_search_folder").checked) flags |= this.SF_FOLDER;
			if (document.getElementById("vmks_search_op").selectedIndex == 1) flags |= this.SF_ANY;
			if (document.getElementById("vmks_search_title").checked) flags |= this.SF_TITLE;
			if (document.getElementById("vmks_search_url").checked) flags |= this.SF_URL;
			if (document.getElementById("vmks_search_description").checked) flags |= this.SF_DESCRIPTION;
			if (document.getElementById("vmks_search_keywords").checked) flags |= this.SF_KEYWORDS;
			if (document.getElementById("vmks_search_tags").checked) flags |= this.SF_TAGS;
			flags |= document.getElementById("vmks_search_rating").selectedIndex << this.SF_RATING_SHIFT;
			ViewMarksPref.prefs.setIntPref("search.flags", flags);
			ViewMarksPref.prefs.setCharPref("search.value", document.getElementById("vmks_searchbox_ext").value);
			window.arguments[0].fResult = true;
			return true;
		} catch(e) {
			try {
				ViewMarksUtil.logerror(e)
				ViewMarksReport.openDialog(e);
				window.arguments[0].fResult = false;
			} catch (e) {
				ViewMarksUtil.logerror(e)
			}
			return true;
		}
	},


	onReset: function()
	{
		this.initDialog(this.getDefaultFlags());
		document.getElementById("vmks_searchbox_ext").value = "";
		document.getElementById("vmks_searchbox_ext").focus();
	},


	initDialog: function(flags)
	{
		if (flags & this.SF_LOCAL) {
			if (flags & this.SF_SUBFOLDER) {
				document.getElementById("vmks_search_scope").selectedIndex = 2;
			} else {
				document.getElementById("vmks_search_scope").selectedIndex = 1;
			}
		} else {
			document.getElementById("vmks_search_scope").selectedIndex = 0;
		}

		document.getElementById("vmks_search_bookmarks").setAttribute("checked", (flags & this.SF_BOOKMARKS) > 0);
		document.getElementById("vmks_search_folder").setAttribute("checked", (flags & this.SF_FOLDER) > 0);

		if (flags & this.SF_ANY) {
			document.getElementById("vmks_search_op").selectedIndex = 1;
		} else {
			document.getElementById("vmks_search_op").selectedIndex = 0;
		}

		document.getElementById("vmks_search_title").setAttribute("checked", (flags & this.SF_TITLE) > 0);
		document.getElementById("vmks_search_url").setAttribute("checked", (flags & this.SF_URL) > 0);
		document.getElementById("vmks_search_description").setAttribute("checked", (flags & this.SF_DESCRIPTION) > 0);
		document.getElementById("vmks_search_keywords").setAttribute("checked", (flags & this.SF_KEYWORDS) > 0);
		document.getElementById("vmks_search_tags").setAttribute("checked", (flags & this.SF_TAGS) > 0);

		if (ViewMarksPref.show_rating) {
			let rating = (flags & this.SF_RATING_MASK) >> this.SF_RATING_SHIFT;
			document.getElementById("vmks_search_rating").selectedIndex = rating;
		} else {
			document.getElementById("vmks_search_rating_row").setAttribute("collapsed", "true");
		}

		document.getElementById("vmks_searchbox_ext").focus();
	},
		

	init: function() {
		ViewMarksPref.init();
		let flags = ViewMarksPref.search_flags;
		if (flags == 0) flags = this.getDefaultFlags();
		if (window.arguments[0].value) {
			document.getElementById("vmks_searchbox_ext").value = window.arguments[0].value;
		}
		this.initDialog(flags);
	}
	
};



