/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2010-2014 Michael Koch
*/


var ViewMarksTrash = {

	bookmarks: Components.classes["@mozilla.org/browser/nav-bookmarks-service;1"]
		.getService(Components.interfaces.nsINavBookmarksService),


	open: function()
	{
		ViewMarksUtil.openInNewTab("about:viewmarks?folder=trash", false);
	},


	createTrashFolder: function()
	{
		// double step test for correct trash folder id
		if (ViewMarksPref.trash_folder_id) {
			let state = ViewMarksData.getItemAnnotation(ViewMarksPref.trash_folder_id, "bookmarkProperties/thisIsTheTrashFolder");
			if (state != "true") {
				let list = ViewMarksData.getItemsWithAnnotation("bookmarkProperties/thisIsTheTrashFolder");
				if (list.length > 0) {
					ViewMarksPref.prefs.setIntPref("trash_folder_id", list[0]);
					ViewMarksPref.trash_folder_id = list[0];
				} else {
					ViewMarksPref.trash_folder_id = 0;
				}
			}
		}
		if (ViewMarksPref.trash_folder_id) {
			let itemType = 0;
			try {itemType = ViewMarksData.getItemType(ViewMarksPref.trash_folder_id);} catch (e) {}
			if (itemType != ViewMarks.bookmarks.TYPE_FOLDER) ViewMarksPref.trash_folder_id = 0;
		}

		if (ViewMarksPref.trash_folder_id == 0) {
			let name = ViewMarksUtil.getString("trash_folder");
			let id = ViewMarks.bookmarks.createFolder(ViewMarks.bookmarks.placesRoot, name, ViewMarks.bookmarks.DEFAULT_INDEX);
			ViewMarksData.setItemAnnotation(id, "bookmarkProperties/thisIsTheTrashFolder", "true");
			ViewMarksPref.prefs.setIntPref("trash_folder_id", id);
			ViewMarksUtil.logmsg("Trash folder created, id = "+id);
		}
	},


	moveItemToTrash: function(itemId, itemType)
	{
		if (ViewMarksData.itemHasAnnotation(itemId, "bookmarkProperties/dateDeleted")) return;
		let parentId = ViewMarksData.getParentFolderId(itemId);
		if (parentId == null) return; // already deleted?
		if (itemType == null) itemType = ViewMarksData.getItemType(itemId);
/*
		ViewMarksData.setItemAnnotation(itemId, "bookmarkProperties/originalId", itemId);
		ViewMarksData.setItemAnnotation(itemId, "bookmarkProperties/originalParentId", parentId);
		ViewMarksData.setItemAnnotation(itemId, "bookmarkProperties/dateDeleted", (new Date()).getTime());
*/
		//ViewMarksUtil.logmsg("trash id = "+itemId+" type = "+itemType+" parentId = "+parentId);
		let newItemId = ViewMarksData.copyItem(itemId, ViewMarksPref.trash_folder_id, 0, true);
		if (newItemId == null) return;
		ViewMarksData.setItemAnnotation(newItemId, "bookmarkProperties/originalId", itemId);
		ViewMarksData.setItemAnnotation(newItemId, "bookmarkProperties/originalParentId", parentId);
		ViewMarksData.setItemAnnotation(newItemId, "bookmarkProperties/dateDeleted", (new Date()).getTime());
		ViewMarksUtil.logmsg("moveItemToTrash originalId = "+ViewMarksData.getItemAnnotation(newItemId, "bookmarkProperties/originalId"));
		ViewMarksUtil.logmsg("moveItemToTrash originalParentId = "+ViewMarksData.getItemAnnotation(newItemId, "bookmarkProperties/originalParentId"));
		ViewMarksUtil.logmsg("moveItemToTrash dateDeleted = "+ViewMarksData.getItemAnnotation(newItemId, "bookmarkProperties/dateDeleted"));
		ViewMarksData.removeItem(itemId);
	},


	relinkTrash: function()
	{
		let list = ViewMarksData.readFolderItemIds(ViewMarksPref.trash_folder_id);	
		let trash = [];
		for (var i=0; i<list.length; i++) {
			let originalId = ViewMarksData.getItemAnnotation(list[i], "bookmarkProperties/originalId");
			let originalParentId = ViewMarksData.getItemAnnotation(list[i], "bookmarkProperties/originalParentId");
			let itemType = ViewMarksData.getItemType(list[i]);
			trash.push({itemId:list[i], originalId:originalId, originalParentId:originalParentId, itemType:itemType});
		}
		for (var i=0; i<trash.length; i++) {
			if (trash[i].itemType != this.bookmarks.TYPE_FOLDER) continue;
			for (var j=0; j<trash.length; j++) {
				if (trash[i].originalId == trash[j].originalParentId) {
					//ViewMarksUtil.logmsg("relink id = "+trash[j].originalId+" type = "+trash[j].itemType+" parentId = "+trash[j].originalParentId);
					this.bookmarks.moveItem(trash[j].itemId, trash[i].itemId, this.bookmarks.DEFAULT_INDEX);
				}
			}
		}
	},


	removeTrashInformation: function(itemId)
	{
		ViewMarksData.removeItemAnnotation(itemId, "bookmarkProperties/originalId");
		ViewMarksData.removeItemAnnotation(itemId, "bookmarkProperties/originalParentId");
		ViewMarksData.removeItemAnnotation(itemId, "bookmarkProperties/dateDeleted");
		if (ViewMarksData.getItemType(itemId) == this.bookmarks.TYPE_FOLDER) {
			let list = ViewMarksData.readFolderItemIds(itemId);
			for (var i=0; i<list.length; i++) {
				this.removeTrashInformation(list[i]);
			}
		}
	},


	deleteOutdatedTrashItems: function()
	{
		if (ViewMarksPref.autodelete_trash == false) return;

		let list = new Array();
		ViewMarksData.enumFolderItems(ViewMarksPref.trash_folder_id, 
			function(item) {list.push(item.itemId);}
		);


		let duration = ViewMarksPref.trash_duration * 24 * 60 * 60 * 1000;
		let now = new Date();
		let midnight = new Date(now.getFullYear(), now.getMonth(), now.getDate(), 0, 0, 0, 0);
		let limit = midnight.getTime() - duration;
		let count = 0;

 		//ViewMarksUtil.alert("deleteOutdatedTrashItems items="+list.length);

		for (var i=0; i<list.length; i++) {
  		let date = ViewMarksData.getItemAnnotation(list[i], "bookmarkProperties/dateDeleted");
  		//ViewMarksUtil.alert(list[i]+" date="+new Date(date).toLocaleString()+" limit="+new Date(limit).toLocaleString()+" "+(date<limit ? "yes" : "no"));
			if (date < limit) {
				//ViewMarksUtil.logmsg("remove trash item "+list[i]+" "+date+" "+limit);
				ViewMarksData.deleteItemThumbnail(list[i]);
				ViewMarksData.removeItem(list[i]);
				count++;
			}
		}
		ViewMarksUtil.logmsg("removed "+count+" outdated trash items");
		//ViewMarksUtil.alert("removed "+count+" outdated trash items");
	},


	deleteAllTrashItems: function(dontask)
	{
		if (!dontask && ViewMarksPopup.open(
			ViewMarksUtil.getString("delete_trash"), 
			ViewMarksUtil.getString("ask_delete_trash"),
			ViewMarksPopup.MB_OK|ViewMarksPopup.MB_CANCEL|ViewMarksPopup.MB_ICON_WARNING) == false) return;

		let list = new Array();
		ViewMarksData.enumFolderItems(ViewMarksPref.trash_folder_id, 
			function(item) {list.push(item.itemId);}
		);
		for (var i=0; i<list.length; i++) {
			ViewMarksData.deleteItemThumbnail(list[i]);
			ViewMarksData.removeItem(list[i]);
		}
		ViewMarksUtil.logmsg("removed "+list.length+" trash items");
	},


	update: function() 
	{
/*
		let node = document.getElementById("placesContext_delete");
		if (node) {
			if (ViewMarksPref.create_trash) {
				node.setAttribute("label", ViewMarksUtil.getString("move_to_trash"));
			} else {
				node.setAttribute("label", ViewMarksUtil.getString("delete"));
			}
		}
*/
	},

	deleteBookmark: function(itemId) 
	{
		try {
			if (ViewMarksPref.create_trash) {
				//ViewMarksUtil.logmsg("moveItemToTrash: "+itemId);
				ViewMarksTrash.moveItemToTrash(itemId);
			} else {
				//ViewMarksUtil.logmsg("removeItem: "+itemId);
				ViewMarksData.deleteItemThumbnail(itemId);
				ViewMarksData.removeItem(itemId);
			}
		} catch (e) {
			ViewMarksUtil.logerror(e)
			ViewMarksReport.openDialog(e);
		}
	}

};


