/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2010-2013 Michael Koch
*/


var ViewMarksUpdate = {

	appShellService: Components.classes["@mozilla.org/appshell/appShellService;1"]
		.getService(Components.interfaces.nsIAppShellService),


	getThumbnail: function(win, itemId)
	{
		if (itemId) {
			ViewMarksUtil.logmsg("ViewMarksUpdate: create thumbnail(s) for item "+itemId);
			ViewMarksEdit.setQuickThumbnail(win, itemId); 
		} else {
			var itemIdList = ViewMarksData.getBookmarkIdsForURL(win.location.href);
			if (itemIdList.length > 0) {
				ViewMarksUtil.logmsg("ViewMarksUpdate: create thumbnail(s) for "+win.location.href);
				for (var i=0; i<itemIdList.length; i++) {
					ViewMarksEdit.setQuickThumbnail(win, itemIdList[i]); 
				}
			} else {
				ViewMarksUtil.logmsg("ViewMarksUpdate: no bookmarks for "+win.location.href);
			}
		}
	},


	onDOMContentLoaded: function(event) 
	{
		try {
			alert("blah!");
			let doc = event.originalTarget;
			let contentLoader = doc.getElementById("contentLoader");
			contentLoader.docShell.allowPlugins = false;
			contentLoader.docShell.allowAuth = false;
			ViewMarksUtil.logmsg("DOMContentLoaded");
		} catch (e) {
			ViewMarksUtil.logmsg("DOMContentLoaded: "+e);
		}
	}, 


	update: function()
	{
		try {

			//ViewMarksUtil.logmsg("update()");
	
			if (ViewMarksGlobal.updateList) return;
			ViewMarksGlobal.updateList = new Array();
			ViewMarksGlobal.updateList = ViewMarksData.readBookmarkList(null, null);	
			ViewMarksGlobal.updateBookmarkCount = ViewMarksGlobal.updateList.length;
			ViewMarksGlobal.updateIndex = -1;
	
			ViewMarksData.getThumbnailItemIdList( 
				function(aList) {
					if (aList == null || aList.length == 0) return;
					var hashTab = new ViewMarksHashtable();
					for (var i=0; i<aList.length; i++) {
						hashTab.put(aList[i], aList[i]);
					}
					var tmpList = new Array();
					for (var i=0; i<ViewMarksGlobal.updateList.length; i++) {
						var proto = ViewMarksGlobal.updateList[i].uri.split(":");
						if (proto == null || proto.length == 0) continue;
						if (proto[0] != "http" && proto[0] != "https" && proto[0] != "ftp") continue;
						if (hashTab.containsKey(ViewMarksGlobal.updateList[i].itemId) == false) {
							tmpList.push(ViewMarksGlobal.updateList[i]);
						}
					}
					ViewMarksGlobal.updateList = tmpList;
					hashTab = null;
					tmpList = null;
				}
			);
			
			var hiddenDOMWindow = this.appShellService.hiddenDOMWindow;
			var hiddenWindow = this.appShellService.hiddenWindow;
			
			setTimeout(function() {
				if (ViewMarksGlobal.updateItemId > 0) {
					try {
						ViewMarksUpdate.getThumbnail(hiddenDOMWindow, ViewMarksGlobal.updateItemId);
					} catch (e) {ViewMarksUtil.logerror(e);}
					ViewMarksGlobal.updateItemId = 0;
				}
				if (ViewMarksPref.update == false) {
					hiddenDOMWindow.location = "about:blank";
					ViewMarksGlobal.updateList = null;
					return;
				}
				ViewMarksGlobal.updateIndex++;
				if (ViewMarksGlobal.updateIndex < ViewMarksGlobal.updateList.length) {
					let index = ViewMarksGlobal.updateIndex;
					let itemId = ViewMarksGlobal.updateList[index].itemId;
					if (ViewMarksData.getItemThumbnail(itemId) == null) {
						ViewMarksUtil.logmsg("BackgroundUpdater("+(index+1)+"/"+ViewMarksGlobal.updateList.length+"): open bookmark "+ViewMarksGlobal.updateList[index].uri);
						hiddenDOMWindow.resizeTo(1024, 768);
						hiddenDOMWindow.location = ViewMarksGlobal.updateList[index].uri;
						hiddenWindow.docShell.allowPlugins = false;
						hiddenWindow.docShell.allowAuth = false;
						ViewMarksGlobal.updateItemId = ViewMarksGlobal.updateList[index].itemId;
						setTimeout(arguments.callee, ViewMarksPref.update_period * 1000);
					} else {
						setTimeout(arguments.callee, 1000);
					}
				} else {
					hiddenDOMWindow.location = "about:blank";
					ViewMarksGlobal.updateList = null;
				}
			}, 60 * 1000);

		} catch(e) {
			ViewMarksGlobal.updateList = null;
			ViewMarksGlobal.updateItemId = 0;
			ViewMarksUtil.logerror(e);
		}
	}

};



