/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2010-2013 Michael Koch
*/


var ViewMarksUtil = {

	// platform string is "Darwin", "Linux" or "WINNT"
	platform: Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULRuntime).OS,
	appinfo: Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo),
	consoleService: Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService),

	addonVersion: "",
	addonID: "{7443739c-bff6-4af0-aea5-7ed29006966c}",

	logfile: null,

	
	getString: function(key)
	{
		try {
			return document.getElementById("idViewMarksStringBundle").getString(key);
		} catch (e) {
			return "?";
		}
	},
	
	addSystemInfoAttributes: function(id)
	{
		var obj = document.getElementById(id);
		obj.setAttribute('vmks_platform', ViewMarksUtil.platform)
		var version = ViewMarksUtil.appinfo.version.split(".")[0];
		obj.setAttribute('vmks_appversion', version)
		var vstring = "3 4 5 6 7 8 9 10 11 12 13";
		for (var i=14; i <= version; i++) {
			vstring += " " + i;
		}
		obj.setAttribute('vmks_appverlist', vstring)
	},

	dispatchGlobalEvent: function(name)
	{
		var event = document.createEvent("Events");  
		event.initEvent(name, true, false);  
		this.getMainWindow().document.dispatchEvent(event);  
	},

	getMainWindow: function()
	{
		return window.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
			.getInterface(Components.interfaces.nsIWebNavigation)
			.QueryInterface(Components.interfaces.nsIDocShellTreeItem)
			.rootTreeItem
			.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
			.getInterface(Components.interfaces.nsIDOMWindow); 
	},
	
	getBrowser: function()
	{
		try {
			var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
			var mainWindow = wm.getMostRecentWindow("navigator:browser");
			var browser =  mainWindow.getBrowser();
			return browser;
		} catch(e) {
			return null;
		}
	},
	
	getAddonVersion: function(callback)
	{
		const addonid = "{7443739c-bff6-4af0-aea5-7ed29006966c}";
		if (typeof(Components.classes["@mozilla.org/extensions/manager;1"]) != 'undefined') {
			var gExtensionManager = Components.classes["@mozilla.org/extensions/manager;1"]
				.getService(Components.interfaces.nsIExtensionManager);
			var addon = gExtensionManager.getItemForID(addonid);
			callback(addon.version);
			return;
		}
		if (typeof(Components.utils) != 'undefined' && typeof(Components.utils.import) != 'undefined') {
			var ascope = {};
			Components.utils.import("resource://gre/modules/AddonManager.jsm", ascope);
			ascope.AddonManager.getAddonByID(addonid, function(addon) {callback(addon.version);} );	
			return;
		}
		callback("");
	},
	
	checkForUpdate: function()
	{
		this.getAddonVersion(
			function(new_version) {
				var old_version = ViewMarksPref.getCharPref("version");
				if (new_version != old_version) {
					if (old_version == "") {
						ViewMarksUtil.openUpdateHelp("install", new_version);
					} else {
						ViewMarksUtil.openUpdateHelp("update", new_version);
					}
					ViewMarksPref.prefs.setCharPref("version", new_version);
				}
			}
		);
	},

	openOnlineHelp: function()
	{
		var browser = ViewMarksUtil.getBrowser();
		var lang = document.getElementById("idViewMarksStringBundle").getString("lang");
		if (this.addonVersion.indexOf("beta") >= 0) {
			var tab = browser.addTab("http://www.codepad.de/"+lang+"/software/firefox-add-ons/viewmarks-beta.html");
		} else {
			var tab = browser.addTab("http://www.codepad.de/"+lang+"/software/firefox-add-ons/viewmarks.html");
		}
		browser.selectedTab = tab;
	},
	
	openUpdateHelp: function(action, version)
	{
		var browser = ViewMarksUtil.getBrowser();
		var lang = document.getElementById("idViewMarksStringBundle").getString("lang");
		if (version.indexOf("beta") >= 0) {
			var tab = browser.addTab("http://www.codepad.de/"+lang+"/software/firefox-add-ons/viewmarks-beta.html?"+action+"="+version);
		} else {
			var tab = browser.addTab("http://www.codepad.de/"+lang+"/software/firefox-add-ons/viewmarks.html?"+action+"="+version);
		}
		browser.selectedTab = tab;
	},
	
	openConfigDialog: function()
	{
		try {
			let create_history = ViewMarksPref.create_history;
			let history_duration = ViewMarksPref.history_duration;
			let create_trash = ViewMarksPref.create_trash;
			let trash_duration = ViewMarksPref.trash_duration;
			let update = ViewMarksPref.update;
			let features = "chrome,titlebar,toolbar,centerscreen,modal";

			if (this.platform == "Darwin") {
				window.open("chrome://viewmarks/content/config.xul", "dlgViewMarksConfig", features).focus();
			} else {
				let argObj = {};
				if (document.getElementById("dlgViewMarksView")) {
					if (ViewMarksView.folderId == ViewMarksData.historyFolder) {
						argObj.pane = "vmks_pref_history";
					}
					if (ViewMarksView.folderId == ViewMarksPref.trash_folder_id) {
						argObj.pane = "vmks_pref_trash";
					}
				}
				window.openDialog("chrome://viewmarks/content/config.xul", "dlgViewMarksConfig", features, argObj).focus();
			}
						
			if (create_history == true && ViewMarksPref.create_history == false) {
				ViewMarksHistory.clearHistory(true);
			}
			if (ViewMarksPref.history_duration < history_duration) {
				ViewMarksHistory.deleteOutdatedHistoryItems();
			}
			if (create_trash == true && ViewMarksPref.create_trash == false) {
				ViewMarksTrash.deleteAllTrashItems(true);
			}
			if (ViewMarksPref.trash_duration < trash_duration) {
				ViewMarksTrash.deleteOutdatedTrashItems();
			}
			if (update == false && ViewMarksPref.update == true) {
				ViewMarksUpdate.update();
			}
	
			this.dispatchGlobalEvent("history-changed");  
			ViewMarksTrash.update();
	
			ViewMarksUtil.showElement("vmks_qrcode_button", ViewMarksPref.getBoolPref("show_qrcode_urlbar"));
		} catch (e) {
			ViewMarksUtil.logerror(e);
			ViewMarksReport.openDialog(e);
		}
	},

	openLog: function(filename)
	{
		let file = ViewMarksData.getLocalFile(filename);
		let logfile = Components.classes["@mozilla.org/network/file-output-stream;1"]
			.createInstance(Components.interfaces.nsIFileOutputStream);
		logfile.init(file, 0x1a /*PR_WRONLY|PR_CREATE_FILE|PR_APPEND*/, -1, 0);
		return logfile;
	},

	writeLog: function(msg)
	{
		if (this.logfile == null) {
			this.logfile = this.openLog("viewmarks.log");
		}
		var s = (new Date()).toISOString() + " " + msg + "\n";
		this.logfile.write(s, s.length);
	},

	writeErrorLog: function(msg)
	{
		if (this.errorlog == null) {
			this.errorlog = this.openLog("error.log");
			this.writeErrorLog("---");
			this.writeErrorLog("System info: ViewMarks "+ViewMarksPref.getCharPref("version") + " running on " + ViewMarksUtil.appinfo.name + " " + ViewMarksUtil.appinfo.version + " (" + ViewMarksUtil.platform + ")");
		}
		msg = msg.split("\n");
		for (var i=0; i<msg.length; i++) {
			msg[i] = msg[i].trim();
			if (msg[i].length == 0) continue;
			let s = (new Date()).toISOString();
			if (i > 0) s += " ";
			s += " " + msg[i] + "\n";
			this.errorlog.write(s, s.length);
		}
	},
	
	logmsg: function(msg) 
	{
		if (ViewMarksPref.debug == false) return;
		this.consoleService.logStringMessage(msg);
		this.writeLog(msg);
	},
	
	logerror: function(msg) 
	{
		if (ViewMarksPref.debug == true) {
		  Components.utils.reportError(msg);
		}
		if (msg.name && msg.message) {
			msg = this.dumpError(msg);
		}

		if (typeof msg.stack === "undefined" && typeof msg.filename === "undefined") {
			for (var frame = Components.stack.caller; frame.filename; frame = frame.caller) {
				msg += "\n " + frame.filename + " [l." + frame.lineNumber + "]";
			}
		}

		this.writeLog(msg);
		this.writeErrorLog(msg);
	},

	alert: function(msg)
	{
		if (ViewMarksPref.debug == false) return;
		if (msg.name && msg.message) {
			this.dumpError(msg);
		} else {
			alert(msg);
		}
		this.writeLog("dump: "+msg);
	},

	dumpError: function(e)
	{
    var msg = "";
		msg += e.name + ": " + e.message + "\n";
		if (e.stack) {
			msg += e.stack + "\n";
		} else if (e.fileName && e.lineNumber) {
			msg += e.fileName + ":" + e.lineNumber + "\n";
		} 
		return msg;
  },


	mimeTypeTable: [
		[".html", "text/html"],
		[".htm", "text/html"]
	],

	getDocumentMimeType: function(doc)
	{
		let index = 0;
		try {
			for (var i=0; i<doc.body.childNodes.length; i++) {
				if (doc.body.childNodes[i].tagName) {
					index = i;
					break;
				}
			}
		} catch (e) {}
		try {
			if (doc.body.childNodes[index].tagName.toLowerCase() == "embed") {
				var type = doc.body.childNodes[index].getAttribute("type");
				if (type) return type;
			}
		} catch (e) {}
		try {
			if (doc.body.childNodes[index].tagName.toLowerCase() == "object") {
				var type = doc.body.childNodes[index].getAttribute("type");
				if (type) return type;
			}
		} catch (e) {}
		try {
			var url = doc.location.href.toLowerCase();
			for (var i=0; i<this.mimeTypeTable.length; i++) {
				if (this.endsWith(url, this.mimeTypeTable[i][0])) {
					return this.mimeTypeTable[i][1];
				}
			}
		} catch (e) {}
		return null;
	},

	showObjectInfo: function(obj)
	{
		var text = "object information (" + obj + "):\n";
		if (typeof obj.toSource == 'function') { 
			text += "properties:\n";
			text += " " + obj.toSource() + "\n";
		}
		if (obj.attributes) {
			text += "attributes:\n";
			for (var i=0; i<obj.attributes.length; i++) {
				text += " "+obj.attributes[i].nodeName+"="+obj.attributes[i].value+"\n";
			}
		} else {
			text += "no attributes";
		}
		this.logmsg(text);
	},

	showObjectProperties: function(obj, showAll)
	{
		ViewMarksUtil.logmsg("object properties: "+obj);
		for (var propertyName in obj) {
			if (showAll || (typeof obj.hasOwnProperty == 'function' && obj.hasOwnProperty(propertyName))) {
				ViewMarksUtil.logmsg(" "+propertyName+":"+obj[propertyName]);
			}
		}
	},
	
	getElementsByClassname: function(node, classname, tagname) 
	{
		var result = new Array();
		if (node == null)	node = document;
		if (tagname == null) tagname = '*';
		var list = node.getElementsByTagName(tagname);
		for (var i = 0; i < list.length; i++) {
			if (list[i].className == classname) {
				Array.add(result, list[i]);
			}
		}
		return result;
	},
	
	substArgs: function(text)
	{
		var newText = "";
		for (var i=1; i<arguments.length && i<10; i++) {
			for (var j=0; j<text.length; j++) {
				var c = text.charAt(j);
				if (c == '$') {
					c = text.charAt(j+1);
					if (c >= '1' && c <= '9') {
						var index = c - '0';
						if (index < arguments.length) {
							newText += arguments[index];
						} else {
							this.logerror("substArgs("+text+"): argument for $"+index+" missing");
						}
						j++;
					} else {
						newText += c;
					}
				} else {
					newText += c;
				}
			}
		}
		return newText;
	},
	
	startsWith: function(str, prefix)
	{
		return (str.substr(0, prefix.length) == prefix);
	},

	endsWith: function(str, suffix) {
	    return str.indexOf(suffix, str.length - suffix.length) !== -1;
	},
	
	openInNewTab: function(url, fRelated)
	{
		try {
		var browser = this.getBrowser();
		if (ViewMarksPref.xulAppInfo.version >= "3.6") {
			var tab = browser.addTab(url, {relatedToCurrent:fRelated});
		} else {
			var tab = browser.addTab(url);
		}
		try {
			if (ViewMarksPref.load_tabs_in_background == true) return;
		} catch (e) {}
		browser.selectedTab = tab;			
	} catch(e) {this.alert(e);}
	},

	getURIFromString: function(url)
	{
		var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);    
		try {
			return ioService.newURI(url, null, null);
		} catch (e) {
			return ioService.newURI("about:blank", null, null);
		}
	},

	showElement: function(id, state)
	{
		var node = document.getElementById(id);
		if (node == null) return;
		if (state == true) {
			node.removeAttribute("collapsed");
		} else {
			node.setAttribute("collapsed", true);
		}
	},

	setElementAttribute: function(id, name, value)
	{
		var node = document.getElementById(id);
		if (node == null) return;
		node.setAttribute(name, value);
	},

	insertWordBreaks: function(text, min, max)
	{
		if (text == null) return "";
		if (!min) min = text.length;
		if (!max) max = text.length;
		var list = ",.:;-_=?#+/&";
		var dest = "";
		for (var i=0; i<text.length; i++) {
			var c = text.substr(i, 1);
			dest = dest + c; 
			if (list.indexOf(c) >= 0) dest = dest + String.fromCharCode(0x200b);
			if (c == ' ' && i >= min) {dest = dest + "..."; break;}
			if (i >= max) {dest = dest + "..."; break;}
		}
		return dest;
	},

	enableNode: function(id, state)
	{
		var node = document.getElementById(id);
		if (state == true) {
			node.removeAttribute("disabled");
		} else {
			node.setAttribute("disabled", true);
		}
	},

	isOverElement: function(x, y, node)
	{
		if (x < node.boxObject.x) return false;
		if (y < node.boxObject.y) return false;
		if (x >= node.boxObject.x + node.boxObject.width) return false;
		if (y >= node.boxObject.y + node.boxObject.height) return false;
		return true;
	},

	sanitize: function(text)
	{
		return text.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
	},

	removeChars: function(text, remove)
	{
		let result = "";
		for (var i=0; i<text.length; i++) {
			let c = text.charAt(i);
			if (remove.indexOf(c) >= 0) continue;			
			result += c;
		}
		return result;
	}


};

ViewMarksUtil.getAddonVersion(
	function(version) {
		ViewMarksUtil.addonVersion = version;
	}
);



	