/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import nu.validator.htmlparser.impl.ByteReadable;

public final class BomSniffer {
    private final ByteReadable source;

    public BomSniffer(ByteReadable source) {
        this.source = source;
    }

    CharsetDecoder sniff() throws IOException {
        int b = this.source.readByte();
        if (b == 239) {
            b = this.source.readByte();
            if (b == 187) {
                b = this.source.readByte();
                if (b == 191) {
                    return Charset.forName("UTF-8").newDecoder();
                }
                return null;
            }
            return null;
        }
        if (b == 255) {
            b = this.source.readByte();
            if (b == 254) {
                return Charset.forName("UTF-16LE").newDecoder();
            }
            return null;
        }
        if (b == 254) {
            b = this.source.readByte();
            if (b == 255) {
                return Charset.forName("UTF-16BE").newDecoder();
            }
            return null;
        }
        return null;
    }
}

