/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.sax;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.common.DocumentModeHandler;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.CharacterHandler;
import nu.validator.htmlparser.impl.Tokenizer;
import nu.validator.htmlparser.impl.TreeBuilder;
import nu.validator.htmlparser.sax.SAXStreamer;
import nu.validator.htmlparser.sax.SAXTreeBuilder;
import nu.validator.saxtree.Document;
import nu.validator.saxtree.DocumentFragment;
import nu.validator.saxtree.TreeParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class HtmlParser
implements XMLReader {
    private Tokenizer tokenizer = null;
    private TreeBuilder<?> treeBuilder = null;
    private SAXStreamer saxStreamer = null;
    private SAXTreeBuilder saxTreeBuilder = null;
    private ContentHandler contentHandler = null;
    private LexicalHandler lexicalHandler = null;
    private DTDHandler dtdHandler = null;
    private EntityResolver entityResolver = null;
    private ErrorHandler errorHandler = null;
    private DocumentModeHandler documentModeHandler = null;
    private DoctypeExpectation doctypeExpectation = DoctypeExpectation.HTML;
    private boolean checkingNormalization = false;
    private boolean scriptingEnabled = false;
    private final List<CharacterHandler> characterHandlers = new LinkedList<CharacterHandler>();
    private XmlViolationPolicy contentSpacePolicy = XmlViolationPolicy.FATAL;
    private XmlViolationPolicy contentNonXmlCharPolicy = XmlViolationPolicy.FATAL;
    private XmlViolationPolicy commentPolicy = XmlViolationPolicy.FATAL;
    private XmlViolationPolicy namePolicy = XmlViolationPolicy.FATAL;
    private XmlViolationPolicy streamabilityViolationPolicy = XmlViolationPolicy.ALLOW;
    private boolean html4ModeCompatibleWithXhtml1Schemata;
    private boolean mappingLangToXmlLang;
    private XmlViolationPolicy xmlnsPolicy;
    private XmlViolationPolicy bogusXmlnsPolicy;
    private boolean reportingDoctype = true;
    private ErrorHandler treeBuilderErrorHandler;

    public HtmlParser() {
        this(XmlViolationPolicy.FATAL);
    }

    public HtmlParser(XmlViolationPolicy xmlPolicy) {
        this.setXmlPolicy(xmlPolicy);
    }

    private void lazyInit() {
        if (this.tokenizer == null) {
            if (this.streamabilityViolationPolicy == XmlViolationPolicy.ALLOW) {
                this.treeBuilder = this.saxTreeBuilder = new SAXTreeBuilder();
                this.saxStreamer = null;
            } else {
                this.treeBuilder = this.saxStreamer = new SAXStreamer();
                this.saxTreeBuilder = null;
            }
            this.tokenizer = new Tokenizer(this.treeBuilder);
            this.tokenizer.setErrorHandler(this.errorHandler);
            this.treeBuilder.setErrorHandler(this.treeBuilderErrorHandler);
            this.tokenizer.setCheckingNormalization(this.checkingNormalization);
            this.tokenizer.setCommentPolicy(this.commentPolicy);
            this.tokenizer.setContentNonXmlCharPolicy(this.contentNonXmlCharPolicy);
            this.tokenizer.setContentSpacePolicy(this.contentSpacePolicy);
            this.tokenizer.setHtml4ModeCompatibleWithXhtml1Schemata(this.html4ModeCompatibleWithXhtml1Schemata);
            this.tokenizer.setMappingLangToXmlLang(this.mappingLangToXmlLang);
            this.tokenizer.setXmlnsPolicy(this.xmlnsPolicy);
            for (CharacterHandler characterHandler : this.characterHandlers) {
                this.tokenizer.addCharacterHandler(characterHandler);
            }
            this.treeBuilder.setDoctypeExpectation(this.doctypeExpectation);
            this.treeBuilder.setDocumentModeHandler(this.documentModeHandler);
            this.treeBuilder.setIgnoringComments(this.lexicalHandler == null);
            this.treeBuilder.setScriptingEnabled(this.scriptingEnabled);
            this.treeBuilder.setReportingDoctype(this.reportingDoctype);
            if (this.saxStreamer != null) {
                this.saxStreamer.setContentHandler(this.contentHandler == null ? new DefaultHandler() : this.contentHandler);
                this.saxStreamer.setLexicalHandler(this.lexicalHandler);
            }
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/external-general-entities".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/external-parameter-entities".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/is-standalone".equals(name)) {
            return true;
        }
        if ("http://xml.org/sax/features/lexical-handler/parameter-entities".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return true;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/resolve-dtd-uris".equals(name)) {
            return true;
        }
        if ("http://xml.org/sax/features/string-interning".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/unicode-normalization-checking".equals(name)) {
            return this.isCheckingNormalization();
        }
        if ("http://xml.org/sax/features/use-attributes2".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/use-locator2".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/use-entity-resolver2".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/validation".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/xmlns-uris".equals(name)) {
            return false;
        }
        if ("http://xml.org/sax/features/xml-1.1".equals(name)) {
            return false;
        }
        if ("http://validator.nu/features/html4-mode-compatible-with-xhtml1-schemata".equals(name)) {
            return this.isHtml4ModeCompatibleWithXhtml1Schemata();
        }
        if ("http://validator.nu/features/mapping-lang-to-xml-lang".equals(name)) {
            return this.isMappingLangToXmlLang();
        }
        if ("http://validator.nu/features/scripting-enabled".equals(name)) {
            return this.isScriptingEnabled();
        }
        throw new SAXNotRecognizedException();
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(name)) {
            throw new SAXNotSupportedException("This parser does not suppert DeclHandler.");
        }
        if ("http://xml.org/sax/properties/document-xml-version".equals(name)) {
            return "1.0";
        }
        if ("http://xml.org/sax/properties/dom-node".equals(name)) {
            throw new SAXNotSupportedException("This parser does not walk the DOM.");
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.getLexicalHandler();
        }
        if ("http://xml.org/sax/properties/xml-string".equals(name)) {
            throw new SAXNotSupportedException("This parser does not expose the source as a string.");
        }
        if ("http://validator.nu/properties/content-space-policy".equals(name)) {
            return this.getContentSpacePolicy();
        }
        if ("http://validator.nu/properties/content-non-xml-char-policy".equals(name)) {
            return this.getContentNonXmlCharPolicy();
        }
        if ("http://validator.nu/properties/comment-policy".equals(name)) {
            return this.getCommentPolicy();
        }
        if ("http://validator.nu/properties/xmlns-policy".equals(name)) {
            return this.getXmlnsPolicy();
        }
        if ("http://validator.nu/properties/name-policy".equals(name)) {
            return this.getNamePolicy();
        }
        if ("http://validator.nu/properties/streamability-violation-policy".equals(name)) {
            return this.getStreamabilityViolationPolicy();
        }
        if ("http://validator.nu/properties/document-mode-handler".equals(name)) {
            return this.getDocumentModeHandler();
        }
        if ("http://validator.nu/properties/doctype-expectation".equals(name)) {
            return this.getDoctypeExpectation();
        }
        if ("http://validator.nu/properties/xml-policy".equals(name)) {
            throw new SAXNotSupportedException("Cannot get a convenience setter.");
        }
        throw new SAXNotRecognizedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource input) throws IOException, SAXException {
        this.lazyInit();
        try {
            this.treeBuilder.setFragmentContext(null);
            this.tokenize(input);
        }
        finally {
            Document document;
            if (this.saxTreeBuilder != null && (document = this.saxTreeBuilder.getDocument()) != null) {
                new TreeParser(this.contentHandler, this.lexicalHandler).parse(document);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFragment(InputSource input, String context) throws IOException, SAXException {
        this.lazyInit();
        try {
            this.treeBuilder.setFragmentContext(context);
            this.tokenize(input);
        }
        finally {
            if (this.saxTreeBuilder != null) {
                DocumentFragment fragment = this.saxTreeBuilder.getDocumentFragment();
                new TreeParser(this.contentHandler, this.lexicalHandler).parse(fragment);
            }
        }
    }

    private void tokenize(InputSource is) throws SAXException, IOException, MalformedURLException {
        if (is == null) {
            throw new IllegalArgumentException("Null input.");
        }
        if (is.getByteStream() == null && is.getCharacterStream() == null) {
            String systemId = is.getSystemId();
            if (systemId == null) {
                throw new IllegalArgumentException("No byte stream, no character stream nor URI.");
            }
            if (this.entityResolver != null) {
                is = this.entityResolver.resolveEntity(is.getPublicId(), systemId);
            }
            if (is.getByteStream() == null || is.getCharacterStream() == null) {
                is = new InputSource();
                is.setSystemId(systemId);
                is.setByteStream(new URL(systemId).openStream());
            }
        }
        this.tokenizer.tokenize(is);
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
        if (this.saxStreamer != null) {
            this.saxStreamer.setContentHandler(this.contentHandler == null ? new DefaultHandler() : this.contentHandler);
        }
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
        if (this.treeBuilder != null) {
            this.treeBuilder.setIgnoringComments(handler == null);
            if (this.saxStreamer != null) {
                this.saxStreamer.setLexicalHandler(handler);
            }
        }
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
        this.treeBuilderErrorHandler = handler;
        if (this.tokenizer != null) {
            this.tokenizer.setErrorHandler(handler);
            this.treeBuilder.setErrorHandler(handler);
        }
    }

    public void setTreeBuilderErrorHandlerOverride(ErrorHandler handler) {
        this.treeBuilderErrorHandler = handler;
        if (this.tokenizer != null) {
            this.treeBuilder.setErrorHandler(handler);
        }
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/external-general-entities".equals(name)) {
            throw new SAXNotSupportedException("Cannot set " + name + ".");
        }
        if ("http://xml.org/sax/features/external-parameter-entities".equals(name)) {
            throw new SAXNotSupportedException("Cannot set " + name + ".");
        }
        if ("http://xml.org/sax/features/is-standalone".equals(name)) {
            throw new SAXNotSupportedException("Cannot set " + name + ".");
        }
        if ("http://xml.org/sax/features/lexical-handler/parameter-entities".equals(name)) {
            throw new SAXNotSupportedException("Cannot set " + name + ".");
        }
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            throw new SAXNotSupportedException("Cannot set " + name + ".");
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            throw new SAXNotSupportedException("Cannot set " + name + ".");
        }
        if ("http://xml.org/sax/features/resolve-dtd-uris".equals(name)) {
            throw new SAXNotSupportedException("Cannot set " + name + ".");
        }
        if ("http://xml.org/sax/features/string-interning".equals(name)) {
            throw new SAXNotSupportedException("Cannot set " + name + ".");
        }
        if ("http://xml.org/sax/features/unicode-normalization-checking".equals(name)) {
            this.setCheckingNormalization(value);
        } else {
            if ("http://xml.org/sax/features/use-attributes2".equals(name)) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
            if ("http://xml.org/sax/features/use-locator2".equals(name)) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
            if ("http://xml.org/sax/features/use-entity-resolver2".equals(name)) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
            if ("http://xml.org/sax/features/validation".equals(name)) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
            if ("http://xml.org/sax/features/xmlns-uris".equals(name)) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
            if ("http://xml.org/sax/features/xml-1.1".equals(name)) {
                throw new SAXNotSupportedException("Cannot set " + name + ".");
            }
            if ("http://validator.nu/features/html4-mode-compatible-with-xhtml1-schemata".equals(name)) {
                this.setHtml4ModeCompatibleWithXhtml1Schemata(value);
            } else if ("http://validator.nu/features/mapping-lang-to-xml-lang".equals(name)) {
                this.setMappingLangToXmlLang(value);
            } else if ("http://validator.nu/features/scripting-enabled".equals(name)) {
                this.setScriptingEnabled(value);
            } else {
                throw new SAXNotRecognizedException();
            }
        }
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(name)) {
            throw new SAXNotSupportedException("This parser does not suppert DeclHandler.");
        }
        if ("http://xml.org/sax/properties/document-xml-version".equals(name)) {
            throw new SAXNotSupportedException("Can't set document-xml-version.");
        }
        if ("http://xml.org/sax/properties/dom-node".equals(name)) {
            throw new SAXNotSupportedException("Can't set dom-node.");
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            this.setLexicalHandler((LexicalHandler)value);
        } else {
            if ("http://xml.org/sax/properties/xml-string".equals(name)) {
                throw new SAXNotSupportedException("Can't set xml-string.");
            }
            if ("http://validator.nu/properties/content-space-policy".equals(name)) {
                this.setContentSpacePolicy((XmlViolationPolicy)((Object)value));
            } else if ("http://validator.nu/properties/content-non-xml-char-policy".equals(name)) {
                this.setContentNonXmlCharPolicy((XmlViolationPolicy)((Object)value));
            } else if ("http://validator.nu/properties/comment-policy".equals(name)) {
                this.setCommentPolicy((XmlViolationPolicy)((Object)value));
            } else if ("http://validator.nu/properties/xmlns-policy".equals(name)) {
                this.setXmlnsPolicy((XmlViolationPolicy)((Object)value));
            } else if ("http://validator.nu/properties/name-policy".equals(name)) {
                this.setNamePolicy((XmlViolationPolicy)((Object)value));
            } else if ("http://validator.nu/properties/streamability-violation-policy".equals(name)) {
                this.setStreamabilityViolationPolicy((XmlViolationPolicy)((Object)value));
            } else if ("http://validator.nu/properties/document-mode-handler".equals(name)) {
                this.setDocumentModeHandler((DocumentModeHandler)value);
            } else if ("http://validator.nu/properties/doctype-expectation".equals(name)) {
                this.setDoctypeExpectation((DoctypeExpectation)((Object)value));
            } else if ("http://validator.nu/properties/xml-policy".equals(name)) {
                this.setXmlPolicy((XmlViolationPolicy)((Object)value));
            } else {
                throw new SAXNotRecognizedException();
            }
        }
    }

    public boolean isCheckingNormalization() {
        return this.checkingNormalization;
    }

    public void setCheckingNormalization(boolean enable) {
        this.checkingNormalization = enable;
        if (this.tokenizer != null) {
            this.tokenizer.setCheckingNormalization(this.checkingNormalization);
        }
    }

    public void setCommentPolicy(XmlViolationPolicy commentPolicy) {
        this.commentPolicy = commentPolicy;
        if (this.tokenizer != null) {
            this.tokenizer.setCommentPolicy(commentPolicy);
        }
    }

    public void setContentNonXmlCharPolicy(XmlViolationPolicy contentNonXmlCharPolicy) {
        this.contentNonXmlCharPolicy = contentNonXmlCharPolicy;
        if (this.tokenizer != null) {
            this.tokenizer.setContentNonXmlCharPolicy(contentNonXmlCharPolicy);
        }
    }

    public void setContentSpacePolicy(XmlViolationPolicy contentSpacePolicy) {
        this.contentSpacePolicy = contentSpacePolicy;
        if (this.tokenizer != null) {
            this.tokenizer.setContentSpacePolicy(contentSpacePolicy);
        }
    }

    public boolean isScriptingEnabled() {
        return this.scriptingEnabled;
    }

    public void setScriptingEnabled(boolean scriptingEnabled) {
        this.scriptingEnabled = scriptingEnabled;
        if (this.treeBuilder != null) {
            this.treeBuilder.setScriptingEnabled(scriptingEnabled);
        }
    }

    public DoctypeExpectation getDoctypeExpectation() {
        return this.doctypeExpectation;
    }

    public void setDoctypeExpectation(DoctypeExpectation doctypeExpectation) {
        this.doctypeExpectation = doctypeExpectation;
        if (this.treeBuilder != null) {
            this.treeBuilder.setDoctypeExpectation(doctypeExpectation);
        }
    }

    public DocumentModeHandler getDocumentModeHandler() {
        return this.documentModeHandler;
    }

    public void setDocumentModeHandler(DocumentModeHandler documentModeHandler) {
        this.documentModeHandler = documentModeHandler;
    }

    public XmlViolationPolicy getStreamabilityViolationPolicy() {
        return this.streamabilityViolationPolicy;
    }

    public void setStreamabilityViolationPolicy(XmlViolationPolicy streamabilityViolationPolicy) {
        this.streamabilityViolationPolicy = streamabilityViolationPolicy;
    }

    public void setHtml4ModeCompatibleWithXhtml1Schemata(boolean html4ModeCompatibleWithXhtml1Schemata) {
        this.html4ModeCompatibleWithXhtml1Schemata = html4ModeCompatibleWithXhtml1Schemata;
        if (this.tokenizer != null) {
            this.tokenizer.setHtml4ModeCompatibleWithXhtml1Schemata(html4ModeCompatibleWithXhtml1Schemata);
        }
    }

    public Locator getDocumentLocator() {
        return this.tokenizer;
    }

    public boolean isHtml4ModeCompatibleWithXhtml1Schemata() {
        return this.html4ModeCompatibleWithXhtml1Schemata;
    }

    public void setMappingLangToXmlLang(boolean mappingLangToXmlLang) {
        this.mappingLangToXmlLang = mappingLangToXmlLang;
        if (this.tokenizer != null) {
            this.tokenizer.setMappingLangToXmlLang(mappingLangToXmlLang);
        }
    }

    public boolean isMappingLangToXmlLang() {
        return this.mappingLangToXmlLang;
    }

    public void setXmlnsPolicy(XmlViolationPolicy xmlnsPolicy) {
        if (xmlnsPolicy == XmlViolationPolicy.FATAL) {
            throw new IllegalArgumentException("Can't use FATAL here.");
        }
        this.xmlnsPolicy = xmlnsPolicy;
        if (this.tokenizer != null) {
            this.tokenizer.setXmlnsPolicy(xmlnsPolicy);
        }
    }

    public XmlViolationPolicy getXmlnsPolicy() {
        return this.xmlnsPolicy;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public XmlViolationPolicy getCommentPolicy() {
        return this.commentPolicy;
    }

    public XmlViolationPolicy getContentNonXmlCharPolicy() {
        return this.contentNonXmlCharPolicy;
    }

    public XmlViolationPolicy getContentSpacePolicy() {
        return this.contentSpacePolicy;
    }

    public void setReportingDoctype(boolean reportingDoctype) {
        this.reportingDoctype = reportingDoctype;
        if (this.treeBuilder != null) {
            this.treeBuilder.setReportingDoctype(reportingDoctype);
        }
    }

    public boolean isReportingDoctype() {
        return this.reportingDoctype;
    }

    public void setNamePolicy(XmlViolationPolicy namePolicy) {
        this.namePolicy = namePolicy;
        if (this.tokenizer != null) {
            this.tokenizer.setNamePolicy(namePolicy);
        }
    }

    public void setXmlPolicy(XmlViolationPolicy xmlPolicy) {
        this.setNamePolicy(xmlPolicy);
        this.setXmlnsPolicy(xmlPolicy == XmlViolationPolicy.FATAL ? XmlViolationPolicy.ALTER_INFOSET : xmlPolicy);
        this.setContentSpacePolicy(xmlPolicy);
        this.setContentNonXmlCharPolicy(xmlPolicy);
        this.setCommentPolicy(xmlPolicy);
        this.setBogusXmlnsPolicy(xmlPolicy);
    }

    public XmlViolationPolicy getNamePolicy() {
        return this.namePolicy;
    }

    public void setBogusXmlnsPolicy(XmlViolationPolicy bogusXmlnsPolicy) {
        this.bogusXmlnsPolicy = bogusXmlnsPolicy;
        if (this.tokenizer != null) {
            this.tokenizer.setBogusXmlnsPolicy(bogusXmlnsPolicy);
        }
    }

    public XmlViolationPolicy getBogusXmlnsPolicy() {
        return this.bogusXmlnsPolicy;
    }

    public void addCharacterHandler(CharacterHandler characterHandler) {
        this.characterHandlers.add(characterHandler);
        if (this.tokenizer != null) {
            this.tokenizer.addCharacterHandler(characterHandler);
        }
    }
}

