/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.sax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class HtmlSerializer
implements ContentHandler,
LexicalHandler {
    private static final String[] VOID_ELEMENTS = new String[]{"area", "base", "basefont", "bgsound", "br", "col", "embed", "frame", "hr", "img", "input", "link", "meta", "param", "spacer", "wbr"};
    private static final String[] NON_ESCAPING = new String[]{"iframe", "noembed", "noframes", "noscript", "plaintext", "script", "style", "xmp"};
    private int ignoreLevel = 0;
    private int escapeLevel = 0;
    private final Writer writer;

    private static Writer wrap(OutputStream out) {
        try {
            return new OutputStreamWriter(out, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public HtmlSerializer(OutputStream out) {
        this(HtmlSerializer.wrap(out));
    }

    public HtmlSerializer(Writer out) {
        this.writer = out;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.escapeLevel > 0) {
                this.writer.write(ch, start, length);
            } else {
                block7: for (int i = start; i < start + length; ++i) {
                    char c = ch[i];
                    switch (c) {
                        case '<': {
                            this.writer.write("&lt;");
                            continue block7;
                        }
                        case '>': {
                            this.writer.write("&gt;");
                            continue block7;
                        }
                        case '&': {
                            this.writer.write("&amp;");
                            continue block7;
                        }
                        default: {
                            this.writer.write(c);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.escapeLevel > 0) {
            --this.escapeLevel;
        }
        if (this.ignoreLevel > 0) {
            --this.ignoreLevel;
        } else {
            try {
                this.writer.write(60);
                this.writer.write(47);
                this.writer.write(localName);
                this.writer.write(62);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        try {
            this.writer.write("<!DOCTYPE html>\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.escapeLevel > 0) {
            ++this.escapeLevel;
        }
        if (this.ignoreLevel > 0 || !"http://www.w3.org/1999/xhtml".equals(uri)) {
            ++this.ignoreLevel;
            return;
        }
        try {
            this.writer.write(60);
            this.writer.write(localName);
            for (int i = 0; i < atts.getLength(); ++i) {
                this.writer.write(32);
                this.writer.write(atts.getLocalName(i));
                this.writer.write(61);
                this.writer.write(34);
                String val = atts.getValue(i);
                block9: for (int j = 0; j < val.length(); ++j) {
                    char c = val.charAt(j);
                    switch (c) {
                        case '\"': {
                            this.writer.write("&quot;");
                            continue block9;
                        }
                        case '<': {
                            this.writer.write("&lt;");
                            continue block9;
                        }
                        case '>': {
                            this.writer.write("&gt;");
                            continue block9;
                        }
                        case '&': {
                            this.writer.write("&amp;");
                            continue block9;
                        }
                        default: {
                            this.writer.write(c);
                        }
                    }
                }
                this.writer.write(34);
            }
            this.writer.write(62);
            if (Arrays.binarySearch(VOID_ELEMENTS, localName) > -1) {
                ++this.ignoreLevel;
                return;
            }
            if ("pre".equals(localName) || "textarea".equals(localName)) {
                this.writer.write(10);
            }
            if (this.escapeLevel == 0 && Arrays.binarySearch(NON_ESCAPING, localName) > -1) {
                this.escapeLevel = 1;
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.ignoreLevel > 0) {
            return;
        }
        try {
            this.writer.write("<!--");
            this.writer.write(ch, start, length);
            this.writer.write("-->");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }
}

