/**
 * 获取应用程序data目录
 **/
function getDataDir()
{
    if(!isQt())
        return "";

    return Qt.getDataDir();
}

/**
 * 获取应用程序temp目录
 **/
function getUserDir()
{
    if(!isQt())
        return "";

    return Qt.getUserDir();
}

/**
 * 获取验证码目录
 **/
function getCodeDir()
{
    if(!isQt())
        return "";

    return Qt.getCodeDir();
}

/**
 * 获取小号
 **/
function getAccount()
{
    if(!isQt())
        return "";

    return toJson(Qt.getAccount());
}

/**
 * 获取用户信息
 **/
function getUser()
{
    if(!isQt())
        return "";

    return toJson(Qt.getUser());
}

/**
 * 获取本地文件内容
 * @param fileName 文件名
 * @return 如果Qt存在返回文件内容
 **/
function getFile(fileName)
{
    if(!isQt())
        return "";

    return Qt.getFile(fileName);
}

/**
 * 获取LANGUAGE文件名
 **/
function getFileLan()
{
    if(!isQt())
        return "";

    return Qt.getFileLan();
}

function setFileLan(value)
{
    if(!isQt())
        return "";

    Qt.setFileLan(value);
}

/**
 * 保存文件内容
 **/
function saveFile(fileName,content)
{
    if(!isQt())
        return "";

    return Qt.saveFile(fileName,content);
}

/**
 * 获取验证码保存路径
 **/
function getCodeFile()
{
    if(!isQt())
        return "";

    return toJson(Qt.getCodeList());
}

/**
 * 输出日志到console
 * @param msg 输出内容
 **/
function log(msg)
{
    if(isQt())
        Qt.slLog(msg);
}

/**
 * 获取服务器地址
 **/
function getServerUrl()
{
    mServerUrl = isQt() ? Qt.getServerUrl() : mServerUrl;
}

function isQt()
{
    return isValue(typeof Qt);
}

/**
 * 获取用户名
 **/
function getUsername()
{
    var username = "38b74a38a95a0d65146cbff7a172c548";
    if(!isQt())
        return username;

    username = Qt.getUsername() == "" ? username : Qt.getUsername();
    return username;
}

function getPassword()
{
    var password = "";
    if (!isQt()) {
        return password;
    }
    
    password = Qt.getPassword();
    return password;
}

function openLink(url)
{
    if (isQt()) {
        Qt.openExternalBrowser(url);
    } else {
        location.href = url;
        /*window.open(url);*/
    }
}

function isAnonymous()
{
    var username = getUsername();
    return username.length == 32;
}

/**
 * 首页调用
 **/
function getTipUsername()
{
    var username = getUsername();

    if (!username) {
        return;
    }

    if (!isQt() && isUser()) {
        jsonp("user/userinfo.php",function(data){
            $("#title_username").html(data.email);
        });
        return;
    }

    if(isAnonymous()) {
        username = $.t("main.anonymous");
        mbox($.t("main.newbie"),3);
    }
    
    $("#title_username").html(username);

    return username;
}

/**
 * 获取密码加密方式
 * @param password 密码
 * @param code 验证码
 **/
function getPasswordEncode(password,code)
{
    if(!isQt())
        return;

    return Qt.getPasswordEncode(password,code);
}

/**
 * 获取远程数据
 * @param callbackFunc 回调函数，字符串
 * @param url 远程地址
 * @param post post数据
 **/
function getUrl(callbackFunc,url,post)
{
    if(!isQt())
        return;

    post = isValue(typeof post) ? post : "";
    Qt.getUrl(callbackFunc, url, post);
}

function getUserInfo(key)
{
    var userInfo = getUser();
    return !userInfo[key] ? '0' : userInfo[key];
}

function setUserInfo(key,value)
{
    if(!isQt()) return;

    var userInfo = getUser();
    userInfo[key] = value;

    Qt.setUserInfo(JSON.stringify(userInfo));
}

function getUserStat(key)
{
    var userStat = getUserDir() + "userStat";
    userStat = toJson(getFile(userStat));
    return !userStat[key] ? "0" : userStat[key] ;
}

function setUserStat(key,value)
{
    var userStat = getUserStat();
    userStat[key] = value;

    saveFile(getDataDir() + "userStat",JSON.stringify(userStat));
}

/**
 * 获取用户是否使用自动码
 **/
function getUseCode()
{
    var codeFile = getUserDir() + "userCode";
    return getFile(codeFile);
}

/**
 * 获取用户是否使用自动拨号
 **/
function getUseDial()
{
    var codeFile = getUserDir() + "userDial";
    return getFile(codeFile);
}

/**
 * 设置用户使用自动码
 * @param open
 **/
function setUseCode(open)
{
    var codeFile = getUserDir() + "userCode";
    if (open == 1) {
        saveFile(codeFile,1);
    } else {
        saveFile(codeFile,0);
    }
}

function setUseDial(open)
{
    var codeFile = getUserDir() + "userDial";
    if (open == 1) {
        saveFile(codeFile,1);
    } else {
        saveFile(codeFile,0);
    }
}

function getCodeValue()
{
    var codeFile = getUserDir() + "code";
    var code = toJson(getFile(codeFile));

    return code;
}

function setCodeValue(func,user,pass)
{
    var codeFile = getUserDir() + "code";
    /*var code = toJson(getFile(codeFile));*/
    var code = {
        "func" : func,
        "user" : user,
        "pass" : pass
    };

    saveFile(codeFile,JSON.stringify(code));

    return code;
}

function getDialValue()
{
    var codeFile = getUserDir() + "dial";
    var code = toJson(getFile(codeFile));

    return code;
}

function disableDialTipValue()
{
    if (confirm(t("message.closeDialTip")) == false) {
        return;
    }

    var dial = getDialValue();

    var codeFile = getUserDir() + "dial";
    var code = {
        "interval":dial.interval,
        "tip" : 0,
        "name" : dial.name,
        "user" : dial.user,
        "pass" : dial.pass
    };

    saveFile(codeFile,JSON.stringify(code));
}

function setDialValue(interval,tip,name,user,pass)
{
    var codeFile = getUserDir() + "dial";
    var code = {
        "interval":interval,
        "tip" : tip,
        "name" : name,
        "user" : user,
        "pass" : pass
    };

    saveFile(codeFile,JSON.stringify(code));

    return code;
}

function getMsg()
{
    if(!isQt())
        return;

    return Qt.getMsg();
}

function getPoolMsg()
{
    if(!isQt())
        return;

    return Qt.getPoolMsg();
}

/**
 * 查询是否自动开启
 **/
function getOpen()
{
    if(!isQt())
        return;

    return Qt.getOpen();
}

/**
 * 设置开机启动
 * @param open 不为空就是开机
 **/
function setOpen(open)
{
    if(!isQt())
        return;

    return Qt.setOpen(open);
}

/**
 * 设置登录帐号和密码
 * @param username 帐号
 * @param password 密码
 **/
function setUser(username,password)
{
    if(!isQt())
        return;

    Qt.setUser(username,password);
    getUsername();
}

/**
 * 重启客户端
 */
function restart()
{
    if (isQt()) {
        Qt.restart();
    }
}