/*
 * Decompiled with CFR 0.152.
 */
package com.android.phantom;

import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.net.Uri;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.Vibrator;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.android.phantom.Phantom;
import com.android.phantom.PhantomActivity;
import com.android.phantom.PhantomCallback;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;
import org.apache.http.conn.util.InetAddressUtils;

public class PhantomSurface
extends GLSurfaceView {
    private static String TAG = "PhantomSurface";
    private static final boolean DEBUG = false;
    private static final boolean ImmediateInput = false;
    public static SoundPool soundPool = null;
    public static int m_adViewShow = -1;
    public static int m_deviceWidth = 960;
    public static int m_deviceHeight = 640;
    public static String s_homeUrl = "http://www.tengzhiyi.com/";
    public static PhantomActivity g_context;
    static String s_pakFile;
    public static PhantomCallback s_callback;
    public static float s_gravity_x;
    public static float s_gravity_y;
    public static float s_gravity_z;
    private static Looper mSensorLooper;
    private static SensorEventListener mSensorEventListener;
    private static final int[] INPUT_SENSORS;
    private static LinkedList<RenderMessage> mRenderQueue;
    static int command_id_open;
    static int command_id_play;
    static int command_id_stop;
    static int command_id_pause;
    static int command_id_resume;
    static int command_id_openurl;
    static int command_id_openedit;
    static int command_id_closeedit;
    static int command_id_showad;
    static int command_id_hidead;
    static int command_id_buy;
    static int command_id_restore;
    public static int command_id_back;
    public static int command_id_wallpoint;
    private static LinkedList<RenderMessage> tempList;
    private static LinkedList<MediaInfo> mMediaInfos;
    private static LinkedList<SoundInfo> mSoundinfos;
    protected static final int MSGID_SETORIENTATION = 20;
    protected static final int MSGID_OPENWAVE = 21;
    protected static final int MSGID_PLAYWAVE = 22;
    protected static final int MSGID_CLOSEWAVE = 23;
    protected static final int MSGID_OPENMP3 = 24;
    protected static final int MSGID_PLAYMP3 = 25;
    protected static final int MSGID_PAUSEMP3 = 26;
    protected static final int MSGID_RESUMEMP3 = 27;
    protected static final int MSGID_CLOSEMP3 = 28;
    protected static final int MSGID_STOPMP3 = 29;
    protected static final int MSGID_SETVOLUME = 30;
    protected static final int MSGID_SHOWAD = 31;
    protected static final int MSGID_SHOWBUY = 32;
    protected static final int MSGID_RESTOREBUY = 33;
    protected static final int MSGID_OPENURL = 34;
    protected static final int MSGID_OPENEDIT = 35;
    protected static final int MSGID_CLOSEEDIT = 36;
    protected static final int MSGID_GOTO_MAIN = 37;
    protected static final int MSGID_CLEAR_PROJ = 38;
    protected static final int MSGID_ADD_PROJ = 39;
    protected static final int MSGID_UPDATE_PROJ = 40;
    protected static final int MSGID_ALERT = 41;
    public static MainCallback s_maincb;
    public static ProjCallback s_projcb;
    private static Handler mHandler;
    public static int g_mid;

    static {
        s_callback = null;
        s_gravity_x = 0.0f;
        s_gravity_y = 0.0f;
        s_gravity_z = 0.0f;
        mSensorLooper = null;
        mSensorEventListener = null;
        INPUT_SENSORS = new int[]{1, 4};
        mRenderQueue = new LinkedList();
        command_id_open = 1;
        command_id_play = 2;
        command_id_stop = 3;
        command_id_pause = 4;
        command_id_resume = 5;
        command_id_openurl = 6;
        command_id_openedit = 7;
        command_id_closeedit = 8;
        command_id_showad = 9;
        command_id_hidead = 10;
        command_id_buy = 11;
        command_id_restore = 12;
        command_id_back = 100;
        command_id_wallpoint = 101;
        tempList = new LinkedList();
        mMediaInfos = new LinkedList();
        mSoundinfos = new LinkedList();
        s_maincb = null;
        s_projcb = null;
        mHandler = new Handler(){

            public void handleMessage(Message msg) {
                block0 : switch (msg.what) {
                    case 20: {
                        if (msg.arg1 == 0) {
                            g_context.setRequestedOrientation(1);
                            break;
                        }
                        g_context.setRequestedOrientation(0);
                        break;
                    }
                    case 41: {
                        AlertDialog.Builder builder = new AlertDialog.Builder((Context)g_context);
                        builder.setTitle((CharSequence)"Message");
                        builder.setMessage((CharSequence)msg.obj.toString());
                        builder.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                            }
                        });
                        builder.create();
                        builder.show();
                        break;
                    }
                    case 38: {
                        if (s_projcb == null) break;
                        s_projcb.clearProj();
                        break;
                    }
                    case 40: {
                        if (s_projcb == null) break;
                        s_projcb.updateProj();
                        break;
                    }
                    case 39: {
                        String[] ret;
                        if (s_projcb == null || (ret = msg.obj.toString().split(",")).length != 2) break;
                        s_projcb.addProj(ret[0], ret[1], msg.arg1);
                        break;
                    }
                    case 37: {
                        if (s_maincb == null) break;
                        s_maincb.gotoMain();
                        break;
                    }
                    case 21: {
                        SoundInfo info = new SoundInfo();
                        String file = msg.obj.toString();
                        info.Open(file);
                        info.m_id = msg.arg1;
                        mSoundinfos.add(info);
                        break;
                    }
                    case 22: {
                        int i = 0;
                        while (i < mSoundinfos.size()) {
                            if (((SoundInfo)mSoundinfos.get((int)i)).m_id == msg.arg1) {
                                ((SoundInfo)mSoundinfos.get(i)).Play(1.0f, (float)msg.arg2 / 10000.0f, 1.0f);
                                break block0;
                            }
                            ++i;
                        }
                        break;
                    }
                    case 24: {
                        String file = msg.obj.toString();
                        MediaInfo info = new MediaInfo();
                        info.OpenT(file);
                        info.id = msg.arg1;
                        mMediaInfos.add(info);
                        break;
                    }
                    case 25: {
                        int k = 0;
                        while (k < mMediaInfos.size()) {
                            if (((MediaInfo)mMediaInfos.get((int)k)).id == msg.arg1) {
                                String str = msg.obj.toString();
                                ((MediaInfo)mMediaInfos.get(k)).PlayT(Integer.parseInt(str), (float)msg.arg2 / 10000.0f);
                                break block0;
                            }
                            ++k;
                        }
                        break;
                    }
                    case 30: {
                        int k = 0;
                        while (k < mMediaInfos.size()) {
                            if (((MediaInfo)mMediaInfos.get((int)k)).id == msg.arg1) {
                                ((MediaInfo)mMediaInfos.get(k)).SetVolume((float)msg.arg2 / 10000.0f);
                                break block0;
                            }
                            ++k;
                        }
                        break;
                    }
                    case 29: {
                        int k = 0;
                        while (k < mMediaInfos.size()) {
                            if (((MediaInfo)mMediaInfos.get((int)k)).id == msg.arg1) {
                                ((MediaInfo)mMediaInfos.get(k)).StopT();
                                break block0;
                            }
                            ++k;
                        }
                        break;
                    }
                    case 26: {
                        int k = 0;
                        while (k < mMediaInfos.size()) {
                            if (((MediaInfo)mMediaInfos.get((int)k)).id == msg.arg1) {
                                if (((MediaInfo)mMediaInfos.get((int)k)).media == null) break block0;
                                ((MediaInfo)mMediaInfos.get((int)k)).media.pause();
                                break block0;
                            }
                            ++k;
                        }
                        break;
                    }
                    case 27: {
                        int k = 0;
                        while (k < mMediaInfos.size()) {
                            if (((MediaInfo)mMediaInfos.get((int)k)).id == msg.arg1) {
                                if (((MediaInfo)mMediaInfos.get((int)k)).media == null) break block0;
                                ((MediaInfo)mMediaInfos.get((int)k)).media.start();
                                break block0;
                            }
                            ++k;
                        }
                        break;
                    }
                    case 28: {
                        int k = 0;
                        while (k < mMediaInfos.size()) {
                            if (((MediaInfo)mMediaInfos.get((int)k)).id == msg.arg1) {
                                ((MediaInfo)mMediaInfos.get(k)).StopT();
                                break block0;
                            }
                            ++k;
                        }
                        break;
                    }
                    case 31: {
                        if (s_callback == null) break;
                        s_callback.showAd(msg.arg1, msg.arg2);
                        break;
                    }
                    case 32: {
                        if (s_callback == null) break;
                        s_callback.showBuy(msg.obj.toString());
                        break;
                    }
                    case 33: {
                        if (s_callback == null) break;
                        s_callback.restoreBuy(msg.obj.toString());
                        break;
                    }
                    case 34: {
                        Intent intent = new Intent();
                        intent.setData(Uri.parse((String)msg.obj.toString()));
                        intent.setAction("android.intent.action.VIEW");
                        g_context.startActivity(intent);
                        break;
                    }
                    case 35: {
                        Rect rc = (Rect)msg.obj;
                        Bundle b = msg.getData();
                        if (s_callback == null) break;
                        s_callback.openEdit(b.getString("Text"), rc.left, rc.top, rc.right, rc.bottom, msg.arg1);
                        break;
                    }
                    case 36: {
                        if (s_callback == null) break;
                        String str = s_callback.closeEdit();
                        PhantomSurface.SendInput2(0, command_id_closeedit, msg.arg1, 0, str);
                        int cfr_ignored_0 = msg.arg1;
                        break;
                    }
                }
            }
        };
        g_mid = 1;
    }

    public String addPackageFile() {
        String apkFilePath;
        String packageName = g_context.getApplication().getPackageName();
        try {
            apkFilePath = PhantomSurface.g_context.getApplication().getPackageManager().getApplicationInfo((String)packageName, (int)0).sourceDir;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to locate assets, aborting...");
        }
        return apkFilePath;
    }

    public static void SetCallback(PhantomCallback c) {
        s_callback = c;
    }

    public PhantomSurface(PhantomActivity act, int[] codes) {
        super((Context)act.getApplication());
        g_context = act;
        s_pakFile = this.addPackageFile();
        File str = g_context.getFilesDir();
        String path = String.valueOf(str.getPath()) + "/";
        DisplayMetrics metrics = new DisplayMetrics();
        g_context.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        m_deviceWidth = metrics.widthPixels;
        m_deviceHeight = metrics.heightPixels;
        Phantom.onCreate(s_pakFile, path, codes);
        this.init(false, 16, 0);
        if (mSensorEventListener == null) {
            SensorManager mSensorMgr = (SensorManager)g_context.getSystemService("sensor");
            Sensor sensorAcc = mSensorMgr.getDefaultSensor(1);
            SensorEventListener lsn = new SensorEventListener(){

                public void onSensorChanged(SensorEvent e) {
                    float x = e.values[0];
                    float y = e.values[1];
                    float z = e.values[2];
                    int ori = g_context.getRequestedOrientation();
                    int confori = PhantomSurface.g_context.getResources().getConfiguration().orientation;
                    if (confori == 2) {
                        s_gravity_x = y * 0.1f;
                        s_gravity_y = x * 0.1f;
                    } else {
                        s_gravity_x = -x * 0.1f;
                        s_gravity_y = y * 0.1f;
                    }
                    s_gravity_z = z * 0.1f;
                }

                public void onAccuracyChanged(Sensor arg0, int arg1) {
                }
            };
            mSensorMgr.registerListener(lsn, sensorAcc, 1);
            mSensorEventListener = new SensorEventListener(){

                public void onSensorChanged(SensorEvent event) {
                    if (event.sensor.getType() == 1) {
                        Phantom.updateAcc(-event.values[1], event.values[0], event.values[2], event.timestamp);
                    } else if (event.sensor.getType() == 4) {
                        Phantom.updateGyro(-event.values[1], event.values[0], event.values[2], event.timestamp);
                    }
                }

                public void onAccuracyChanged(Sensor sensor, int accuracy) {
                }
            };
            Thread sensorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Looper.prepare();
                    mSensorLooper = Looper.myLooper();
                    Handler handler = new Handler();
                    SensorManager sensorManager = (SensorManager)g_context.getSystemService("sensor");
                    int[] nArray = INPUT_SENSORS;
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int sensorType = nArray[n2];
                        Sensor sensor = sensorManager.getDefaultSensor(sensorType);
                        sensorManager.registerListener(mSensorEventListener, sensor, 0, handler);
                        ++n2;
                    }
                    Looper.loop();
                }
            });
            sensorThread.start();
        }
    }

    public PhantomSurface(Context context, boolean translucent, int depth, int stencil) {
        super(context);
        this.init(translucent, depth, stencil);
    }

    private void init(boolean translucent, int depth, int stencil) {
        if (translucent) {
            this.getHolder().setFormat(-3);
        }
        this.setEGLContextFactory(new ContextFactory());
        this.setEGLConfigChooser(translucent ? new ConfigChooser(8, 8, 8, 8, depth, stencil) : new ConfigChooser(5, 6, 5, 0, depth, stencil));
        this.setRenderer(new Renderer());
    }

    private static void checkEglError(String prompt, EGL10 egl) {
        int error;
        while ((error = egl.eglGetError()) != 12288) {
            Log.e((String)TAG, (String)String.format("%s: EGL error: 0x%x", prompt, error));
        }
    }

    public boolean onKey(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.SendInput(0, command_id_back, 0, 0);
            return false;
        }
        return false;
    }

    public boolean isPtIn(Rect rc, int x, int y) {
        return x >= rc.left && x <= rc.right && y >= rc.top && y <= rc.bottom;
    }

    public boolean onTouch(MotionEvent event) {
        int eventaction = event.getAction();
        int index = event.getActionIndex();
        switch (eventaction) {
            case 0: {
                int i = 0;
                while (i < event.getPointerCount()) {
                    int x = (int)event.getX(i);
                    int y = (int)event.getY(i);
                    this.SendInput(event.getPointerId(i), 0, x, y);
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < event.getPointerCount()) {
                    int x = (int)event.getX(i);
                    int y = (int)event.getY(i);
                    this.SendInput(event.getPointerId(i), 1, x, y);
                    ++i;
                }
                break;
            }
            case 5: {
                int x = (int)event.getX(0);
                int y = (int)event.getY(0);
                this.SendInput(0, 0, x, y);
                break;
            }
            case 6: {
                int x = (int)event.getX(0);
                int y = (int)event.getY(0);
                this.SendInput(0, 1, x, y);
                break;
            }
            case 3: {
                int i = 0;
                while (i < event.getPointerCount()) {
                    int x = (int)event.getX(i);
                    int y = (int)event.getY(i);
                    this.SendInput(event.getPointerId(i), 1, x, y);
                    ++i;
                }
                break;
            }
            case 2: {
                String str = String.format("a2index:%d,count:%d,(%d,%d)", index, event.getPointerCount(), (int)event.getRawX(), (int)event.getRawY());
                int i = 0;
                while (i < event.getPointerCount()) {
                    int id1 = event.getPointerId(i);
                    str = String.valueOf(str) + String.format(",id%d:%d(%.0f,%.0f)", i, id1, Float.valueOf(event.getX(i)), Float.valueOf(event.getY(i)));
                    ++i;
                }
                Log.i((String)"lww", (String)str);
                i = 0;
                while (i < event.getPointerCount()) {
                    int x = (int)event.getX(i);
                    int y = (int)event.getY(i);
                    this.SendInput(event.getPointerId(i), 2, x, y);
                    ++i;
                }
                break;
            }
            case 261: {
                int x = (int)event.getX(1);
                int y = (int)event.getY(1);
                this.SendInput(1, 0, x, y);
                break;
            }
            case 262: {
                int x = (int)event.getX(1);
                int y = (int)event.getY(1);
                this.SendInput(1, 1, x, y);
                break;
            }
            case 517: {
                int x = (int)event.getX(2);
                int y = (int)event.getY(2);
                this.SendInput(1, 0, x, y);
                break;
            }
            case 518: {
                int x = (int)event.getX(2);
                int y = (int)event.getY(2);
                this.SendInput(1, 1, x, y);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(int id, String str) {
        RenderMessage cmd = new RenderMessage();
        cmd.code = 1000;
        cmd.index = id;
        cmd.temp = str;
        LinkedList<RenderMessage> linkedList = mRenderQueue;
        synchronized (linkedList) {
            mRenderQueue.add(cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SendInput(int index, int code, int x, int y) {
        RenderMessage cmd = new RenderMessage();
        cmd.code = code;
        cmd.index = index;
        cmd.x = x;
        cmd.y = y;
        LinkedList<RenderMessage> linkedList = mRenderQueue;
        synchronized (linkedList) {
            mRenderQueue.add(cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SendInput2(int index, int code, int x, int y, String str) {
        RenderMessage cmd = new RenderMessage();
        cmd.code = code;
        cmd.index = index;
        cmd.x = x;
        cmd.y = y;
        cmd.temp = str;
        LinkedList<RenderMessage> linkedList = mRenderQueue;
        synchronized (linkedList) {
            mRenderQueue.add(cmd);
        }
    }

    public static void SaveConfig(String key, String value) {
        SharedPreferences preferences = g_context.getSharedPreferences("phantom", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public static String LoadConfig(String key) {
        SharedPreferences preferences = g_context.getSharedPreferences("phantom", 0);
        return preferences.getString(key, "");
    }

    public static String GetDeviceName() {
        Build bd = new Build();
        String model = String.valueOf(Build.MODEL) + Build.ID;
        return model;
    }

    public static String GetHomeUrl() {
        return s_homeUrl;
    }

    public static void Utf8ToWideOS(String str) {
        try {
            byte[] result = str.getBytes("UnicodeLittle");
            Phantom.setByteArray(result);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void WideToUtf8OS(byte[] str, int length) {
    }

    public static void SetViewOrientation(int ori) {
        Message msg = new Message();
        msg.what = 20;
        msg.arg1 = ori;
        mHandler.sendMessage(msg);
    }

    public static int GetTextureSize(int n) {
        int v = 2;
        int i = 0;
        while (i < 32) {
            if (n <= v) {
                return v;
            }
            v *= 2;
            ++i;
        }
        return 1024;
    }

    public static void DrawTexts(String font, String str, int fontSize, int fontStyle, int alignment) {
        Paint p = new Paint(256);
        int style = 0;
        if (fontStyle == 1) {
            style = 1;
        } else if (fontStyle == 2) {
            style = 2;
        } else if (fontStyle == 3) {
            style = 3;
        }
        Typeface typeface = Typeface.create((String)font, (int)style);
        p.setAntiAlias(true);
        p.setColor(-1);
        p.setTypeface(typeface);
        p.setTextSize((float)fontSize);
        ArrayList<String> strlist = new ArrayList<String>();
        int last = 0;
        int i = 0;
        while (i <= str.length()) {
            block24: {
                boolean bend;
                block23: {
                    block22: {
                        bend = false;
                        if (i != str.length()) break block22;
                        ++i;
                        bend = true;
                        break block23;
                    }
                    if (str.charAt(i) == '\r') break block24;
                    if (str.charAt(i) == '\n') {
                        bend = true;
                    }
                }
                if (bend) {
                    if (i > str.length()) {
                        --i;
                    }
                    strlist.add(str.substring(last, i));
                    last = i + 1;
                }
            }
            ++i;
        }
        Paint.FontMetrics fm = p.getFontMetrics();
        int sizeW = 0;
        int sizeH = fontSize * strlist.size();
        ArrayList<Rect> rects = new ArrayList<Rect>();
        if (strlist.size() == 1) {
            Rect bounds1 = new Rect();
            p.getTextBounds(str, 0, str.length(), bounds1);
            sizeW = bounds1.width() + 2;
        } else {
            int i2 = 0;
            while (i2 < strlist.size()) {
                Rect rctemp = new Rect();
                p.getTextBounds((String)strlist.get(i2), 0, ((String)strlist.get(i2)).length(), rctemp);
                rects.add(rctemp);
                int w = rctemp.width() + 2;
                if (w > sizeW) {
                    sizeW = w;
                }
                ++i2;
            }
        }
        int bmw = PhantomSurface.GetTextureSize(sizeW);
        int bmh = PhantomSurface.GetTextureSize(sizeH);
        Bitmap bitmap = Bitmap.createBitmap((int)bmw, (int)bmh, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(0);
        float top = (float)fontSize + fm.top - fm.ascent;
        if (strlist.size() == 1) {
            canvas.drawText(str, 0.0f, top, p);
        } else {
            int i3 = 0;
            while (i3 < strlist.size()) {
                Rect rctemp = (Rect)rects.get(i3);
                int left = 0;
                if ((alignment & 1) > 0) {
                    left = (sizeW - rctemp.width()) / 2;
                } else if ((alignment & 2) > 0) {
                    left = sizeW - rctemp.width();
                }
                canvas.drawText((String)strlist.get(i3), (float)left, top + (float)(i3 * fontSize), p);
                ++i3;
            }
        }
        int[] pixels = new int[bitmap.getWidth() * bitmap.getHeight()];
        bitmap.getPixels(pixels, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        Phantom.setPixels(pixels, bitmap.getWidth(), bitmap.getHeight(), sizeW, sizeH);
    }

    public static void OnGotoMain() {
        Message msg = new Message();
        msg.what = 37;
        mHandler.sendMessage(msg);
    }

    public static void ClearProject() {
        Message msg = new Message();
        msg.what = 38;
        mHandler.sendMessage(msg);
    }

    public static void UpdateProject() {
        Message msg = new Message();
        msg.what = 40;
        mHandler.sendMessage(msg);
    }

    public static void AddProject(String projName, String time, int index) {
        Message msg = new Message();
        msg.what = 39;
        msg.arg1 = index;
        msg.obj = String.valueOf(projName) + "," + time;
        mHandler.sendMessage(msg);
    }

    public static void onAlert(String m) {
        Message msg = new Message();
        msg.what = 41;
        msg.obj = m;
        mHandler.sendMessage(msg);
    }

    public static int OpenWave(String file) {
        Message msg = new Message();
        msg.what = 21;
        msg.arg1 = ++g_mid;
        msg.obj = file;
        mHandler.sendMessage(msg);
        return g_mid;
    }

    public static void PlayWave(int id, float fVolume) {
        Message msg = new Message();
        msg.what = 22;
        msg.arg1 = id;
        msg.arg2 = (int)(fVolume * 10000.0f);
        mHandler.sendMessage(msg);
    }

    public static void CloseWave(int id) {
        Message msg = new Message();
        msg.what = 23;
        msg.arg1 = id;
        mHandler.sendMessage(msg);
    }

    public static int OpenMp3(String path) {
        Message msg = new Message();
        msg.what = 24;
        msg.arg1 = ++g_mid;
        msg.obj = path;
        mHandler.sendMessage(msg);
        return g_mid;
    }

    public static void PlayMp3(int id, int loopCount, float fVolume) {
        Message msg = new Message();
        msg.what = 25;
        msg.arg1 = id;
        msg.arg2 = (int)(fVolume * 10000.0f);
        msg.obj = loopCount;
        mHandler.sendMessage(msg);
    }

    public static void PauseMp3(int id) {
        Message msg = new Message();
        msg.what = 26;
        msg.arg1 = id;
        mHandler.sendMessage(msg);
    }

    public static void ResumeMp3(int id) {
        Message msg = new Message();
        msg.what = 27;
        msg.arg1 = id;
        mHandler.sendMessage(msg);
    }

    public static void StopMp3(int id) {
        Message msg = new Message();
        msg.what = 29;
        msg.arg1 = id;
        mHandler.sendMessage(msg);
    }

    public static void CloseMp3(int id) {
        Message msg = new Message();
        msg.what = 28;
        msg.arg1 = id;
        mHandler.sendMessage(msg);
    }

    public static void SetVolumeMp3(int id, float fVolume) {
        Message msg = new Message();
        msg.what = 30;
        msg.arg1 = id;
        msg.arg2 = (int)(fVolume * 10000.0f);
        mHandler.sendMessage(msg);
    }

    public static void ShowAd(int type, int bshow) {
        Message msg = new Message();
        msg.what = 31;
        msg.arg1 = type;
        msg.arg2 = bshow;
        mHandler.sendMessage(msg);
    }

    public static void ShowBuy(String str) {
        Message msg = new Message();
        msg.what = 32;
        msg.obj = str;
        mHandler.sendMessage(msg);
    }

    public static void RestoreBuy(String str) {
        Message msg = new Message();
        msg.what = 33;
        msg.obj = str;
        mHandler.sendMessage(msg);
    }

    public static void OpenUrl(String str) {
        Message msg = new Message();
        msg.what = 34;
        msg.obj = str;
        mHandler.sendMessage(msg);
    }

    public static int GetMemoryFree() {
        ActivityManager am = (ActivityManager)g_context.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        return (int)mi.availMem;
    }

    public static void OnVibrator(int mill) {
        Vibrator vib = (Vibrator)g_context.getSystemService("vibrator");
        vib.vibrate((long)mill);
    }

    public static void OpenEdit(String strDefault, int x, int y, int w, int h, int id) {
        Message msg = new Message();
        msg.what = 35;
        msg.arg1 = id;
        msg.arg2 = y;
        Rect rc = new Rect();
        rc.left = x;
        rc.top = y;
        rc.right = x + w;
        rc.bottom = y + h;
        Bundle bundleData = new Bundle();
        bundleData.putString("Text", strDefault);
        msg.setData(bundleData);
        msg.obj = rc;
        mHandler.sendMessage(msg);
    }

    public static void CloseEdit(int iscancel) {
        Message msg = new Message();
        msg.what = 35;
        mHandler.sendMessage(msg);
    }

    public static String GetLocalIP() {
        try {
            Enumeration<NetworkInterface> mEnumeration = NetworkInterface.getNetworkInterfaces();
            while (mEnumeration.hasMoreElements()) {
                NetworkInterface intf = mEnumeration.nextElement();
                Enumeration<InetAddress> enumIPAddr = intf.getInetAddresses();
                while (enumIPAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIPAddr.nextElement();
                    String ret = inetAddress.getHostAddress().toString();
                    if (inetAddress.isLoopbackAddress() || !InetAddressUtils.isIPv4Address((String)inetAddress.getHostAddress())) continue;
                    return ret;
                }
            }
        }
        catch (SocketException ex) {
            System.err.print("error");
        }
        return "";
    }

    static /* synthetic */ LinkedList access$4() {
        return mRenderQueue;
    }

    static /* synthetic */ LinkedList access$5() {
        return tempList;
    }

    public static class AverageValue {
        float[] xlist = null;
        float[] ylist = null;
        float[] zlist = null;
        public float x = 0.0f;
        public float y = 0.0f;
        public float z = 0.0f;
        public int maxavg = 0;
        int count = 0;

        AverageValue(int _ma) {
            this.maxavg = _ma;
            this.xlist = new float[this.maxavg];
            this.ylist = new float[this.maxavg];
            this.zlist = new float[this.maxavg];
        }

        void add(float _x, float _y, float _z) {
            if (this.maxavg == 1) {
                this.x = _x;
                this.y = _y;
                this.z = _z;
                return;
            }
            ++this.count;
            this.xlist[this.count % this.maxavg] = _x;
            this.ylist[this.count % this.maxavg] = _y;
            this.zlist[this.count % this.maxavg] = _z;
            int ac = this.count;
            if (ac > this.maxavg) {
                ac = this.maxavg;
            }
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
            int i = 0;
            while (i < ac) {
                this.x += this.xlist[i];
                this.y += this.ylist[i];
                this.z += this.zlist[i];
                ++i;
            }
            this.x /= (float)ac;
            this.y /= (float)ac;
            this.z /= (float)ac;
        }
    }

    private static class ConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private static int EGL_OPENGL_ES2_BIT = 4;
        private static int[] s_configAttribs2 = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, EGL_OPENGL_ES2_BIT, 12344};
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;
        private int[] mValue = new int[1];

        public ConfigChooser(int r, int g, int b, int a, int depth, int stencil) {
            this.mRedSize = r;
            this.mGreenSize = g;
            this.mBlueSize = b;
            this.mAlphaSize = a;
            this.mDepthSize = depth;
            this.mStencilSize = stencil;
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            egl.eglChooseConfig(display, s_configAttribs2, null, 0, num_config);
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            egl.eglChooseConfig(display, s_configAttribs2, configs, numConfigs, num_config);
            return this.chooseConfig(egl, display, configs);
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            EGLConfig[] eGLConfigArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                EGLConfig config = eGLConfigArray[n2];
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d >= this.mDepthSize && s >= this.mStencilSize) {
                    int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                    int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                    int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                    int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                    if (r == this.mRedSize && g == this.mGreenSize && b == this.mBlueSize && a == this.mAlphaSize) {
                        return config;
                    }
                }
                ++n2;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultValue;
        }

        private void printConfigs(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            int numConfigs = configs.length;
            Log.w((String)TAG, (String)String.format("%d configurations", numConfigs));
            int i = 0;
            while (i < numConfigs) {
                Log.w((String)TAG, (String)String.format("Configuration %d:\n", i));
                this.printConfig(egl, display, configs[i]);
                ++i;
            }
        }

        private void printConfig(EGL10 egl, EGLDisplay display, EGLConfig config) {
            int[] attributes = new int[]{12320, 12321, 12322, 12323, 12324, 12325, 12326, 12327, 12328, 12329, 12330, 12331, 12332, 12333, 12334, 12335, 12336, 12337, 12338, 12339, 12340, 12343, 12342, 12341, 12345, 12346, 12347, 12348, 12349, 12350, 12351, 12352, 12354};
            String[] names = new String[]{"EGL_BUFFER_SIZE", "EGL_ALPHA_SIZE", "EGL_BLUE_SIZE", "EGL_GREEN_SIZE", "EGL_RED_SIZE", "EGL_DEPTH_SIZE", "EGL_STENCIL_SIZE", "EGL_CONFIG_CAVEAT", "EGL_CONFIG_ID", "EGL_LEVEL", "EGL_MAX_PBUFFER_HEIGHT", "EGL_MAX_PBUFFER_PIXELS", "EGL_MAX_PBUFFER_WIDTH", "EGL_NATIVE_RENDERABLE", "EGL_NATIVE_VISUAL_ID", "EGL_NATIVE_VISUAL_TYPE", "EGL_PRESERVED_RESOURCES", "EGL_SAMPLES", "EGL_SAMPLE_BUFFERS", "EGL_SURFACE_TYPE", "EGL_TRANSPARENT_TYPE", "EGL_TRANSPARENT_RED_VALUE", "EGL_TRANSPARENT_GREEN_VALUE", "EGL_TRANSPARENT_BLUE_VALUE", "EGL_BIND_TO_TEXTURE_RGB", "EGL_BIND_TO_TEXTURE_RGBA", "EGL_MIN_SWAP_INTERVAL", "EGL_MAX_SWAP_INTERVAL", "EGL_LUMINANCE_SIZE", "EGL_ALPHA_MASK_SIZE", "EGL_COLOR_BUFFER_TYPE", "EGL_RENDERABLE_TYPE", "EGL_CONFORMANT"};
            int[] value = new int[1];
            int i = 0;
            while (i < attributes.length) {
                int attribute = attributes[i];
                String name = names[i];
                if (egl.eglGetConfigAttrib(display, config, attribute, value)) {
                    Log.w((String)TAG, (String)String.format("  %s: %d\n", name, value[0]));
                } else {
                    while (egl.eglGetError() != 12288) {
                    }
                }
                ++i;
            }
        }
    }

    private static class ContextFactory
    implements GLSurfaceView.EGLContextFactory {
        private static int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private ContextFactory() {
        }

        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig eglConfig) {
            Log.w((String)TAG, (String)"creating OpenGL ES 2.0 context");
            PhantomSurface.checkEglError("Before eglCreateContext", egl);
            int[] attrib_list = new int[]{EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
            EGLContext context = egl.eglCreateContext(display, eglConfig, EGL10.EGL_NO_CONTEXT, attrib_list);
            PhantomSurface.checkEglError("After eglCreateContext", egl);
            return context;
        }

        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            egl.eglDestroyContext(display, context);
        }
    }

    public static interface MainCallback {
        public void gotoMain();
    }

    private static final class MediaInfo
    implements MediaPlayer.OnPreparedListener {
        MediaPlayer media = null;
        int id;
        boolean m_playing = false;
        boolean m_prepare = false;

        private MediaInfo() {
        }

        public void OpenT(String file) {
            if (this.media != null) {
                this.media.release();
                this.media = null;
            }
            try {
                AssetFileDescriptor afd = g_context.getAssets().openFd(file);
                if (afd != null) {
                    if (this.media == null) {
                        this.media = new MediaPlayer();
                    }
                    this.media.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
                    this.media.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
                    this.media.prepareAsync();
                    this.m_playing = false;
                    this.m_prepare = false;
                    return;
                }
            }
            catch (Exception afd) {
                // empty catch block
            }
            if (this.media == null) {
                this.media = new MediaPlayer();
            }
            try {
                this.media.setDataSource(file);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return;
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            this.media.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.media.prepareAsync();
            this.m_playing = false;
        }

        public void StopT() {
            if (this.media == null) {
                return;
            }
            if (this.media.isPlaying()) {
                this.media.pause();
                this.media.seekTo(0);
            }
            this.m_playing = false;
        }

        public void PlayT(int loopCount, float fVolume) {
            if (this.media != null) {
                try {
                    this.media.setVolume(fVolume, fVolume);
                    this.media.setLooping(loopCount != 0);
                    if (this.m_prepare) {
                        this.media.start();
                    }
                    this.m_playing = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void SetVolume(float fVolume) {
            if (this.media != null) {
                try {
                    this.media.setVolume(fVolume, fVolume);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void onPrepared(MediaPlayer mp) {
            this.m_prepare = true;
            if (this.m_playing) {
                mp.start();
            }
        }
    }

    public static interface ProjCallback {
        public void clearProj();

        public void updateProj();

        public void addProj(String var1, String var2, int var3);
    }

    private static final class RenderMessage {
        int code;
        int index;
        int x;
        int y;
        String temp;

        private RenderMessage() {
        }
    }

    private static class Renderer
    implements GLSurfaceView.Renderer {
        private final float[] mRotationMatrix = new float[16];
        private final float[] mRvalues = new float[3];

        private Renderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void onDrawFrame(GL10 gl) {
            bHasCmd = false;
            cmd = null;
            var4_4 = PhantomSurface.access$4();
            synchronized (var4_4) {
                if (PhantomSurface.access$4().size() > 0) {
                    PhantomSurface.access$5().addAll(PhantomSurface.access$4());
                }
                PhantomSurface.access$4().clear();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                if (true) ** GOTO lbl36
            }
            do {
                cmd = (RenderMessage)PhantomSurface.access$5().removeFirst();
                switch (cmd.code) {
                    case 0: {
                        Phantom.onMouseEvent(cmd.index, 2, cmd.x, cmd.y);
                        break;
                    }
                    case 2: {
                        Phantom.onMouseEvent(cmd.index, 1, cmd.x, cmd.y);
                        break;
                    }
                    case 1: {
                        Phantom.onMouseEvent(cmd.index, 4, cmd.x, cmd.y);
                        break;
                    }
                    case 1000: {
                        Phantom.sendMessage(cmd.index, cmd.temp);
                        break;
                    }
                    case 1001: {
                        Phantom.closeEdit(cmd.index, cmd.x, cmd.temp);
                        break;
                    }
                    case 100: {
                        if (Phantom.onBack() != 0) break;
                        PhantomSurface.g_context.finish();
                        return;
                    }
                }
lbl36:
                // 8 sources

            } while (PhantomSurface.access$5().size() > 0);
            Phantom.updateGravity(PhantomSurface.s_gravity_x, PhantomSurface.s_gravity_y, PhantomSurface.s_gravity_z);
            SystemClock.sleep((long)5L);
            if (PhantomSurface.s_callback != null) {
                PhantomSurface.s_callback.onFrameMove();
            }
            Phantom.onFrameMove();
            Phantom.onRender();
        }

        public void onSurfaceChanged(GL10 gl, int width, int height) {
            int oriv = g_context.getRequestedOrientation();
            int ori = 1;
            if (oriv == 0) {
                ori = 3;
            } else if (oriv == 1) {
                ori = 1;
            }
            Phantom.onResize(ori, width, height, m_deviceWidth, m_deviceHeight);
        }

        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            Phantom.onLost();
            Phantom.onRestore();
        }
    }

    public static class SoundInfo
    implements SoundPool.OnLoadCompleteListener {
        public int m_id = 0;
        public int m_soundID = -1;
        public boolean m_play = false;
        public boolean m_comp = false;
        private float m_leftVolume = 1.0f;
        private float m_rightVolume = 1.0f;
        private float m_fRate = 1.0f;

        public void Pause(int streamID) {
        }

        public void Resume(int streamID) {
        }

        public void Stop(int streamID) {
        }

        public void SetVolume(int streamID, float v1, float v2) {
        }

        public void SetRate(int streamID, float v1) {
        }

        public void Open(String path) {
            this.m_soundID = -1;
            if (soundPool == null) {
                soundPool = new SoundPool(5, 3, 0);
            }
            try {
                AssetFileDescriptor afd = g_context.getAssets().openFd(path);
                if (afd != null) {
                    this.m_soundID = soundPool.load(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength(), 0);
                    soundPool.setOnLoadCompleteListener((SoundPool.OnLoadCompleteListener)this);
                    this.m_play = false;
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_soundID = soundPool.load(path, 0);
            if (this.m_soundID > 0) {
                soundPool.setOnLoadCompleteListener((SoundPool.OnLoadCompleteListener)this);
            }
            this.m_play = false;
        }

        public int Play(float leftVolume, float rightVolume, float fRate) {
            if (this.m_soundID >= 0) {
                this.m_leftVolume = leftVolume;
                this.m_rightVolume = rightVolume;
                this.m_fRate = fRate;
                this.m_play = true;
                if (this.m_comp) {
                    return soundPool.play(this.m_soundID, leftVolume, rightVolume, 1, 0, fRate);
                }
                return -1;
            }
            return -1;
        }

        public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
            if (sampleId == this.m_soundID && !this.m_comp) {
                this.m_comp = true;
                if (this.m_play) {
                    soundPool.play(this.m_soundID, this.m_leftVolume, this.m_rightVolume, 1, 0, this.m_fRate);
                }
            }
        }
    }
}

