/*
 * Decompiled with CFR 0.152.
 */
package net.nlanr.jperf.ui.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Paint;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.nlanr.jperf.core.Measurement;
import net.nlanr.jperf.ui.chart.AbstractChartPanel;
import net.nlanr.jperf.ui.chart.SeriesColorGenerator;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class IPerfChartPanel
extends AbstractChartPanel
implements Runnable {
    private int proportion;
    private CombinedDomainXYPlot graphSet;
    private XYItemRenderer bandwidthRenderer;
    private XYItemRenderer jitterRenderer;
    private XYSeriesCollection bandwidthCollection;
    private XYSeriesCollection jitterCollection;
    private JPanel panelTextStats = new JPanel(new GridLayout(0, 4));
    private JLabel labelDate = new JLabel(" ");
    private double delayInSeconds;
    private SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
    private HashMap<String, SeriesData> seriesData = new HashMap();
    private Thread timeThread = null;
    private Color backgroundColor;
    private Color foregroundColor;
    private Color gridColor;
    private String bandwidthUnit;
    private String jitterUnit;
    private boolean isServerMode = false;
    private double timeWindow;
    private double reportInterval;

    public IPerfChartPanel(String string, String string2, String string3, String string4, String string5, String string6, double d, double d2, double d3, Color color, Color color2, Color color3) {
        this.delayInSeconds = d;
        this.proportion = 1;
        this.backgroundColor = color;
        this.foregroundColor = color2;
        this.gridColor = color3;
        this.reconfigure(false, string, string2, string3, string4, string5, string6, d2, d3);
    }

    public void start() {
        if (this.timeThread == null) {
            this.timeThread = new Thread(this);
            this.timeThread.start();
        }
    }

    private boolean seriesExists(String string) {
        return this.seriesData.keySet().contains(string);
    }

    public void maybeAddNewSeries(String string, String string2, String string3, Color color) {
        this.maybeAddNewSeries(string, string2, string3, color, "%4.2f", "%4.2f");
    }

    public synchronized void maybeAddNewSeries(String string, String string2, String string3, Color color, String string4, String string5) {
        if (!this.seriesExists(string)) {
            SeriesData seriesData = new SeriesData(string, string2, string3, color, string4, string5);
            this.seriesData.put(string, seriesData);
            this.bandwidthCollection.addSeries(seriesData.bandwidthSeries);
            this.bandwidthRenderer.setSeriesPaint(this.bandwidthCollection.getSeriesCount() - 1, (Paint)seriesData.seriesColor);
            if (this.isServerMode) {
                this.jitterCollection.addSeries(seriesData.jitterSeries);
                this.jitterRenderer.setSeriesPaint(this.jitterCollection.getSeriesCount() - 1, (Paint)seriesData.seriesColor);
            }
            this.panelTextStats.add(seriesData.seriesLabel);
        }
    }

    public void reconfigure(boolean bl, String string, String string2, String string3, String string4, String string5, String string6, double d, double d2) {
        this.isServerMode = bl;
        this.bandwidthUnit = string2;
        this.jitterUnit = string3;
        this.timeWindow = d;
        this.reportInterval = d2;
        this.removeAll();
        this.panelTextStats.removeAll();
        SeriesColorGenerator.reset();
        this.seriesData.clear();
        this.graphSet = new CombinedDomainXYPlot((ValueAxis)new NumberAxis(string4));
        this.graphSet.setGap(10.0);
        this.jFreeChart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.graphSet, false);
        this.jFreeChart.setBackgroundPaint((Paint)this.backgroundColor);
        if (string != null) {
            this.jFreeChart.setTitle(string);
            this.jFreeChart.getTitle().setPaint((Paint)this.foregroundColor);
        }
        this.chartPanel = new ChartPanel(this.jFreeChart);
        this.chartPanel.setBackground(this.backgroundColor);
        this.bandwidthCollection = new XYSeriesCollection();
        this.bandwidthRenderer = new XYLineAndShapeRenderer();
        NumberAxis numberAxis = new NumberAxis(string5);
        numberAxis.setLabelPaint((Paint)this.foregroundColor);
        XYPlot xYPlot = new XYPlot((XYDataset)this.bandwidthCollection, null, (ValueAxis)numberAxis, this.bandwidthRenderer);
        xYPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        xYPlot.setDomainCrosshairVisible(false);
        xYPlot.setRangeCrosshairVisible(false);
        xYPlot.setBackgroundPaint((Paint)this.backgroundColor);
        xYPlot.setDomainGridlinePaint((Paint)this.gridColor);
        xYPlot.setRangeGridlinePaint((Paint)this.gridColor);
        this.graphSet.add(xYPlot, this.proportion);
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        if (string4 != null) {
            valueAxis.setTickLabelPaint((Paint)this.foregroundColor);
            valueAxis.setLabel(string4);
            valueAxis.setLabelPaint((Paint)this.foregroundColor);
        } else {
            valueAxis.setVisible(false);
        }
        valueAxis.setAutoRange(true);
        valueAxis.setFixedAutoRange((double)((int)Math.min(d, 30.0)));
        valueAxis = xYPlot.getRangeAxis();
        valueAxis.setTickLabelPaint((Paint)this.foregroundColor);
        if (bl) {
            numberAxis = new NumberAxis(string6);
            numberAxis.setLabelPaint((Paint)this.foregroundColor);
            this.jitterRenderer = new XYLineAndShapeRenderer();
            this.jitterCollection = new XYSeriesCollection();
            XYPlot xYPlot2 = new XYPlot((XYDataset)this.jitterCollection, null, (ValueAxis)numberAxis, this.jitterRenderer);
            xYPlot2.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
            xYPlot2.setDomainCrosshairVisible(false);
            xYPlot2.setRangeCrosshairVisible(false);
            xYPlot2.setBackgroundPaint((Paint)this.backgroundColor);
            xYPlot2.setDomainGridlinePaint((Paint)this.gridColor);
            xYPlot2.setRangeGridlinePaint((Paint)this.gridColor);
            this.graphSet.add(xYPlot2, this.proportion);
            valueAxis = xYPlot2.getRangeAxis();
            valueAxis.setTickLabelPaint((Paint)this.foregroundColor);
        }
        this.labelDate.setHorizontalAlignment(4);
        this.labelDate.setForeground(this.foregroundColor);
        this.panelTextStats.setBackground(this.backgroundColor);
        this.add((Component)this.labelDate, "North");
        this.add((Component)this.chartPanel, "Center");
        this.add((Component)this.panelTextStats, "South");
        this.setBackground(this.backgroundColor);
    }

    public void addSeriesBandwidthMeasurement(String string, Measurement measurement) {
        SeriesData seriesData = this.seriesData.get(string);
        if (measurement.getEndTime() - measurement.getStartTime() > this.reportInterval) {
            seriesData.seriesLabel.setText(String.format("<html><b>%s</b> [" + seriesData.printfBandwidthValueExpression + "%s] </html>", seriesData.bandwidthLegend, measurement.getValue(), this.bandwidthUnit + "/s"));
            return;
        }
        if (this.isServerMode) {
            try {
                if (seriesData.bandwidthSeries.getDataItem((int)measurement.getEndTime()) != null) {
                    seriesData.bandwidthSeries.clear();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        seriesData.bandwidthSeries.add(measurement.getEndTime(), measurement.getValue());
        seriesData.seriesLabel.setText(String.format("<html><b>%s</b> " + seriesData.printfBandwidthValueExpression + "%s </html>", seriesData.bandwidthLegend, measurement.getValue(), this.bandwidthUnit + "/s"));
    }

    public void addSeriesBandwidthAndJitterMeasurement(String string, Measurement measurement, Measurement measurement2) {
        SeriesData seriesData = this.seriesData.get(string);
        if (measurement.getEndTime() - measurement.getStartTime() > this.reportInterval) {
            seriesData.seriesLabel.setText(String.format("<html><b>%s</b> [" + seriesData.printfBandwidthValueExpression + "%s]<br><b>%s</b> [" + seriesData.printfJitterValueExpression + "%s]</html>", seriesData.bandwidthLegend, measurement.getValue(), this.bandwidthUnit + "/s", seriesData.jitterLegend, measurement2.getValue(), this.jitterUnit));
            return;
        }
        if (this.isServerMode) {
            try {
                if (seriesData.bandwidthSeries.getDataItem((int)measurement.getEndTime()) != null) {
                    seriesData.bandwidthSeries.clear();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (seriesData.jitterSeries.getDataItem((int)measurement2.getEndTime()) != null) {
                    seriesData.jitterSeries.clear();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        seriesData.bandwidthSeries.add(measurement.getEndTime(), measurement.getValue());
        seriesData.jitterSeries.add(measurement2.getEndTime(), measurement2.getValue());
        seriesData.seriesLabel.setText(String.format("<html><b>%s</b> " + seriesData.printfBandwidthValueExpression + "%s<br><b>%s</b> " + seriesData.printfJitterValueExpression + "%s</html>", seriesData.bandwidthLegend, measurement.getValue(), this.bandwidthUnit + "/s", seriesData.jitterLegend, measurement2.getValue(), this.jitterUnit));
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Date date = new Date();
                    this.labelDate.setText(this.sdf.format(date));
                    Thread.sleep((int)(this.delayInSeconds * 1000.0));
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private class SeriesData {
        public String seriesId;
        public String bandwidthLegend;
        public String jitterLegend;
        public JLabel seriesLabel;
        public XYSeries bandwidthSeries;
        public XYSeries jitterSeries;
        public Color seriesColor;
        public String printfBandwidthValueExpression;
        public String printfJitterValueExpression;

        public SeriesData(String string, String string2, String string3, Color color, String string4, String string5) {
            this.seriesId = string;
            this.bandwidthLegend = string2;
            this.jitterLegend = string3;
            this.bandwidthSeries = new XYSeries((Comparable)((Object)string2));
            this.jitterSeries = new XYSeries((Comparable)((Object)string2));
            this.seriesLabel = new JLabel(string2);
            this.seriesColor = color;
            this.printfBandwidthValueExpression = string4;
            this.printfJitterValueExpression = string5;
            this.seriesLabel.setForeground(color);
        }
    }
}

