/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.calendar.CalendarUtils;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;
import org.jdesktop.swingx.plaf.MonthViewUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMonthViewUI
extends MonthViewUI {
    private static final Logger LOG = Logger.getLogger(BasicMonthViewUI.class.getName());
    protected static final int LEADING_DAY_OFFSET = 1;
    protected static final int NO_OFFSET = 0;
    protected static final int TRAILING_DAY_OFFSET = -1;
    private static final int WEEKS_IN_MONTH = 6;
    private static final int CALENDAR_SPACING = 10;
    private static final Point NO_SUCH_CALENDAR = new Point(-1, -1);
    protected final SimpleDateFormat dayOfMonthFormatter = new SimpleDateFormat("d");
    protected String[] monthsOfTheYear;
    protected JXMonthView monthView;
    private PropertyChangeListener propertyChangeListener;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private Handler handler;
    private long firstDisplayedDate;
    private int firstDisplayedMonth;
    private int firstDisplayedYear;
    private long lastDisplayedDate;
    private boolean usingKeyboard = false;
    private long pivotDate = -1L;
    private SortedSet<Date> originalDateSpan;
    protected Font derivedFont;
    protected boolean isLeftToRight;
    protected Icon monthUpImage;
    protected Icon monthDownImage;
    private Color weekOfTheYearForeground;
    private Color unselectableDayForeground;
    private Color leadingDayForeground;
    private Color trailingDayForeground;
    private int arrowPaddingX = 3;
    private int arrowPaddingY = 3;
    private Rectangle bounds = new Rectangle();
    private int startX;
    private int startY;
    private int monthBoxHeight;
    private int fullMonthBoxHeight;
    private int boxWidth;
    private int boxHeight;
    private int fullBoxWidth;
    private int fullBoxHeight;
    private int calendarWidth;
    private int calendarHeight;
    private int calendarRowCount = 1;
    private int calendarColumnCount = 1;
    private Rectangle[] monthStringBounds = new Rectangle[12];
    private Rectangle[] yearStringBounds = new Rectangle[12];

    public static ComponentUI createUI(JComponent c) {
        return new BasicMonthViewUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.monthView = (JXMonthView)c;
        this.monthView.setLayout(this.createLayoutManager());
        this.isLeftToRight = this.monthView.getComponentOrientation().isLeftToRight();
        LookAndFeel.installProperty(this.monthView, "opaque", Boolean.TRUE);
        this.installComponents();
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.monthView.setLayout(null);
        this.monthView = null;
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installDefaults() {
        Color background = this.monthView.getBackground();
        if (background == null || background instanceof UIResource) {
            this.monthView.setBackground(UIManager.getColor("JXMonthView.background"));
        }
        this.monthView.setBoxPaddingX(UIManager.getInt("JXMonthView.boxPaddingX"));
        this.monthView.setBoxPaddingY(UIManager.getInt("JXMonthView.boxPaddingY"));
        this.monthView.setMonthStringBackground(UIManager.getColor("JXMonthView.monthStringBackground"));
        this.monthView.setMonthStringForeground(UIManager.getColor("JXMonthView.monthStringForeground"));
        this.monthView.setDaysOfTheWeekForeground(UIManager.getColor("JXMonthView.daysOfTheWeekForeground"));
        this.monthView.setSelectedBackground(UIManager.getColor("JXMonthView.selectedBackground"));
        this.monthView.setFlaggedDayForeground(UIManager.getColor("JXMonthView.flaggedDayForeground"));
        Font f = this.monthView.getFont();
        if (f == null || f instanceof UIResource) {
            this.monthView.setFont(UIManager.getFont("JXMonthView.font"));
        }
        this.monthDownImage = UIManager.getIcon("JXMonthView.monthDownFileName");
        this.monthUpImage = UIManager.getIcon("JXMonthView.monthUpFileName");
        this.weekOfTheYearForeground = UIManager.getColor("JXMonthView.weekOfTheYearForeground");
        this.leadingDayForeground = UIManager.getColor("JXMonthView.leadingDayForeground");
        this.trailingDayForeground = UIManager.getColor("JXMonthView.trailingDayForeground");
        this.unselectableDayForeground = UIManager.getColor("JXMonthView.unselectableDayForeground");
        this.derivedFont = this.createDerivedFont();
        this.setFirstDisplayedDate(this.monthView.getFirstDisplayedDate());
        this.updateLocale();
    }

    protected void uninstallDefaults() {
    }

    protected void installKeyboardActions() {
        this.installKeyBindings(0);
        ActionMap actionMap = this.monthView.getActionMap();
        KeyboardAction acceptAction = new KeyboardAction(0);
        actionMap.put("acceptSelection", acceptAction);
        KeyboardAction cancelAction = new KeyboardAction(1);
        actionMap.put("cancelSelection", cancelAction);
        actionMap.put("selectPreviousDay", new KeyboardAction(2));
        actionMap.put("selectNextDay", new KeyboardAction(3));
        actionMap.put("selectDayInPreviousWeek", new KeyboardAction(4));
        actionMap.put("selectDayInNextWeek", new KeyboardAction(5));
        actionMap.put("adjustSelectionPreviousDay", new KeyboardAction(6));
        actionMap.put("adjustSelectionNextDay", new KeyboardAction(7));
        actionMap.put("adjustSelectionPreviousWeek", new KeyboardAction(8));
        actionMap.put("adjustSelectionNextWeek", new KeyboardAction(9));
        actionMap.put("monthViewCommit", acceptAction);
        actionMap.put("monthViewCancel", cancelAction);
    }

    private void installKeyBindings(int type) {
        InputMap inputMap = this.monthView.getInputMap(type);
        inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "acceptSelection");
        inputMap.put(KeyStroke.getKeyStroke(27, 0, false), "cancelSelection");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "selectPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "selectNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "selectDayInPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "selectDayInNextWeek");
        inputMap.put(KeyStroke.getKeyStroke(37, 1, false), "adjustSelectionPreviousDay");
        inputMap.put(KeyStroke.getKeyStroke(39, 1, false), "adjustSelectionNextDay");
        inputMap.put(KeyStroke.getKeyStroke(38, 1, false), "adjustSelectionPreviousWeek");
        inputMap.put(KeyStroke.getKeyStroke(40, 1, false), "adjustSelectionNextWeek");
    }

    private void uninstallKeyBindings(int type) {
        InputMap inputMap = this.monthView.getInputMap(type);
        inputMap.clear();
    }

    protected void uninstallKeyboardActions() {
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.mouseListener = this.createMouseListener();
        this.mouseMotionListener = this.createMouseMotionListener();
        this.monthView.addPropertyChangeListener(this.propertyChangeListener);
        this.monthView.addMouseListener(this.mouseListener);
        this.monthView.addMouseMotionListener(this.mouseMotionListener);
        this.monthView.getSelectionModel().addDateSelectionListener(this.getHandler());
    }

    protected void uninstallListeners() {
        this.monthView.getSelectionModel().removeDateSelectionListener(this.getHandler());
        this.monthView.removeMouseMotionListener(this.mouseMotionListener);
        this.monthView.removeMouseListener(this.mouseListener);
        this.monthView.removePropertyChangeListener(this.propertyChangeListener);
        this.mouseMotionListener = null;
        this.mouseListener = null;
        this.propertyChangeListener = null;
    }

    protected void updateComponentInputMap() {
        if (this.monthView.isComponentInputMapEnabled()) {
            this.installKeyBindings(2);
        } else {
            this.uninstallKeyBindings(2);
        }
    }

    protected void updateLocale() {
        Locale locale = this.monthView.getLocale();
        this.monthsOfTheYear = new DateFormatSymbols(locale).getMonths();
        String[] daysOfTheWeek = (String[])UIManager.get("JXMonthView.daysOfTheWeek");
        if (daysOfTheWeek == null) {
            daysOfTheWeek = new String[7];
            String[] dateFormatSymbols = new DateFormatSymbols(locale).getShortWeekdays();
            daysOfTheWeek = new String[7];
            for (int i = 1; i <= 7; ++i) {
                daysOfTheWeek[i - 1] = dateFormatSymbols[i];
            }
        }
        this.monthView.setDaysOfTheWeek(daysOfTheWeek);
        this.monthView.invalidate();
        this.monthView.validate();
    }

    protected Font createDerivedFont() {
        return this.monthView.getFont().deriveFont(1);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected LayoutManager createLayoutManager() {
        return this.getHandler();
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    public boolean isUsingKeyboard() {
        return this.usingKeyboard;
    }

    public void setUsingKeyboard(boolean val) {
        this.usingKeyboard = val;
    }

    @Deprecated
    protected boolean isToday(long date) {
        return date == this.getTodayInMillis();
    }

    protected boolean isToday(Date date) {
        return date.equals(this.monthView.getToday());
    }

    @Override
    public Date getDayAtLocation(int x, int y) {
        long result = this.getDayAt(x, y);
        return result != -1L ? new Date(result) : null;
    }

    @Override
    public long getDayAt(int x, int y) {
        Point rowCol = this.getCalRowColAt(x, y);
        if (NO_SUCH_CALENDAR.equals(rowCol)) {
            return -1L;
        }
        if (rowCol.x > this.calendarRowCount - 1 || rowCol.y > this.calendarColumnCount - 1) {
            return -1L;
        }
        int row = 1;
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        row += (y - this.startY - rowCol.x * (this.calendarHeight + 10) - (boxPaddingY + this.monthBoxHeight + boxPaddingY)) / (boxPaddingY + this.boxHeight + boxPaddingY);
        if ((row -= 2) < 0 || row > 5) {
            return -1L;
        }
        int col = ((this.isLeftToRight ? x - this.startX : this.startX - x) - rowCol.y * (this.calendarWidth + 10)) / (boxPaddingX + this.boxWidth + boxPaddingX);
        if (this.monthView.isShowingWeekNumber()) {
            --col;
        }
        if (col < 0 || col > 6) {
            return -1L;
        }
        Calendar cal = this.getCalendar(this.getFirstDisplayedDate());
        cal.add(2, rowCol.y + rowCol.x * this.calendarColumnCount);
        int firstDayViewIndex = this.getDayOfWeekViewIndex(cal.get(7));
        int daysToAdd = row * 7 + (col - firstDayViewIndex);
        if (daysToAdd < 0 || daysToAdd > cal.getActualMaximum(5) - 1) {
            return -1L;
        }
        cal.add(5, daysToAdd);
        long selected = cal.getTimeInMillis();
        return selected;
    }

    protected int getDayOfTheWeek(Calendar cal) {
        return cal.get(7);
    }

    private int getDayOfWeekViewIndex(int dayOfWeek) {
        int result = dayOfWeek - this.monthView.getFirstDayOfWeek();
        if (result < 0) {
            result += 7;
        }
        return result;
    }

    protected int getTraversableButtonAt(int x, int y) {
        Point rowCol = this.getCalRowColAt(x, y);
        if (NO_SUCH_CALENDAR.equals(rowCol)) {
            return -1;
        }
        if ((y = y - this.startY - rowCol.x * (this.calendarHeight + 10) - this.monthView.getBoxPaddingY()) < this.arrowPaddingY || y > this.monthBoxHeight - this.arrowPaddingY) {
            return -1;
        }
        x = (this.isLeftToRight ? x - this.startX : this.startX - x) - rowCol.y * (this.calendarWidth + 10);
        if (x > this.arrowPaddingX && x < this.arrowPaddingX + this.monthDownImage.getIconWidth() + this.arrowPaddingX) {
            return 1;
        }
        if (x > this.calendarWidth - this.arrowPaddingX * 2 - this.monthUpImage.getIconWidth() && x < this.calendarWidth - this.arrowPaddingX) {
            return 2;
        }
        return -1;
    }

    protected Point getCalRowColAt(int x, int y) {
        if (this.isLeftToRight ? this.startX > x : this.startX < x || this.startY > y) {
            return NO_SUCH_CALENDAR;
        }
        Point result = new Point();
        result.x = (y - this.startY) / (this.calendarHeight + 10);
        result.y = (this.isLeftToRight ? x - this.startX : this.startX - x) / (this.calendarWidth + 10);
        if (result.x > this.calendarRowCount - 1 || result.y > this.calendarColumnCount - 1) {
            result = NO_SUCH_CALENDAR;
        }
        return result;
    }

    private void calculateStartPosition() {
        int width = this.monthView.getWidth();
        this.startX = (width - (this.calendarWidth * this.calendarColumnCount + 10 * (this.calendarColumnCount - 1))) / 2;
        if (!this.isLeftToRight) {
            this.startX = width - this.startX;
        }
        this.startY = (this.monthView.getHeight() - (this.calendarHeight * this.calendarRowCount + 10 * (this.calendarRowCount - 1))) / 2;
    }

    private void calculateNumDisplayedCals() {
        int oldNumCalCols = this.calendarColumnCount;
        int oldNumCalRows = this.calendarRowCount;
        this.calendarColumnCount = 1;
        this.calendarColumnCount += (this.monthView.getWidth() - this.calendarWidth) / (this.calendarWidth + 10);
        this.calendarRowCount = 1;
        this.calendarRowCount += (this.monthView.getHeight() - this.calendarHeight) / (this.calendarHeight + 10);
        if (oldNumCalCols != this.calendarColumnCount || oldNumCalRows != this.calendarRowCount) {
            this.updateLastDisplayedDate(this.getFirstDisplayedDate());
        }
    }

    private void calculateDirtyRectForSelection() {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2;
        super.paint(g, c);
        Object oldAAValue = null;
        Graphics2D graphics2D = g2 = g instanceof Graphics2D ? (Graphics2D)g : null;
        if (g2 != null && this.monthView.isAntialiased()) {
            oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Rectangle clip = g.getClipBounds();
        Graphics tmp = g.create();
        this.paintBackground(clip, tmp);
        tmp.dispose();
        g.setColor(this.monthView.getForeground());
        Calendar cal = this.getCalendar(this.getFirstDisplayedDate());
        for (int row = 0; row < this.calendarRowCount; ++row) {
            this.bounds.x = 0;
            this.bounds.y = this.startY + row * (this.calendarHeight + 10);
            this.bounds.width = this.monthView.getWidth();
            this.bounds.height = this.calendarHeight;
            if (!this.bounds.intersects(clip)) {
                cal.add(2, this.calendarColumnCount);
                continue;
            }
            for (int column = 0; column < this.calendarColumnCount; ++column) {
                this.bounds.x = this.startX + (this.isLeftToRight ? column * (this.calendarWidth + 10) : -(column * (this.calendarWidth + 10) + this.calendarWidth));
                this.bounds.y = this.startY + row * (this.calendarHeight + 10);
                this.bounds.width = this.calendarWidth;
                this.bounds.height = this.calendarHeight;
                if (this.bounds.intersects(clip)) {
                    this.paintMonth(g, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, cal);
                }
                cal.add(2, 1);
            }
        }
        if (g2 != null && this.monthView.isAntialiased()) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        }
    }

    protected void paintMonth(Graphics g, int x, int y, int width, int height, Calendar cal) {
        this.paintMonthStringBackground(g, x, y, width, this.fullMonthBoxHeight, cal);
        this.paintMonthStringForeground(g, x, y, width, this.fullMonthBoxHeight, cal);
        if (this.monthView.isTraversable()) {
            this.monthDownImage.paintIcon(this.monthView, g, x + this.arrowPaddingX, y + (this.fullMonthBoxHeight - this.monthDownImage.getIconHeight()) / 2);
            this.monthUpImage.paintIcon(this.monthView, g, x + width - this.arrowPaddingX - this.monthUpImage.getIconWidth(), y + (this.fullMonthBoxHeight - this.monthDownImage.getIconHeight()) / 2);
        }
        boolean showingWeekNumber = this.monthView.isShowingWeekNumber();
        int tmpX = this.isLeftToRight ? x + (showingWeekNumber ? this.fullBoxWidth : 0) : x;
        int tmpY = y + this.fullMonthBoxHeight;
        int tmpWidth = width - (showingWeekNumber ? this.fullBoxWidth : 0);
        this.paintDayOfTheWeekBackground(g, tmpX, tmpY, tmpWidth, this.fullBoxHeight, cal);
        int dayIndex = this.monthView.getFirstDayOfWeek() - 1;
        Font oldFont = this.monthView.getFont();
        g.setFont(this.derivedFont);
        g.setColor(this.monthView.getDaysOfTheWeekForeground());
        FontMetrics fm = this.monthView.getFontMetrics(this.derivedFont);
        String[] daysOfTheWeek = this.monthView.getDaysOfTheWeek();
        for (int i = 0; i < 7; ++i) {
            int n = tmpX = this.isLeftToRight ? x + i * this.fullBoxWidth + this.monthView.getBoxPaddingX() + this.boxWidth / 2 - fm.stringWidth(daysOfTheWeek[dayIndex]) / 2 : x + width - i * this.fullBoxWidth - this.monthView.getBoxPaddingX() - this.boxWidth / 2 - fm.stringWidth(daysOfTheWeek[dayIndex]) / 2;
            if (showingWeekNumber) {
                tmpX += this.isLeftToRight ? this.fullBoxWidth : -this.fullBoxWidth;
            }
            tmpY = y + this.fullMonthBoxHeight + this.monthView.getBoxPaddingY() + fm.getAscent();
            g.drawString(daysOfTheWeek[dayIndex], tmpX, tmpY);
            if (++dayIndex != 7) continue;
            dayIndex = 0;
        }
        g.setFont(oldFont);
        int yNew = y + this.fullMonthBoxHeight + this.fullBoxHeight;
        this.paintWeeksOfYear(g, x, yNew, width, cal);
        int xOffset = 0;
        if (this.monthView.isShowingWeekNumber()) {
            xOffset = this.fullBoxWidth;
        }
        if (this.isLeftToRight) {
            this.paintDays(g, x + xOffset, yNew, width - xOffset, cal);
        } else {
            this.paintDays(g, x, yNew, width - xOffset, cal);
        }
    }

    protected void paintDays(Graphics g, int left, int top, int width, Calendar cal) {
        Calendar calendar = (Calendar)cal.clone();
        CalendarUtils.startOfMonth(calendar);
        Date startOfMonth = calendar.getTime();
        CalendarUtils.endOfMonth(calendar);
        Date endOfMonth = calendar.getTime();
        calendar.setTime(cal.getTime());
        int weeks = this.getWeeks(calendar);
        calendar.setTime(cal.getTime());
        CalendarUtils.startOfWeek(calendar);
        int topOfDay = top;
        for (int week = 0; week <= weeks; ++week) {
            int leftOfDay = this.isLeftToRight ? left : left + width - this.fullBoxWidth;
            for (int day = 0; day < 7; ++day) {
                if (calendar.getTime().before(startOfMonth)) {
                    this.paintLeadingDay(g, leftOfDay, topOfDay, calendar);
                } else if (calendar.getTime().after(endOfMonth)) {
                    this.paintTrailingDay(g, leftOfDay, topOfDay, calendar);
                } else {
                    this.paintDay(g, leftOfDay, topOfDay, calendar);
                }
                leftOfDay = this.isLeftToRight ? leftOfDay + this.fullBoxWidth : leftOfDay - this.fullBoxWidth;
                calendar.add(5, 1);
            }
            if (!CalendarUtils.isStartOfWeek(calendar)) {
                throw new IllegalStateException("expected start of week");
            }
            topOfDay += this.fullBoxHeight;
        }
    }

    protected void paintDay(Graphics g, int left, int top, Calendar calendar) {
        if (this.monthView.isUnselectableDate(calendar.getTime())) {
            this.paintUnselectableDayBackground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
            this.paintUnselectableDayForeground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
        } else if (this.monthView.isFlaggedDate(calendar.getTime())) {
            this.paintFlaggedDayBackground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
            this.paintFlaggedDayForeground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
        } else {
            this.paintDayBackground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
            this.paintDayForeground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
        }
    }

    protected void paintTrailingDay(Graphics g, int left, int top, Calendar calendar) {
        if (!this.monthView.isShowingTrailingDates()) {
            return;
        }
        this.paintTrailingDayBackground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
        this.paintTrailingDayForeground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
    }

    protected void paintLeadingDay(Graphics g, int left, int top, Calendar calendar) {
        if (!this.monthView.isShowingLeadingDates()) {
            return;
        }
        this.paintLeadingDayBackground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
        this.paintLeadingDayForeground(g, left, top, this.fullBoxWidth, this.fullBoxHeight, calendar);
    }

    protected int getWeeks(Calendar month) {
        Date old = month.getTime();
        CalendarUtils.startOfWeek(month);
        int firstWeek = month.get(3);
        month.setTime(old);
        CalendarUtils.endOfMonth(month);
        int lastWeek = month.get(3);
        if (lastWeek < firstWeek) {
            lastWeek = month.getActualMaximum(3) + 1;
        }
        month.setTime(old);
        return lastWeek - firstWeek;
    }

    protected void paintWeeksOfYear(Graphics g, int x, int initialY, int width, Calendar cal) {
        if (!this.monthView.isShowingWeekNumber()) {
            return;
        }
        int tmpX = this.isLeftToRight ? x : x + width - this.fullBoxWidth;
        this.paintWeekOfYearBackground(g, tmpX, initialY, this.fullBoxWidth, this.calendarHeight - (this.fullMonthBoxHeight + this.fullBoxHeight), cal);
        Calendar calendar = (Calendar)cal.clone();
        int weeks = this.getWeeks(calendar);
        calendar.setTime(cal.getTime());
        for (int weekOfYear = 0; weekOfYear <= weeks; ++weekOfYear) {
            this.paintWeekOfYearForeground(g, tmpX, initialY, this.fullBoxWidth, this.fullBoxHeight, calendar);
            initialY += this.fullBoxHeight;
            calendar.add(3, 1);
        }
    }

    protected void paintDayOfTheWeekBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        int boxPaddingX = this.monthView.getBoxPaddingX();
        g.drawLine(x + boxPaddingX, y + height - 1, x + width - boxPaddingX, y + height - 1);
    }

    protected void paintWeekOfYearBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        int boxPaddingY = this.monthView.getBoxPaddingY();
        x = this.isLeftToRight ? x + width - 1 : x;
        g.drawLine(x, y + boxPaddingY, x, y + height - boxPaddingY);
    }

    protected void paintWeekOfYearForeground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        String str = Integer.toString(cal.get(3));
        g.setColor(this.weekOfTheYearForeground);
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        FontMetrics fm = g.getFontMetrics();
        g.drawString(str, this.isLeftToRight ? x + boxPaddingX + this.boxWidth - fm.stringWidth(str) : x + boxPaddingX + this.boxWidth - fm.stringWidth(str) - 1, y + boxPaddingY + fm.getAscent());
    }

    protected void paintMonthStringBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        Insets monthStringInsets = this.monthView.getMonthStringInsets();
        x = this.isLeftToRight ? x + monthStringInsets.left : x + monthStringInsets.right;
        width = width - monthStringInsets.left - monthStringInsets.right;
        height = height - monthStringInsets.top - monthStringInsets.bottom;
        g.setColor(this.monthView.getMonthStringBackground());
        g.fillRect(x, y += monthStringInsets.top, width, height);
    }

    protected void paintMonthStringForeground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        Font oldFont = this.monthView.getFont();
        g.setFont(this.derivedFont);
        FontMetrics fm = this.monthView.getFontMetrics(this.derivedFont);
        int month = cal.get(2);
        String monthName = this.monthsOfTheYear[month];
        String yearString = Integer.toString(cal.get(1));
        Rectangle2D rect = fm.getStringBounds(monthName, g);
        this.monthStringBounds[month] = new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
        int spaceWidth = (int)fm.getStringBounds(" ", g).getWidth();
        rect = fm.getStringBounds(yearString, g);
        this.yearStringBounds[month] = new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
        g.setColor(this.monthView.getMonthStringForeground());
        int tmpX = x + this.calendarWidth / 2 - (this.monthStringBounds[month].width + this.yearStringBounds[month].width + spaceWidth) / 2;
        int tmpY = y + this.monthView.getBoxPaddingY() + (this.monthBoxHeight - this.boxHeight) / 2 + fm.getAscent();
        this.monthStringBounds[month].x = tmpX;
        this.yearStringBounds[month].x = this.monthStringBounds[month].x + this.monthStringBounds[month].width + spaceWidth;
        this.paintMonthStringForeground(g, monthName, this.monthStringBounds[month].x, tmpY, yearString, this.yearStringBounds[month].x, tmpY, cal);
        g.setFont(oldFont);
    }

    protected void paintMonthStringForeground(Graphics g, String monthName, int monthX, int monthY, String yearName, int yearX, int yearY, Calendar cal) {
        g.drawString(monthName, monthX, monthY);
        g.drawString(yearName, yearX, yearY);
    }

    protected void paintDayBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        Date date = cal.getTime();
        if (this.monthView.isSelectedDate(date)) {
            g.setColor(this.monthView.getSelectedBackground());
            g.fillRect(x, y, width, height);
        }
        if (this.isToday(date)) {
            g.setColor(this.monthView.getTodayBackground());
            g.drawRect(x, y, width - 1, height - 1);
        }
    }

    protected void paintDayForeground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        String numericDay = this.dayOfMonthFormatter.format(cal.getTime());
        g.setColor(this.monthView.getDayForeground(this.getDayOfTheWeek(cal)));
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        this.paintDayForeground(g, numericDay, this.isLeftToRight ? x + boxPaddingX + this.boxWidth : x + boxPaddingX + this.boxWidth - 1, y + boxPaddingY, cal);
    }

    protected void paintDayForeground(Graphics g, String numericDay, int x, int y, Calendar cal) {
        FontMetrics fm = g.getFontMetrics();
        g.drawString(numericDay, x - fm.stringWidth(numericDay), y + fm.getAscent());
    }

    protected void paintFlaggedDayBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        this.paintDayBackground(g, x, y, width, height, cal);
    }

    protected void paintFlaggedDayForeground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        Date date = cal.getTime();
        String numericDay = this.dayOfMonthFormatter.format(date);
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        Font oldFont = this.monthView.getFont();
        g.setColor(this.monthView.getFlaggedDayForeground());
        g.setFont(this.derivedFont);
        FontMetrics fm = this.monthView.getFontMetrics(this.derivedFont);
        g.drawString(numericDay, this.isLeftToRight ? x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay) : x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay) - 1, y + boxPaddingY + fm.getAscent());
        g.setFont(oldFont);
    }

    protected void paintUnselectableDayBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        this.paintDayBackground(g, x, y, width, height, cal);
    }

    protected void paintUnselectableDayForeground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        this.paintDayForeground(g, x, y, width, height, cal);
        g.setColor(this.unselectableDayForeground);
        String numericDay = this.dayOfMonthFormatter.format(cal.getTime());
        FontMetrics fm = this.monthView.getFontMetrics(this.derivedFont);
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        width = fm.stringWidth(numericDay);
        height = fm.getAscent();
        x = this.isLeftToRight ? x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay) : x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay) - 1;
        g.drawLine(x, y += boxPaddingY, x + width, y + height);
        g.drawLine(x + 1, y, x + width + 1, y + height);
        g.drawLine(x + width, y, x, y + height);
        g.drawLine(x + width - 1, y, x - 1, y + height);
    }

    protected void paintLeadingDayBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        this.paintDayBackground(g, x, y, width, height, cal);
    }

    protected void paintLeadingDayForeground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        String numericDay = this.dayOfMonthFormatter.format(cal.getTime());
        g.setColor(this.leadingDayForeground);
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        FontMetrics fm = g.getFontMetrics();
        int ltorOffset = x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay);
        g.drawString(numericDay, this.isLeftToRight ? ltorOffset : ltorOffset - 1, y + boxPaddingY + fm.getAscent());
    }

    protected void paintTrailingDayBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        this.paintLeadingDayBackground(g, x, y, width, height, cal);
    }

    protected void paintTrailingDayForeground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        String numericDay = this.dayOfMonthFormatter.format(cal.getTime());
        g.setColor(this.trailingDayForeground);
        int boxPaddingX = this.monthView.getBoxPaddingX();
        int boxPaddingY = this.monthView.getBoxPaddingY();
        FontMetrics fm = g.getFontMetrics();
        g.drawString(numericDay, this.isLeftToRight ? x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay) : x + boxPaddingX + this.boxWidth - fm.stringWidth(numericDay) - 1, y + boxPaddingY + fm.getAscent());
    }

    protected void paintBackground(Rectangle clip, Graphics g) {
        if (this.monthView.isOpaque()) {
            g.setColor(this.monthView.getBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
    }

    private void traverseMonth(int arrowType) {
        if (arrowType == 1) {
            this.previousMonth();
        } else if (arrowType == 2) {
            this.nextMonth();
        }
    }

    private void nextMonth() {
        Date upperBound = this.monthView.getUpperBound();
        if (upperBound == null || upperBound.getTime() > this.getLastDisplayedDate()) {
            Calendar cal = this.getCalendar(this.getFirstDisplayedDate());
            cal.add(2, 1);
            this.monthView.setFirstDisplayedDate(cal.getTimeInMillis());
            this.calculateDirtyRectForSelection();
        }
    }

    private void previousMonth() {
        Date lowerBound = this.monthView.getLowerBound();
        if (lowerBound == null || lowerBound.getTime() < this.getFirstDisplayedDate()) {
            Calendar cal = this.getCalendar(this.getFirstDisplayedDate());
            cal.add(2, -1);
            this.monthView.setFirstDisplayedDate(cal.getTimeInMillis());
            this.calculateDirtyRectForSelection();
        }
    }

    private long startOfDay(long date) {
        Calendar cal = this.getCalendar(date);
        CalendarUtils.startOfDay(cal);
        return cal.getTimeInMillis();
    }

    protected Calendar getCalendar(long millis) {
        Calendar calendar = this.monthView.getCalendar();
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    @Override
    public long calculateLastDisplayedDate() {
        this.updateLastDisplayedDate(this.getFirstDisplayedDate());
        return this.lastDisplayedDate;
    }

    private void updateLastDisplayedDate(long first) {
        Calendar cal = this.getCalendar(first);
        cal.add(2, this.calendarColumnCount * this.calendarRowCount - 1);
        CalendarUtils.endOfMonth(cal);
        this.lastDisplayedDate = cal.getTimeInMillis();
    }

    @Override
    public long getLastDisplayedDate() {
        return this.lastDisplayedDate;
    }

    protected void setFirstDisplayedDate(long firstDisplayedDate) {
        this.firstDisplayedDate = firstDisplayedDate;
        Calendar calendar = this.getCalendar(firstDisplayedDate);
        this.firstDisplayedMonth = calendar.get(2);
        this.firstDisplayedYear = calendar.get(1);
        this.updateLastDisplayedDate(firstDisplayedDate);
        this.calculateDirtyRectForSelection();
    }

    protected long getFirstDisplayedDate() {
        return this.firstDisplayedDate;
    }

    protected int getFirstDisplayedMonth() {
        return this.firstDisplayedMonth;
    }

    protected int getFirstDisplayedYear() {
        return this.firstDisplayedYear;
    }

    protected SortedSet<Date> getSelection() {
        return this.monthView.getSelection();
    }

    @Deprecated
    protected long getTodayInMillis() {
        return this.monthView.getToday().getTime();
    }

    protected Date getToday() {
        return this.monthView.getToday();
    }

    private boolean canSelectByMode() {
        return true;
    }

    private class KeyboardAction
    extends AbstractAction {
        public static final int ACCEPT_SELECTION = 0;
        public static final int CANCEL_SELECTION = 1;
        public static final int SELECT_PREVIOUS_DAY = 2;
        public static final int SELECT_NEXT_DAY = 3;
        public static final int SELECT_DAY_PREVIOUS_WEEK = 4;
        public static final int SELECT_DAY_NEXT_WEEK = 5;
        public static final int ADJUST_SELECTION_PREVIOUS_DAY = 6;
        public static final int ADJUST_SELECTION_NEXT_DAY = 7;
        public static final int ADJUST_SELECTION_PREVIOUS_WEEK = 8;
        public static final int ADJUST_SELECTION_NEXT_WEEK = 9;
        private int action;

        public KeyboardAction(int action) {
            this.action = action;
        }

        public void actionPerformed(ActionEvent ev) {
            if (!BasicMonthViewUI.this.canSelectByMode()) {
                return;
            }
            if (!BasicMonthViewUI.this.isUsingKeyboard()) {
                BasicMonthViewUI.this.originalDateSpan = BasicMonthViewUI.this.monthView.getSelection();
            }
            if (this.action >= 0 && this.action <= 1) {
                if (this.action == 1) {
                    if (BasicMonthViewUI.this.originalDateSpan != null && !BasicMonthViewUI.this.originalDateSpan.isEmpty()) {
                        BasicMonthViewUI.this.monthView.setSelectionInterval((Date)BasicMonthViewUI.this.originalDateSpan.first(), (Date)BasicMonthViewUI.this.originalDateSpan.last());
                    } else {
                        BasicMonthViewUI.this.monthView.clearSelection();
                    }
                    BasicMonthViewUI.this.monthView.cancelSelection();
                } else {
                    BasicMonthViewUI.this.monthView.commitSelection();
                }
                BasicMonthViewUI.this.setUsingKeyboard(false);
            } else if (this.action >= 2 && this.action <= 5) {
                BasicMonthViewUI.this.setUsingKeyboard(true);
                BasicMonthViewUI.this.monthView.getSelectionModel().setAdjusting(true);
                BasicMonthViewUI.this.pivotDate = -1L;
                this.traverse(this.action);
            } else if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.SINGLE_INTERVAL_SELECTION && this.action >= 6 && this.action <= 9) {
                BasicMonthViewUI.this.setUsingKeyboard(true);
                BasicMonthViewUI.this.monthView.getSelectionModel().setAdjusting(true);
                this.addToSelection(this.action);
            }
        }

        private void traverse(int action) {
            long oldStart = BasicMonthViewUI.this.monthView.isSelectionEmpty() ? System.currentTimeMillis() : BasicMonthViewUI.this.getSelection().first().getTime();
            Calendar cal = BasicMonthViewUI.this.getCalendar(oldStart);
            switch (action) {
                case 2: {
                    cal.add(5, -1);
                    break;
                }
                case 3: {
                    cal.add(5, 1);
                    break;
                }
                case 4: {
                    cal.add(5, -7);
                    break;
                }
                case 5: {
                    cal.add(5, 7);
                }
            }
            long newStartDate = cal.getTimeInMillis();
            if (newStartDate != oldStart) {
                Date startDate = new Date(newStartDate);
                BasicMonthViewUI.this.monthView.setSelectionInterval(startDate, startDate);
                BasicMonthViewUI.this.monthView.ensureDateVisible(startDate);
            }
        }

        private void addToSelection(int action) {
            long newEndDate;
            long selectionEnd;
            long newStartDate;
            long selectionStart;
            if (!BasicMonthViewUI.this.monthView.isSelectionEmpty()) {
                newStartDate = selectionStart = BasicMonthViewUI.this.getSelection().first().getTime();
                newEndDate = selectionEnd = BasicMonthViewUI.this.getSelection().last().getTime();
            } else {
                newEndDate = selectionEnd = (newStartDate = (selectionStart = BasicMonthViewUI.this.startOfDay(System.currentTimeMillis())));
            }
            if (-1L == BasicMonthViewUI.this.pivotDate) {
                BasicMonthViewUI.this.pivotDate = newStartDate;
            }
            boolean isForward = true;
            Calendar cal = BasicMonthViewUI.this.getCalendar(BasicMonthViewUI.this.getFirstDisplayedDate());
            switch (action) {
                case 6: {
                    if (newEndDate <= BasicMonthViewUI.this.pivotDate) {
                        cal.setTimeInMillis(newStartDate);
                        cal.add(5, -1);
                        newStartDate = cal.getTimeInMillis();
                    } else {
                        cal.setTimeInMillis(newEndDate);
                        cal.add(5, -1);
                        newEndDate = cal.getTimeInMillis();
                    }
                    isForward = false;
                    break;
                }
                case 7: {
                    if (newStartDate >= BasicMonthViewUI.this.pivotDate) {
                        cal.setTimeInMillis(newEndDate);
                        cal.add(5, 1);
                        newStartDate = BasicMonthViewUI.this.pivotDate;
                        newEndDate = cal.getTimeInMillis();
                        break;
                    }
                    cal.setTimeInMillis(newStartDate);
                    cal.add(5, 1);
                    newStartDate = cal.getTimeInMillis();
                    break;
                }
                case 8: {
                    long newTime;
                    if (newEndDate <= BasicMonthViewUI.this.pivotDate) {
                        cal.setTimeInMillis(newStartDate);
                        cal.add(5, -7);
                        newStartDate = cal.getTimeInMillis();
                    } else {
                        cal.setTimeInMillis(newEndDate);
                        cal.add(5, -7);
                        newTime = cal.getTimeInMillis();
                        if (newTime <= BasicMonthViewUI.this.pivotDate) {
                            newStartDate = newTime;
                            newEndDate = BasicMonthViewUI.this.pivotDate;
                        } else {
                            newEndDate = cal.getTimeInMillis();
                        }
                    }
                    isForward = false;
                    break;
                }
                case 9: {
                    if (newStartDate >= BasicMonthViewUI.this.pivotDate) {
                        cal.setTimeInMillis(newEndDate);
                        cal.add(5, 7);
                        newEndDate = cal.getTimeInMillis();
                        break;
                    }
                    cal.setTimeInMillis(newStartDate);
                    cal.add(5, 7);
                    long newTime = cal.getTimeInMillis();
                    if (newTime >= BasicMonthViewUI.this.pivotDate) {
                        newStartDate = BasicMonthViewUI.this.pivotDate;
                        newEndDate = newTime;
                        break;
                    }
                    newStartDate = cal.getTimeInMillis();
                }
            }
            if (newStartDate != selectionStart || newEndDate != selectionEnd) {
                Date nStart = new Date(newStartDate);
                Date nEnd = new Date(newEndDate);
                BasicMonthViewUI.this.monthView.setSelectionInterval(nStart, nEnd);
                BasicMonthViewUI.this.monthView.ensureDateVisible(isForward ? nEnd : nStart);
            }
        }
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener,
    LayoutManager,
    PropertyChangeListener,
    DateSelectionListener {
        private boolean armed;
        private long startDate;
        private long endDate;
        private Dimension preferredSize = new Dimension();

        private Handler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            int arrowType;
            BasicMonthViewUI.this.setUsingKeyboard(false);
            if (!BasicMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            if (!BasicMonthViewUI.this.monthView.hasFocus() && BasicMonthViewUI.this.monthView.isFocusable()) {
                BasicMonthViewUI.this.monthView.requestFocusInWindow();
            }
            if (BasicMonthViewUI.this.monthView.isTraversable() && (arrowType = BasicMonthViewUI.this.getTraversableButtonAt(e.getX(), e.getY())) != -1) {
                BasicMonthViewUI.this.traverseMonth(arrowType);
                return;
            }
            if (!BasicMonthViewUI.this.canSelectByMode()) {
                return;
            }
            long selected = BasicMonthViewUI.this.monthView.getDayAt(e.getX(), e.getY());
            if (selected == -1L) {
                return;
            }
            this.startDate = selected;
            this.endDate = selected;
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.SINGLE_INTERVAL_SELECTION || BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION) {
                BasicMonthViewUI.this.pivotDate = selected;
            }
            BasicMonthViewUI.this.monthView.getSelectionModel().setAdjusting(true);
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION && e.isControlDown()) {
                BasicMonthViewUI.this.monthView.addSelectionInterval(new Date(this.startDate), new Date(this.endDate));
            } else {
                BasicMonthViewUI.this.monthView.setSelectionInterval(new Date(this.startDate), new Date(this.endDate));
            }
            this.armed = true;
        }

        public void mouseReleased(MouseEvent e) {
            BasicMonthViewUI.this.setUsingKeyboard(false);
            if (!BasicMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            if (!BasicMonthViewUI.this.monthView.hasFocus() && BasicMonthViewUI.this.monthView.isFocusable()) {
                BasicMonthViewUI.this.monthView.requestFocusInWindow();
            }
            if (this.armed) {
                BasicMonthViewUI.this.monthView.commitSelection();
            }
            this.armed = false;
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            BasicMonthViewUI.this.setUsingKeyboard(false);
            if (!BasicMonthViewUI.this.monthView.isEnabled() || !BasicMonthViewUI.this.canSelectByMode()) {
                return;
            }
            long selected = BasicMonthViewUI.this.monthView.getDayAt(e.getX(), e.getY());
            if (selected == -1L) {
                return;
            }
            long oldStart = this.startDate;
            long oldEnd = this.endDate;
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.SINGLE_SELECTION) {
                if (selected == oldStart) {
                    return;
                }
                this.startDate = selected;
                this.endDate = selected;
            } else if (selected <= BasicMonthViewUI.this.pivotDate) {
                this.startDate = selected;
                this.endDate = BasicMonthViewUI.this.pivotDate;
            } else if (selected > BasicMonthViewUI.this.pivotDate) {
                this.startDate = BasicMonthViewUI.this.pivotDate;
                this.endDate = selected;
            }
            if (oldStart == this.startDate && oldEnd == this.endDate) {
                return;
            }
            if (BasicMonthViewUI.this.monthView.getSelectionMode() == DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION && e.isControlDown()) {
                BasicMonthViewUI.this.monthView.addSelectionInterval(new Date(this.startDate), new Date(this.endDate));
            } else {
                BasicMonthViewUI.this.monthView.setSelectionInterval(new Date(this.startDate), new Date(this.endDate));
            }
            this.armed = true;
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            this.layoutContainer(parent);
            return new Dimension(this.preferredSize);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            int newHeight;
            int val;
            String[] daysOfTheWeek;
            int currWidth;
            int longestMonth = 0;
            int daysInLongestMonth = 0;
            int longestMonthWidth = 0;
            FontMetrics fm = BasicMonthViewUI.this.monthView.getFontMetrics(BasicMonthViewUI.this.derivedFont);
            Calendar cal = BasicMonthViewUI.this.getCalendar(BasicMonthViewUI.this.getFirstDisplayedDate());
            cal.set(2, cal.getMinimum(2));
            cal.set(5, cal.getActualMinimum(5));
            for (int i = 0; i < cal.getMaximum(2); ++i) {
                int currDays;
                currWidth = fm.stringWidth(BasicMonthViewUI.this.monthsOfTheYear[i]);
                if (currWidth > longestMonthWidth) {
                    longestMonthWidth = currWidth;
                }
                if ((currDays = cal.getActualMaximum(5)) > daysInLongestMonth) {
                    longestMonth = cal.get(2);
                    daysInLongestMonth = currDays;
                }
                cal.add(2, 1);
            }
            BasicMonthViewUI.this.boxHeight = fm.getHeight();
            for (String dayOfTheWeek : daysOfTheWeek = BasicMonthViewUI.this.monthView.getDaysOfTheWeek()) {
                currWidth = fm.stringWidth(dayOfTheWeek);
                if (currWidth <= BasicMonthViewUI.this.boxWidth) continue;
                BasicMonthViewUI.this.boxWidth = currWidth;
            }
            cal.set(2, longestMonth);
            cal.set(5, cal.getActualMinimum(5));
            for (int i = 0; i < daysInLongestMonth; ++i) {
                currWidth = fm.stringWidth(BasicMonthViewUI.this.dayOfMonthFormatter.format(cal.getTime()));
                if (currWidth > BasicMonthViewUI.this.boxWidth) {
                    BasicMonthViewUI.this.boxWidth = currWidth;
                }
                cal.add(5, 1);
            }
            boolean showingWeekNumber = BasicMonthViewUI.this.monthView.isShowingWeekNumber();
            if (showingWeekNumber && (currWidth = fm.stringWidth(Integer.toString(val = cal.getActualMaximum(3)))) > BasicMonthViewUI.this.boxWidth) {
                BasicMonthViewUI.this.boxWidth = currWidth;
            }
            BasicMonthViewUI.this.monthBoxHeight = BasicMonthViewUI.this.boxHeight;
            if (BasicMonthViewUI.this.monthView.isTraversable() && (newHeight = BasicMonthViewUI.this.monthDownImage.getIconHeight() + BasicMonthViewUI.this.arrowPaddingY + BasicMonthViewUI.this.arrowPaddingY) > BasicMonthViewUI.this.monthBoxHeight) {
                BasicMonthViewUI.this.monthBoxHeight = newHeight;
            }
            int boxPaddingX = BasicMonthViewUI.this.monthView.getBoxPaddingX();
            int boxPaddingY = BasicMonthViewUI.this.monthView.getBoxPaddingY();
            this.preferredSize.width = (BasicMonthViewUI.this.boxWidth + 2 * boxPaddingX) * 7;
            if (this.preferredSize.width < longestMonthWidth) {
                double diff = longestMonthWidth - this.preferredSize.width;
                if (BasicMonthViewUI.this.monthView.isTraversable()) {
                    diff += (double)(BasicMonthViewUI.this.monthDownImage.getIconWidth() + BasicMonthViewUI.this.monthUpImage.getIconWidth() + BasicMonthViewUI.this.arrowPaddingX * 4);
                }
                BasicMonthViewUI.this.boxWidth = (int)((double)BasicMonthViewUI.this.boxWidth + Math.ceil(diff / 7.0));
            }
            BasicMonthViewUI.this.fullBoxWidth = BasicMonthViewUI.this.boxWidth + boxPaddingX + boxPaddingX;
            BasicMonthViewUI.this.fullBoxHeight = BasicMonthViewUI.this.boxHeight + boxPaddingY + boxPaddingY;
            BasicMonthViewUI.this.fullMonthBoxHeight = BasicMonthViewUI.this.monthBoxHeight + boxPaddingY + boxPaddingY;
            BasicMonthViewUI.this.calendarWidth = BasicMonthViewUI.this.fullBoxWidth * 7;
            if (showingWeekNumber) {
                BasicMonthViewUI.this.calendarWidth += BasicMonthViewUI.this.fullBoxWidth;
            }
            BasicMonthViewUI.this.calendarHeight = BasicMonthViewUI.this.fullBoxHeight * 7 + BasicMonthViewUI.this.fullMonthBoxHeight;
            int prefRows = BasicMonthViewUI.this.monthView.getPreferredRows();
            this.preferredSize.height = BasicMonthViewUI.this.calendarHeight * prefRows + 10 * (prefRows - 1);
            int prefCols = BasicMonthViewUI.this.monthView.getPreferredCols();
            this.preferredSize.width = BasicMonthViewUI.this.calendarWidth * prefCols + 10 * (prefCols - 1);
            Insets insets = BasicMonthViewUI.this.monthView.getInsets();
            this.preferredSize.width += insets.left + insets.right;
            this.preferredSize.height += insets.top + insets.bottom;
            BasicMonthViewUI.this.calculateNumDisplayedCals();
            BasicMonthViewUI.this.calculateStartPosition();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if ("componentOrientation".equals(property)) {
                BasicMonthViewUI.this.isLeftToRight = BasicMonthViewUI.this.monthView.getComponentOrientation().isLeftToRight();
                BasicMonthViewUI.this.monthView.revalidate();
                BasicMonthViewUI.this.calculateStartPosition();
                BasicMonthViewUI.this.calculateDirtyRectForSelection();
            } else if ("selectionModel".equals(property)) {
                DateSelectionModel selectionModel = (DateSelectionModel)evt.getOldValue();
                selectionModel.removeDateSelectionListener(BasicMonthViewUI.this.getHandler());
                selectionModel = (DateSelectionModel)evt.getNewValue();
                selectionModel.addDateSelectionListener(BasicMonthViewUI.this.getHandler());
            } else if ("firstDisplayedDate".equals(property)) {
                BasicMonthViewUI.this.setFirstDisplayedDate((Long)evt.getNewValue());
            } else if ("boxPaddingX".equals(property) || "boxPaddingY".equals(property) || "traversable".equals(property) || "daysOfTheWeek".equals(property) || "border".equals(property) || "weekNumber".equals(property)) {
                BasicMonthViewUI.this.monthView.revalidate();
            } else if ("font".equals(property)) {
                BasicMonthViewUI.this.derivedFont = BasicMonthViewUI.this.createDerivedFont();
                BasicMonthViewUI.this.monthView.revalidate();
            } else if ("componentInputMapEnabled".equals(property)) {
                BasicMonthViewUI.this.updateComponentInputMap();
            } else if ("locale".equals(property)) {
                BasicMonthViewUI.this.updateLocale();
            } else if ("timeZone".equals(property)) {
                BasicMonthViewUI.this.dayOfMonthFormatter.setTimeZone((TimeZone)evt.getNewValue());
            }
        }

        public void valueChanged(DateSelectionEvent ev) {
            BasicMonthViewUI.this.monthView.repaint();
        }
    }
}

