/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tess4j.util;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFImageWriteParam;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class ImageIOHelper {
    static final String OUTPUT_FILE_NAME = "Tesstmp";
    static final String TIFF_EXT = ".tif";
    static final String TIFF_FORMAT = "tiff";
    static final String JAI_IMAGE_WRITER_MESSAGE = "Need to install JAI Image I/O package.\nhttps://java.net/projects/jai-imageio/";
    static final String JAI_IMAGE_READER_MESSAGE = "Unsupported image format. May need to install JAI Image I/O package.\nhttps://java.net/projects/jai-imageio/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BufferedImage> getImageList(File file) throws IOException {
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        try {
            ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
            String string = file.getName();
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string2);
            if (!iterator.hasNext()) {
                throw new RuntimeException(JAI_IMAGE_READER_MESSAGE);
            }
            imageReader = iterator.next();
            imageInputStream = ImageIO.createImageInputStream(file);
            imageReader.setInput(imageInputStream);
            int n = imageReader.getNumImages(true);
            for (int i = 0; i < n; ++i) {
                BufferedImage bufferedImage = imageReader.read(i);
                arrayList.add(bufferedImage);
            }
            ArrayList<BufferedImage> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            try {
                if (imageInputStream != null) {
                    imageInputStream.close();
                }
                if (imageReader != null) {
                    imageReader.dispose();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IIOImage> getIIOImageList(File file) throws IOException {
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        try {
            ArrayList<IIOImage> arrayList = new ArrayList<IIOImage>();
            String string = file.getName();
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            if (string2.matches("(pbm|pgm|ppm)")) {
                string2 = "pnm";
            } else if (string2.equals("jp2")) {
                string2 = "jpeg2000";
            }
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string2);
            if (!iterator.hasNext()) {
                throw new RuntimeException(JAI_IMAGE_READER_MESSAGE);
            }
            imageReader = iterator.next();
            imageInputStream = ImageIO.createImageInputStream(file);
            imageReader.setInput(imageInputStream);
            int n = imageReader.getNumImages(true);
            for (int i = 0; i < n; ++i) {
                IIOImage iIOImage = imageReader.readAll(i, imageReader.getDefaultReadParam());
                arrayList.add(iIOImage);
            }
            ArrayList<IIOImage> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            try {
                if (imageInputStream != null) {
                    imageInputStream.close();
                }
                if (imageReader != null) {
                    imageReader.dispose();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static List<File> createTiffFiles(File file, int n, boolean bl) throws IOException {
        Iterator<ImageWriter> iterator;
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = file.getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        Iterator<ImageReader> iterator2 = ImageIO.getImageReadersByFormatName(string2);
        if (!iterator2.hasNext()) {
            throw new RuntimeException(JAI_IMAGE_READER_MESSAGE);
        }
        ImageReader imageReader = iterator2.next();
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
        imageReader.setInput(imageInputStream);
        TIFFImageWriteParam tIFFImageWriteParam = new TIFFImageWriteParam(Locale.US);
        if (!bl) {
            tIFFImageWriteParam.setCompressionMode(0);
        }
        if (!(iterator = ImageIO.getImageWritersByFormatName(TIFF_FORMAT)).hasNext()) {
            throw new RuntimeException(JAI_IMAGE_WRITER_MESSAGE);
        }
        ImageWriter imageWriter = iterator.next();
        IIOMetadata iIOMetadata = imageWriter.getDefaultStreamMetadata(tIFFImageWriteParam);
        int n2 = imageReader.getNumImages(true);
        for (int i = 0; i < n2; ++i) {
            if (n != -1 && i != n) continue;
            IIOImage iIOImage = imageReader.readAll(i, imageReader.getDefaultReadParam());
            File file2 = File.createTempFile(OUTPUT_FILE_NAME, TIFF_EXT);
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file2);
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(iIOMetadata, iIOImage, tIFFImageWriteParam);
            imageOutputStream.close();
            arrayList.add(file2);
        }
        imageWriter.dispose();
        imageReader.dispose();
        return arrayList;
    }

    public static void mergeTiff(File[] fileArray, File file) throws IOException {
        ArrayList<IIOImage> arrayList = new ArrayList<IIOImage>();
        for (File file2 : fileArray) {
            arrayList.addAll(ImageIOHelper.getIIOImageList(file2));
        }
        ImageIOHelper.mergeTiff(arrayList, file);
    }

    public static void mergeTiff(BufferedImage[] bufferedImageArray, File file) throws IOException {
        ArrayList<IIOImage> arrayList = new ArrayList<IIOImage>();
        for (BufferedImage bufferedImage : bufferedImageArray) {
            arrayList.add(new IIOImage(bufferedImage, null, null));
        }
        ImageIOHelper.mergeTiff(arrayList, file);
    }

    public static void mergeTiff(List<IIOImage> list, File file) throws IOException {
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(TIFF_FORMAT);
        if (!iterator.hasNext()) {
            throw new RuntimeException(JAI_IMAGE_WRITER_MESSAGE);
        }
        ImageWriter imageWriter = iterator.next();
        TIFFImageWriteParam tIFFImageWriteParam = new TIFFImageWriteParam(Locale.US);
        IIOMetadata iIOMetadata = imageWriter.getDefaultStreamMetadata(tIFFImageWriteParam);
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
        imageWriter.setOutput(imageOutputStream);
        int n = 300;
        int n2 = 300;
        for (IIOImage iIOImage : list) {
            ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(iIOImage.getRenderedImage());
            IIOMetadata object = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, null);
            object = ImageIOHelper.setDPIViaAPI(object, n, n2);
            iIOImage.setMetadata(object);
        }
        IIOImage iIOImage = list.remove(0);
        imageWriter.write(iIOMetadata, iIOImage, tIFFImageWriteParam);
        int n3 = 1;
        for (IIOImage iIOImage2 : list) {
            imageWriter.writeInsert(n3++, iIOImage2, tIFFImageWriteParam);
        }
        imageOutputStream.close();
        imageWriter.dispose();
    }

    private static IIOMetadata setDPIViaAPI(IIOMetadata iIOMetadata, int n, int n2) throws IIOInvalidTreeException {
        TIFFDirectory tIFFDirectory = TIFFDirectory.createFromMetadata(iIOMetadata);
        BaselineTIFFTagSet baselineTIFFTagSet = BaselineTIFFTagSet.getInstance();
        TIFFTag tIFFTag = baselineTIFFTagSet.getTag(282);
        TIFFTag tIFFTag2 = baselineTIFFTagSet.getTag(283);
        TIFFField tIFFField = new TIFFField(tIFFTag, 5, 1, new long[][]{{n, 1L}});
        TIFFField tIFFField2 = new TIFFField(tIFFTag2, 5, 1, new long[][]{{n2, 1L}});
        tIFFDirectory.addTIFFField(tIFFField);
        tIFFDirectory.addTIFFField(tIFFField2);
        IIOMetadata iIOMetadata2 = tIFFDirectory.getAsMetadata();
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("javax_imageio_1.0");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelSize");
        iIOMetadataNode2.setAttribute("value", Double.toString(25.4f / (float)n));
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("VerticalPixelSize");
        iIOMetadataNode3.setAttribute("value", Double.toString(25.4f / (float)n2));
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("Dimension");
        iIOMetadataNode4.appendChild(iIOMetadataNode2);
        iIOMetadataNode4.appendChild(iIOMetadataNode3);
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        iIOMetadata2.mergeTree("javax_imageio_1.0", iIOMetadataNode);
        return iIOMetadata2;
    }
}

