/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.sourceforge.tess4j.util.ImageIOHelper;
import net.sourceforge.tessboxeditor.FileDropTargetListener;
import net.sourceforge.tessboxeditor.MacOSXApplication;
import net.sourceforge.tessboxeditor.SubImageView;
import net.sourceforge.tessboxeditor.TrainingMode;
import net.sourceforge.tessboxeditor.components.ImageIconScalable;
import net.sourceforge.tessboxeditor.components.JImageLabel;
import net.sourceforge.tessboxeditor.components.MyTableCellEditor;
import net.sourceforge.tessboxeditor.components.RowHeaderList;
import net.sourceforge.tessboxeditor.datamodel.TessBox;
import net.sourceforge.tessboxeditor.datamodel.TessBoxCollection;
import net.sourceforge.vietocr.util.Utils;
import net.sourceforge.vietpad.components.HtmlPane;
import net.sourceforge.vietpad.components.SimpleFilter;
import net.sourceforge.vietpad.utilities.LimitedLengthDocument;
import net.sourceforge.vietpad.utilities.TextUtilities;

public class Gui
extends JFrame {
    public static final String APP_NAME = "jTessBoxEditor";
    public static final String TO_BE_IMPLEMENTED = "To be implemented in subclass";
    final String[] headers = new String[]{"Char", "X", "Y", "Width", "Height"};
    static final boolean MAC_OS_X = System.getProperty("os.name").startsWith("Mac");
    static final boolean WINDOWS = System.getProperty("os.name").toLowerCase().startsWith("windows");
    static final String EOL = System.getProperty("line.separator");
    static final String UTF8 = "UTF-8";
    protected ResourceBundle bundle;
    static final Preferences prefs = Preferences.userRoot().node("/net/sourceforge/tessboxeditor");
    private final Rectangle screen = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
    private int filterIndex;
    private FileFilter[] fileFilters;
    private File boxFile;
    private String currentDirectory;
    private String outputDirectory;
    private boolean boxChanged = true;
    protected boolean tableSelectAction;
    private List<TessBoxCollection> boxPages;
    protected TessBoxCollection boxes;
    protected short imageIndex;
    private List<BufferedImage> imageList;
    protected final File baseDir = Utils.getBaseDir(this);
    DefaultTableModel tableModel;
    private boolean isTess2_0Format;
    protected RowHeaderList rowHeader;
    protected Font font;
    protected static int iconMargin = 3;
    protected static boolean invertControls = false;
    protected static int scaleFactor = 4;
    protected static int iconPosX = 0;
    protected static int iconPosY = 0;
    protected static int iconWidth = 0;
    protected static int iconHeight = 0;
    protected static int imageWidth = 0;
    protected static int imageHeight = 0;
    protected static int movementMultiplier = 1;
    private static final Logger logger = Logger.getLogger(Gui.class.getName());
    private Box.Filler filler2;
    protected JButton jButtonBrowseData;
    private JButton jButtonBrowseOutputDir;
    protected JButton jButtonBrowseTess;
    protected JButton jButtonCancel;
    private JButton jButtonClear;
    protected JButton jButtonClearLog;
    private JButton jButtonCloseDialog;
    private JButton jButtonConvert;
    private JButton jButtonDelete;
    private JButton jButtonFind;
    protected JButton jButtonFont;
    protected JButton jButtonGenerate;
    private JButton jButtonInput;
    private JButton jButtonInsert;
    private JButton jButtonMerge;
    private JButton jButtonNext;
    private JButton jButtonNextPage;
    private JButton jButtonOpen;
    private JButton jButtonPrev;
    private JButton jButtonPrevPage;
    private JButton jButtonReload;
    private JButton jButtonSave;
    private JButton jButtonSaveLog;
    private JButton jButtonSplit;
    protected JButton jButtonTrain;
    protected JButton jButtonValidate;
    protected JCheckBox jCheckBoxAntiAliasing;
    protected JCheckBox jCheckBoxRTL;
    protected JComboBox jComboBoxOps;
    protected JDialog jDialogValidationResult;
    private JFileChooser jFileChooserInputImage;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabelCharacter;
    private JLabel jLabelCodepoint;
    private JLabel jLabelH;
    private JLabel jLabelH1;
    protected JLabel jLabelImage;
    private JLabel jLabelNoise;
    private JLabel jLabelOutput;
    private JLabel jLabelPageNbr;
    private JLabel jLabelSpinnerMargin;
    private JLabel jLabelSpinnerScale;
    protected JLabel jLabelStatus;
    protected JLabel jLabelSubimage;
    protected JLabel jLabelTime;
    private JLabel jLabelTracking;
    private JLabel jLabelW;
    private JLabel jLabelW1;
    private JLabel jLabelX;
    private JLabel jLabelY;
    private JMenuBar jMenuBar;
    private JMenu jMenuEdit;
    private JMenu jMenuFile;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemAbout;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemFont;
    private JMenuItem jMenuItemHelp;
    private JMenuItem jMenuItemInsert;
    private JMenuItem jMenuItemMerge;
    private JMenuItem jMenuItemMergeTiff;
    private JMenuItem jMenuItemOpen;
    private JMenuItem jMenuItemSave;
    private JMenuItem jMenuItemSaveAs;
    private JMenuItem jMenuItemSplit;
    private JMenuItem jMenuItemSplitTiff;
    protected JMenu jMenuLookAndFeel;
    protected JMenu jMenuRecentFiles;
    private JMenu jMenuSettings;
    private JMenu jMenuTools;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelBoxView;
    private JPanel jPanelButtons;
    private JPanel jPanelChar;
    private JPanel jPanelCommand;
    private JPanel jPanelControls;
    protected JPanel jPanelCoord;
    private JPanel jPanelEditor;
    private JPanel jPanelFind;
    private JPanel jPanelMain;
    private JPanel jPanelNorthContainer;
    private JPanel jPanelSpinner;
    private JPanel jPanelStatus;
    private JPanel jPanelStatus1;
    private JPanel jPanelTIFFBox;
    private JPanel jPanelTrainer;
    protected JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPaneBoxData;
    private JScrollPane jScrollPaneCoord;
    private JScrollPane jScrollPaneImage;
    private JScrollPane jScrollPaneText;
    private JPopupMenu.Separator jSeparatorAbout;
    private JPopupMenu.Separator jSeparatorExit;
    private JPopupMenu.Separator jSeparatorLAF;
    private JPopupMenu.Separator jSeparatorRecentFiles;
    protected JSpinner jSpinnerH;
    protected JSpinner jSpinnerH1;
    private JSpinner jSpinnerMargin;
    protected JSpinner jSpinnerNoise;
    private JSpinner jSpinnerScale;
    protected JSpinner jSpinnerTracking;
    protected JSpinner jSpinnerW;
    protected JSpinner jSpinnerW1;
    protected JSpinner jSpinnerX;
    protected JSpinner jSpinnerY;
    private JSplitPane jSplitPaneEditor;
    private JTabbedPane jTabbedPaneBoxData;
    private JTabbedPane jTabbedPaneMain;
    protected JTable jTable;
    protected JTextArea jTextAreaBoxData;
    protected JTextArea jTextAreaInput;
    protected JTextArea jTextAreaOutput;
    protected JTextArea jTextAreaValidationResult;
    protected JTextField jTextFieldBootstrapLang;
    protected JTextField jTextFieldChar;
    protected JTextField jTextFieldCharacter;
    private JTextField jTextFieldCodepointValue;
    protected JTextField jTextFieldDataDir;
    protected JTextField jTextFieldFileName;
    protected JTextField jTextFieldFind;
    protected JTextField jTextFieldLang;
    protected JTextField jTextFieldOuputDir;
    protected JTextField jTextFieldPrefix;
    protected JTextField jTextFieldTessDir;
    private JToolBar jToolBarEditor;
    private JToolBar jToolBarGenerator;
    private JToolBar jToolBarTrainer;
    private JFrame helptopicsFrame;

    public Gui() {
        try {
            UIManager.setLookAndFeel(prefs.get("lookAndFeel", UIManager.getSystemLookAndFeelClassName()));
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
        this.bundle = ResourceBundle.getBundle("net.sourceforge.tessboxeditor.Gui");
        this.initComponents();
        if (MAC_OS_X) {
            new MacOSXApplication(this);
            this.jMenuFile.remove(this.jSeparatorExit);
            this.jMenuFile.remove(this.jMenuItemExit);
            this.jMenuHelp.remove(this.jSeparatorAbout);
            this.jMenuHelp.remove(this.jMenuItemAbout);
        }
        this.boxPages = new ArrayList<TessBoxCollection>();
        new DropTarget(this.jSplitPaneEditor, new FileDropTargetListener(this, this.jSplitPaneEditor));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Gui.this.quit();
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                Gui.this.updateSave(false);
                Gui.this.setExtendedState(prefs.getInt("windowState", 0));
                Gui.this.populateMRUList();
            }
        });
        this.setSize(this.snap(prefs.getInt("frameWidth", 500), 300, this.screen.width), this.snap(prefs.getInt("frameHeight", 360), 150, this.screen.height));
        this.setLocation(this.snap(prefs.getInt("frameX", (this.screen.width - this.getWidth()) / 2), this.screen.x, this.screen.x + this.screen.width - this.getWidth()), this.snap(prefs.getInt("frameY", this.screen.y + (this.screen.height - this.getHeight()) / 3), this.screen.y, this.screen.y + this.screen.height - this.getHeight()));
        KeyEventDispatcher keyEventDispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 114) {
                    Gui.this.jButtonFind.doClick();
                }
                return false;
            }
        };
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(keyEventDispatcher);
    }

    private int snap(int n, int n2, int n3) {
        return n < n2 + 0 ? n2 : (n > n3 - 0 ? n3 : n);
    }

    protected void populateMRUList() {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    private void initComponents() {
        this.jFileChooserInputImage = new JFileChooser();
        this.jDialogValidationResult = new JDialog();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaValidationResult = new JTextArea();
        this.jPanelCommand = new JPanel();
        this.jButtonCloseDialog = new JButton();
        this.jTabbedPaneMain = new JTabbedPane();
        this.jPanelTrainer = new JPanel();
        this.jToolBarTrainer = new JToolBar();
        this.jPanelMain = new JPanel();
        this.jLabel4 = new JLabel();
        this.jTextFieldTessDir = new JTextField();
        this.jButtonBrowseTess = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextFieldDataDir = new JTextField();
        this.jButtonBrowseData = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldLang = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldBootstrapLang = new JTextField();
        this.jCheckBoxRTL = new JCheckBox();
        this.jComboBoxOps = new JComboBox();
        this.jButtonTrain = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonCancel.setEnabled(false);
        this.jButtonValidate = new JButton();
        this.jButtonSaveLog = new JButton();
        this.jButtonClearLog = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaOutput = new JTextArea();
        this.jPanelStatus1 = new JPanel();
        this.filler2 = new Box.Filler(new Dimension(0, 17), new Dimension(0, 17), new Dimension(Short.MAX_VALUE, 17));
        this.jProgressBar1 = new JProgressBar();
        this.jProgressBar1.setVisible(false);
        this.jLabelTime = new JLabel();
        this.jPanelEditor = new JPanel();
        this.jToolBarEditor = new JToolBar();
        this.jPanel4 = new JPanel();
        this.jButtonOpen = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonReload = new JButton();
        this.jButtonMerge = new JButton();
        this.jButtonSplit = new JButton();
        this.jButtonInsert = new JButton();
        this.jButtonDelete = new JButton();
        this.jPanelSpinner = new JPanel();
        this.jLabelCharacter = new JLabel();
        this.jTextFieldCharacter = new JTextField();
        this.jTextFieldCharacter.setDocument(new LimitedLengthDocument(12));
        this.jButtonConvert = new JButton();
        this.jLabelX = new JLabel();
        this.jSpinnerX = new JSpinner();
        this.jLabelY = new JLabel();
        this.jSpinnerY = new JSpinner();
        this.jLabelW = new JLabel();
        this.jSpinnerW = new JSpinner();
        this.jLabelH = new JLabel();
        this.jSpinnerH = new JSpinner();
        this.jSplitPaneEditor = new JSplitPane();
        this.jTabbedPaneBoxData = new JTabbedPane();
        this.jPanelCoord = new JPanel();
        this.jScrollPaneCoord = new JScrollPane();
        this.jTable = new JTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (Gui.this.font != null && n2 == 0) {
                    component.setFont(Gui.this.font);
                }
                return component;
            }
        };
        this.jPanelFind = new JPanel();
        this.jTextFieldFind = new JTextField();
        this.jButtonFind = new JButton();
        this.jScrollPaneBoxData = new JScrollPane();
        this.jTextAreaBoxData = new JTextArea();
        this.jPanelBoxView = new JPanel();
        this.jPanelNorthContainer = new JPanel();
        this.jPanelChar = new JPanel();
        this.jLabelCodepoint = new JLabel();
        this.jLabelCodepoint.setFont(this.jLabelCodepoint.getFont().deriveFont(14.0f));
        this.jTextFieldChar = new JTextField();
        this.jTextFieldChar.setFont(this.jTextFieldChar.getFont().deriveFont(14.0f));
        this.jTextFieldCodepointValue = new JTextField();
        this.jTextFieldCodepointValue.setFont(this.jTextFieldCodepointValue.getFont().deriveFont(14.0f));
        this.jPanelControls = new JPanel();
        this.jLabelSpinnerMargin = new JLabel();
        this.jSpinnerMargin = new JSpinner();
        this.jLabelSpinnerScale = new JLabel();
        this.jSpinnerScale = new JSpinner();
        this.jLabelSubimage = new SubImageView();
        this.jPanelButtons = new JPanel();
        this.jButtonPrev = new JButton();
        this.jButtonNext = new JButton();
        this.jScrollPaneImage = new JScrollPane();
        this.jScrollPaneImage.getVerticalScrollBar().setUnitIncrement(20);
        this.jScrollPaneImage.getHorizontalScrollBar().setUnitIncrement(20);
        this.jLabelImage = new JImageLabel();
        this.jPanelStatus = new JPanel();
        this.jLabelStatus = new JLabel();
        this.jLabelPageNbr = new JLabel();
        this.jButtonPrevPage = new JButton();
        this.jButtonNextPage = new JButton();
        this.jPanelTIFFBox = new JPanel();
        this.jToolBarGenerator = new JToolBar();
        this.jPanel3 = new JPanel();
        this.jButtonInput = new JButton();
        this.jLabelOutput = new JLabel();
        this.jTextFieldOuputDir = new JTextField();
        this.jButtonBrowseOutputDir = new JButton();
        this.jTextFieldPrefix = new JTextField();
        this.jTextFieldPrefix.setText(prefs.get("trainLanguage", "eng"));
        this.jTextFieldFileName = new JTextField();
        this.jButtonFont = new JButton();
        this.jCheckBoxAntiAliasing = new JCheckBox();
        this.jLabelNoise = new JLabel();
        this.jSpinnerNoise = new JSpinner();
        this.jLabelTracking = new JLabel();
        this.jSpinnerTracking = new JSpinner();
        this.jLabelW1 = new JLabel();
        this.jSpinnerW1 = new JSpinner();
        this.jLabelH1 = new JLabel();
        this.jSpinnerH1 = new JSpinner();
        this.jButtonGenerate = new JButton();
        this.jButtonClear = new JButton();
        this.jScrollPaneText = new JScrollPane();
        this.jTextAreaInput = new JTextArea();
        this.jMenuBar = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemOpen = new JMenuItem();
        this.jMenuItemSave = new JMenuItem();
        this.jMenuItemSaveAs = new JMenuItem();
        this.jSeparatorRecentFiles = new JPopupMenu.Separator();
        this.jMenuRecentFiles = new JMenu();
        this.jSeparatorExit = new JPopupMenu.Separator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuEdit = new JMenu();
        this.jMenuEdit.setVisible(false);
        this.jMenuItemMerge = new JMenuItem();
        this.jMenuItemSplit = new JMenuItem();
        this.jMenuItemInsert = new JMenuItem();
        this.jMenuItemDelete = new JMenuItem();
        this.jMenuSettings = new JMenu();
        this.jMenuItemFont = new JMenuItem();
        this.jSeparatorLAF = new JPopupMenu.Separator();
        this.jMenuLookAndFeel = new JMenu();
        this.jMenuTools = new JMenu();
        this.jMenuItemMergeTiff = new JMenuItem();
        this.jMenuItemSplitTiff = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemHelp = new JMenuItem();
        this.jSeparatorAbout = new JPopupMenu.Separator();
        this.jMenuItemAbout = new JMenuItem();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui");
        this.jFileChooserInputImage.setDialogTitle(resourceBundle.getString("jButtonOpen.ToolTipText"));
        this.currentDirectory = prefs.get("currentDirectory", null);
        this.outputDirectory = prefs.get("outputDirectory", null);
        this.jFileChooserInputImage.setCurrentDirectory(this.currentDirectory == null ? null : new File(this.currentDirectory));
        this.filterIndex = prefs.getInt("filterIndex", 0);
        SimpleFilter simpleFilter = new SimpleFilter("bmp;jpg;jpeg;png;tif;tiff", resourceBundle.getString("All_Image_Files"));
        SimpleFilter simpleFilter2 = new SimpleFilter("png", "PNG");
        SimpleFilter simpleFilter3 = new SimpleFilter("tif;tiff", "TIFF");
        this.jFileChooserInputImage.setAcceptAllFileFilterUsed(false);
        this.jFileChooserInputImage.addChoosableFileFilter(simpleFilter);
        this.jFileChooserInputImage.addChoosableFileFilter(simpleFilter2);
        this.jFileChooserInputImage.addChoosableFileFilter(simpleFilter3);
        this.fileFilters = this.jFileChooserInputImage.getChoosableFileFilters();
        if (this.filterIndex < this.fileFilters.length) {
            this.jFileChooserInputImage.setFileFilter(this.fileFilters[this.filterIndex]);
        }
        this.jDialogValidationResult.setTitle("Validation Result");
        this.jDialogValidationResult.setMinimumSize(new Dimension(600, 450));
        this.jTextAreaValidationResult.setEditable(false);
        this.jTextAreaValidationResult.setColumns(20);
        this.jTextAreaValidationResult.setRows(5);
        this.jTextAreaValidationResult.setMargin(new Insets(5, 5, 2, 2));
        this.jScrollPane2.setViewportView(this.jTextAreaValidationResult);
        this.jDialogValidationResult.getContentPane().add((Component)this.jScrollPane2, "Center");
        this.jPanelCommand.setBorder(BorderFactory.createEmptyBorder(5, 1, 5, 1));
        this.jButtonCloseDialog.setText("Close");
        this.jButtonCloseDialog.setToolTipText("Close Dialog");
        this.jButtonCloseDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonCloseDialogActionPerformed(actionEvent);
            }
        });
        this.jPanelCommand.add(this.jButtonCloseDialog);
        this.jDialogValidationResult.getContentPane().add((Component)this.jPanelCommand, "South");
        this.jDialogValidationResult.setLocationRelativeTo(this);
        this.setDefaultCloseOperation(3);
        this.setTitle(APP_NAME);
        this.jTabbedPaneMain.setBorder(BorderFactory.createEmptyBorder(-2, 0, 0, 0));
        this.jTabbedPaneMain.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Gui.this.jTabbedPaneMainStateChanged(changeEvent);
            }
        });
        this.jPanelTrainer.setLayout(new BorderLayout());
        this.jToolBarTrainer.setRollover(true);
        this.jPanelMain.setLayout(new FlowLayout(0));
        this.jLabel4.setText("Tesseract Executables");
        this.jPanelMain.add(this.jLabel4);
        this.jTextFieldTessDir.setToolTipText("Location of Tesseract Executables");
        this.jTextFieldTessDir.setEnabled(false);
        this.jTextFieldTessDir.setPreferredSize(new Dimension(180, 24));
        this.jPanelMain.add(this.jTextFieldTessDir);
        this.jButtonBrowseTess.setText("...");
        this.jButtonBrowseTess.setToolTipText("Browse");
        this.jButtonBrowseTess.setMaximumSize(new Dimension(30, 23));
        this.jButtonBrowseTess.setMinimumSize(new Dimension(30, 23));
        this.jButtonBrowseTess.setPreferredSize(new Dimension(24, 23));
        this.jButtonBrowseTess.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonBrowseTessActionPerformed(actionEvent);
            }
        });
        this.jPanelMain.add(this.jButtonBrowseTess);
        this.jLabel3.setText("Training Data");
        this.jPanelMain.add(this.jLabel3);
        this.jTextFieldDataDir.setToolTipText("Location of Source Training Data");
        this.jTextFieldDataDir.setEnabled(false);
        this.jTextFieldDataDir.setPreferredSize(new Dimension(180, 24));
        this.jPanelMain.add(this.jTextFieldDataDir);
        this.jButtonBrowseData.setText("...");
        this.jButtonBrowseData.setToolTipText("Browse");
        this.jButtonBrowseData.setMaximumSize(new Dimension(30, 23));
        this.jButtonBrowseData.setMinimumSize(new Dimension(30, 23));
        this.jButtonBrowseData.setPreferredSize(new Dimension(24, 23));
        this.jButtonBrowseData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonBrowseDataActionPerformed(actionEvent);
            }
        });
        this.jPanelMain.add(this.jButtonBrowseData);
        this.jLabel1.setText("Language");
        this.jPanelMain.add(this.jLabel1);
        this.jTextFieldLang.setMinimumSize(new Dimension(34, 19));
        this.jTextFieldLang.setPreferredSize(new Dimension(30, 24));
        this.jPanelMain.add(this.jTextFieldLang);
        this.jLabel2.setText("Bootstrap Language");
        this.jPanelMain.add(this.jLabel2);
        this.jTextFieldBootstrapLang.setMinimumSize(new Dimension(34, 19));
        this.jTextFieldBootstrapLang.setPreferredSize(new Dimension(30, 24));
        this.jPanelMain.add(this.jTextFieldBootstrapLang);
        this.jCheckBoxRTL.setText("RTL");
        this.jCheckBoxRTL.setToolTipText("Right-To-Left Text Direction");
        this.jPanelMain.add(this.jCheckBoxRTL);
        this.jComboBoxOps.setModel(new DefaultComboBoxModel<TrainingMode>(TrainingMode.values()));
        this.jComboBoxOps.setToolTipText("Training Mode");
        this.jPanelMain.add(this.jComboBoxOps);
        this.jButtonTrain.setText("Run");
        this.jButtonTrain.setToolTipText("Start Training");
        this.jButtonTrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonTrainActionPerformed(actionEvent);
            }
        });
        this.jPanelMain.add(this.jButtonTrain);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setToolTipText("Cancel Training");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonCancelActionPerformed(actionEvent);
            }
        });
        this.jPanelMain.add(this.jButtonCancel);
        this.jButtonValidate.setText("Validate");
        this.jButtonValidate.setToolTipText("Validate Generated Traineddata");
        this.jButtonValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonValidateActionPerformed(actionEvent);
            }
        });
        this.jPanelMain.add(this.jButtonValidate);
        this.jButtonSaveLog.setText("Save");
        this.jButtonSaveLog.setToolTipText("Save Log");
        this.jButtonSaveLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonSaveLogActionPerformed(actionEvent);
            }
        });
        this.jPanelMain.add(this.jButtonSaveLog);
        this.jButtonClearLog.setText("Clear");
        this.jButtonClearLog.setToolTipText("Clear Textaera");
        this.jButtonClearLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonClearLogActionPerformed(actionEvent);
            }
        });
        this.jPanelMain.add(this.jButtonClearLog);
        this.jToolBarTrainer.add(this.jPanelMain);
        this.jPanelTrainer.add((Component)this.jToolBarTrainer, "First");
        this.jTextAreaOutput.setEditable(false);
        this.jTextAreaOutput.setColumns(20);
        this.jTextAreaOutput.setRows(5);
        this.jTextAreaOutput.setMargin(new Insets(5, 5, 2, 2));
        this.jScrollPane1.setViewportView(this.jTextAreaOutput);
        this.jPanelTrainer.add((Component)this.jScrollPane1, "Center");
        this.jPanelStatus1.setLayout(new FlowLayout(0));
        this.jPanelStatus1.add(this.filler2);
        this.jProgressBar1.setStringPainted(true);
        this.jPanelStatus1.add(this.jProgressBar1);
        this.jPanelStatus1.add(this.jLabelTime);
        this.jPanelTrainer.add((Component)this.jPanelStatus1, "South");
        this.jTabbedPaneMain.addTab("Trainer", this.jPanelTrainer);
        this.jPanelEditor.setLayout(new BorderLayout());
        this.jToolBarEditor.setRollover(true);
        this.jPanel4.setLayout(new FlowLayout(0, 1, 5));
        this.jButtonOpen.setText(resourceBundle.getString("jButtonOpen.Text"));
        this.jButtonOpen.setToolTipText(resourceBundle.getString("jButtonOpen.ToolTipText"));
        this.jButtonOpen.setFocusable(false);
        this.jButtonOpen.setHorizontalTextPosition(0);
        this.jButtonOpen.setVerticalTextPosition(3);
        this.jButtonOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonOpenActionPerformed(actionEvent);
            }
        });
        this.jPanel4.add(this.jButtonOpen);
        this.jButtonSave.setText(resourceBundle.getString("jButtonSave.Text"));
        this.jButtonSave.setToolTipText(resourceBundle.getString("jButtonSave.ToolTipText"));
        this.jButtonSave.setFocusable(false);
        this.jButtonSave.setHorizontalTextPosition(0);
        this.jButtonSave.setVerticalTextPosition(3);
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonSaveActionPerformed(actionEvent);
            }
        });
        this.jPanel4.add(this.jButtonSave);
        this.jButtonReload.setText("Reload");
        this.jButtonReload.setToolTipText("Reload Box File");
        this.jButtonReload.setFocusable(false);
        this.jButtonReload.setHorizontalTextPosition(0);
        this.jButtonReload.setVerticalTextPosition(3);
        this.jButtonReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonReloadActionPerformed(actionEvent);
            }
        });
        this.jPanel4.add(this.jButtonReload);
        this.jPanel4.add(Box.createHorizontalStrut(100));
        this.jButtonMerge.setText(resourceBundle.getString("jButtonMerge.Text"));
        this.jButtonMerge.setToolTipText(resourceBundle.getString("jButtonMerge.ToolTipText"));
        this.jButtonMerge.setFocusable(false);
        this.jButtonMerge.setHorizontalTextPosition(0);
        this.jButtonMerge.setVerticalTextPosition(3);
        this.jButtonMerge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonMergeActionPerformed(actionEvent);
            }
        });
        this.jPanel4.add(this.jButtonMerge);
        this.jButtonSplit.setText(resourceBundle.getString("jButtonSplit.Text"));
        this.jButtonSplit.setToolTipText(resourceBundle.getString("jButtonSplit.ToolTipText"));
        this.jButtonSplit.setFocusable(false);
        this.jButtonSplit.setHorizontalTextPosition(0);
        this.jButtonSplit.setVerticalTextPosition(3);
        this.jButtonSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonSplitActionPerformed(actionEvent);
            }
        });
        this.jPanel4.add(this.jButtonSplit);
        this.jButtonInsert.setText(resourceBundle.getString("jButtonInsert.Text"));
        this.jButtonInsert.setToolTipText(resourceBundle.getString("jButtonInsert.ToolTipText"));
        this.jButtonInsert.setFocusable(false);
        this.jButtonInsert.setHorizontalTextPosition(0);
        this.jButtonInsert.setVerticalTextPosition(3);
        this.jButtonInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonInsertActionPerformed(actionEvent);
            }
        });
        this.jPanel4.add(this.jButtonInsert);
        this.jButtonDelete.setText(resourceBundle.getString("jButtonDelete.Text"));
        this.jButtonDelete.setToolTipText(resourceBundle.getString("jButtonDelete.ToolTipText"));
        this.jButtonDelete.setFocusable(false);
        this.jButtonDelete.setHorizontalTextPosition(0);
        this.jButtonDelete.setVerticalTextPosition(3);
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonDeleteActionPerformed(actionEvent);
            }
        });
        this.jPanel4.add(this.jButtonDelete);
        this.jToolBarEditor.add(this.jPanel4);
        this.jLabelCharacter.setLabelFor(this.jTextFieldCharacter);
        this.jLabelCharacter.setText("Character");
        this.jPanelSpinner.add(this.jLabelCharacter);
        this.jTextFieldCharacter.setColumns(4);
        this.jTextFieldCharacter.setEnabled(false);
        this.jTextFieldCharacter.setMargin(new Insets(0, 2, 0, 2));
        this.jTextFieldCharacter.setPreferredSize(new Dimension(40, 24));
        this.jTextFieldCharacter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jTextFieldCharacterActionPerformed(actionEvent);
            }
        });
        this.jTextFieldCharacter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Gui.this.jTextFieldCharacterKeyReleased(keyEvent);
            }
        });
        this.jPanelSpinner.add(this.jTextFieldCharacter);
        this.jButtonConvert.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/tessboxeditor/icons/tools.png")));
        this.jButtonConvert.setToolTipText("<html>Convert NCR and Escape<br/>Sequence to Unicode</html>");
        this.jButtonConvert.setPreferredSize(new Dimension(20, 20));
        this.jButtonConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonConvertActionPerformed(actionEvent);
            }
        });
        this.jPanelSpinner.add(this.jButtonConvert);
        this.jPanelSpinner.add(Box.createHorizontalStrut(10));
        this.jLabelX.setLabelFor(this.jSpinnerX);
        this.jLabelX.setText("X");
        this.jPanelSpinner.add(this.jLabelX);
        this.jSpinnerX.setEditor(new JSpinner.NumberEditor(this.jSpinnerX, "#"));
        this.jSpinnerX.setEnabled(false);
        this.jSpinnerX.setPreferredSize(new Dimension(63, 22));
        this.jSpinnerX.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Gui.this.jSpinnerXStateChanged(changeEvent);
            }
        });
        this.jPanelSpinner.add(this.jSpinnerX);
        this.jLabelY.setLabelFor(this.jSpinnerY);
        this.jLabelY.setText("Y");
        this.jPanelSpinner.add(this.jLabelY);
        this.jSpinnerY.setEditor(new JSpinner.NumberEditor(this.jSpinnerY, "#"));
        this.jSpinnerY.setEnabled(false);
        this.jSpinnerY.setPreferredSize(new Dimension(63, 22));
        this.jSpinnerY.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Gui.this.jSpinnerYStateChanged(changeEvent);
            }
        });
        this.jPanelSpinner.add(this.jSpinnerY);
        this.jLabelW.setLabelFor(this.jSpinnerW);
        this.jLabelW.setText("W");
        this.jPanelSpinner.add(this.jLabelW);
        this.jSpinnerW.setModel(new SpinnerNumberModel());
        this.jSpinnerW.setEditor(new JSpinner.NumberEditor(this.jSpinnerW, "#"));
        this.jSpinnerW.setEnabled(false);
        this.jSpinnerW.setPreferredSize(new Dimension(48, 22));
        this.jSpinnerW.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Gui.this.jSpinnerWStateChanged(changeEvent);
            }
        });
        this.jPanelSpinner.add(this.jSpinnerW);
        this.jLabelH.setLabelFor(this.jSpinnerH);
        this.jLabelH.setText("H");
        this.jPanelSpinner.add(this.jLabelH);
        this.jSpinnerH.setModel(new SpinnerNumberModel());
        this.jSpinnerH.setEditor(new JSpinner.NumberEditor(this.jSpinnerH, "#"));
        this.jSpinnerH.setEnabled(false);
        this.jSpinnerH.setPreferredSize(new Dimension(48, 22));
        this.jSpinnerH.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Gui.this.jSpinnerHStateChanged(changeEvent);
            }
        });
        this.jPanelSpinner.add(this.jSpinnerH);
        this.jToolBarEditor.add(this.jPanelSpinner);
        this.jToolBarEditor.add(Box.createHorizontalGlue());
        this.jPanelEditor.add((Component)this.jToolBarEditor, "First");
        this.jSplitPaneEditor.setDividerSize(2);
        this.jPanelCoord.setLayout(new BorderLayout());
        this.jScrollPaneCoord.setPreferredSize(new Dimension(200, 275));
        this.jTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Char", "X", "Y", "Width", "Height"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class, Object.class, Object.class, Object.class};
                this.canEdit = new boolean[]{true, false, false, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jTable.setFillsViewportHeight(true);
        this.jTable.setSelectionMode(2);
        this.jScrollPaneCoord.setViewportView(this.jTable);
        this.tableModel = (DefaultTableModel)this.jTable.getModel();
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = tableModelEvent.getFirstRow();
                int n2 = tableModelEvent.getColumn();
                if (n != -1 && n2 == 0) {
                    TableModel tableModel = (TableModel)tableModelEvent.getSource();
                    Object object = tableModel.getValueAt(n, n2);
                    String string = (String)object;
                    TessBox tessBox = Gui.this.boxes.toList().get(n);
                    tessBox.setChrs(string);
                    Gui.this.jTextFieldCharacter.setText(string);
                    Gui.this.jTextFieldChar.setText(string);
                    Gui.this.jTextFieldCodepointValue.setText(Utils.toHex(string));
                    Gui.this.updateSave(true);
                }
            }
        });
        ListSelectionModel listSelectionModel = this.jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = Gui.this.jTable.getSelectedRow();
                    if (n != -1) {
                        Object object;
                        if (!((JImageLabel)Gui.this.jLabelImage).isBoxClickAction()) {
                            Gui.this.boxes.deselectAll();
                        }
                        List<TessBox> list = Gui.this.boxes.toList();
                        for (int bufferedImage : Gui.this.jTable.getSelectedRows()) {
                            object = list.get(bufferedImage);
                            ((TessBox)object).setSelected(true);
                            Gui.this.jLabelImage.scrollRectToVisible(((TessBox)object).getRect());
                        }
                        Gui.this.jLabelImage.repaint();
                        if (Gui.this.jTable.getSelectedRows().length == 1) {
                            Gui.this.enableReadout(true);
                            Gui.this.jTextFieldCharacter.setText((String)Gui.this.tableModel.getValueAt(n, 0));
                            Gui.this.jTextFieldChar.setText(Gui.this.jTextFieldCharacter.getText());
                            Gui.this.jTextFieldCodepointValue.setText(Utils.toHex(Gui.this.jTextFieldCharacter.getText()));
                            Icon icon = Gui.this.jLabelImage.getIcon();
                            TessBox tessBox = list.get(n);
                            Rectangle rectangle = tessBox.getRect();
                            try {
                                BufferedImage exception = Gui.this.getSubimage((BufferedImage)((ImageIcon)icon).getImage(), rectangle);
                                object = new ImageIconScalable(exception);
                                ((ImageIconScalable)object).setScaledFactor(scaleFactor);
                                Gui.this.jLabelSubimage.setIcon((Icon)object);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Gui.this.tableSelectAction = true;
                            Gui.this.jSpinnerX.setValue(rectangle.x);
                            Gui.this.jSpinnerY.setValue(rectangle.y);
                            Gui.this.jSpinnerH.setValue(rectangle.height);
                            Gui.this.jSpinnerW.setValue(rectangle.width);
                            Gui.this.tableSelectAction = false;
                        } else {
                            Gui.this.enableReadout(false);
                            Gui.this.resetReadout();
                        }
                    } else {
                        Gui.this.boxes.deselectAll();
                        Gui.this.jLabelImage.repaint();
                        Gui.this.enableReadout(false);
                        Gui.this.tableSelectAction = true;
                        Gui.this.resetReadout();
                        Gui.this.tableSelectAction = false;
                    }
                }
            }
        });
        TableCellRenderer tableCellRenderer = this.jTable.getDefaultRenderer(String.class);
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)tableCellRenderer;
        defaultTableCellRenderer.setHorizontalAlignment(0);
        ((JLabel)((Object)this.jTable.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        ((JImageLabel)this.jLabelImage).setTable(this.jTable);
        this.jTable.getInputMap(1).put(KeyStroke.getKeyStroke("control C"), "none");
        this.jTable.getInputMap(1).put(KeyStroke.getKeyStroke("control X"), "none");
        this.jTable.getInputMap(1).put(KeyStroke.getKeyStroke("control V"), "none");
        this.rowHeader = new RowHeaderList(this.jTable);
        this.jScrollPaneCoord.setRowHeaderView(this.rowHeader);
        this.jTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.jTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.jTable.setDefaultEditor(String.class, new MyTableCellEditor());
        this.jPanelCoord.add((Component)this.jScrollPaneCoord, "Center");
        this.jTextFieldFind.setPreferredSize(new Dimension(200, 20));
        this.jTextFieldFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jTextFieldFindActionPerformed(actionEvent);
            }
        });
        this.jPanelFind.add(this.jTextFieldFind);
        this.jButtonFind.setText(resourceBundle.getString("jButtonFind.Text"));
        this.jButtonFind.setToolTipText(resourceBundle.getString("jButtonFind.ToolTipText"));
        this.jButtonFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonFindActionPerformed(actionEvent);
            }
        });
        this.jPanelFind.add(this.jButtonFind);
        this.jPanelCoord.add((Component)this.jPanelFind, "South");
        this.jTabbedPaneBoxData.addTab("Box Coordinates", this.jPanelCoord);
        this.jTextAreaBoxData.setEditable(false);
        this.jTextAreaBoxData.setColumns(20);
        this.jTextAreaBoxData.setRows(5);
        this.jTextAreaBoxData.setMargin(new Insets(8, 8, 2, 2));
        this.jScrollPaneBoxData.setViewportView(this.jTextAreaBoxData);
        this.jTabbedPaneBoxData.addTab("Box Data", this.jScrollPaneBoxData);
        this.jPanelBoxView.setBackground(Color.lightGray);
        this.jPanelBoxView.setLayout(new BorderLayout());
        this.jPanelNorthContainer.setLayout(new BoxLayout(this.jPanelNorthContainer, 1));
        this.jPanelChar.setBackground(Color.lightGray);
        this.jPanelChar.setLayout(new FlowLayout(0));
        this.jLabelCodepoint.setText("Char/Codepoint:");
        this.jPanelChar.add(this.jLabelCodepoint);
        this.jTextFieldChar.setEditable(false);
        this.jTextFieldChar.setOpaque(false);
        this.jPanelChar.add(this.jTextFieldChar);
        this.jTextFieldCodepointValue.setEditable(false);
        this.jTextFieldCodepointValue.setOpaque(false);
        this.jPanelChar.add(this.jTextFieldCodepointValue);
        this.jPanelNorthContainer.add(this.jPanelChar);
        this.jPanelControls.setBackground(Color.lightGray);
        this.jPanelControls.setLayout(new FlowLayout(0));
        this.jLabelSpinnerMargin.setLabelFor(this.jSpinnerMargin);
        this.jLabelSpinnerMargin.setText("Margins");
        this.jPanelControls.add(this.jLabelSpinnerMargin);
        this.jSpinnerMargin.setModel(new SpinnerNumberModel(3, 0, 20, 1));
        this.jSpinnerMargin.setFocusable(false);
        ((JSpinner.DefaultEditor)this.jSpinnerMargin.getEditor()).getTextField().setEditable(false);
        ((JSpinner.DefaultEditor)this.jSpinnerMargin.getEditor()).getTextField().setFocusable(false);
        this.jSpinnerMargin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Gui.this.jSpinnerMarginStateChanged(changeEvent);
            }
        });
        this.jPanelControls.add(this.jSpinnerMargin);
        this.jLabelSpinnerScale.setLabelFor(this.jSpinnerScale);
        this.jLabelSpinnerScale.setText("Scale");
        this.jPanelControls.add(Box.createHorizontalStrut(10));
        this.jPanelControls.add(this.jLabelSpinnerScale);
        this.jSpinnerScale.setModel(new SpinnerNumberModel(4, 1, 10, 1));
        this.jSpinnerScale.setFocusable(false);
        ((JSpinner.DefaultEditor)this.jSpinnerScale.getEditor()).getTextField().setEditable(false);
        ((JSpinner.DefaultEditor)this.jSpinnerScale.getEditor()).getTextField().setFocusable(false);
        this.jSpinnerScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Gui.this.jSpinnerScaleStateChanged(changeEvent);
            }
        });
        this.jPanelControls.add(this.jSpinnerScale);
        this.jPanelNorthContainer.add(this.jPanelControls);
        this.jPanelBoxView.add((Component)this.jPanelNorthContainer, "North");
        this.jLabelSubimage.setHorizontalAlignment(0);
        this.jPanelBoxView.add((Component)this.jLabelSubimage, "Center");
        this.jPanelButtons.setBackground(new Color(192, 192, 192));
        this.jButtonPrev.setText("Prev");
        this.jButtonPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonPrevActionPerformed(actionEvent);
            }
        });
        this.jPanelButtons.add(this.jButtonPrev);
        this.jButtonNext.setText("Next");
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonNextActionPerformed(actionEvent);
            }
        });
        this.jPanelButtons.add(this.jButtonNext);
        this.jPanelBoxView.add((Component)this.jPanelButtons, "South");
        this.jTabbedPaneBoxData.addTab("Box View", this.jPanelBoxView);
        this.jSplitPaneEditor.setLeftComponent(this.jTabbedPaneBoxData);
        this.jLabelImage.setVerticalAlignment(1);
        this.jScrollPaneImage.setViewportView(this.jLabelImage);
        this.jSplitPaneEditor.setRightComponent(this.jScrollPaneImage);
        this.jPanelEditor.add((Component)this.jSplitPaneEditor, "Center");
        this.jPanelStatus.add(this.jLabelStatus);
        this.jPanelStatus.add(this.jLabelPageNbr);
        this.jPanelStatus.add(Box.createHorizontalStrut(10));
        this.jButtonPrevPage.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/tessboxeditor/icons/PrevPage.gif")));
        this.jButtonPrevPage.setToolTipText(resourceBundle.getString("jButtonPrevPage.ToolTipText"));
        this.jButtonPrevPage.setFocusable(false);
        this.jButtonPrevPage.setHorizontalTextPosition(0);
        this.jButtonPrevPage.setVerticalTextPosition(3);
        this.jButtonPrevPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonPrevPageActionPerformed(actionEvent);
            }
        });
        this.jPanelStatus.add(this.jButtonPrevPage);
        this.jButtonNextPage.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/tessboxeditor/icons/NextPage.gif")));
        this.jButtonNextPage.setToolTipText(resourceBundle.getString("jButtonNextPage.ToolTipText"));
        this.jButtonNextPage.setFocusable(false);
        this.jButtonNextPage.setHorizontalTextPosition(0);
        this.jButtonNextPage.setVerticalTextPosition(3);
        this.jButtonNextPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonNextPageActionPerformed(actionEvent);
            }
        });
        this.jPanelStatus.add(this.jButtonNextPage);
        this.jPanelEditor.add((Component)this.jPanelStatus, "South");
        this.jTabbedPaneMain.addTab("Box Editor", this.jPanelEditor);
        this.jPanelTIFFBox.setLayout(new BorderLayout());
        this.jToolBarGenerator.setRollover(true);
        this.jPanel3.setLayout(new FlowLayout(0));
        this.jButtonInput.setText("Input");
        this.jButtonInput.setToolTipText("Load Text File");
        this.jButtonInput.setFocusable(false);
        this.jButtonInput.setHorizontalTextPosition(0);
        this.jButtonInput.setVerticalTextPosition(3);
        this.jButtonInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonInputActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.jButtonInput);
        this.jLabelOutput.setText("Output");
        this.jPanel3.add(this.jLabelOutput);
        this.jTextFieldOuputDir.setToolTipText("Ouput Directory");
        this.jTextFieldOuputDir.setEnabled(false);
        this.jTextFieldOuputDir.setPreferredSize(new Dimension(180, 24));
        this.jPanel3.add(this.jTextFieldOuputDir);
        this.jButtonBrowseOutputDir.setText("...");
        this.jButtonBrowseOutputDir.setToolTipText("Browse");
        this.jButtonBrowseOutputDir.setPreferredSize(new Dimension(24, 23));
        this.jButtonBrowseOutputDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonBrowseOutputDirActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.jButtonBrowseOutputDir);
        this.jTextFieldPrefix.setToolTipText("Prefix (Language Code)");
        this.jTextFieldPrefix.setPreferredSize(new Dimension(38, 24));
        this.jPanel3.add(this.jTextFieldPrefix);
        this.jTextFieldFileName.setToolTipText("Filename");
        this.jTextFieldFileName.setPreferredSize(new Dimension(140, 24));
        this.jPanel3.add(this.jTextFieldFileName);
        this.jButtonFont.setText("Font");
        this.jButtonFont.setToolTipText("Select Font");
        this.jButtonFont.setFocusable(false);
        this.jButtonFont.setHorizontalTextPosition(0);
        this.jButtonFont.setVerticalTextPosition(3);
        this.jButtonFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonFontActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.jButtonFont);
        this.jCheckBoxAntiAliasing.setText("Anti-Aliasing");
        this.jPanel3.add(this.jCheckBoxAntiAliasing);
        this.jLabelNoise.setText("Noise");
        this.jPanel3.add(this.jLabelNoise);
        this.jSpinnerNoise.setModel(new SpinnerNumberModel(0, 0, 5, 1));
        this.jSpinnerNoise.setToolTipText("Add Noise to Image");
        this.jSpinnerNoise.setName("Noise");
        this.jSpinnerNoise.setPreferredSize(new Dimension(47, 22));
        this.jPanel3.add(this.jSpinnerNoise);
        this.jLabelTracking.setText("Letter Tracking");
        this.jPanel3.add(this.jLabelTracking);
        this.jSpinnerTracking.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(-0.04f), Float.valueOf(0.1f), Float.valueOf(0.01f)));
        this.jSpinnerTracking.setToolTipText("Adjust Letter Tracking");
        this.jSpinnerTracking.setPreferredSize(new Dimension(64, 22));
        this.jSpinnerTracking.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Gui.this.jSpinnerTrackingStateChanged(changeEvent);
            }
        });
        this.jPanel3.add(this.jSpinnerTracking);
        this.jLabelW1.setText("W");
        this.jPanel3.add(this.jLabelW1);
        this.jSpinnerW1.setModel(new SpinnerNumberModel(2550, 600, 2550, 10));
        this.jSpinnerW1.setToolTipText("Image Width");
        this.jSpinnerW1.setEditor(new JSpinner.NumberEditor(this.jSpinnerW1, "#"));
        this.jSpinnerW1.setPreferredSize(new Dimension(63, 22));
        this.jPanel3.add(this.jSpinnerW1);
        this.jLabelH1.setText("H");
        this.jPanel3.add(this.jLabelH1);
        this.jSpinnerH1.setModel(new SpinnerNumberModel(3300, 400, 3300, 10));
        this.jSpinnerH1.setToolTipText("Image Height");
        this.jSpinnerH1.setEditor(new JSpinner.NumberEditor(this.jSpinnerH1, "#"));
        this.jSpinnerH1.setPreferredSize(new Dimension(63, 22));
        this.jPanel3.add(this.jSpinnerH1);
        this.jButtonGenerate.setText("Generate");
        this.jButtonGenerate.setToolTipText("Generate TIFF/Box");
        this.jButtonGenerate.setFocusable(false);
        this.jButtonGenerate.setHorizontalTextPosition(0);
        this.jButtonGenerate.setVerticalTextPosition(3);
        this.jButtonGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonGenerateActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.jButtonGenerate);
        this.jButtonClear.setText("Clear");
        this.jButtonClear.setToolTipText("Clear Textarea");
        this.jButtonClear.setFocusable(false);
        this.jButtonClear.setHorizontalTextPosition(0);
        this.jButtonClear.setVerticalTextPosition(3);
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jButtonClearActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.jButtonClear);
        this.jToolBarGenerator.add(this.jPanel3);
        this.jPanelTIFFBox.add((Component)this.jToolBarGenerator, "First");
        this.jTextAreaInput.setColumns(20);
        this.jTextAreaInput.setLineWrap(true);
        this.jTextAreaInput.setRows(5);
        this.jTextAreaInput.setWrapStyleWord(true);
        this.jTextAreaInput.setMargin(new Insets(5, 5, 2, 2));
        this.jScrollPaneText.setViewportView(this.jTextAreaInput);
        this.jPanelTIFFBox.add((Component)this.jScrollPaneText, "Center");
        this.jTabbedPaneMain.addTab("TIFF/Box Generator", this.jPanelTIFFBox);
        this.getContentPane().add((Component)this.jTabbedPaneMain, "Center");
        this.jMenuFile.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuFile.Mnemonic").charAt(0));
        this.jMenuFile.setText(resourceBundle.getString("jMenuFile.Text"));
        this.jMenuItemOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItemOpen.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuItemOpen.Mnemonic").charAt(0));
        this.jMenuItemOpen.setText(resourceBundle.getString("jMenuItemOpen.Text"));
        this.jMenuItemOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jMenuItemOpenActionPerformed(actionEvent);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpen);
        this.jMenuItemSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItemSave.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuItemSave.Mnemonic").charAt(0));
        this.jMenuItemSave.setText(resourceBundle.getString("jMenuItemSave.Text"));
        this.jMenuItemSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jMenuItemSaveActionPerformed(actionEvent);
            }
        });
        this.jMenuFile.add(this.jMenuItemSave);
        this.jMenuItemSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.jMenuItemSaveAs.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuItemSaveAs.Mnemonic").charAt(0));
        this.jMenuItemSaveAs.setText(resourceBundle.getString("jMenuItemSaveAs.Text"));
        this.jMenuItemSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jMenuItemSaveAsActionPerformed(actionEvent);
            }
        });
        this.jMenuFile.add(this.jMenuItemSaveAs);
        this.jMenuFile.add(this.jSeparatorRecentFiles);
        this.jMenuRecentFiles.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuRecentFiles.Mnemonic").charAt(0));
        this.jMenuRecentFiles.setText(resourceBundle.getString("jMenuRecentFiles.Text"));
        this.jMenuFile.add(this.jMenuRecentFiles);
        this.jMenuFile.add(this.jSeparatorExit);
        this.jMenuItemExit.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuItemExit.Mnemonic").charAt(0));
        this.jMenuItemExit.setText(resourceBundle.getString("jMenuItemExit.Text"));
        this.jMenuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jMenuItemExitActionPerformed(actionEvent);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuEdit.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuEdit.Mnemonic").charAt(0));
        this.jMenuEdit.setText(resourceBundle.getString("jMenuEdit.Text"));
        this.jMenuItemMerge.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenuItemMerge.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuItemMerge.Mnemonic").charAt(0));
        this.jMenuItemMerge.setText(resourceBundle.getString("jMenuItemMerge.Text"));
        this.jMenuItemMerge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jMenuItemMergeActionPerformed(actionEvent);
            }
        });
        this.jMenuEdit.add(this.jMenuItemMerge);
        this.jMenuItemSplit.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.jMenuItemSplit.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuItemSplit.Mnemonic").charAt(0));
        this.jMenuItemSplit.setText(resourceBundle.getString("jMenuItemSplit.Text"));
        this.jMenuItemSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jMenuItemSplitActionPerformed(actionEvent);
            }
        });
        this.jMenuEdit.add(this.jMenuItemSplit);
        this.jMenuItemInsert.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMenuItemInsert.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuItemInsert.Mnemonic").charAt(0));
        this.jMenuItemInsert.setText(resourceBundle.getString("jMenuItemInsert.Text"));
        this.jMenuItemInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jMenuItemInsertActionPerformed(actionEvent);
            }
        });
        this.jMenuEdit.add(this.jMenuItemInsert);
        this.jMenuItemDelete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.jMenuItemDelete.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuItemDelete.Mnemonic").charAt(0));
        this.jMenuItemDelete.setText(resourceBundle.getString("jMenuItemDelete.Text"));
        this.jMenuItemDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jMenuItemDeleteActionPerformed(actionEvent);
            }
        });
        this.jMenuEdit.add(this.jMenuItemDelete);
        this.jMenuBar.add(this.jMenuEdit);
        this.jMenuSettings.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuSettings.Mnemonic").charAt(0));
        this.jMenuSettings.setText("Settings");
        this.jMenuItemFont.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.jMenuItemFont.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuItemFont.Mnemonic").charAt(0));
        this.jMenuItemFont.setText(resourceBundle.getString("jMenuItemFont.Text"));
        this.jMenuItemFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jMenuItemFontActionPerformed(actionEvent);
            }
        });
        this.jMenuSettings.add(this.jMenuItemFont);
        this.jMenuSettings.add(this.jSeparatorLAF);
        this.jMenuLookAndFeel.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuLookAndFeel.Mnemonic").charAt(0));
        this.jMenuLookAndFeel.setText(resourceBundle.getString("jMenuLookAndFeel.Text"));
        this.jMenuSettings.add(this.jMenuLookAndFeel);
        this.jMenuBar.add(this.jMenuSettings);
        this.jMenuTools.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuTools.Mnemonic").charAt(0));
        this.jMenuTools.setText(resourceBundle.getString("jMenuTools.Text"));
        this.jMenuItemMergeTiff.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.jMenuItemMergeTiff.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuItemMergeTiff.Mnemonic").charAt(0));
        this.jMenuItemMergeTiff.setText(resourceBundle.getString("jMenuItemMergeTiff.Text"));
        this.jMenuItemMergeTiff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jMenuItemMergeTiffActionPerformed(actionEvent);
            }
        });
        this.jMenuTools.add(this.jMenuItemMergeTiff);
        this.jMenuItemSplitTiff.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.jMenuItemSplitTiff.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuItemSplitTiff.Mnemonic").charAt(0));
        this.jMenuItemSplitTiff.setText(resourceBundle.getString("jMenuItemSplitTiff.Text"));
        this.jMenuItemSplitTiff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jMenuItemSplitTiffActionPerformed(actionEvent);
            }
        });
        this.jMenuTools.add(this.jMenuItemSplitTiff);
        this.jMenuBar.add(this.jMenuTools);
        this.jMenuHelp.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuHelp.Mnemonic").charAt(0));
        this.jMenuHelp.setText(resourceBundle.getString("jMenuHelp.Text"));
        this.jMenuItemHelp.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuItemHelp.Mnemonic").charAt(0));
        this.jMenuItemHelp.setText(resourceBundle.getString("jMenuItemHelp.Text"));
        this.jMenuItemHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jMenuItemHelpActionPerformed(actionEvent);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelp);
        this.jMenuHelp.add(this.jSeparatorAbout);
        this.jMenuItemAbout.setMnemonic(ResourceBundle.getBundle("net/sourceforge/tessboxeditor/Gui").getString("jMenuItemAbout.Mnemonic").charAt(0));
        this.jMenuItemAbout.setText(resourceBundle.getString("jMenuItemAbout.Text"));
        this.jMenuItemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Gui.this.jMenuItemAboutActionPerformed(actionEvent);
            }
        });
        this.jMenuHelp.add(this.jMenuItemAbout);
        this.jMenuBar.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addKeyEventDispatcher(new KeyEventDispatcher(){

            private void inc(JSpinner jSpinner) {
                if (jSpinner == Gui.this.jSpinnerX || jSpinner == Gui.this.jSpinnerY) {
                    if (!invertControls) {
                        jSpinner.setValue(Math.max(0, (Integer)jSpinner.getValue() - movementMultiplier));
                    } else {
                        jSpinner.setValue((Integer)jSpinner.getValue() + movementMultiplier);
                    }
                } else {
                    jSpinner.setValue((Integer)jSpinner.getValue() + movementMultiplier);
                }
            }

            private void inc(JSpinner jSpinner, int n) {
                if (!(jSpinner != Gui.this.jSpinnerX && jSpinner != Gui.this.jSpinnerY || invertControls)) {
                    jSpinner.setValue(Math.max(0, (Integer)jSpinner.getValue() - movementMultiplier));
                } else {
                    jSpinner.setValue((Integer)jSpinner.getValue() + movementMultiplier);
                }
            }

            private void dec(JSpinner jSpinner) {
                if (!(jSpinner != Gui.this.jSpinnerX && jSpinner != Gui.this.jSpinnerY || invertControls)) {
                    jSpinner.setValue((Integer)jSpinner.getValue() + movementMultiplier);
                } else {
                    jSpinner.setValue(Math.max(0, (Integer)jSpinner.getValue() - movementMultiplier));
                }
            }

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getID() != 400) {
                    return false;
                }
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (component instanceof JSpinner || component instanceof JTextField) {
                    return false;
                }
                if (Gui.this.jLabelCharacter.hasFocus()) {
                    return false;
                }
                if (!Gui.this.jPanelBoxView.isShowing()) {
                    return false;
                }
                movementMultiplier = keyEvent.isShiftDown() ? 10 : 1;
                char c = Character.toLowerCase(keyEvent.getKeyChar());
                if (c == 'w') {
                    this.inc(Gui.this.jSpinnerY);
                } else if (c == 's') {
                    this.dec(Gui.this.jSpinnerY);
                } else if (c == 'd') {
                    this.dec(Gui.this.jSpinnerX);
                } else if (c == 'a') {
                    this.inc(Gui.this.jSpinnerX);
                } else if (c == 'q') {
                    this.dec(Gui.this.jSpinnerW);
                } else if (c == 'e') {
                    this.inc(Gui.this.jSpinnerW);
                } else if (c == 'r') {
                    this.dec(Gui.this.jSpinnerH);
                } else if (c == 'f') {
                    this.inc(Gui.this.jSpinnerH);
                } else if (c == ',') {
                    Gui.this.jButtonPrev.doClick();
                } else if (c == '.') {
                    Gui.this.jButtonNext.doClick();
                } else if (c == 'x') {
                    Gui.this.jTextFieldCharacter.requestFocus();
                } else {
                    return false;
                }
                return true;
            }
        });
        this.pack();
    }

    private void jMenuItemOpenActionPerformed(ActionEvent actionEvent) {
        if (this.jFileChooserInputImage.showOpenDialog(this) == 0) {
            this.currentDirectory = this.jFileChooserInputImage.getCurrentDirectory().getPath();
            this.openFile(this.jFileChooserInputImage.getSelectedFile());
            for (int i = 0; i < this.fileFilters.length; ++i) {
                if (this.fileFilters[i] != this.jFileChooserInputImage.getFileFilter()) continue;
                this.filterIndex = i;
                break;
            }
        }
    }

    public void openFile(final File file) {
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("File_not_exist"), APP_NAME, 0);
            return;
        }
        if (!this.promptToSave()) {
            return;
        }
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Gui.this.readImageFile(file);
                Gui.this.updateMRUList(file.getPath());
                int n = file.getName().lastIndexOf(".");
                Gui.this.boxFile = new File(file.getParentFile(), file.getName().substring(0, n) + ".box");
                Gui.this.readBoxFile(Gui.this.boxFile);
                return null;
            }

            @Override
            protected void done() {
                Gui.this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                Gui.this.getGlassPane().setVisible(false);
            }
        };
        swingWorker.execute();
    }

    void readImageFile(File file) {
        block4: {
            try {
                this.imageList = ImageIOHelper.getImageList(file);
                if (this.imageList == null) {
                    JOptionPane.showMessageDialog(this, this.bundle.getString("Cannotloadimage"), APP_NAME, 0);
                    return;
                }
                this.imageIndex = 0;
                this.loadImage();
                this.jScrollPaneImage.getViewport().setViewPosition(new Point(0, 0));
                this.setTitle("jTessBoxEditor - " + file.getName());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                JOptionPane.showMessageDialog(this, outOfMemoryError.getMessage(), "Out-Of-Memory Exception", 0);
            }
            catch (HeadlessException | IOException exception) {
                logger.log(Level.SEVERE, exception.getMessage(), exception);
                if (exception.getMessage() == null) break block4;
                JOptionPane.showMessageDialog(this, exception.getMessage(), APP_NAME, 0);
            }
        }
    }

    void readBoxFile(File file) {
        block22: {
            if (file.exists()) {
                try {
                    this.boxPages.clear();
                    try (String[] stringArray = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));){
                        this.jTextAreaBoxData.read((Reader)stringArray, null);
                    }
                    stringArray = this.jTextAreaBoxData.getText().split("\\n");
                    if (stringArray.length > 0) {
                        this.isTess2_0Format = stringArray[0].split("\\s+").length == 5;
                    }
                    int n = 0;
                    for (int i = 0; i < this.imageList.size(); ++i) {
                        TessBoxCollection tessBoxCollection = new TessBoxCollection();
                        int n2 = this.imageList.get(i).getHeight();
                        for (int j = n; j < stringArray.length; ++j) {
                            String[] stringArray = stringArray[j].split("\\s+");
                            if (stringArray.length < 5 || stringArray.length > 6) continue;
                            String string = stringArray[0];
                            int n3 = Integer.parseInt(stringArray[1]);
                            int n4 = Integer.parseInt(stringArray[2]);
                            int n5 = Integer.parseInt(stringArray[3]) - n3;
                            int n6 = Integer.parseInt(stringArray[4]) - n4;
                            n4 = n2 - n4 - n6;
                            short s = stringArray.length == 6 ? Short.parseShort(stringArray[5]) : (short)0;
                            if (s > i) {
                                n = j;
                                break;
                            }
                            tessBoxCollection.add(new TessBox(string, new Rectangle(n3, n4, n5, n6), s));
                        }
                        this.boxPages.add(tessBoxCollection);
                    }
                    this.loadTable();
                    this.updateSave(false);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    logger.log(Level.SEVERE, outOfMemoryError.getMessage(), outOfMemoryError);
                    JOptionPane.showMessageDialog(this, outOfMemoryError.getMessage(), "Out-Of-Memory Exception", 0);
                }
                catch (IOException | NumberFormatException exception) {
                    logger.log(Level.SEVERE, exception.getMessage(), exception);
                    if (exception.getMessage() != null) {
                        JOptionPane.showMessageDialog(this, exception.getMessage(), APP_NAME, 0);
                    }
                    break block22;
                }
            }
            this.tableModel.setDataVector((Object[][])null, (Object[])null);
            ((JImageLabel)this.jLabelImage).setBoxes(null);
            this.jTextAreaBoxData.setText(null);
        }
    }

    void loadTable() {
        if (!this.boxPages.isEmpty()) {
            this.boxes = this.boxPages.get(this.imageIndex);
            this.tableModel.setDataVector((Object[][])this.boxes.getTableDataList().toArray((T[])new String[0][5]), this.headers);
            ((JImageLabel)this.jLabelImage).setBoxes(this.boxes);
        }
    }

    protected boolean promptToDiscardChanges() {
        if (!this.boxChanged) {
            return false;
        }
        switch (JOptionPane.showConfirmDialog(this, this.bundle.getString("Do_you_want_to_discard_the_changes_to_") + this.boxFile.getName() + "?", APP_NAME, 1, 1)) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    protected boolean promptToSave() {
        if (!this.boxChanged) {
            return true;
        }
        switch (JOptionPane.showConfirmDialog(this, this.bundle.getString("Do_you_want_to_save_the_changes_to_") + (this.boxFile == null ? this.bundle.getString("Untitled") : this.boxFile.getName()) + "?", APP_NAME, 1, 1)) {
            case 0: {
                return this.saveAction();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    boolean saveAction() {
        if (this.boxFile == null || !this.boxFile.exists()) {
            return this.saveFileDlg();
        }
        return this.saveBoxFile();
    }

    boolean saveFileDlg() {
        JFileChooser jFileChooser = new JFileChooser(this.outputDirectory);
        SimpleFilter simpleFilter = new SimpleFilter("box", "Box Files");
        jFileChooser.addChoosableFileFilter(simpleFilter);
        jFileChooser.setFileFilter(simpleFilter);
        jFileChooser.setDialogTitle(this.bundle.getString("Save_As"));
        if (this.boxFile != null) {
            jFileChooser.setSelectedFile(this.boxFile);
        }
        if (jFileChooser.showSaveDialog(this) == 0) {
            this.outputDirectory = jFileChooser.getCurrentDirectory().getPath();
            File file = jFileChooser.getSelectedFile();
            if (jFileChooser.getFileFilter() == simpleFilter) {
                if (!file.getName().endsWith(".box")) {
                    file = new File(file.getPath() + ".box");
                }
                if (this.boxFile != null && this.boxFile.getPath().equals(file.getPath())) {
                    if (1 == JOptionPane.showConfirmDialog(this, this.boxFile.getName() + this.bundle.getString("file_already_exist"), this.bundle.getString("Confirm_Save_As"), 0, 2)) {
                        return false;
                    }
                } else {
                    this.boxFile = file;
                }
            } else {
                this.boxFile = file;
            }
            return this.saveBoxFile();
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    boolean saveBoxFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    String formatOutputString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (short s = 0; s < this.imageList.size(); s = (short)((short)(s + 1))) {
            int n = this.imageList.get(s).getHeight();
            for (TessBox tessBox : this.boxPages.get(s).toList()) {
                Rectangle rectangle = tessBox.getRect();
                stringBuilder.append(String.format("%s %d %d %d %d %d", tessBox.getChrs(), rectangle.x, n - rectangle.y - rectangle.height, rectangle.x + rectangle.width, n - rectangle.y, s)).append(EOL);
            }
        }
        if (this.isTess2_0Format) {
            return stringBuilder.toString().replace(" 0" + EOL, EOL);
        }
        return stringBuilder.toString();
    }

    protected void updateMRUList(String string) {
    }

    private void jMenuItemSaveActionPerformed(ActionEvent actionEvent) {
        this.saveAction();
    }

    private void jMenuItemExitActionPerformed(ActionEvent actionEvent) {
        this.quit();
    }

    void quit() {
        if (!this.promptToSave()) {
            return;
        }
        if (this.currentDirectory != null) {
            prefs.put("currentDirectory", this.currentDirectory);
        }
        if (this.outputDirectory != null) {
            prefs.put("outputDirectory", this.outputDirectory);
        }
        prefs.putInt("windowState", this.getExtendedState());
        if (this.getExtendedState() == 0) {
            prefs.putInt("frameHeight", this.getHeight());
            prefs.putInt("frameWidth", this.getWidth());
            prefs.putInt("frameX", this.getX());
            prefs.putInt("frameY", this.getY());
        }
        prefs.putInt("filterIndex", this.filterIndex);
        System.exit(0);
    }

    private void jMenuItemAboutActionPerformed(ActionEvent actionEvent) {
        this.about();
    }

    void about() {
        try {
            Properties properties = new Properties();
            properties.loadFromXML(this.getClass().getResourceAsStream("config.xml"));
            String string = properties.getProperty("Version");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
            Date date = simpleDateFormat.parse(properties.getProperty("ReleaseDate"));
            JOptionPane.showMessageDialog(this, "jTessBoxEditor " + string + " \u00a9 2011\n" + "Tesseract Box Editor & Trainer\n" + DateFormat.getDateInstance(1).format(date) + "\nhttp://vietocr.sourceforge.net", this.jMenuItemAbout.getText(), 1);
        }
        catch (HeadlessException | IOException | ParseException exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void jButtonPrevPageActionPerformed(ActionEvent actionEvent) {
        if (this.imageList != null && this.imageIndex > 0) {
            this.imageIndex = (short)(this.imageIndex - 1);
            this.loadImage();
            this.loadTable();
        }
    }

    private void jButtonNextPageActionPerformed(ActionEvent actionEvent) {
        if (this.imageList != null && this.imageIndex < this.imageList.size() - 1) {
            this.imageIndex = (short)(this.imageIndex + 1);
            this.loadImage();
            this.loadTable();
        }
    }

    void loadImage() {
        this.jLabelImage.setIcon(new ImageIcon(this.imageList.get(this.imageIndex)));
        if (this.boxes != null) {
            this.boxes.deselectAll();
        }
        this.jLabelImage.repaint();
        this.jLabelPageNbr.setText(String.format("Page: %d of %d", this.imageIndex + 1, this.imageList.size()));
        this.setButton();
        this.tableSelectAction = true;
        this.resetReadout();
        this.tableSelectAction = false;
    }

    void setButton() {
        if (this.imageIndex == 0) {
            this.jButtonPrevPage.setEnabled(false);
        } else {
            this.jButtonPrevPage.setEnabled(true);
        }
        if (this.imageIndex == this.imageList.size() - 1) {
            this.jButtonNextPage.setEnabled(false);
        } else {
            this.jButtonNextPage.setEnabled(true);
        }
    }

    void resetReadout() {
        this.jTextFieldCharacter.setText(null);
        this.jTextFieldChar.setText(null);
        this.jTextFieldCodepointValue.setText(null);
        this.jSpinnerH.setValue(0);
        this.jSpinnerW.setValue(0);
        this.jSpinnerX.setValue(0);
        this.jSpinnerY.setValue(0);
        this.jLabelSubimage.setIcon(null);
    }

    void enableReadout(boolean bl) {
        this.jTextFieldCharacter.setEnabled(bl);
        this.jSpinnerX.setEnabled(bl);
        this.jSpinnerY.setEnabled(bl);
        this.jSpinnerH.setEnabled(bl);
        this.jSpinnerW.setEnabled(bl);
    }

    void updateSave(boolean bl) {
        if (this.boxChanged != bl) {
            this.boxChanged = bl;
            this.jButtonSave.setEnabled(bl);
            this.jMenuItemSave.setEnabled(bl);
            this.rootPane.putClientProperty("windowModified", bl);
        }
    }

    private void jButtonOpenActionPerformed(ActionEvent actionEvent) {
        this.jMenuItemOpenActionPerformed(actionEvent);
    }

    private void jButtonSaveActionPerformed(ActionEvent actionEvent) {
        this.jMenuItemSaveActionPerformed(actionEvent);
    }

    private void jButtonReloadActionPerformed(ActionEvent actionEvent) {
        if (!this.promptToDiscardChanges()) {
            return;
        }
        if (this.boxFile != null) {
            this.jButtonReload.setEnabled(false);
            this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            this.getGlassPane().setVisible(true);
            SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    Gui.this.readBoxFile(Gui.this.boxFile);
                    return null;
                }

                @Override
                protected void done() {
                    Gui.this.jButtonReload.setEnabled(true);
                    Gui.this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    Gui.this.getGlassPane().setVisible(false);
                }
            };
            swingWorker.execute();
        }
    }

    void jMenuItemFontActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    private void jMenuItemHelpActionPerformed(ActionEvent actionEvent) {
        String string = this.bundle.getString("readme");
        if (MAC_OS_X) {
            try {
                File file = new File(System.getProperty("user.home") + "/Library/Application Support/" + APP_NAME);
                if (!file.exists()) {
                    file.mkdirs();
                }
                File file2 = new File(file, "readme.html");
                this.copyFileFromJarToSupportDir(file2);
                Runtime.getRuntime().exec(new String[]{"open", "-b", "com.apple.helpviewer", string}, null, file);
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        } else {
            if (this.helptopicsFrame == null) {
                this.helptopicsFrame = new JFrame(this.jMenuItemHelp.getText());
                this.helptopicsFrame.getContentPane().setLayout(new BorderLayout());
                HtmlPane htmlPane = new HtmlPane(string);
                this.helptopicsFrame.getContentPane().add((Component)htmlPane, "Center");
                this.helptopicsFrame.getContentPane().add((Component)htmlPane.getStatusBar(), "South");
                this.helptopicsFrame.pack();
                this.helptopicsFrame.setLocation((this.screen.width - this.helptopicsFrame.getWidth()) / 2, 40);
            }
            this.helptopicsFrame.setVisible(true);
        }
    }

    private void copyFileFromJarToSupportDir(File file) throws IOException {
        if (!file.exists()) {
            try (ReadableByteChannel readableByteChannel = Channels.newChannel(ClassLoader.getSystemResourceAsStream(file.getName()));
                 FileChannel fileChannel = new FileOutputStream(file).getChannel();){
                fileChannel.transferFrom(readableByteChannel, 0L, 1000000L);
            }
        }
    }

    private void jMenuItemSaveAsActionPerformed(ActionEvent actionEvent) {
        this.saveFileDlg();
    }

    private void jSpinnerXStateChanged(ChangeEvent changeEvent) {
        this.stateChanged(changeEvent);
    }

    private void jSpinnerYStateChanged(ChangeEvent changeEvent) {
        this.stateChanged(changeEvent);
    }

    private void jSpinnerWStateChanged(ChangeEvent changeEvent) {
        this.stateChanged(changeEvent);
    }

    private void jSpinnerHStateChanged(ChangeEvent changeEvent) {
        this.stateChanged(changeEvent);
    }

    void stateChanged(ChangeEvent changeEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    private void jTextFieldCharacterActionPerformed(ActionEvent actionEvent) {
        if (this.boxes == null) {
            return;
        }
        List<TessBox> list = this.boxes.getSelectedBoxes();
        if (list.size() <= 0) {
            return;
        }
        if (list.size() > 1) {
            JOptionPane.showMessageDialog(this, "Please select only one box to apply the change.");
            return;
        }
        TessBox tessBox = list.get(0);
        int n = this.boxes.toList().indexOf(tessBox);
        this.jTextFieldCharacter.setText(TextUtilities.convertNCR(this.jTextFieldCharacter.getText()));
        String string = this.jTextFieldCharacter.getText();
        if (!tessBox.getChrs().equals(string)) {
            tessBox.setChrs(string);
            this.tableModel.setValueAt(tessBox.getChrs(), n, 0);
            this.jTextFieldChar.setText(string);
            this.jTextFieldCodepointValue.setText(Utils.toHex(string));
            this.updateSave(true);
        }
    }

    private void jButtonConvertActionPerformed(ActionEvent actionEvent) {
        String string = this.jTextFieldCharacter.getText();
        if (string.trim().length() == 0) {
            return;
        }
        this.jTextFieldCharacter.setText(TextUtilities.convertNCR(this.jTextFieldCharacter.getText()));
        if (string.equals(this.jTextFieldCharacter.getText())) {
            this.jTextFieldCharacterActionPerformed(actionEvent);
        }
    }

    void jMenuItemMergeActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    void jMenuItemSplitActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    void jMenuItemDeleteActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    void jMenuItemInsertActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    private void jButtonMergeActionPerformed(ActionEvent actionEvent) {
        this.jMenuItemMergeActionPerformed(actionEvent);
    }

    private void jButtonDeleteActionPerformed(ActionEvent actionEvent) {
        this.jMenuItemDeleteActionPerformed(actionEvent);
    }

    private void jButtonSplitActionPerformed(ActionEvent actionEvent) {
        this.jMenuItemSplitActionPerformed(actionEvent);
    }

    private void jButtonInsertActionPerformed(ActionEvent actionEvent) {
        this.jMenuItemInsertActionPerformed(actionEvent);
    }

    private void jButtonFindActionPerformed(ActionEvent actionEvent) {
        if (this.imageList == null) {
            return;
        }
        int n = this.imageList.get(this.imageIndex).getHeight();
        String[] stringArray = this.jTextFieldFind.getText().split("\\s+");
        try {
            TessBox tessBox;
            if (stringArray.length == 1) {
                String string = stringArray[0];
                if (string.length() == 0) {
                    throw new Exception("Empty search values.");
                }
                string = TextUtilities.convertNCR(string);
                tessBox = new TessBox(string, new Rectangle(), this.imageIndex);
                tessBox = this.boxes.selectByChars(tessBox);
            } else {
                int n2 = Integer.parseInt(stringArray[0]);
                int n3 = Integer.parseInt(stringArray[1]);
                int n4 = Integer.parseInt(stringArray[2]) - n2;
                int n5 = Integer.parseInt(stringArray[3]) - n3;
                n3 = n - n3 - n5;
                tessBox = new TessBox("", new Rectangle(n2, n3, n4, n5), this.imageIndex);
                tessBox = this.boxes.select(tessBox);
            }
            if (tessBox != null) {
                int n6 = this.boxes.toList().indexOf(tessBox);
                this.jTable.setRowSelectionInterval(n6, n6);
                Rectangle rectangle = this.jTable.getCellRect(n6, 0, true);
                this.jTable.scrollRectToVisible(rectangle);
            } else {
                this.jTable.clearSelection();
                String string = String.format("No box with the specified %s was found.", stringArray.length == 1 ? "character(s)" : "coordinates");
                JOptionPane.showMessageDialog(this, string);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Please enter box character(s) or coordinates (x1 y1 x2 y2).");
        }
    }

    private void jTextFieldFindActionPerformed(ActionEvent actionEvent) {
        this.jButtonFindActionPerformed(actionEvent);
    }

    void jMenuItemMergeTiffActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    void jMenuItemSplitTiffActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    private void jButtonPrevActionPerformed(ActionEvent actionEvent) {
        int n = this.jTable.getSelectedRow();
        if (n > 0) {
            this.boxes.deselectAll();
            this.jTable.clearSelection();
            List<TessBox> list = this.boxes.toList();
            TessBox tessBox = list.get(--n);
            tessBox.setSelected(true);
            this.jTable.addRowSelectionInterval(n, n);
            Rectangle rectangle = this.jTable.getCellRect(n, 0, true);
            this.jTable.scrollRectToVisible(rectangle);
        }
    }

    private void jButtonNextActionPerformed(ActionEvent actionEvent) {
        if (this.boxes == null) {
            return;
        }
        List<TessBox> list = this.boxes.toList();
        int n = this.jTable.getSelectedRow();
        if (n < list.size() - 1) {
            this.boxes.deselectAll();
            this.jTable.clearSelection();
            TessBox tessBox = list.get(++n);
            tessBox.setSelected(true);
            this.jTable.addRowSelectionInterval(n, n);
            Rectangle rectangle = this.jTable.getCellRect(n, 0, true);
            this.jTable.scrollRectToVisible(rectangle);
        }
    }

    void jButtonInputActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    void jButtonFontActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    void jSpinnerTrackingStateChanged(ChangeEvent changeEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    void jButtonGenerateActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    void jButtonClearActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    void jButtonBrowseTessActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    void jButtonBrowseDataActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    void jButtonTrainActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    void jButtonCancelActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    private void jTabbedPaneMainStateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        boolean bl = jTabbedPane.getSelectedIndex() == 1;
        this.jMenuEdit.setVisible(bl);
        this.jMenuItemFont.setVisible(bl || jTabbedPane.getSelectedIndex() == 0);
        this.jSeparatorLAF.setVisible(this.jMenuItemFont.isVisible());
        this.jMenuItemOpen.setVisible(bl);
        this.jMenuItemSave.setVisible(bl);
        this.jMenuItemSaveAs.setVisible(bl);
        this.jMenuRecentFiles.setVisible(bl);
        this.jSeparatorRecentFiles.setVisible(bl);
        this.jSeparatorExit.setVisible(bl);
    }

    void jButtonClearLogActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    void jButtonSaveLogActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    void jButtonValidateActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    void jButtonCloseDialogActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    private void jSpinnerMarginStateChanged(ChangeEvent changeEvent) {
        iconMargin = (Integer)this.jSpinnerMargin.getValue();
        int n = this.jTable.getSelectedRow();
        this.jTable.clearSelection();
        this.jTable.setRowSelectionInterval(n, n);
        this.jLabelSubimage.requestFocus();
    }

    private void jSpinnerScaleStateChanged(ChangeEvent changeEvent) {
        scaleFactor = (Integer)this.jSpinnerScale.getValue();
        int n = this.jTable.getSelectedRow();
        this.jTable.clearSelection();
        this.jTable.setRowSelectionInterval(n, n);
        this.jLabelSubimage.requestFocus();
    }

    private void jTextFieldCharacterKeyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 10) {
            this.jLabelSubimage.requestFocus();
        }
    }

    void jButtonBrowseOutputDirActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, TO_BE_IMPLEMENTED);
    }

    BufferedImage getSubimage(BufferedImage bufferedImage, Rectangle rectangle) {
        iconPosX = rectangle.x;
        iconPosY = rectangle.y;
        imageWidth = bufferedImage.getWidth();
        imageHeight = bufferedImage.getHeight();
        iconHeight = rectangle.height;
        iconWidth = rectangle.width;
        int n = iconHeight + iconMargin * 2;
        int n2 = iconWidth + iconMargin * 2;
        while (n2 + iconPosX > bufferedImage.getWidth() + 1) {
            --n2;
        }
        while (n + iconPosY > bufferedImage.getHeight() + 1) {
            --n;
        }
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(Math.max(0, Math.min(imageWidth - 1, iconPosX - iconMargin)), Math.max(0, Math.min(imageHeight - 1, iconPosY - iconMargin)), n2, n);
        return bufferedImage2;
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Gui().setVisible(true);
            }
        });
    }
}

