/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import net.sourceforge.tessboxeditor.GuiWithGenerator;
import net.sourceforge.tessboxeditor.TessTrainer;
import net.sourceforge.tessboxeditor.TrainingMode;
import net.sourceforge.vietpad.components.SimpleFilter;

public class GuiWithTrainer
extends GuiWithGenerator {
    protected static final String DIALOG_TITLE = "Train Tesseract";
    protected String tessDirectory;
    protected String trainDataDirectory;
    private JFileChooser jFileChooserTrainingData;
    private JFileChooser jFileChooserTessExecutables;
    private TrainingWorker trainWorker;

    public GuiWithTrainer() {
        this.initComponents();
    }

    private void initComponents() {
        this.tessDirectory = prefs.get("tessDirectory", new File(System.getProperty("user.dir"), "tesseract-ocr").getPath());
        this.jTextFieldTessDir.setText(this.tessDirectory);
        this.jFileChooserTessExecutables = new JFileChooser();
        this.jFileChooserTessExecutables.setApproveButtonText("Set");
        this.jFileChooserTessExecutables.setDialogTitle("Set Location of Tesseract Executables");
        this.jFileChooserTessExecutables.setCurrentDirectory(this.tessDirectory == null ? null : new File(this.tessDirectory));
        this.trainDataDirectory = prefs.get("trainDataDirectory", new File(System.getProperty("user.dir"), "samples/vie").getPath());
        this.jTextFieldDataDir.setText(this.trainDataDirectory);
        this.jFileChooserTrainingData = new JFileChooser();
        this.jFileChooserTrainingData.setAcceptAllFileFilterUsed(false);
        this.jFileChooserTrainingData.setApproveButtonText("Set");
        this.jFileChooserTrainingData.setDialogTitle("Set Location of Source Training Data");
        SimpleFilter simpleFilter = new SimpleFilter("bmp;jpg;jpeg;png;tif;tiff;box;font_properties;frequent_words_list;words_list;unicharambigs", "Source Training Data");
        this.jFileChooserTrainingData.setFileFilter(simpleFilter);
        this.jFileChooserTrainingData.setCurrentDirectory(this.trainDataDirectory == null ? null : new File(this.trainDataDirectory));
        this.jTextFieldLang.setText(prefs.get("trainnedLanguage", null));
        this.jTextFieldBootstrapLang.setText(prefs.get("bootstrapLanguage", null));
        this.jComboBoxOps.setSelectedIndex(prefs.getInt("trainingMode", 0));
        this.jCheckBoxRTL.setSelected(prefs.getBoolean("trainingRTL", false));
    }

    @Override
    void jButtonBrowseTessActionPerformed(ActionEvent actionEvent) {
        if (this.jFileChooserTessExecutables.showOpenDialog(this) == 0) {
            this.tessDirectory = this.jFileChooserTessExecutables.getCurrentDirectory().getPath();
            this.jTextFieldTessDir.setText(this.tessDirectory);
        }
    }

    @Override
    void jButtonBrowseDataActionPerformed(ActionEvent actionEvent) {
        if (this.jFileChooserTrainingData.showOpenDialog(this) == 0) {
            this.trainDataDirectory = this.jFileChooserTrainingData.getCurrentDirectory().getPath();
            this.jTextFieldDataDir.setText(this.trainDataDirectory);
        }
    }

    @Override
    void jButtonTrainActionPerformed(ActionEvent actionEvent) {
        int n;
        String[] stringArray;
        String string = "";
        TrainingMode trainingMode = TrainingMode.getValueByDesc(this.jComboBoxOps.getSelectedItem().toString());
        if (this.jTextFieldTessDir.getText().length() == 0 || this.jTextFieldDataDir.getText().length() == 0) {
            string = "Input is not complete.";
        } else if (this.jTextFieldLang.getText().trim().length() == 0) {
            string = "Language is required.";
        } else if (trainingMode == TrainingMode.HeaderText) {
            string = "Please select a Training Mode.";
        }
        if (string.length() > 0) {
            JOptionPane.showMessageDialog(this, string);
            return;
        }
        if (trainingMode == TrainingMode.Train_with_Existing_Box || trainingMode == TrainingMode.Dictionary || trainingMode == TrainingMode.Train_from_Scratch) {
            stringArray = this.jTextFieldLang.getText();
            int n2 = n = new File(this.trainDataDirectory, (String)stringArray + ".font_properties").exists() && new File(this.trainDataDirectory, (String)stringArray + ".frequent_words_list").exists() && new File(this.trainDataDirectory, (String)stringArray + ".words_list").exists() ? 1 : 0;
            if (n == 0) {
                string = String.format("The required file %1$s.font_properties, %1$s.frequent_words_list, or %1$s.words_list does not exist.", new Object[]{stringArray});
                JOptionPane.showMessageDialog(this, string, DIALOG_TITLE, 0);
                return;
            }
        }
        stringArray = new File(this.trainDataDirectory).list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".box");
            }
        });
        if (trainingMode == TrainingMode.Make_Box_File_Only || trainingMode == TrainingMode.Train_from_Scratch) {
            if (stringArray.length > 0 && (n = JOptionPane.showConfirmDialog(this, "There are existing box files. Continuing may overwrite them.\nDo you want to proceed?", DIALOG_TITLE, 0, 1)) == 1) {
                return;
            }
        } else if (stringArray.length == 0) {
            JOptionPane.showMessageDialog(this, "There are no existing box files.", DIALOG_TITLE, 0);
            return;
        }
        this.jButtonTrain.setEnabled(false);
        this.jButtonCancel.setEnabled(true);
        this.jProgressBar1.setIndeterminate(true);
        this.jProgressBar1.setString("Training...");
        this.jProgressBar1.setVisible(true);
        this.jLabelTime.setText(null);
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.trainWorker = new TrainingWorker();
        this.trainWorker.execute();
    }

    @Override
    void jButtonCancelActionPerformed(ActionEvent actionEvent) {
        if (this.trainWorker != null && !this.trainWorker.isDone()) {
            this.trainWorker.cancel(true);
        }
        this.jButtonCancel.setEnabled(false);
    }

    @Override
    void jButtonSaveLogActionPerformed(ActionEvent actionEvent) {
        if (this.jTextAreaOutput.getDocument().getLength() == 0) {
            return;
        }
        try {
            File file = new File(this.trainDataDirectory, "training.log");
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
                this.jTextAreaOutput.write(bufferedWriter);
            }
            JOptionPane.showMessageDialog(this, String.format("Log has been saved as \"%s\".", file.getPath()), DIALOG_TITLE, 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    void jButtonClearLogActionPerformed(ActionEvent actionEvent) {
        this.jTextAreaOutput.setText(null);
    }

    @Override
    void quit() {
        if (this.tessDirectory != null) {
            prefs.put("tessDirectory", this.tessDirectory);
        }
        if (this.trainDataDirectory != null) {
            prefs.put("trainDataDirectory", this.trainDataDirectory);
        }
        prefs.put("trainnedLanguage", this.jTextFieldLang.getText());
        prefs.put("bootstrapLanguage", this.jTextFieldBootstrapLang.getText());
        prefs.putInt("trainingMode", this.jComboBoxOps.getSelectedIndex());
        prefs.putBoolean("trainingRTL", this.jCheckBoxRTL.isSelected());
        super.quit();
    }

    public static String getDisplayTime(long l) {
        String string = String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(l), TimeUnit.MILLISECONDS.toMinutes(l) % 60L, TimeUnit.MILLISECONDS.toSeconds(l) % 60L);
        return string;
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GuiWithTrainer().setVisible(true);
            }
        });
    }

    public class TrainingWorker
    extends SwingWorker<Void, Void> {
        TessTrainer trainer;
        long startTime;

        public TrainingWorker() {
            this.trainer = new TessTrainer(GuiWithTrainer.this.tessDirectory, GuiWithTrainer.this.trainDataDirectory, GuiWithTrainer.this.jTextFieldLang.getText(), GuiWithTrainer.this.jTextFieldBootstrapLang.getText(), GuiWithTrainer.this.jCheckBoxRTL.isSelected());
            this.trainer.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("value".equals(propertyChangeEvent.getPropertyName())) {
                        GuiWithTrainer.this.jTextAreaOutput.append(propertyChangeEvent.getNewValue().toString());
                        GuiWithTrainer.this.jTextAreaOutput.setCaretPosition(GuiWithTrainer.this.jTextAreaOutput.getDocument().getLength());
                    }
                }
            });
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.startTime = System.currentTimeMillis();
            this.trainer.generate(TrainingMode.getValueByDesc(GuiWithTrainer.this.jComboBoxOps.getSelectedItem().toString()));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            GuiWithTrainer.this.jProgressBar1.setIndeterminate(false);
            try {
                this.get();
                GuiWithTrainer.this.jProgressBar1.setString("Training completed.");
                long l = System.currentTimeMillis() - this.startTime;
                GuiWithTrainer.this.jLabelTime.setText("Elapsed time: " + GuiWithTrainer.getDisplayTime(l));
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                String string = throwable != null ? throwable.getMessage() : executionException.getMessage();
                if (string.trim().length() == 0) {
                    string = "An error has occurred. Input files could be missing.";
                }
                JOptionPane.showMessageDialog(GuiWithTrainer.this, string, GuiWithTrainer.DIALOG_TITLE, 0);
                GuiWithTrainer.this.jProgressBar1.setVisible(false);
                GuiWithTrainer.this.jProgressBar1.setString(null);
            }
            catch (CancellationException cancellationException) {
                GuiWithTrainer.this.jProgressBar1.setString("Training cancelled.");
                long l = System.currentTimeMillis() - this.startTime;
                GuiWithTrainer.this.jLabelTime.setText("Elapsed time: " + GuiWithTrainer.getDisplayTime(l));
            }
            finally {
                GuiWithTrainer.this.jButtonTrain.setEnabled(true);
                GuiWithTrainer.this.jButtonCancel.setEnabled(false);
                GuiWithTrainer.this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                GuiWithTrainer.this.getGlassPane().setVisible(false);
            }
        }
    }
}

