/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vietocr;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.vietocr.OCR;
import net.sourceforge.vietocr.StreamGobbler;
import net.sourceforge.vietocr.util.Utils;

public class OCRFiles
extends OCR<File> {
    private final String LANG_OPTION = "-l";
    private final String PSM_OPTION = "-psm";
    private final String tessPath;
    static final String OUTPUT_FILE_NAME = "TessOutput";
    static final String TEXTFILE_EXTENSION = ".txt";

    public OCRFiles(String string) {
        this.tessPath = string;
    }

    @Override
    public String recognizeText(List<File> list) throws Exception {
        File file = File.createTempFile(OUTPUT_FILE_NAME, TEXTFILE_EXTENSION);
        String string = Utils.stripExtension(file.getPath());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.tessPath + "/tesseract");
        arrayList.add("");
        arrayList.add(string);
        arrayList.add("-l");
        arrayList.add(this.getLanguage());
        arrayList.add("-psm");
        arrayList.add(this.getPageSegMode());
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        Map<String, String> map = processBuilder.environment();
        map.put("TESSDATA_PREFIX", this.getDatapath());
        processBuilder.directory(new File(this.tessPath));
        processBuilder.redirectErrorStream(true);
        StringBuilder stringBuilder = new StringBuilder();
        for (File file2 : list) {
            String string2;
            arrayList.set(1, file2.getPath());
            processBuilder.command(arrayList);
            Process process = processBuilder.start();
            StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream());
            streamGobbler.start();
            int n = process.waitFor();
            System.out.println("Exit value = " + n);
            if (n == 0) {
                string2 = Utils.readTextFile(file);
                stringBuilder.append(string2);
                continue;
            }
            file.delete();
            string2 = streamGobbler.getMessage();
            if (string2.trim().length() == 0) {
                string2 = "Errors occurred.";
            }
            throw new RuntimeException(string2);
        }
        file.delete();
        return stringBuilder.toString();
    }

    @Override
    public void processPages(File file, File file2) throws Exception {
    }
}

