/*
 * Decompiled with CFR 0.152.
 */
public class Buddy
extends User {
    public MListItem item;
    public String address;
    public int bloodType;
    public int nickNameReset;
    public int flag;
    public boolean subscribed;
    public String externalURI;
    public String rights;
    public int[] groups;
    public int messageCount;
    public String screenName;
    public byte smsStatus = 1;

    public Buddy() {
    }

    public Buddy(String string) {
        this.setUri(string);
    }

    public boolean isBlock() {
        return "BD".equals(this.rights);
    }

    public boolean isCancelService() {
        return (this.flag & 0x10) == 16;
    }

    public void setBlock(boolean bl) {
        this.rights = bl ? "BD" : "AA";
    }

    public String toString() {
        return this.uri;
    }

    public String getNickNameOrSid() {
        if (this.nickNameReset == 1) {
            return this.screenName;
        }
        return this.nickName != null && this.nickName.length() != 0 ? this.nickName : this.sid;
    }

    public String getNickNameDrawString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getNickNameOrSid());
        if (this.impresa != null && this.impresa.length() > 0) {
            stringBuffer.append('<').append(this.impresa).append('>');
        }
        return stringBuffer.toString();
    }

    public String getPresenceDrawString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isCancelService()) {
            stringBuffer.append('(').append("\u79bb\u7ebf").append(')');
        } else if (this.getStateDesc() != null) {
            stringBuffer.append('(').append(this.getStateDesc()).append(')');
        }
        return stringBuffer.toString();
    }

    public boolean isSMSOnline() {
        return this.smsStatus == 1;
    }

    public String getStateDesc() {
        try {
            int n = Integer.parseInt(this.activity);
            switch (n) {
                case 400: {
                    return "\u5728\u7ebf";
                }
                case 100: {
                    return "\u79bb\u5f00";
                }
                case 150: {
                    return "\u5916\u51fa\u5c31\u9910";
                }
                case 300: {
                    return "\u9a6c\u4e0a\u56de\u6765";
                }
                case 500: {
                    return "\u63a5\u542c\u7535\u8bdd";
                }
                case 600: {
                    return "\u5fd9\u788c";
                }
                case 0: {
                    if (this.isSMSOnline()) {
                        return "\u77ed\u4fe1\u5728\u7ebf";
                    }
                    return "\u79bb\u7ebf";
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

