/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MListItem {
    public static byte BUDDY_ITEM = 0;
    public static byte CHAT_SESSION_ITEM = 1;
    public byte type = BUDDY_ITEM;
    Buddy buddy;
    ChatSession chatSession;
    boolean selected;

    public MListItem(Buddy buddy) {
        this.type = BUDDY_ITEM;
        this.buddy = buddy;
        this.buddy.item = this;
    }

    public MListItem(ChatSession chatSession) {
        this.chatSession = chatSession;
        this.chatSession.item = this;
        this.type = CHAT_SESSION_ITEM;
    }

    public void paint(int n, int n2, Graphics graphics) {
        if (this.buddy != null) {
            this.paintBuddy(n, n2, graphics);
        } else {
            this.paintChatSession(n, n2, graphics);
        }
    }

    private void paintChatSession(int n, int n2, Graphics graphics) {
        graphics.setColor(0);
        if (this.chatSession.uris == null) {
            graphics.setColor(0x666666);
        } else if (this.chatSession.uris.size() == 1) {
            MCanvas.blt(MCanvas.img_BigIcon, Setting.BUDDY_ICON_SIZE * 4, 0, Setting.BUDDY_ICON_SIZE, Setting.BUDDY_ICON_SIZE, n, n2, graphics);
        } else {
            MCanvas.blt(MCanvas.img_BigIcon, Setting.BUDDY_ICON_SIZE * 5, 0, Setting.BUDDY_ICON_SIZE, Setting.BUDDY_ICON_SIZE, n, n2, graphics);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.chatSession.unReadMessageCount > 0) {
            graphics.setColor(0xFF0000);
            stringBuffer.append('[');
            stringBuffer.append(this.chatSession.unReadMessageCount);
            stringBuffer.append("\u65b0\u6d88\u606f");
            stringBuffer.append(']');
        }
        if (this.selected) {
            graphics.setColor(0xFFFFFF);
        }
        stringBuffer.append(this.chatSession.getTitle());
        int n3 = Setting.WIDTH - Setting.BUDDY_ICON_SIZE - 2;
        graphics.drawString(this.adjustDrawString(stringBuffer.toString(), n3), n + Setting.BUDDY_ICON_SIZE + 1, n2 + 0, 20);
    }

    private String adjustDrawString(String string, int n) {
        int n2 = MMIDlet.DEFAULT_FONT.stringWidth(string);
        if (n2 > n) {
            int n3 = MMIDlet.DEFAULT_FONT.stringWidth("...");
            int n4 = string.length();
            while (n2 > n) {
                n2 = n3 + MMIDlet.DEFAULT_FONT.stringWidth(string.substring(0, --n4));
            }
            return string.substring(0, n4) + "...";
        }
        return string;
    }

    private void paintBuddy(int n, int n2, Graphics graphics) {
        if (this.buddy.isOnline()) {
            MCanvas.blt(MCanvas.img_BigIcon, 0, 0, Setting.BUDDY_ICON_SIZE, Setting.BUDDY_ICON_SIZE, n, n2, graphics);
            graphics.setColor(0);
            if (!this.buddy.isActive()) {
                if (this.buddy.isBusy()) {
                    MCanvas.blt(MCanvas.img_BigIcon, Setting.BUDDY_ICON_SIZE * 11, 0, Setting.BUDDY_ICON_SIZE, Setting.BUDDY_ICON_SIZE, n, n2, graphics);
                } else {
                    MCanvas.blt(MCanvas.img_BigIcon, Setting.BUDDY_ICON_SIZE * 12, 0, Setting.BUDDY_ICON_SIZE, Setting.BUDDY_ICON_SIZE, n, n2, graphics);
                }
            }
        } else if (this.buddy.isSMSOnline()) {
            MCanvas.blt(MCanvas.img_BigIcon, 0, 0, Setting.BUDDY_ICON_SIZE, Setting.BUDDY_ICON_SIZE, n, n2, graphics);
            graphics.setColor(0xFFBB00);
        } else {
            MCanvas.blt(MCanvas.img_BigIcon, Setting.BUDDY_ICON_SIZE, 0, Setting.BUDDY_ICON_SIZE, Setting.BUDDY_ICON_SIZE, n, n2, graphics);
            graphics.setColor(0x666666);
        }
        if (this.buddy.isCancelService()) {
            graphics.setColor(0x666666);
        }
        if (this.selected) {
            graphics.setColor(0xFFFFFF);
        }
        int n3 = Setting.WIDTH - Setting.BUDDY_ICON_SIZE - MMIDlet.DEFAULT_FONT.stringWidth(this.buddy.getPresenceDrawString()) - 2;
        graphics.drawString(this.adjustDrawString(this.buddy.getNickNameDrawString(), n3), n + Setting.BUDDY_ICON_SIZE + 1, n2 + 0, 20);
        graphics.drawString(this.buddy.getPresenceDrawString(), Setting.WIDTH - 2, n2 + 0, 24);
        if (this.buddy.isBlock()) {
            MCanvas.blt(MCanvas.img_BigIcon, Setting.BUDDY_ICON_SIZE * 7, 0, Setting.BUDDY_ICON_SIZE, Setting.BUDDY_ICON_SIZE, n, n2, graphics);
        }
    }

    public Object getObject() {
        if (this.type == BUDDY_ITEM) {
            return this.buddy;
        }
        return this.chatSession;
    }
}

