/*
 * Decompiled with CFR 0.152.
 */
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Transform {
    public static final int RETRY_TIME = 4;
    public static int uploadLength = 0;
    public static int downloadLength = 0;
    public static Transform instance = new Transform();
    public Sender sender;
    public static final byte DEFAULT_POLL_INTERVAL = 5;
    private byte poll_Interval = (byte)5;
    private boolean isFirstLoginPoll = true;
    private static String buddyListVersion = "0";
    static int loginErrorCounter = 0;

    public void setPollInterVal(byte by) {
        this.poll_Interval = by;
        this.autoPolling(true);
    }

    private Transform() {
        this.sender = new Sender(this);
    }

    void on_NetworkError(DataPackage dataPackage) {
        MMIDlet.instance.on_NetworkError(dataPackage);
    }

    public void receive(DataPackage dataPackage) {
        byte by = dataPackage.type;
        switch (by) {
            default: {
                break;
            }
            case 6: {
                if (this.isFirstLoginPoll) {
                    dataPackage.delayTime = 3;
                    this.isFirstLoginPoll = false;
                } else {
                    dataPackage.delayTime = 0;
                }
                this.sender.sendDataPackage(dataPackage);
                break;
            }
            case 3: {
                this.on_OpenService(dataPackage.getData());
                break;
            }
            case -2: {
                this.on_Error(dataPackage.getData());
                break;
            }
            case 2: {
                this.on_Navigation(dataPackage.getData());
                break;
            }
            case 4: {
                MMIDlet.instance.on_SetUserInf();
                break;
            }
            case 5: {
                this.isFirstLoginPoll = true;
                this.on_Login(dataPackage.getData());
                break;
            }
            case 8: 
            case 10: {
                this.on_NewMessage(dataPackage.getData());
                break;
            }
            case 9: {
                this.on_NewMessages(dataPackage.getData());
                break;
            }
            case 11: {
                this.on_ByeChatSession(dataPackage.getData());
                break;
            }
            case 7: {
                MMIDlet.instance.on_Logout();
                break;
            }
            case 12: {
                this.on_BuddyListUpdate(dataPackage.getData());
                break;
            }
            case 13: {
                MMIDlet.instance.on_CancelService();
                break;
            }
            case 14: {
                this.on_SetUserPresence(dataPackage.getData());
                break;
            }
            case 15: {
                this.on_GetUserInf(dataPackage.getData());
                break;
            }
            case 16: {
                this.on_ServiceInit(dataPackage.getData());
                break;
            }
            case 17: {
                this.on_ServiceFinish(dataPackage.getData());
                break;
            }
            case 20: {
                this.on_SetClientConfig(dataPackage.getData());
                break;
            }
            case 1: {
                this.on_InitRequest(dataPackage.getData());
            }
        }
    }

    private void on_InitRequest(byte[] byArray) {
        MMIDlet.instance.on_InitRequest(byArray);
    }

    private void on_SetClientConfig(byte[] byArray) {
        MMIDlet.instance.on_SetClientConfig(this.byte2String(byArray));
    }

    private void on_ServiceFinish(byte[] byArray) {
        boolean bl = false;
        String string = this.byte2String(byArray);
        Vector vector = StringParser.split(string, '\u0002');
        MMIDlet.instance.on_ServiceFinish(vector);
    }

    private void on_ServiceInit(byte[] byArray) {
        MMIDlet.instance.on_ServiceInit(Integer.parseInt(this.byte2String(byArray)));
    }

    private void on_GetUserInf(byte[] byArray) {
        String string = this.byte2String(byArray);
        Vector vector = StringParser.split(string, '\u0002');
        MMIDlet.instance.on_GetUserInf(vector);
    }

    private void on_SetUserPresence(byte[] byArray) {
        String string = this.byte2String(byArray);
        int n = string.indexOf(2);
        MMIDlet.instance.on_SetUserPresence(string.substring(0, n), string.substring(n + 1));
    }

    public DataPackage getPollPackage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(buddyListVersion);
        stringBuffer.append(MMIDlet.instance.getCurrentServiceID());
        DataPackage dataPackage = Transform.makeDataPackage((byte)0, stringBuffer.toString());
        dataPackage.delayTime = this.poll_Interval;
        return dataPackage;
    }

    private void on_BuddyListUpdate(byte[] byArray) {
        Vector vector = StringParser.split(this.byte2String(byArray), '\u0001');
        Vector vector2 = StringParser.split(String.valueOf(vector.elementAt(0)), '\u0002');
        Vector vector3 = StringParser.split(String.valueOf(vector.elementAt(1)), '\u0002');
        buddyListVersion = vector.lastElement().toString();
        MMIDlet.instance.on_BuddyListUpdate(vector2, vector3);
    }

    private void on_ByeChatSession(byte[] byArray) {
        Vector vector = StringParser.split(this.byte2String(byArray), '\u0002');
        MMIDlet.instance.on_ByeChatSession(vector);
    }

    private void on_NewMessages(byte[] byArray) {
        Vector vector = StringParser.split(this.byte2String(byArray), '\u0001');
        int n = vector.size();
        try {
            for (int i = n - 1; i >= 0; --i) {
                this.on_NewMessage(vector.elementAt(i).toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void on_NewMessage(String string) {
        Vector vector = StringParser.split(string, '\u0002');
        int n = vector.size() - 2;
        String string2 = String.valueOf(vector.elementAt(0));
        Vector<String> vector2 = StringParser.split(vector.elementAt(1).toString(), '\u0003');
        Vector<ChatMessage> vector3 = new Vector<ChatMessage>(n);
        if (n == 1) {
            ChatMessage chatMessage;
            Vector vector4 = StringParser.split(vector.elementAt(2).toString(), '\u0003');
            if (vector4 != null && (chatMessage = this.newChatMessage(vector4)) != null) {
                vector3.addElement(chatMessage);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                ChatMessage chatMessage = this.newChatMessage(StringParser.split(vector.elementAt(2 + i).toString(), '\u0003'));
                if (chatMessage == null) continue;
                vector3.addElement(chatMessage);
            }
        }
        if (string2 == null || string2.trim().length() == 0) {
            string2 = null;
        }
        if (vector2 == null) {
            vector2 = new Vector<String>(1);
            if (vector3.size() != 0) {
                vector2.addElement(((ChatMessage)((Object)vector3.elementAt((int)0))).from);
            }
        }
        MMIDlet.instance.on_NewMessage(string2, vector2, vector3.size() != 0 ? vector3 : null);
    }

    private void on_NewMessage(byte[] byArray) {
        this.on_NewMessage(this.byte2String(byArray));
    }

    ChatMessage newChatMessage(Vector vector) {
        byte by = Byte.parseByte(vector.elementAt(3).toString().trim());
        switch (by) {
            case 1: 
            case 7: 
            case 9: 
            case 10: {
                return null;
            }
        }
        ChatMessage chatMessage = new ChatMessage(vector.elementAt(0).toString(), vector.elementAt(2).toString(), by, vector.elementAt(4).toString());
        return chatMessage;
    }

    private void on_Login(byte[] byArray) {
        Vector vector = StringParser.split(this.byte2String(byArray), '\u0001');
        buddyListVersion = "0";
        try {
            MMIDlet.instance.on_Login(vector);
            loginErrorCounter = 0;
        }
        catch (Exception exception) {
            if (++loginErrorCounter == 6) {
                MMIDlet.instance.on_Error("1000");
                return;
            }
            this.sender.sendLastDataPackage();
        }
    }

    private void on_Navigation(byte[] byArray) {
        Vector vector = StringParser.split(this.byte2String(byArray), '\u0001');
        MMIDlet.instance.on_Navigation(vector);
    }

    String byte2String(byte[] byArray) {
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static DataPackage makeDataPackage(byte by, String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            int n = byArray.length + 4;
            byte[] byArray2 = new byte[n];
            byArray2[0] = (byte)(n >> 16);
            byArray2[1] = (byte)(n >> 8);
            byArray2[2] = (byte)n;
            byArray2[3] = by;
            System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
            return new DataPackage(byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private void on_Error(byte[] byArray) {
        MMIDlet.instance.on_Error(this.byte2String(byArray));
    }

    private void on_OpenService(byte[] byArray) {
        MMIDlet.instance.on_OpenService(this.byte2String(byArray));
    }

    public void openService() {
        DataPackage dataPackage = new DataPackage(new byte[]{0, 0, 4, 3});
        this.sender.sendDataPackage(dataPackage);
    }

    public void setUserInf(User user) {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(user.nickName).append('\u0002').append(user.getGender(true)).append('\u0002').append(user.birthDate);
        this.sender.sendDataPackage(Transform.makeDataPackage((byte)4, stringBuffer.toString()));
    }

    public void navigationRequest() {
        StringBuffer stringBuffer = new StringBuffer(MMIDlet.str_ClientVersion.length() + 10);
        stringBuffer.append(MMIDlet.str_ClientVersion);
        stringBuffer.append('\u0002');
        stringBuffer.append(MMIDlet.user.sid);
        this.sender.sendDataPackage(Transform.makeDataPackage((byte)2, stringBuffer.toString()));
    }

    public void login(User user) {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(user.availability).append('\u0003').append(user.activity).append('\u0003').append(user.uri);
        this.sender.sendDataPackage(Transform.makeDataPackage((byte)5, stringBuffer.toString()));
    }

    public void sendChatMessage(String string, ChatSession chatSession) {
        if (chatSession == null) {
            return;
        }
        String string2 = chatSession.getSessionName();
        String string3 = chatSession.uris.elementAt(0).toString();
        StringBuffer stringBuffer = new StringBuffer(30);
        if (string2 == null || string2.length() == 0) {
            stringBuffer.append(string).append('\u0002').append('\u0002').append(string3);
        } else if (chatSession.uris.size() == 1) {
            stringBuffer.append(string).append('\u0002').append(string2).append('\u0002').append(string3);
        } else {
            stringBuffer.append(string).append('\u0002').append(string2).append('\u0002');
        }
        this.sender.sendDataPackage(Transform.makeDataPackage((byte)8, stringBuffer.toString()));
    }

    public void byeChatSession(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = stringArray.length - 1; i >= 0; --i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append('\u0002');
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        this.sender.sendDataPackage(Transform.makeDataPackage((byte)11, stringBuffer.toString()));
    }

    public void logout() {
        this.sender.sendDataPackage(new DataPackage(new byte[]{0, 0, 4, 7}));
    }

    public void autoPolling(boolean bl) {
        this.sender.autoPolling(bl);
    }

    public boolean isAutoPolling() {
        return this.sender.isAutoPolling();
    }

    public void manualPolling() {
        if (this.sender.isQueueEmpty()) {
            this.sender.sendDataPackage(this.getPollPackage());
        }
    }

    public void cancelService() {
        this.sender.sendDataPackage(new DataPackage(new byte[]{0, 0, 4, 13}));
    }

    public void inviteMorePerson(ChatSession chatSession, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(chatSession.getSessionName());
        stringBuffer.append('\u0002');
        for (int i = stringArray.length - 1; i >= 0; --i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append('\u0002');
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        this.sender.sendDataPackage(Transform.makeDataPackage((byte)10, stringBuffer.toString()));
    }

    public void setUserPresence(String string, String string2) {
        this.sender.sendDataPackage(Transform.makeDataPackage((byte)14, string + '\u0002' + string2));
    }

    public void getUserInfByUri(String string) {
        this.sender.sendDataPackage(Transform.makeDataPackage((byte)15, "U\u0002" + string));
    }

    public void initServiceAction(String string) {
        this.sender.sendDataPackage(Transform.makeDataPackage((byte)16, string));
    }

    public void getUserInfByCellphone(String string) {
        this.sender.sendDataPackage(Transform.makeDataPackage((byte)15, "M\u0002" + string));
    }

    public void getUserInfBySid(String string) {
        this.sender.sendDataPackage(Transform.makeDataPackage((byte)15, "S\u0002" + string));
    }

    public void setClientConfig(String string) {
        this.sender.sendDataPackage(Transform.makeDataPackage((byte)20, string));
    }

    public void initRequest() {
        this.sender.sendDataPackage(Transform.makeDataPackage((byte)1, MMIDlet.str_ClientVersion.toString()));
    }

    public void killNetWorkThread() {
        this.sender.abort();
    }
}

