/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScrCanvas
extends Canvas {
    private Ripple midlet;
    private int AppStatus = 1;
    private Timer timer;
    private int ScrWidth;
    private int ScrHeight;
    private int picSize;
    private int[] BackPic;
    private int[] ShowPic;
    private short[] buf1;
    private short[] buf2;
    private boolean ScrClean = false;
    private boolean stoneAuto = false;
    private Random rand;
    private String exitStr = "exit";
    private int exitLeft = 500;
    private int exitTop = 500;

    public ScrCanvas(Ripple midlet) {
        Image pic;
        this.midlet = midlet;
        this.setFullScreenMode(true);
        this.ScrWidth = this.getWidth();
        this.ScrHeight = this.getHeight();
        this.picSize = this.ScrWidth * this.ScrHeight;
        try {
            pic = Image.createImage((String)"/default.png");
        }
        catch (IOException e) {
            System.out.println("File not found");
            this.midlet.quit();
            return;
        }
        this.BackPic = new int[this.picSize];
        this.ShowPic = new int[this.picSize];
        pic.getRGB(this.BackPic, 0, this.ScrWidth, 0, 0, this.ScrWidth, this.ScrHeight);
        int i = 0;
        while (i < this.picSize) {
            this.ShowPic[i] = this.BackPic[i];
            ++i;
        }
        this.buf1 = new short[this.picSize];
        this.buf2 = new short[this.picSize];
        this.clean();
        this.rand = new Random();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new ScrTimer(this), 1000L, 100L);
    }

    public void setAppStatus(int st) {
        this.ScrClean = false;
        this.AppStatus = st;
    }

    private void clean() {
        int i = 0;
        while (i < this.picSize) {
            this.buf1[i] = 0;
            this.buf2[i] = 0;
            ++i;
        }
    }

    public void onTimer() {
        if (this.AppStatus == 1) {
            if (!this.ScrClean) {
                this.ScrClean = true;
                this.clean();
                this.repaint();
            }
            return;
        }
        if (this.AppStatus == 0) {
            if (this.stoneAuto) {
                int x = this.rand.nextInt() % this.ScrWidth;
                int y = this.rand.nextInt() % this.ScrHeight;
                this.stone(x, y, 3, 128);
            }
            this.spread();
            this.repaint();
        }
    }

    private void spread() {
        int i = this.ScrWidth;
        while (i < this.picSize - this.ScrWidth) {
            this.buf2[i] = (short)((this.buf1[i - 1] + this.buf1[i + 1] + this.buf1[i - this.ScrWidth] + this.buf1[i + this.ScrWidth] >> 2) - this.buf2[i]);
            int n = i;
            this.buf2[n] = (short)(this.buf2[n] - (this.buf2[i] >> 5));
            ++i;
        }
        short[] tmp = this.buf1;
        this.buf1 = this.buf2;
        this.buf2 = tmp;
    }

    protected void paint(Graphics g) {
        int k = this.ScrWidth;
        int i = 1;
        while (i < this.ScrHeight - 1) {
            int j = 0;
            while (j < this.ScrWidth) {
                int xoff = j + this.buf1[k - 1] - this.buf1[k + 1];
                int yoff = i + this.buf1[k - this.ScrWidth] - this.buf1[k + this.ScrWidth];
                if (yoff >= 0 && yoff < this.ScrHeight && xoff >= 0 && xoff < this.ScrWidth) {
                    this.ShowPic[k] = this.BackPic[yoff * this.ScrWidth + xoff];
                }
                ++j;
                ++k;
            }
            ++i;
        }
        g.drawRGB(this.ShowPic, 0, this.ScrWidth, 0, 0, this.ScrWidth, this.ScrHeight, false);
        if (this.exitLeft > this.ScrWidth) {
            Font font = g.getFont();
            this.exitLeft = this.ScrWidth - font.stringWidth(this.exitStr);
            this.exitTop = this.ScrHeight - font.getHeight();
        }
        g.setColor(0);
        g.drawString(this.exitStr, this.exitLeft + 1, this.exitTop + 1, 0);
        g.setColor(255);
        g.drawString(this.exitStr, this.exitLeft, this.exitTop, 0);
    }

    private void stone(int x, int y, int radius, int power) {
        if (x + radius > this.ScrWidth || y + radius > this.ScrHeight || x - radius < 0 || y - radius < 0) {
            return;
        }
        int posx = x - radius;
        while (posx < x + radius) {
            int posy = y - radius;
            while (posy < y + radius) {
                if ((posx - x) * (posx - x) + (posy - y) * (posy - y) < radius * radius) {
                    this.buf1[this.ScrWidth * posy + posx] = (short)(-power);
                }
                ++posy;
            }
            ++posx;
        }
    }

    protected void pointerPressed(int x, int y) {
        if (x >= this.exitLeft && y >= this.exitTop) {
            this.midlet.quit();
        } else {
            this.stone(x, y, 3, 128);
        }
    }

    protected void pointerDragged(int x, int y) {
        this.stone(x, y, 3, 128);
    }

    protected void keyPressed(int keyCode) {
        int k = this.getGameAction(keyCode);
        switch (k) {
            case 8: {
                this.stoneAuto = !this.stoneAuto;
                break;
            }
            default: {
                this.clean();
            }
        }
    }
}

