/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.color_game;

import com.siemens.mp.color_game.Layer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import multime.MultiME;

public class TiledLayer
extends Layer {
    int cellHeight;
    int cellWidth;
    int rows;
    int columns;
    int[][] cellMatrix;
    Image sourceImage;
    private int numberOfTiles;
    int[] tileSetX;
    int[] tileSetY;
    private int[] anim_to_static;
    private int numOfAnimTiles;

    public TiledLayer(int n, int n2, Image image, int n3, int n4) {
        super(n >= 1 && n3 >= 1 ? n * n3 : -1, n2 >= 1 && n4 >= 1 ? n2 * n4 : -1);
        if (image.getWidth() % n3 != 0 || image.getHeight() % n4 != 0) {
            throw new IllegalArgumentException();
        }
        this.columns = n;
        this.rows = n2;
        this.cellMatrix = new int[n2][n];
        int n5 = image.getWidth() / n3 * (image.getHeight() / n4);
        this.createStaticSet(image, n5 + 1, n3, n4, true);
    }

    public int createAnimatedTile(int n) {
        if (this.anim_to_static == null) {
            this.anim_to_static = new int[4];
            this.numOfAnimTiles = 1;
        } else if (this.numOfAnimTiles == this.anim_to_static.length) {
            int[] nArray = new int[this.anim_to_static.length * 2];
            System.arraycopy(this.anim_to_static, 0, nArray, 0, this.anim_to_static.length);
            this.anim_to_static = nArray;
        }
        this.anim_to_static[this.numOfAnimTiles] = n;
        ++this.numOfAnimTiles;
        return -(this.numOfAnimTiles - 1);
    }

    public void setAnimatedTile(int n, int n2) {
        n = -n;
        this.anim_to_static[n] = n2;
    }

    public int getAnimatedTile(int n) {
        n = -n;
        return this.anim_to_static[n];
    }

    public void setCell(int n, int n2, int n3) {
        this.cellMatrix[n2][n] = n3;
    }

    public int getCell(int n, int n2) {
        return this.cellMatrix[n2][n];
    }

    public void fillCells(int n, int n2, int n3, int n4, int n5) {
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            for (int i3 = n; i3 < n + n3; ++i3) {
                this.cellMatrix[i2][i3] = n5;
            }
        }
    }

    public final int getCellWidth() {
        return this.cellWidth;
    }

    public final int getCellHeight() {
        return this.cellHeight;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final int getRows() {
        return this.rows;
    }

    public void setStaticTileSet(Image image, int n, int n2) {
        if (n < 1 || n2 < 1 || image.getWidth() % n != 0 || image.getHeight() % n2 != 0) {
            throw new IllegalArgumentException();
        }
        this.width = this.columns * n;
        this.height = this.rows * n2;
        int n3 = image.getWidth() / n * (image.getHeight() / n2);
        if (n3 >= this.numberOfTiles - 1) {
            this.createStaticSet(image, n3 + 1, n, n2, true);
        } else {
            this.createStaticSet(image, n3 + 1, n, n2, false);
        }
    }

    public final void paint(Graphics graphics) {
        if (this.visible) {
            int n = 0;
            int n2 = graphics.getClipX();
            int n3 = graphics.getClipY();
            int n4 = graphics.getClipWidth();
            int n5 = graphics.getClipHeight();
            int n6 = this.y;
            int n7 = 0;
            while (n7 < this.cellMatrix.length) {
                int n8 = this.x;
                int n9 = this.cellMatrix[n7].length;
                int n10 = 0;
                while (n10 < n9) {
                    n = this.cellMatrix[n7][n10];
                    if (n != 0) {
                        if (n < 0) {
                            n = this.getAnimatedTile(n);
                        }
                        if (n8 + this.cellWidth >= n2 && n6 + this.cellHeight >= n3 && n8 <= n2 + n4 && n6 <= n3 + n5) {
                            graphics.setClip(n8, n6, this.cellWidth, this.cellHeight);
                            graphics.drawImage(this.sourceImage, n8 - this.tileSetX[n], n6 - this.tileSetY[n], 20);
                        }
                    }
                    ++n10;
                    n8 += this.cellWidth;
                }
                ++n7;
                n6 += this.cellHeight;
            }
            graphics.setClip(n2, n3, n4, n5);
        }
    }

    private void createStaticSet(Image image, int n, int n2, int n3, boolean bl) {
        int n4;
        this.cellWidth = n2;
        this.cellHeight = n3;
        int n5 = image.getWidth();
        int n6 = image.getHeight();
        this.sourceImage = image;
        this.numberOfTiles = n;
        this.tileSetX = new int[this.numberOfTiles];
        this.tileSetY = new int[this.numberOfTiles];
        if (!bl) {
            this.rows = 0;
            while (this.rows < this.cellMatrix.length) {
                n4 = this.cellMatrix[this.rows].length;
                this.columns = 0;
                while (this.columns < n4) {
                    this.cellMatrix[this.rows][this.columns] = 0;
                    ++this.columns;
                }
                ++this.rows;
            }
            this.anim_to_static = null;
        }
        n4 = 1;
        for (int i2 = 0; i2 < n6; i2 += n3) {
            for (int i3 = 0; i3 < n5; i3 += n2) {
                this.tileSetX[n4] = i3;
                this.tileSetY[n4] = i2;
                ++n4;
            }
        }
    }

    static {
        MultiME.classLoaded("com.siemens.mp.color_game.TiledLayer");
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("com.siemens.mp.color_game.TiledLayer");
    }

    public static void staticSuperCleaningRoutine() {
    }
}

