/*
 * Decompiled with CFR 0.152.
 */
package Calc4M;

import Calc4M.Settings;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CalcButton {
    private static Font largeFont = Font.getFont((int)0, (int)1, (int)16);
    public static final int COLOR_BUTTON = 0xB0B0FF;
    public static final int COLOR_BUTTON_PRESSED = 0xE0E0FF;
    public static final int COLOR_BUTTON_BORDER = 0x505050;
    public static final int COLOR_BUTTON_TEXT = 0xE0E0FF;
    public static final int COLOR_BUTTON_TEXT_PRESSED = 0xD0D0FF;
    public static final int COLOR_BUTTON_ALT_TEXT = 0;
    public static final int BUTTON_0 = 0;
    public static final int BUTTON_1 = 1;
    public static final int BUTTON_2 = 2;
    public static final int BUTTON_3 = 3;
    public static final int BUTTON_4 = 4;
    public static final int BUTTON_5 = 5;
    public static final int BUTTON_6 = 6;
    public static final int BUTTON_7 = 7;
    public static final int BUTTON_8 = 8;
    public static final int BUTTON_9 = 9;
    public static final int BUTTON_STAR = 10;
    public static final int BUTTON_POUND = 11;
    public static final int BUTTON_C = 12;
    public static final int BUTTON_BACK = 13;
    public static final int BUTTON_LEFT = 14;
    public static final int BUTTON_UP = 15;
    public static final int BUTTON_RIGHT = 16;
    public static final int BUTTON_DOWN = 17;
    public static final int BUTTON_FIRE = 18;
    public static final int BUTTON_SOFT_LEFT = 19;
    public static final int BUTTON_SOFT_RIGHT = 20;
    public static final int BUTTON_SEND = 21;
    public static final int FUNCTION_none = 0;
    public static final int FUNCTION_0 = 1;
    public static final int FUNCTION_1 = 2;
    public static final int FUNCTION_2 = 3;
    public static final int FUNCTION_3 = 4;
    public static final int FUNCTION_4 = 5;
    public static final int FUNCTION_5 = 6;
    public static final int FUNCTION_6 = 7;
    public static final int FUNCTION_7 = 8;
    public static final int FUNCTION_8 = 9;
    public static final int FUNCTION_9 = 10;
    public static final int FUNCTION_decimal = 11;
    public static final int FUNCTION_equals = 12;
    public static final int FUNCTION_sqrt = 13;
    public static final int FUNCTION_sqr = 14;
    public static final int FUNCTION_plus = 15;
    public static final int FUNCTION_pow = 16;
    public static final int FUNCTION_inv = 17;
    public static final int FUNCTION_minus = 18;
    public static final int FUNCTION_leftbracket = 19;
    public static final int FUNCTION_rightbracket = 20;
    public static final int FUNCTION_times = 21;
    public static final int FUNCTION_exp = 22;
    public static final int FUNCTION_plusminus = 23;
    public static final int FUNCTION_div = 24;
    public static final int FUNCTION_sin = 25;
    public static final int FUNCTION_asin = 26;
    public static final int FUNCTION_cos = 27;
    public static final int FUNCTION_acos = 28;
    public static final int FUNCTION_tan = 29;
    public static final int FUNCTION_atan = 30;
    public static final int FUNCTION_sinh = 31;
    public static final int FUNCTION_asinh = 32;
    public static final int FUNCTION_cosh = 33;
    public static final int FUNCTION_acosh = 34;
    public static final int FUNCTION_tanh = 35;
    public static final int FUNCTION_atanh = 36;
    public static final int FUNCTION_drg = 37;
    public static final int FUNCTION_pi = 38;
    public static final int FUNCTION_fac = 39;
    public static final int FUNCTION_e_pow = 40;
    public static final int FUNCTION_ln = 41;
    public static final int FUNCTION_e = 42;
    public static final int FUNCTION_10_pow = 43;
    public static final int FUNCTION_log = 44;
    public static final int FUNCTION_m1r = 45;
    public static final int FUNCTION_m1s = 46;
    public static final int FUNCTION_m1p = 47;
    public static final int FUNCTION_m1c = 48;
    public static final int FUNCTION_m2r = 49;
    public static final int FUNCTION_m2s = 50;
    public static final int FUNCTION_m2p = 51;
    public static final int FUNCTION_m2c = 52;
    public static final int FUNCTION_m3r = 53;
    public static final int FUNCTION_m3s = 54;
    public static final int FUNCTION_m3p = 55;
    public static final int FUNCTION_m3c = 56;
    public static final int FUNCTION_m4r = 57;
    public static final int FUNCTION_m4s = 58;
    public static final int FUNCTION_m4p = 59;
    public static final int FUNCTION_m4c = 60;
    public static final int FUNCTION_m5r = 61;
    public static final int FUNCTION_m5s = 62;
    public static final int FUNCTION_m5p = 63;
    public static final int FUNCTION_m5c = 64;
    public static final int FUNCTION_m6r = 65;
    public static final int FUNCTION_m6s = 66;
    public static final int FUNCTION_m6p = 67;
    public static final int FUNCTION_m6c = 68;
    public static final int FUNCTION_clear = 69;
    public static final int FUNCTION_allclear = 70;
    public static final int FUNCTION_pop = 71;
    public static final int FUNCTION_redo = 72;
    public static final int FUNCTION_switchxy = 73;
    public static final int FUNCTION_percent = 74;
    public static final int FUNCTION_menu = 75;
    public static final int FUNCTION_menu_next = 76;
    public static final int FUNCTION_menu_prev = 77;
    public static final int FUNCTION_menu_select = 78;
    public static final int FUNCTION_menu_exit = 79;
    public static final int FUNCTION_inch_to_cm = 80;
    public static final int FUNCTION_cm_to_inch = 81;
    public static final int FUNCTION_feet_to_cm = 82;
    public static final int FUNCTION_cm_to_feet = 83;
    public static final int FUNCTION_yd_to_m = 84;
    public static final int FUNCTION_m_to_yd = 85;
    public static final int FUNCTION_mile_to_km = 86;
    public static final int FUNCTION_km_to_mile = 87;
    public static final int FUNCTION_nmile_to_km = 88;
    public static final int FUNCTION_km_to_nmile = 89;
    public static final int FUNCTION_acre_to_hectar = 90;
    public static final int FUNCTION_hectar_to_acre = 91;
    public static final int FUNCTION_mph_to_kmh = 92;
    public static final int FUNCTION_kmh_to_mph = 93;
    public static final int FUNCTION_kmh_to_ms = 94;
    public static final int FUNCTION_ms_to_kmh = 95;
    public static final int FUNCTION_mph_to_ms = 96;
    public static final int FUNCTION_ms_to_mph = 97;
    public static final int FUNCTION_knot_to_ms = 98;
    public static final int FUNCTION_ms_to_knot = 99;
    public static final int FUNCTION_knot_to_kmh = 100;
    public static final int FUNCTION_kmh_to_knot = 101;
    public static final int FUNCTION_oz_to_g = 102;
    public static final int FUNCTION_g_to_oz = 103;
    public static final int FUNCTION_lb_to_kg = 104;
    public static final int FUNCTION_kg_to_lb = 105;
    public static final int FUNCTION_usg_to_l = 106;
    public static final int FUNCTION_l_to_usg = 107;
    public static final int FUNCTION_mpg_to_l100km = 108;
    public static final int FUNCTION_l100km_to_mpg = 109;
    public static final int FUNCTION_hp_to_kw = 110;
    public static final int FUNCTION_kw_to_hp = 111;
    public static final int FUNCTION_kcal_to_kj = 112;
    public static final int FUNCTION_kj_to_kcal = 113;
    public static final int FUNCTION_kwh_to_mj = 114;
    public static final int FUNCTION_mj_to_kwh = 115;
    public static final int FUNCTION_f_to_c = 116;
    public static final int FUNCTION_c_to_f = 117;
    public static final int FUNCTION_c_to_k = 118;
    public static final int FUNCTION_k_to_c = 119;
    public static final int FUNCTION_f_to_k = 120;
    public static final int FUNCTION_k_to_f = 121;
    public static final int FUNCTION_bar_to_pa = 122;
    public static final int FUNCTION_pa_to_bar = 123;
    public static final int FUNCTION_mmhg_to_pa = 124;
    public static final int FUNCTION_pa_to_mmhg = 125;
    public static final int FUNCTION_bar_to_mmhg = 126;
    public static final int FUNCTION_mmhg_to_bar = 127;
    public static final int FUNCTION_hexa = 128;
    public static final int FUNCTION_hexb = 129;
    public static final int FUNCTION_hexc = 130;
    public static final int FUNCTION_hexd = 131;
    public static final int FUNCTION_hexe = 132;
    public static final int FUNCTION_hexf = 133;
    public static final int FUNCTION_bin = 134;
    public static final int FUNCTION_oct = 135;
    public static final int FUNCTION_dec = 136;
    public static final int FUNCTION_hex = 137;
    public static final int FUNCTION_fse = 138;
    public static final int FUNCTION_toarith = 139;
    public static final int FUNCTION_totriglog = 140;
    public static final int FUNCTION_tomem = 141;
    public static final int FUNCTION_tohex = 142;
    public static final int FUNCTION_toconvert = 143;
    public static final int FUNCTION_toconvert2 = 144;
    public static final int CONSTANT_SPEED_OF_LIGHT = 145;
    public static final int CONSTANT_ELECTRIC_CONSTANT = 146;
    public static final int CONSTANT_MAGNETIC_CONSTANT = 147;
    public static final int CONSTANT_PLANCK = 148;
    public static final int CONSTANT_DIRAC = 149;
    public static final int CONSTANT_COULOMB = 150;
    public static final int CONSTANT_FARADAY = 151;
    public static final int CONSTANT_ELEMENTARY_CHARGE = 152;
    public static final int CONSTANT_ELECTRON_MASS = 153;
    public static final int CONSTANT_PROTON_MASS = 154;
    public static final int CONSTANT_RYDBERG = 155;
    public static final int CONSTANT_AVOGADRO = 156;
    public static final int CONSTANT_GAS_CONSTANT = 157;
    public static final int CONSTANT_GRAVITATION_CONSTANT = 158;
    public static final int CONSTANT_GRAVITY = 159;
    public static final int CONSTANT_SPEED_OF_SOUND = 160;
    public static final int CONSTANT_EARTH_RADIUS = 161;
    private char buttonChar;
    private int functionShort;
    private int functionLong;
    private int width;
    private int height;
    private int top;
    private int left;
    private static Font altFont;
    private static int padding;
    private static final String[] buttonValues;
    private static final String[] buttonValuesNokia;
    private static final String[] buttonValuesSafe;
    private boolean isPressed = false;

    public CalcButton(int button) {
        this.buttonChar = button < 10 ? (char)(button + 48) : (button == 10 ? (char)42 : (button == 11 ? (char)35 : (button == 12 ? (char)67 : (char)66)));
        this.left = 0;
        this.top = 0;
        this.width = 0;
        this.height = 0;
    }

    public void setIsPressed(boolean isPressed) {
        this.isPressed = isPressed;
    }

    public boolean getIsPressed() {
        return this.isPressed;
    }

    public void repeatPressed() {
        this.isPressed = false;
    }

    public void setFunctionalities(int shortFunction, int longFunction) {
        this.functionShort = shortFunction;
        this.functionLong = longFunction;
    }

    public String getShortText() {
        switch (Settings.getSafeStringsMode()) {
            case 1: {
                return buttonValues[this.functionShort];
            }
            case 2: {
                return buttonValuesNokia[this.functionShort];
            }
        }
        return buttonValuesSafe[this.functionShort];
    }

    public String getLongText() {
        switch (Settings.getSafeStringsMode()) {
            case 1: {
                return buttonValues[this.functionLong];
            }
            case 2: {
                return buttonValuesNokia[this.functionLong];
            }
        }
        return buttonValuesSafe[this.functionLong];
    }

    public int getLongFunctionality() {
        return this.functionLong;
    }

    public int getShortFunctionality() {
        return this.functionShort;
    }

    public void setPosSize(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        padding = height / 10;
        for (byte i = 6; i > 0 && height < (altFont = Settings.getFont(i, 32)).getHeight() * 2 + 2 * padding; i = (byte)(i - 1)) {
        }
    }

    public int getTop() {
        return this.top;
    }

    public int getLeft() {
        return this.left;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isPosOn(int x, int y) {
        return x > this.left && x < this.left + this.width && y > this.top && y < this.top + this.height;
    }

    protected void paint(Graphics g) {
        if (this.isPressed) {
            g.setColor(0xE0E0FF);
        } else {
            g.setColor(0xB0B0FF);
        }
        g.setClip(this.left, this.top, this.width, this.height);
        g.fillRoundRect(this.left, this.top, this.width - 1, this.height - 1, this.width / 2, this.height / 2);
        g.setColor(0x505050);
        g.drawRoundRect(this.left, this.top, this.width - 1, this.height - 1, this.width / 2, this.height / 2);
        g.setFont(largeFont);
        if (this.isPressed) {
            g.setColor(0xD0D0FF);
        } else {
            g.setColor(0xE0E0FF);
        }
        g.drawChar(this.buttonChar, this.left + this.width / 2, this.top + this.height / 2 + largeFont.getHeight() / 2, 33);
        g.setFont(altFont);
        g.setColor(0);
        if (this.functionShort != 0) {
            g.drawString(this.getShortText(), this.left + padding, this.top + padding, 20);
        }
        if (this.functionLong != 0) {
            g.drawString(this.getLongText(), this.left + this.width - padding - 1, this.top + this.height - padding, 40);
        }
    }

    static {
        buttonValues = new String[]{null, "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ".", "=", "\u221ax", "x\u00b2", "+", "x^y", "1/x", "-", "(", ")", "*", "exp", "\u00b1", "/", "sin", "asin", "cos", "acos", "tan", "atan", "sinh", "asinh", "cosh", "acosh", "tanh", "atanh", "drg", "\u03c0", "n!", "e^x", "ln", "e", "10^x", "log", "m1r", "m1s", "m1+", "m1c", "m2r", "m2s", "m2+", "m2c", "m3r", "m3s", "m3+", "m3c", "m4r", "m4s", "m4+", "m4c", "m5r", "m5s", "m5+", "m5c", "m6r", "m6s", "m6+", "m6c", "C", "AC", "\u2190", "\u2192", "x\u2194y", "%", "menu", "next", "prev", "ok", "e", "inch\u2198", "\u2196cm", "feet\u2198", "\u2196cm", "yd\u2198", "\u2196m", "mile\u2198", "\u2196km", "n mi\u2198", "\u2196km", "acre\u2198", "\u2196hectar", "mph\u2198", "\u2196km/h", "km/h\u2198", "\u2196m/s", "mph\u2198", "\u2196m/s", "knot\u2198", "\u2196m/s", "knot\u2198", "\u2196km/h", "oz\u2198", "\u2196g", "lb\u2198", "\u2196kg", "USGallon\u2198", "\u2196l", "mpg\u2198", "\u2196l/100km", "hp\u2198", "\u2196kW", "kCal\u2198", "\u2196kJ", "kWh\u2198", "\u2196MJ", "\u00baF\u2198", "\u2196\u00baC", "\u00baC\u2198", "\u2196K", "\u00baF\u2198", "\u2196K", "bar\u2198", "\u2196Pa", "mm Hg\u2198", "\u2196Pa", "bar\u2198", "\u2196mm Hg", "A", "B", "C", "D", "E", "F", "Bin", "Oct", "Dec", "Hex", "eng/sci"};
        buttonValuesNokia = new String[]{null, "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ".", "=", "\u221ax", "x\u00b2", "+", "x^y", "1/x", "-", "(", ")", "*", "exp", "\u00b1", "/", "sin", "asin", "cos", "acos", "tan", "atan", "sinh", "asinh", "cosh", "acosh", "tanh", "atanh", "drg", "\u03c0", "n!", "e^x", "ln", "e", "10^x", "log", "m1r", "m1s", "m1+", "m1c", "m2r", "m2s", "m2+", "m2c", "m3r", "m3s", "m3+", "m3c", "m4r", "m4s", "m4+", "m4c", "m5r", "m5s", "m5+", "m5c", "m6r", "m6s", "m6+", "m6c", "C", "AC", "\u2190", "\u2192", "x\u2194y", "%", "menu", "next", "prev", "ok", "e", "inch\u2193", "\u2191cm", "feet\u2193", "\u2191cm", "yd\u2193", "\u2191m", "mile\u2193", "\u2191km", "n mi\u2193", "\u2191km", "acre\u2193", "\u2191hectar", "mph\u2193", "\u2191km/h", "km/h\u2193", "\u2191m/s", "mph\u2193", "\u2191m/s", "knot\u2193", "\u2191m/s", "knot\u2193", "\u2191km/h", "oz\u2193", "\u2191g", "lb\u2193", "\u2191kg", "USGallon\u2193", "\u2191l", "mpg\u2193", "\u2191l/100km", "hp\u2193", "\u2191kW", "kCal\u2193", "\u2191kJ", "kWh\u2193", "\u2191MJ", "\u00baF\u2193", "\u2191\u00baC", "\u00baC\u2193", "\u2191K", "\u00baF\u2193", "\u2191K", "bar\u2193", "\u2191Pa", "mm Hg\u2193", "\u2191Pa", "bar\u2193", "\u2191mm Hg", "A", "B", "C", "D", "E", "F", "Bin", "Oct", "Dec", "Hex", "eng/sci"};
        buttonValuesSafe = new String[]{null, "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ".", "=", "sqrt(x)", "x^2", "+", "x^y", "1/x", "-", "(", ")", "*", "exp", "+-", "/", "sin", "asin", "cos", "acos", "tan", "atan", "sinh", "asinh", "cosh", "acosh", "tanh", "atanh", "drg", "pi", "n!", "e^x", "ln", "e", "10^x", "log", "m1r", "m1s", "m1+", "m1c", "m2r", "m2s", "m2+", "m2c", "m3r", "m3s", "m3+", "m3c", "m4r", "m4s", "m4+", "m4c", "m5r", "m5s", "m5+", "m5c", "m6r", "m6s", "m6+", "m6c", "C", "AC", "undo", "redo", "x<->y", "%", "menu", "next", "prev", "ok", "e", "inch", "cm", "feet", "cm", "yd", "m", "mile", "km", "n mi", "km", "acre", "hectar", "mph", "km/h", "km/h", "m/s", "mph", "m/s", "knot", "m/s", "knot", "km/h", "oz", "g", "lb", "kg", "USGallon", "l", "mpg", "l/100km", "hp", "kW", "kCal", "kJ", "kWh", "MJ", "\u00baF", "\u00baC", "\u00baC", "K", "\u00baF", "K", "bar", "Pa", "mm Hg", "Pa", "bar", "mm Hg", "A", "B", "C", "D", "E", "F", "Bin", "Oct", "Dec", "Hex", "eng/sci"};
    }
}

