/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import java.io.DataInputStream;

public class MediaPlayer {
    private byte[] m_Tone = null;
    private Sound m_Sound = null;
    private boolean m_boLoop = false;
    private boolean m_boPlaying = false;
    private int m_iVolumeLevel = 15;
    private int[] m_aVolume = new int[]{0, 1, 10, 30, 60};

    MediaPlayer() {
    }

    public void setVolumeLevel(String s) {
        System.out.println("play sound " + s);
        int i = Integer.valueOf(s);
        this.m_iVolumeLevel = this.m_aVolume[i - 1];
        if (this.m_Sound == null) {
            return;
        }
        boolean boPlaying = this.m_boPlaying;
        if (boPlaying) {
            this.stop();
        }
        try {
            this.m_Sound.setGain(this.m_iVolumeLevel);
        }
        catch (Exception e) {
            System.out.println("setVolumeLevel error");
        }
        if (boPlaying) {
            this.start();
        }
    }

    public void setMediaLocation(String fileName) {
        try {
            this.m_Sound = null;
            String obj = fileName = fileName + ".ott";
            DataInputStream is = new DataInputStream(this.getClass().getResourceAsStream(fileName));
            int iLength = 128;
            if (iLength > 0) {
                this.m_Tone = new byte[iLength];
                try {
                    is.read(this.m_Tone);
                    this.m_Sound = new Sound(this.m_Tone, 1);
                }
                catch (Exception e) {
                    System.out.println("new sound  " + fileName + " error");
                }
            }
            this.m_boPlaying = false;
        }
        catch (Exception e) {
            System.out.println("setMediaLocation " + fileName + " error");
        }
    }

    public void setPlayBackLoop(boolean boLoop) {
        this.m_boLoop = boLoop;
        if (this.m_boPlaying) {
            this.start();
        }
    }

    public void start() {
        if (this.m_Sound == null) {
            return;
        }
        try {
            this.m_Sound.stop();
            this.m_Sound.setGain(this.m_iVolumeLevel);
            if (this.m_boLoop) {
                this.m_Sound.play(0);
            } else {
                this.m_Sound.play(1);
            }
            this.m_boPlaying = true;
        }
        catch (Exception e) {
            System.out.println("start sound error");
        }
    }

    public void stop() {
        if (this.m_Sound == null) {
            return;
        }
        try {
            this.m_Sound.stop();
            this.m_boPlaying = false;
        }
        catch (Exception e) {
            System.out.println("stop sound error");
        }
    }

    private void discardPlayer() {
        if (this.m_Sound != null) {
            this.m_Sound.release();
            this.m_Sound = null;
            this.m_boPlaying = false;
        }
    }
}

