/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager;

import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.jnlp.JNLPBundler;
import com.sun.javafx.tools.ant.Callback;
import com.sun.javafx.tools.packager.CommonParams;
import com.sun.javafx.tools.packager.HtmlParam;
import com.sun.javafx.tools.packager.JSCallback;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.Param;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class DeployParams
extends CommonParams {
    final List<RelativeFileSet> resources = new ArrayList<RelativeFileSet>();
    String id;
    String title;
    String vendor;
    String email;
    String description;
    String category;
    String licenseType;
    String copyright;
    String version;
    Boolean systemWide;
    Boolean serviceHint;
    Boolean signBundle;
    Boolean installdirChooser;
    String applicationClass;
    String preloader;
    List<Param> params;
    List<HtmlParam> htmlParams;
    List<String> arguments;
    int width;
    int height;
    String embeddedWidth = null;
    String embeddedHeight = null;
    String appName;
    String codebase;
    boolean embedJNLP = true;
    @Deprecated
    final boolean embedCertificates = false;
    boolean allPermissions = false;
    String updateMode = "background";
    boolean isExtension = false;
    boolean isSwingApp = false;
    Boolean needShortcut = null;
    Boolean needMenu = null;
    boolean needInstall = false;
    String outfile;
    boolean includeDT;
    String placeholder = "'javafx-app-placeholder'";
    String appId = null;
    boolean offlineAllowed = true;
    List<JSCallback> callbacks;
    List<Template> templates = new LinkedList<Template>();
    String jrePlatform = "1.6+";
    String fxPlatform = "8.0+";
    File javaRuntimeToUse = null;
    boolean javaRuntimeWasSet = false;
    List<String> jvmargs = new LinkedList<String>();
    Map<String, String> jvmUserArgs = new LinkedHashMap<String, String>();
    Map<String, String> properties = new LinkedHashMap<String, String>();
    Map<String, ? super Object> bundlerArguments = new LinkedHashMap<String, Object>();
    String fallbackApp = null;
    List<Icon> icons = new LinkedList<Icon>();
    Bundler.BundleType bundleType = Bundler.BundleType.NONE;
    String targetFormat = null;
    static final Set<String> multi_args = new TreeSet<String>(Arrays.asList(StandardBundlerParam.JVM_PROPERTIES.getID(), StandardBundlerParam.JVM_OPTIONS.getID(), StandardBundlerParam.USER_JVM_OPTIONS.getID(), StandardBundlerParam.ARGUMENTS.getID()));

    public void setJavaRuntimeSource(File file) {
        this.javaRuntimeToUse = file;
        this.javaRuntimeWasSet = true;
    }

    public void setCodebase(String string) {
        this.codebase = string;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public void setLicenseType(String string) {
        this.licenseType = string;
    }

    public void setCopyright(String string) {
        this.copyright = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setSystemWide(Boolean bl) {
        this.systemWide = bl;
    }

    public void setServiceHint(Boolean bl) {
        this.serviceHint = bl;
    }

    public void setInstalldirChooser(Boolean bl) {
        this.installdirChooser = bl;
    }

    public void setSignBundle(Boolean bl) {
        this.signBundle = bl;
    }

    public void setJRE(String string) {
        this.jrePlatform = string;
    }

    public void setSwingAppWithEmbeddedJavaFX(boolean bl) {
        this.isSwingApp = bl;
    }

    public void setNeedInstall(boolean bl) {
        this.needInstall = bl;
    }

    public void setOfflineAllowed(boolean bl) {
        this.offlineAllowed = bl;
    }

    public void setNeedShortcut(Boolean bl) {
        this.needShortcut = bl;
    }

    public void setNeedMenu(Boolean bl) {
        this.needMenu = bl;
    }

    public void setEmbeddedDimensions(String string, String string2) {
        this.embeddedWidth = string;
        this.embeddedHeight = string2;
    }

    public void setFallback(String string) {
        if (string == null) {
            return;
        }
        this.fallbackApp = "none".equals(string) || "null".equals(string) ? null : string;
    }

    public void setJavafx(String string) {
        this.fxPlatform = string;
    }

    public void addJvmArg(String string) {
        this.jvmargs.add(string);
    }

    public void addJvmUserArg(String string, String string2) {
        this.jvmUserArgs.put(string, string2);
    }

    public void addJvmProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public void setAllPermissions(boolean bl) {
        this.allPermissions = bl;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public void setArguments(List<String> list) {
        this.arguments = list;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setEmbedJNLP(boolean bl) {
        this.embedJNLP = bl;
    }

    @Deprecated
    public void setEmbedCertifcates(boolean bl) {
        if (bl) {
            System.out.println("JavaFX Packager no longer supports embedding certificates in JNLP files.  Setting will be ignored.");
        }
    }

    public void setPlaceholder(String string) {
        this.placeholder = string;
    }

    public void setAppId(String string) {
        this.appId = string;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setHtmlParams(List<HtmlParam> list) {
        this.htmlParams = list;
    }

    public void setOutfile(String string) {
        this.outfile = string;
    }

    public void setParams(List<Param> list) {
        this.params = list;
    }

    public void setPreloader(String string) {
        this.preloader = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setUpdateMode(String string) {
        this.updateMode = string;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public void setEmail(String string) {
        this.email = string;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setExtension(boolean bl) {
        this.isExtension = bl;
    }

    public void setApplicationClass(String string) {
        this.applicationClass = string;
    }

    public void setIncludeDT(boolean bl) {
        this.includeDT = bl;
    }

    public void setJSCallbacks(List<JSCallback> list) {
        this.callbacks = list;
    }

    public void setCallbacks(List<Callback> list) {
        ArrayList<JSCallback> arrayList = new ArrayList<JSCallback>(list.size());
        for (Callback callback : list) {
            arrayList.add(new JSCallback(callback.getName(), callback.getCmd()));
        }
        this.callbacks = arrayList;
    }

    public void addTemplate(File file, File file2) {
        this.templates.add(new Template(file, file2));
    }

    List<File> expandFileset(File file) {
        LinkedList<File> linkedList = new LinkedList<File>();
        if (IOUtils.isNotSymbolicLink(file)) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    for (File file2 : fileArray) {
                        linkedList.addAll(this.expandFileset(file2));
                    }
                }
            } else {
                linkedList.add(file);
            }
        }
        return linkedList;
    }

    @Override
    public void addResource(File file, String string) {
        File file2 = new File(file, string);
        file2 = file2.getAbsoluteFile();
        if (file == null) {
            file = file2.getParentFile();
        }
        this.resources.add(new RelativeFileSet(file, (Set<File>)new LinkedHashSet<File>(this.expandFileset(file2))));
    }

    @Override
    public void addResource(File file, File file2) {
        file2 = file2.getAbsoluteFile();
        if (file == null) {
            file = file2.getParentFile();
        }
        this.resources.add(new RelativeFileSet(file, (Set<File>)new LinkedHashSet<File>(this.expandFileset(file2))));
    }

    public void addResource(File file, String string, String string2) {
        this.addResource(file, DeployParams.createFile(file, string), string2);
    }

    public void addResource(File file, File file2, String string) {
        this.addResource(file, file2, "eager", string, null, null);
    }

    public void addResource(File file, File file2, String string, String string2, String string3, String string4) {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        linkedHashSet.add(file2);
        if (file == null) {
            file = file2.getParentFile();
        }
        RelativeFileSet relativeFileSet = new RelativeFileSet(file, (Set<File>)linkedHashSet);
        relativeFileSet.setArch(string4);
        relativeFileSet.setMode(string);
        relativeFileSet.setOs(string3);
        relativeFileSet.setType(this.parseTypeFromString(string2, file2));
        this.resources.add(relativeFileSet);
    }

    private RelativeFileSet.Type parseTypeFromString(String string, File file) {
        if (string == null) {
            if (file.getName().endsWith(".jar")) {
                return RelativeFileSet.Type.jar;
            }
            if (file.getName().endsWith(".jnlp")) {
                return RelativeFileSet.Type.jnlp;
            }
            return RelativeFileSet.Type.UNKNOWN;
        }
        return RelativeFileSet.Type.valueOf(string);
    }

    private static File createFile(File file, String string) {
        File file2 = new File(string);
        return file2.isAbsolute() ? file2 : new File(file == null ? null : file.getAbsolutePath(), string);
    }

    @Override
    public void validate() throws PackagerException {
        if (this.outdir == null) {
            throw new PackagerException("ERR_MissingArgument", "-outdir");
        }
        if (this.outfile == null) {
            throw new PackagerException("ERR_MissingArgument", "-outfile");
        }
        if (this.resources.isEmpty()) {
            throw new PackagerException("ERR_MissingAppResources");
        }
        if (this.applicationClass == null) {
            throw new PackagerException("ERR_MissingArgument", "-appclass");
        }
    }

    public void addIcon(String string, String string2, int n, int n2, int n3, RunMode runMode) {
        this.icons.add(new Icon(string, string2, n, n2, n3, runMode));
    }

    public void setBundleType(Bundler.BundleType bundleType) {
        this.bundleType = bundleType;
    }

    public Bundler.BundleType getBundleType() {
        return this.bundleType;
    }

    public void setTargetFormat(String string) {
        this.targetFormat = string;
    }

    public String getTargetFormat() {
        return this.targetFormat;
    }

    private String getArch() {
        String string = System.getProperty("os.arch").toLowerCase();
        if ("x86".equals(string) || "i386".equals(string) || "i486".equals(string) || "i586".equals(string) || "i686".equals(string)) {
            string = "x86";
        } else if ("x86_64".equals(string) || "amd64".equals("arch")) {
            string = "x86_64";
        }
        return string;
    }

    public void addBundleArgument(String string, Object object) {
        if (multi_args.contains(string) && object instanceof String) {
            Object object2 = this.bundlerArguments.get(string);
            if (object2 instanceof String) {
                this.bundlerArguments.put(string, object2 + "\n\n" + object);
            } else if (object2 instanceof List) {
                ((List)object2).add(object);
            } else if (object2 instanceof Map && ((String)object).contains("=")) {
                String[] stringArray = ((String)object).split("=", 2);
                ((Map)object2).put(stringArray[0], stringArray[1]);
            } else {
                this.bundlerArguments.put(string, object);
            }
        } else {
            this.bundlerArguments.put(string, object);
        }
    }

    public BundleParams getBundleParams() {
        BundleParams bundleParams = new BundleParams();
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = this.getArch();
        for (RelativeFileSet treeMap22 : this.resources) {
            String string3 = treeMap22.getOs();
            String string4 = treeMap22.getArch();
            if (string3 != null && !string.contains(string3.toLowerCase()) || string4 != null && !string2.startsWith(string4.toLowerCase()) || treeMap22.getType() == RelativeFileSet.Type.nativelib || treeMap22.getType() != RelativeFileSet.Type.license) continue;
            for (String string5 : treeMap22.getIncludedFiles()) {
                bundleParams.addLicenseFile(string5);
            }
        }
        bundleParams.setAppResourcesList(this.resources);
        bundleParams.setIdentifier(this.id);
        if (this.javaRuntimeWasSet) {
            bundleParams.setRuntime(this.javaRuntimeToUse);
        }
        bundleParams.setApplicationClass(this.applicationClass);
        bundleParams.setPrelaoderClass(this.preloader);
        bundleParams.setName(this.appName);
        bundleParams.setAppVersion(this.version);
        bundleParams.setType(this.bundleType);
        bundleParams.setBundleFormat(this.targetFormat);
        bundleParams.setVendor(this.vendor);
        bundleParams.setEmail(this.email);
        bundleParams.setShortcutHint(this.needShortcut);
        bundleParams.setMenuHint(this.needMenu);
        bundleParams.setSystemWide(this.systemWide);
        bundleParams.setServiceHint(this.serviceHint);
        bundleParams.setInstalldirChooser(this.installdirChooser);
        bundleParams.setSignBundle(this.signBundle);
        bundleParams.setCopyright(this.copyright);
        bundleParams.setApplicationCategory(this.category);
        bundleParams.setLicenseType(this.licenseType);
        bundleParams.setDescription(this.description);
        bundleParams.setTitle(this.title);
        if (this.verbose) {
            bundleParams.setVerbose(true);
        }
        bundleParams.setJvmProperties(this.properties);
        bundleParams.setJvmargs(this.jvmargs);
        bundleParams.setJvmUserArgs(this.jvmUserArgs);
        bundleParams.setArguments(this.arguments);
        Object object4 = null;
        for (Icon icon : this.icons) {
            if (icon.kind != null && !icon.kind.equals("default") || ((File)(object4 = new File(icon.href))).exists()) continue;
            Log.debug("Icon [" + icon.href + "] is not valid absolute path. " + "Assume it is relative to the output dir.");
            object4 = new File(this.outdir, icon.href);
        }
        bundleParams.setIcon((File)object4);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (this.params != null) {
            for (Param param : this.params) {
                treeMap.put(param.name, param.value);
            }
        }
        this.putUnlessNullOrEmpty(JNLPBundler.APP_PARAMS.getID(), treeMap);
        TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
        TreeMap<String, String> treeMap3 = new TreeMap<String, String>();
        if (this.htmlParams != null) {
            for (HtmlParam htmlParam : this.htmlParams) {
                if (htmlParam.needEscape) {
                    treeMap3.put(htmlParam.name, htmlParam.value);
                    continue;
                }
                treeMap2.put(htmlParam.name, htmlParam.value);
            }
        }
        this.putUnlessNullOrEmpty(JNLPBundler.APPLET_PARAMS.getID(), treeMap2);
        this.putUnlessNullOrEmpty(JNLPBundler.ESCAPED_APPLET_PARAMS.getID(), treeMap3);
        this.putUnlessNull(JNLPBundler.WIDTH.getID(), this.width);
        this.putUnlessNull(JNLPBundler.HEIGHT.getID(), this.height);
        this.putUnlessNull(JNLPBundler.EMBEDDED_WIDTH.getID(), this.embeddedWidth);
        this.putUnlessNull(JNLPBundler.EMBEDDED_HEIGHT.getID(), this.embeddedHeight);
        this.putUnlessNull(JNLPBundler.CODEBASE.getID(), this.codebase);
        this.putUnlessNull(JNLPBundler.EMBED_JNLP.getID(), this.embedJNLP);
        this.putUnlessNull(JNLPBundler.ALL_PERMISSIONS.getID(), this.allPermissions);
        this.putUnlessNull(JNLPBundler.UPDATE_MODE.getID(), this.updateMode);
        this.putUnlessNull(JNLPBundler.EXTENSION.getID(), this.isExtension);
        this.putUnlessNull(JNLPBundler.SWING_APP.getID(), this.isSwingApp);
        this.putUnlessNull(JNLPBundler.OUT_FILE.getID(), this.outfile);
        this.putUnlessNull(JNLPBundler.INCLUDE_DT.getID(), this.includeDT);
        this.putUnlessNull(JNLPBundler.PLACEHOLDER.getID(), this.placeholder);
        this.putUnlessNull(JNLPBundler.OFFLINE_ALLOWED.getID(), this.offlineAllowed);
        TreeMap treeMap4 = new TreeMap();
        if (this.callbacks != null) {
            for (JSCallback jSCallback : this.callbacks) {
                treeMap4.put(jSCallback.getName(), jSCallback.getCmd());
            }
        }
        this.putUnlessNull(JNLPBundler.JS_CALLBACKS.getID(), treeMap4);
        TreeMap<File, File> treeMap5 = new TreeMap<File, File>();
        if (this.templates != null) {
            for (Template template : this.templates) {
                treeMap5.put(template.in, template.out);
            }
        }
        this.putUnlessNull(JNLPBundler.TEMPLATES.getID(), treeMap5);
        this.putUnlessNull(JNLPBundler.FX_PLATFORM.getID(), this.fxPlatform);
        this.putUnlessNull(JNLPBundler.JRE_PLATFORM.getID(), this.jrePlatform);
        this.putUnlessNull(JNLPBundler.FALLBACK_APP.getID(), this.fallbackApp);
        TreeSet<String> treeSet = new TreeSet<String>(this.bundlerArguments.keySet());
        treeSet.retainAll(bundleParams.getBundleParamsAsMap().keySet());
        if (!treeSet.isEmpty()) {
            throw new RuntimeException("Deploy Params and Bundler Arguments overlap in the following values:" + treeSet.toString());
        }
        bundleParams.addAllBundleParams(this.bundlerArguments);
        return bundleParams;
    }

    public void putUnlessNull(String string, Object object) {
        if (object != null) {
            this.bundlerArguments.put(string, object);
        }
    }

    public void putUnlessNullOrEmpty(String string, Map map) {
        if (map != null && !map.isEmpty()) {
            this.bundlerArguments.put(string, map);
        }
    }

    static class Icon {
        static final int UNDEFINED = -1;
        String href;
        String kind;
        int width = -1;
        int height = -1;
        int depth = -1;
        RunMode mode = RunMode.WEBSTART;

        Icon(String string, String string2, int n, int n2, int n3, RunMode runMode) {
            this.mode = runMode;
            this.href = string;
            this.kind = string2;
            if (n > 0) {
                this.width = n;
            }
            if (n2 > 0) {
                this.height = n2;
            }
            if (n3 > 0) {
                this.depth = n3;
            }
        }
    }

    static class Template {
        File in;
        File out;

        Template(File file, File file2) {
            this.in = file;
            this.out = file2;
        }
    }

    public static enum RunMode {
        WEBSTART,
        EMBEDDED,
        STANDALONE,
        ALL;

    }
}

