/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.windows.TopComponent;

public final class UI {
    private static Stack<Long> ourTimes = new Stack();
    public static final int TINY_SIZE = 2;
    public static final int SMALL_SIZE = 3;
    public static final int MEDIUM_SIZE = 5;
    public static final int LARGE_SIZE = 8;
    public static final int HUGE_SIZE = 13;
    private static final double MILLIS = 1000.0;
    public static final String UH = System.getProperty("user.home");
    public static final String LS = System.getProperty("line.separator");
    public static final String FS = System.getProperty("file.separator");
    private static final Border CORNER_BORDER = new CornerBorder();
    private static final boolean ENABLE_OUT = System.getProperty("org.netbeans.modules.out") != null;
    private static final boolean ENABLE_LOG = System.getProperty("org.netbeans.modules.log") != null;
    private static final boolean ENABLE_TIM = System.getProperty("org.netbeans.modules.tim") != null;

    private UI() {
    }

    public static boolean isAlt(int n) {
        return UI.isModifier(n, 8);
    }

    public static boolean isShift(int n) {
        return UI.isModifier(n, 1);
    }

    public static boolean isCtrl(int n) {
        return UI.isModifier(n, 2) || UI.isModifier(n, 4);
    }

    private static boolean isModifier(int n, int n2) {
        return (n & n2) != 0;
    }

    public static MyComboBox createComboBox(Object[] objectArray) {
        return new MyComboBox(objectArray);
    }

    public static JLabel createLabel(String string) {
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)string);
        return jLabel;
    }

    public static JRadioButton createRadioButton(String string, String string2) {
        JRadioButton jRadioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)jRadioButton, (String)string);
        jRadioButton.setText(UI.cutMnemonicAndAmpersand(string));
        jRadioButton.setToolTipText(string2);
        return jRadioButton;
    }

    public static JButton createButton(Action action) {
        return (JButton)UI.createAbstractButton(new JButton(), action);
    }

    public static JCheckBox createCheckBox(Action action) {
        return (JCheckBox)UI.createAbstractButton(new JCheckBox(), action);
    }

    public static JToggleButton createToggleButton(Action action) {
        return (JToggleButton)UI.createAbstractButton(new JToggleButton(), action);
    }

    public static void setItems(JComboBox jComboBox, Object[] objectArray) {
        Object object = jComboBox.getSelectedItem();
        jComboBox.removeAllItems();
        for (int i = 0; i < objectArray.length; ++i) {
            jComboBox.insertItemAt(objectArray[i], i);
        }
        if (objectArray.length > 0) {
            jComboBox.setSelectedIndex(0);
        }
        if (object != null) {
            jComboBox.setSelectedItem(object);
        }
    }

    public static JPanel createSeparator(String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        jPanel.add((Component)UI.createLabel(string), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        jPanel.add((Component)new JSeparator(), gridBagConstraints);
        return jPanel;
    }

    private static AbstractButton createAbstractButton(AbstractButton abstractButton, Action action) {
        abstractButton.setAction(action);
        UI.mnemonicAndToolTip(abstractButton, (String)action.getValue("ShortDescription"));
        return abstractButton;
    }

    private static void mnemonicAndToolTip(AbstractButton abstractButton, String string) {
        String string2 = abstractButton.getText();
        if (string2 == null) {
            Mnemonics.setLocalizedText((AbstractButton)abstractButton, (String)string);
            abstractButton.setText(null);
        } else {
            Mnemonics.setLocalizedText((AbstractButton)abstractButton, (String)string2);
            abstractButton.setText(UI.cutMnemonicAndAmpersand(string2));
        }
        abstractButton.setToolTipText(UI.cutMnemonicAndAmpersand(string));
    }

    private static String cutMnemonicAndAmpersand(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(" // ");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("&")) == -1) {
            return string;
        }
        return string.substring(0, n) + string.substring(n + 1);
    }

    public static JTextArea createTextArea(int n, String string) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setBackground(null);
        jTextArea.setEditable(false);
        jTextArea.setColumns(n);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        return jTextArea;
    }

    public static void a11y(Component component, String string) {
        UI.a11y(component, string, string);
    }

    public static void a11y(Component component, String string, String string2) {
        if (string != null) {
            component.getAccessibleContext().setAccessibleName(string);
        }
        if (string2 != null) {
            component.getAccessibleContext().setAccessibleDescription(string2);
        }
    }

    public static String i18n(Class clazz, String string) {
        if (string == null) {
            return null;
        }
        return NbBundle.getMessage((Class)clazz, (String)string);
    }

    public static String i18n(Class clazz, String string, String string2) {
        if (string == null) {
            return null;
        }
        return NbBundle.getMessage((Class)clazz, (String)string, (Object)string2);
    }

    public static String i18n(Class clazz, String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        return NbBundle.getMessage((Class)clazz, (String)string, (Object)string2, (Object)string3);
    }

    public static String i18n(Class clazz, String string, String string2, String string3, String string4) {
        if (string == null) {
            return null;
        }
        return NbBundle.getMessage((Class)clazz, (String)string, (Object)string2, (Object)string3, (Object)string4);
    }

    public static boolean printWarning(String string) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0, 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        return confirmation.getValue() == NotifyDescriptor.YES_OPTION;
    }

    public static boolean printConfirmation(String string) {
        return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string, 0)));
    }

    public static void printInformation(String string) {
        UI.print(string, 1);
    }

    public static void printError(String string) {
        UI.print(string, 0);
    }

    public static void printError(Exception exception) {
        UI.print(exception.getMessage(), 0);
    }

    private static void print(String string, int n) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, n));
    }

    public static ImageIcon icon(Class clazz, String string) {
        if (string == null) {
            return null;
        }
        return new ImageIcon(clazz.getResource("image/" + string + ".gif"));
    }

    public static Node getSelectedNode() {
        Node[] nodeArray = UI.getSelectedNodes();
        if (nodeArray == null) {
            return null;
        }
        return nodeArray[0];
    }

    public static Node[] getSelectedNodes() {
        TopComponent topComponent = UI.getActiveTopComponent();
        if (topComponent == null) {
            return null;
        }
        Node[] nodeArray = topComponent.getActivatedNodes();
        if (nodeArray == null || nodeArray.length == 0) {
            return null;
        }
        return nodeArray;
    }

    public static TopComponent getActiveTopComponent() {
        return TopComponent.getRegistry().getActivated();
    }

    public static void setWidth(JComponent jComponent, int n) {
        UI.setSize(jComponent, new Dimension(n, jComponent.getPreferredSize().height));
    }

    public static void setHeight(JComponent jComponent, int n) {
        UI.setSize(jComponent, new Dimension(jComponent.getPreferredSize().width, n));
    }

    public static void setSize(JComponent jComponent, Dimension dimension) {
        jComponent.setMinimumSize(dimension);
        jComponent.setPreferredSize(dimension);
    }

    public static void setSize(JComponent jComponent, int n, int n2) {
        UI.setSize(jComponent, new Dimension(n, n2));
    }

    public static int getInt(Object object) {
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static double getDouble(Object object) {
        try {
            return Double.parseDouble(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0;
        }
    }

    public static int round(double d) {
        return (int)Math.ceil(d);
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        int n = 0;
        int n2 = string.indexOf(string2, n);
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 != -1) {
            stringBuilder.append(string.substring(n, n2));
            stringBuilder.append(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        if (n > 0) {
            stringBuilder.append(string.substring(n));
            return stringBuilder.toString();
        }
        return string;
    }

    public static DataObject getDataObject(Object object) {
        if (!(object instanceof Node)) {
            return null;
        }
        return (DataObject)((Node)object).getLookup().lookup(DataObject.class);
    }

    public static JComponent getResizableX(JPanel jPanel) {
        return UI.getResizable(jPanel, 2);
    }

    public static JComponent getResizableXY(JPanel jPanel) {
        return UI.getResizable(jPanel, 1);
    }

    private static JComponent getResizable(JPanel jPanel, int n) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = n;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        gridBagConstraints.anchor = 18;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        return jPanel2;
    }

    public static String removeHtml(String string) {
        if (string == null) {
            return null;
        }
        string = UI.replace(string, "<b>", "'");
        string = UI.replace(string, "</b>", "'");
        string = UI.replace(string, "&nbsp;", " ");
        return string;
    }

    public static String getHtml(String string) {
        return "<html>" + string + "</html>";
    }

    public static <T> List<T> getInstances(Class<T> clazz) {
        Collection collection = Lookup.getDefault().lookupAll(clazz);
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Object e : collection) {
            arrayList.add(clazz.cast(e));
        }
        return arrayList;
    }

    public static void copyToClipboard(String string) {
        UI.getClipboard().setContents(new StringSelection(string), null);
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(ExClipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    public static boolean isDigit(char c) {
        return "0123456789".indexOf(c) != -1;
    }

    public static void show(Container container, String string) {
        Component[] componentArray;
        UI.out((container.isShowing() ? "[[ " : "") + string + container.getClass().getName());
        for (Component component : componentArray = container.getComponents()) {
            if (!(component instanceof Container)) continue;
            UI.show((Container)component, "    " + string);
        }
    }

    public static void startTimeln() {
        UI.tim();
        UI.startTime();
    }

    public static void startTime() {
        ourTimes.push(System.currentTimeMillis());
    }

    public static void endTime(Object object) {
        long l = System.currentTimeMillis();
        UI.tim(object + ": " + (double)(l - ourTimes.pop()) / 1000.0 + " sec.");
    }

    public static void tim() {
        if (ENABLE_TIM) {
            System.out.println();
        }
    }

    public static void tim(Object object) {
        if (ENABLE_TIM) {
            System.out.println("*** " + object);
        }
    }

    public static void log() {
        if (ENABLE_LOG) {
            System.out.println();
        }
    }

    public static void log(Object object) {
        if (ENABLE_LOG) {
            System.out.println("*** " + object);
        }
    }

    public static void dump() {
        UI.dump(null);
    }

    public static void dump(Object object) {
        UI.out();
        UI.out();
        if (object != null) {
            UI.out(object);
        }
        new Exception("!!!").printStackTrace();
    }

    public static void out() {
        if (ENABLE_OUT) {
            System.out.println();
        }
    }

    public static void out(Object object) {
        if (ENABLE_OUT) {
            System.out.println("*** " + object);
        }
    }

    private static final class CornerBorder
    extends EmptyBorder {
        private static final Icon CORNER = new ImageIcon(new byte[]{71, 73, 70, 56, 57, 97, 12, 0, 12, 0, -9, 0, 0, -125, -125, -125, -45, -45, -56, -3, -3, -3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 33, -7, 4, 1, 0, 0, -1, 0, 44, 0, 0, 0, 0, 12, 0, 12, 0, 64, 8, 52, 0, -1, 9, 28, 72, -16, -97, -128, -127, 2, 0, 0, 48, -88, -48, 96, 65, -127, 9, 23, 30, 124, 8, -79, 33, -63, -120, 12, 37, 54, -60, -120, -111, 98, 69, -113, 29, 11, 114, 92, -120, 112, -93, -59, -116, 40, 19, -114, -44, -72, 48, 32, 0, 59});

        public CornerBorder() {
            super(0, 3, 3, 3);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            CORNER.paintIcon(component, graphics, n3 - CORNER.getIconWidth(), n4 - CORNER.getIconHeight());
        }
    }

    public static abstract class Dialog
    extends WindowAdapter {
        private boolean myIsModal = true;
        private java.awt.Dialog myDialog;

        protected void opened() {
        }

        protected void closed() {
        }

        protected void resized() {
        }

        protected void updated() {
        }

        protected abstract DialogDescriptor createDescriptor();

        public void show() {
            this.show(true, true);
        }

        public void show(boolean bl) {
            this.show(true, bl);
        }

        public void showAndWait() {
            this.show(false, true);
        }

        protected final void setModal(boolean bl) {
            this.myIsModal = bl;
        }

        private void show(boolean bl, boolean bl2) {
            if (this.myDialog == null) {
                this.myDialog = DialogDisplayer.getDefault().createDialog(this.createDescriptor());
                this.myDialog.addWindowListener(this);
                this.myDialog.setResizable(bl2);
                this.myDialog.setModal(this.myIsModal);
                if (bl2) {
                    this.setCorner();
                }
                this.myDialog.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent componentEvent) {
                        Dialog.this.resized();
                    }
                });
            } else {
                this.opened();
            }
            this.updated();
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Dialog.this.myDialog.setVisible(true);
                    }
                });
            } else {
                this.myDialog.setVisible(true);
            }
        }

        public Component getUIComponent() {
            return this.myDialog;
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            this.opened();
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            this.closed();
        }

        protected final String i18n(String string) {
            return UI.i18n(this.getClass(), string);
        }

        protected final String i18n(String string, String string2) {
            return UI.i18n(this.getClass(), string, string2);
        }

        private void setCorner() {
            if (this.myDialog instanceof JDialog) {
                ((JDialog)this.myDialog).getRootPane().setBorder(CORNER_BORDER);
            }
        }
    }

    public static abstract class ButtonAction
    extends AbstractAction {
        public ButtonAction(String string, String string2) {
            this(string, null, string2);
        }

        public ButtonAction(Icon icon, String string) {
            this(null, icon, string);
        }

        public ButtonAction(String string) {
            this(string, null, string);
        }

        private ButtonAction(String string, Icon icon, String string2) {
            super(string, icon);
            this.putValue("ShortDescription", string2);
        }
    }

    public static abstract class IconAction
    extends AbstractAction {
        private Node myLastNode;

        protected IconAction(String string, String string2, Icon icon) {
            super(string, icon);
            this.putValue("ShortDescription", string2);
        }

        protected final Node getLastNode() {
            Node node = UI.getSelectedNode();
            if (node == null) {
                node = this.myLastNode;
            } else {
                this.myLastNode = node;
            }
            return node;
        }
    }

    public static class MyComboBox
    extends JComboBox {
        private int myIndex;
        private String myPrefix;

        public MyComboBox(Object[] objectArray) {
            super(objectArray);
            this.init();
        }

        @Override
        public boolean selectWithKeyChar(char c) {
            this.processKey(c);
            this.setSelectedIndex(this.myIndex);
            return true;
        }

        public void init() {
            this.myIndex = 0;
            this.myPrefix = "";
        }

        private void processKey(char c) {
            if (c == '\b') {
                this.init();
                return;
            }
            this.myPrefix = this.myPrefix + c;
            this.myPrefix = this.myPrefix.toLowerCase();
            for (int i = this.myIndex; i < this.getItemCount(); ++i) {
                String string = this.getItemAt(i).toString().toLowerCase();
                if (!string.startsWith(this.myPrefix)) continue;
                this.myIndex = i;
                return;
            }
        }
    }
}

