/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import java.util.Date;
import java.util.Map;
import javax.management.ObjectName;

public final class RecordingDescriptor
implements IRecordingDescriptor {
    private final String serverId;
    private final ObjectName objectName;
    private final Long id;
    private final String name;
    private final Map<String, ?> options;
    private final IRecordingDescriptor.RecordingState state;
    private final Date dataStartTime;
    private final Date dataEndTime;

    RecordingDescriptor(String serverId, Long id, String name, boolean isStarted, boolean isStopped, boolean isRunning, Map<String, ?> options, Date dataStartTime, Date dataEndTime, ObjectName objectName) {
        this.serverId = serverId;
        this.id = id;
        this.name = name;
        this.state = this.decideState(isStarted, isStopped, isRunning);
        this.options = options;
        this.objectName = objectName;
        this.dataStartTime = dataStartTime;
        this.dataEndTime = dataEndTime;
    }

    private IRecordingDescriptor.RecordingState decideState(boolean isStarted, boolean isStopped, boolean isRunning) {
        if (!isStarted) {
            return IRecordingDescriptor.RecordingState.CREATED;
        }
        if (isRunning) {
            return IRecordingDescriptor.RecordingState.RUNNING;
        }
        if (isStopped) {
            return IRecordingDescriptor.RecordingState.STOPPED;
        }
        return IRecordingDescriptor.RecordingState.STOPPING;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IRecordingDescriptor.RecordingState getState() {
        return this.state;
    }

    @Override
    public Map<String, ?> getOptions() {
        return this.options;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    public boolean equals(Object o) {
        if (o instanceof RecordingDescriptor) {
            RecordingDescriptor that = (RecordingDescriptor)o;
            return that.id.equals(this.id) && that.serverId.equals(this.serverId);
        }
        return false;
    }

    public int hashCode() {
        return this.id.intValue() ^ this.serverId.hashCode();
    }

    public String toString() {
        return "RecordingDescriptor@" + this.serverId + '[' + this.getName() + '(' + this.getId() + "), " + (Object)((Object)this.getState()) + ", " + this.getOptions() + ']';
    }

    @Override
    public Date getDataStartTime() {
        return this.dataStartTime;
    }

    @Override
    public Date getDataEndTime() {
        return this.dataEndTime;
    }

    @Override
    public Date getStartTime() {
        Object startTime = this.getOptions().get("recordingOption.startTime");
        if (startTime instanceof Date) {
            return (Date)startTime;
        }
        return null;
    }

    @Override
    public long getDuration() {
        return this.getLong("recordingOption.duration");
    }

    @Override
    public boolean isContinuous() {
        return this.getDuration() == 0L;
    }

    @Override
    public boolean getToDisk() {
        Object object = this.getOptions().get("recordingOption.toDisk");
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    @Override
    public long getMaxAge() {
        return this.getLong("recordingOption.maxAge");
    }

    @Override
    public long getMaxSize() {
        return this.getLong("recordingOption.maxSize");
    }

    private long getLong(String optionKey) {
        Object object = this.getOptions().get(optionKey);
        if (object instanceof Long) {
            return (Long)object;
        }
        return -1L;
    }
}

