/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.mbean;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalMBeanToolkit {
    private static final int localPID = LocalMBeanToolkit.initPID();

    static {
        if (localPID != 0) {
            Logger.getLogger("com.jrockit.mc.common.mbean").log(Level.FINE, "Acquired local PID. PID resolved to " + localPID);
        }
    }

    public static int getThisPID() {
        return localPID;
    }

    private static int initPID() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            if (name != null) {
                String s = name.split("@")[0];
                return Integer.parseInt(s);
            }
        }
        catch (Exception e) {
            Logger.getLogger("com.jrockit.mc.common.mbean").log(Level.FINE, "Could not retrieve PID of this running jvm instance", e);
        }
        return 0;
    }
}

