/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.DecimalScaleFactor;
import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.unit.ScaleFactor;
import com.jrockit.mc.common.unit.TimestampKind;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.util.Date;

public class Timestamp
implements IQuantity {
    private final long numericalValue;
    private final TimestampKind.TimestampUnit unit;

    public Timestamp(long numericalValue, TimestampKind.TimestampUnit unit) {
        this.numericalValue = numericalValue;
        this.unit = unit;
    }

    public Date getDate() {
        return new Date(this.floorValueIn(TimestampKind.MILLIS_UNIT));
    }

    @Override
    public int compareTo(IQuantity other) {
        if (other instanceof Timestamp) {
            long otherNanos = ((Timestamp)other).numericalValue;
            return this.numericalValue == otherNanos ? 0 : (this.numericalValue < otherNanos ? -1 : 1);
        }
        return 0;
    }

    public TimestampKind.TimestampUnit getUnit() {
        return this.unit;
    }

    public IQuantity in(IUnit<? extends IQuantity> targetUnit) {
        if (targetUnit.equals(this.unit)) {
            return this;
        }
        if (targetUnit instanceof TimestampKind.TimestampUnit) {
            return new Timestamp(this.floorValueIn(targetUnit), (TimestampKind.TimestampUnit)targetUnit);
        }
        throw new IllegalArgumentException("Cannot convert " + this.persistableString() + " into unit " + targetUnit);
    }

    @Override
    public long longValueIn(IUnit<?> targetUnit, long maxAbsValue) throws QuantityConversionException {
        ScaleFactor factor = this.valueFactorTo(targetUnit);
        if (factor.targetOutOfRange(this.numericalValue, maxAbsValue)) {
            if (this.numericalValue < 0L) {
                throw QuantityConversionException.tooLow(this, targetUnit.quantity(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL));
            }
            throw QuantityConversionException.tooHigh(this, targetUnit.quantity(maxAbsValue));
        }
        return factor.targetValue(this.numericalValue);
    }

    private long floorValueIn(IUnit<?> targetUnit) {
        return this.valueFactorTo(targetUnit).targetFloor(this.numericalValue);
    }

    private ScaleFactor valueFactorTo(IUnit<?> targetUnit) {
        if (targetUnit instanceof TimestampKind.TimestampUnit) {
            return this.unit.getLinearUnit().valueFactorTo(((TimestampKind.TimestampUnit)targetUnit).getLinearUnit());
        }
        throw new IllegalArgumentException("Cannot convert " + this.persistableString() + " into unit " + targetUnit);
    }

    @Override
    public double doubleValueIn(IUnit<?> targetUnit) {
        return this.valueFactorTo(targetUnit).targetValue(this.numericalValue);
    }

    @Override
    public long longValue() {
        return this.numericalValue;
    }

    @Override
    public double doubleValue() {
        return this.numericalValue;
    }

    @Override
    public String persistableString() {
        return String.valueOf(Long.toString(this.numericalValue)) + ' ' + this.unit.getIdentifier();
    }

    @Override
    public String interactiveFormat() {
        StringBuffer out = new StringBuffer();
        long seconds = this.floorValueIn(TimestampKind.SECONDS_UNIT);
        Date date = new Date(seconds * 1000L);
        DateFormat formatter = TimestampKind.getDateFormatter();
        FieldPosition secondPos = new FieldPosition(7);
        formatter.format(date, out, secondPos);
        if (!this.unit.equals(TimestampKind.SECONDS_UNIT)) {
            DecimalScaleFactor restFactor = (DecimalScaleFactor)this.valueFactorTo(TimestampKind.SECONDS_UNIT).invert();
            long rest = this.numericalValue - restFactor.targetFloor(seconds);
            out.append(DecimalFormatSymbols.getInstance().getDecimalSeparator());
            String restStr = Long.toString(rest);
            out.append("000000000000000000000000", restStr.length(), restFactor.powerOf10);
            out.append(restStr);
        }
        return out.toString();
    }

    @Override
    public String displayUsing(String formatIdentifier) {
        return this.unit.getContentType().getDisplayUnit(formatIdentifier).format(this);
    }

    public boolean equals(Object other) {
        if (other instanceof Timestamp) {
            Timestamp otherStamp = (Timestamp)other;
            return this.numericalValue == otherStamp.numericalValue && this.unit.equals(otherStamp.unit);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.numericalValue;
    }

    public String toString() {
        return String.valueOf(this.persistableString()) + " (" + this.interactiveFormat() + ')';
    }
}

