/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsDiff;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.CPUDiffPanel;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.MemoryDiffPanel;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.actions.FindAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public final class SnapshotsDiffWindow
extends ProfilerTopComponent {
    private static final String HELP_CTX_KEY_CPU = "CpuDiff.HelpCtx";
    private static final String HELP_CTX_KEY_MEM = "MemoryDiff.HelpCtx";
    private static final Image WINDOW_ICON_CPU = Icons.getImage((String)"ProfilerIcons.SnapshotsCompare");
    private static final Image WINDOW_ICON_MEMORY = Icons.getImage((String)"ProfilerIcons.SnapshotsCompare");
    private HelpCtx helpCtx;

    public SnapshotsDiffWindow() {
        throw new InternalError("This constructor should never be called");
    }

    public SnapshotsDiffWindow(ResultsSnapshot resultsSnapshot, LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2, int n, boolean bl, Lookup.Provider provider) {
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        if (resultsSnapshot instanceof SampledMemoryResultsDiff) {
            this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotDiffWindow_SampledAccessDescr());
            this.displayMemorySampledDiff((MemoryResultsSnapshot)((SampledMemoryResultsDiff)resultsSnapshot), loadedSnapshot, loadedSnapshot2, n, bl, provider);
        } else if (resultsSnapshot instanceof AllocMemoryResultsDiff) {
            this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotDiffWindow_AllocAccessDescr());
            this.displayMemoryAllocDiff((MemoryResultsSnapshot)((AllocMemoryResultsDiff)resultsSnapshot), loadedSnapshot, loadedSnapshot2, n, bl, provider);
        } else if (resultsSnapshot instanceof LivenessMemoryResultsDiff) {
            this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotDiffWindow_LivenessAccessDescr());
            this.displayMemoryLivenessDiff((MemoryResultsSnapshot)((LivenessMemoryResultsDiff)resultsSnapshot), loadedSnapshot, loadedSnapshot2, n, bl, provider);
        } else if (resultsSnapshot instanceof CPUResultsSnapshot) {
            this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotDiffWindow_CpuAccessDescr());
            this.displayCPUDiff((CPUResultsSnapshot)resultsSnapshot, loadedSnapshot, loadedSnapshot2, n, bl, provider);
        }
    }

    public static synchronized SnapshotsDiffWindow get(ResultsSnapshot resultsSnapshot, LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2) {
        return SnapshotsDiffWindow.get(resultsSnapshot, loadedSnapshot, loadedSnapshot2, -1, false, null);
    }

    public static synchronized SnapshotsDiffWindow get(ResultsSnapshot resultsSnapshot, LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2, int n, boolean bl, Lookup.Provider provider) {
        return new SnapshotsDiffWindow(resultsSnapshot, loadedSnapshot, loadedSnapshot2, n, bl, provider);
    }

    public int getPersistenceType() {
        return 2;
    }

    public HelpCtx getHelpCtx() {
        return this.helpCtx;
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void displayMemorySampledDiff(MemoryResultsSnapshot memoryResultsSnapshot, LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2, int n, boolean bl, Lookup.Provider provider) {
        MemoryDiffPanel memoryDiffPanel = new MemoryDiffPanel(this.getLookup(), memoryResultsSnapshot, loadedSnapshot, loadedSnapshot2, n, bl, provider);
        this.updateFind(true, memoryDiffPanel);
        this.add(memoryDiffPanel, "Center");
        this.setName(Bundle.SnapshotDiffWindow_SampledCaption());
        this.setIcon(WINDOW_ICON_MEMORY);
        this.helpCtx = new HelpCtx(HELP_CTX_KEY_MEM);
    }

    private void displayMemoryAllocDiff(MemoryResultsSnapshot memoryResultsSnapshot, LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2, int n, boolean bl, Lookup.Provider provider) {
        MemoryDiffPanel memoryDiffPanel = new MemoryDiffPanel(this.getLookup(), memoryResultsSnapshot, loadedSnapshot, loadedSnapshot2, n, bl, provider);
        this.updateFind(true, memoryDiffPanel);
        this.add(memoryDiffPanel, "Center");
        this.setName(Bundle.SnapshotDiffWindow_AllocCaption());
        this.setIcon(WINDOW_ICON_MEMORY);
        this.helpCtx = new HelpCtx(HELP_CTX_KEY_MEM);
    }

    private void displayMemoryLivenessDiff(MemoryResultsSnapshot memoryResultsSnapshot, LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2, int n, boolean bl, Lookup.Provider provider) {
        MemoryDiffPanel memoryDiffPanel = new MemoryDiffPanel(this.getLookup(), memoryResultsSnapshot, loadedSnapshot, loadedSnapshot2, n, bl, provider);
        this.updateFind(true, memoryDiffPanel);
        this.add(memoryDiffPanel, "Center");
        this.setName(Bundle.SnapshotDiffWindow_LivenessCaption());
        this.setIcon(WINDOW_ICON_MEMORY);
        this.helpCtx = new HelpCtx(HELP_CTX_KEY_MEM);
    }

    private void displayCPUDiff(CPUResultsSnapshot cPUResultsSnapshot, LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2, int n, boolean bl, Lookup.Provider provider) {
        LoadedSnapshot loadedSnapshot3 = new LoadedSnapshot((ResultsSnapshot)cPUResultsSnapshot, loadedSnapshot.getSettings(), null, loadedSnapshot.getProject());
        CPUDiffPanel cPUDiffPanel = new CPUDiffPanel(this.getLookup(), loadedSnapshot3, loadedSnapshot, loadedSnapshot2, n, bl);
        this.updateFind(true, cPUDiffPanel);
        this.add((Component)((Object)cPUDiffPanel), "Center");
        this.setName(Bundle.SnapshotDiffWindow_CpuCaption());
        this.setIcon(WINDOW_ICON_CPU);
        this.helpCtx = new HelpCtx(HELP_CTX_KEY_CPU);
    }

    private void updateFind(boolean bl, final SnapshotResultsWindow.FindPerformer findPerformer) {
        CallbackSystemAction callbackSystemAction = (CallbackSystemAction)SystemAction.get(FindAction.class);
        Object object = callbackSystemAction.getActionMapKey();
        if (bl) {
            this.getActionMap().put(object, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    findPerformer.performFind();
                }
            });
        } else {
            this.getActionMap().remove(object);
        }
    }
}

