/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.inputs;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.BrowseInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.ITrackGroup;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class TrackGroupInput
extends BrowseInput {
    private final FlightRecording m_recording;

    public TrackGroupInput(String property, String name, IServiceLocator serviceLocator) {
        super(property, name);
        this.m_recording = (FlightRecording)serviceLocator.getService(FlightRecording.class);
    }

    protected boolean browse(Shell shell) {
        TrackGroupLabelProvider lp = new TrackGroupLabelProvider();
        TrackGroupContentProvider lc = new TrackGroupContentProvider();
        ElementTreeSelectionDialog selectionDialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)lp, (ITreeContentProvider)lc);
        selectionDialog.setAllowMultiple(false);
        selectionDialog.setTitle(Messages.TRACK_GROUP_INPUT_SELECT_ROOT_GROUP_MSG);
        ITrackGroup tg = this.getGroupFromPath();
        if (tg != null) {
            selectionDialog.setInitialSelection((Object)tg);
        }
        selectionDialog.setInput((Object)this.m_recording);
        if (selectionDialog.open() == 0) {
            tg = (ITrackGroup)selectionDialog.getFirstResult();
            if (tg == null) {
                this.setPropertyValue("");
            } else {
                this.setPropertyValue(tg.getPath());
            }
            this.fireChange(IInput.STATUS_SETTING_CHANGE);
            return true;
        }
        return false;
    }

    ITrackGroup getGroupFromPath() {
        String path = this.getPropertyValue();
        for (ITrackGroup tg : this.m_recording.getRootGroup().getAllGroups()) {
            if (!path.equals(tg.getPath())) continue;
            return tg;
        }
        return null;
    }

    protected boolean hasValidData() {
        return true;
    }

    protected String getTextualRepresentation() {
        return this.getPropertyValue();
    }

    private static class TrackGroupContentProvider
    implements ITreeContentProvider {
        private TrackGroupContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof FlightRecording) {
                FlightRecording fr = (FlightRecording)inputElement;
                return fr.getRootGroup().getGroups().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            ITrackGroup tg = (ITrackGroup)parentElement;
            return tg.getGroups().toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            ITrackGroup tg = (ITrackGroup)element;
            return !tg.getGroups().isEmpty();
        }
    }

    private static class TrackGroupLabelProvider
    extends LabelProvider {
        private TrackGroupLabelProvider() {
        }

        public String getText(Object element) {
            ITrackGroup tg = (ITrackGroup)element;
            return tg.getName();
        }
    }
}

