/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Stack;
import pxb.android.dex2jar.DataIn;

public class DataInImpl
implements DataIn {
    Stack<Integer> stack = new Stack();
    XByteArrayInputStream in;

    public DataInImpl(byte[] data) {
        this.in = new XByteArrayInputStream(data);
    }

    public void move(int offset) {
        this.in.setPos(offset);
    }

    public void pop() {
        this.move(this.stack.pop());
    }

    public void pushMove(int offset) {
        this.push();
        this.move(offset);
    }

    public int readIntx() {
        return this.in.read() | this.in.read() << 8 | this.in.read() << 16 | this.in.read() << 24;
    }

    public byte[] readBytes(int size) {
        byte[] data = new byte[size];
        try {
            this.in.read(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    public long readUnsignedLeb128() {
        long value = 0L;
        int count = 0;
        int b = this.in.read();
        while ((b & 0x80) != 0) {
            value |= (long)((b & 0x7F) << count);
            count += 7;
            b = this.in.read();
        }
        return value |= (long)((b & 0x7F) << count);
    }

    public long readSignedLeb128() {
        int inp;
        int bitpos = 0;
        long vln = 0L;
        do {
            inp = this.in.read();
            vln |= (long)(inp & 0x7F) << bitpos;
            bitpos += 7;
        } while ((inp & 0x80) != 0);
        if ((1L << bitpos - 1 & vln) != 0L) {
            vln -= 1L << bitpos;
        }
        return vln;
    }

    public void push() {
        this.stack.push(this.in.getPos());
    }

    public short readShortx() {
        return (short)(this.in.read() | this.in.read() << 8);
    }

    public int readByte() {
        return this.in.read();
    }

    public int readUnsignedByte() {
        return this.in.read() & 0xFF;
    }

    public void skip(int bytes) {
        this.in.skip(bytes);
    }

    public boolean needPadding() {
        return this.in.getPos() % 4 != 0;
    }

    public long readLongx() {
        return (long)this.readIntx() | (long)this.readIntx() << 32;
    }

    private static class XByteArrayInputStream
    extends ByteArrayInputStream {
        public XByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        public void setPos(int pos) {
            this.pos = pos;
        }

        public int getPos() {
            return this.pos;
        }
    }
}

