/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.dump;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import pxb.android.dex2jar.DexOpcodeDump;
import pxb.android.dex2jar.DexOpcodes;
import pxb.android.dex2jar.Field;
import pxb.android.dex2jar.Method;
import pxb.android.dex2jar.visitors.DexCodeAdapter;
import pxb.android.dex2jar.visitors.DexCodeVisitor;

public class DumpDexCodeAdapter
extends DexCodeAdapter
implements DexOpcodes {
    private PrintWriter out;
    private Method m;
    List<Label> _labels = new ArrayList<Label>();
    List<TryCatch> trys = new ArrayList<TryCatch>();

    protected int labels(Label label) {
        int i = this._labels.indexOf(label);
        if (i > -1) {
            return i;
        }
        this._labels.add(label);
        return this._labels.indexOf(label);
    }

    public DumpDexCodeAdapter(DexCodeVisitor dcv, Method m, PrintWriter out) {
        super(dcv);
        this.m = m;
        this.out = out;
    }

    protected void info(int opcode, String format, Object ... args) {
        String s = String.format(format, args);
        if (opcode < 0) {
            this.out.printf("%-20s|%5s|%s\n", "", "", s);
        } else {
            this.out.printf("%-20s|%5s|%s\n", DexOpcodeDump.dump(opcode), "", s);
        }
    }

    public void visitInitLocal(int ... args) {
        int i = 0;
        if ((this.m.getAccessFlags() & 8) == 0) {
            int reg = args[i++];
            String type = Type.getType((String)this.m.getOwner()).getClassName();
            this.out.printf("%20s:v%d   //%s\n", "this", reg, type);
        }
        String[] stringArray = this.m.getType().getParameterTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            int reg = args[i++];
            type = Type.getType((String)type).getClassName();
            this.out.printf("%20s:v%d   //%s\n", "", reg, type);
            ++n2;
        }
        super.visitInitLocal(args);
    }

    private static String c(String type) {
        return Type.getType((String)type).getClassName();
    }

    public void visitArrayInsn(int opcode, int value, int array, int index) {
        switch (opcode) {
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                this.info(opcode, "v%d[v%d]=v%d", array, index, value);
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.info(opcode, "v%d=v%d[v%d]", value, array, index);
            }
        }
        super.visitArrayInsn(opcode, value, array, index);
    }

    public void visitArrayInsn(int opcode, String type, int saveToReg, int demReg) {
        String type_show = Type.getType((String)type).getElementType().getClassName();
        this.info(opcode, "v%d=new %s[v%d]", saveToReg, type_show, demReg);
        super.visitArrayInsn(opcode, type, saveToReg, demReg);
    }

    public void visitEnd() {
        super.visitEnd();
    }

    public void visitFieldInsn(int opcode, Field field, int regFromOrTo, int owner_reg) {
        switch (opcode) {
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 88: {
                this.info(opcode, "v%d=v%d.%s  //%s", regFromOrTo, owner_reg, field.getName(), field);
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: {
                this.info(opcode, "v%d.%s=v%d  //%s", owner_reg, field.getName(), regFromOrTo, field);
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                this.info(opcode, "%s.%s=v%d  //%s", DumpDexCodeAdapter.c(field.getOwner()), field.getName(), regFromOrTo, field);
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                this.info(opcode, "v%d=%s.%s  //%s", regFromOrTo, DumpDexCodeAdapter.c(field.getOwner()), field.getName(), field);
            }
        }
        super.visitFieldInsn(opcode, field, regFromOrTo, owner_reg);
    }

    public void visitFillArrayInsn(int opcode, int reg, int elemWidth, int initLength, Object[] values) {
        int j = 0;
        if (j < initLength) {
            this.info(opcode, "v%d[%d]=%d", reg, j, values[j]);
            ++j;
        }
        while (j < initLength) {
            this.info(-1, "v%d[%d]=%d", reg, j, values[j]);
            ++j;
        }
        super.visitFillArrayInsn(opcode, reg, elemWidth, initLength, values);
    }

    public void visitInInsn(int opcode, int saveToReg, int opReg) {
        switch (opcode) {
            case 181: 
            case 192: {
                this.info(opcode, "v%d &= v%d", saveToReg, opReg);
                break;
            }
            case 182: 
            case 193: {
                this.info(opcode, "v%d |= v%d", saveToReg, opReg);
                break;
            }
            case 183: 
            case 194: {
                this.info(opcode, "v%d ^= v%d", saveToReg, opReg);
                break;
            }
            case 178: 
            case 189: 
            case 200: 
            case 205: {
                this.info(opcode, "v%d *= v%d", saveToReg, opReg);
                break;
            }
            case 177: 
            case 188: 
            case 199: 
            case 204: {
                this.info(opcode, "v%d -= v%d", saveToReg, opReg);
                break;
            }
            case 180: 
            case 191: {
                this.info(opcode, "v%d %%= v%d", saveToReg, opReg);
                break;
            }
            case 179: 
            case 190: 
            case 201: 
            case 206: {
                this.info(opcode, "v%d /= v%d", saveToReg, opReg);
                break;
            }
            case 176: 
            case 187: 
            case 198: 
            case 203: {
                this.info(opcode, "v%d += v%d", saveToReg, opReg);
                break;
            }
            case 123: 
            case 125: 
            case 127: 
            case 128: {
                this.info(opcode, "v%d = ~v%d", saveToReg, opReg);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                this.info(opcode, "v%d = v%d", saveToReg, opReg);
                break;
            }
            case 141: {
                this.info(opcode, "v%d = (byte)v%d", saveToReg, opReg);
                break;
            }
            case 142: {
                this.info(opcode, "v%d = (char)v%d", saveToReg, opReg);
                break;
            }
            case 129: 
            case 130: 
            case 131: {
                this.info(opcode, "v%d = v%d", saveToReg, opReg);
                break;
            }
            case 143: {
                this.info(opcode, "v%d = (short)v%d", saveToReg, opReg);
                break;
            }
            case 133: 
            case 134: {
                this.info(opcode, "v%d = v%d", saveToReg, opReg);
                break;
            }
            case 132: {
                this.info(opcode, "v%d = (int)v%d", saveToReg, opReg);
                break;
            }
            case 140: {
                this.info(opcode, "v%d = (float)v%d", saveToReg, opReg);
                break;
            }
            case 138: {
                this.info(opcode, "v%d = (int)v%d", saveToReg, opReg);
                break;
            }
            case 139: {
                this.info(opcode, "v%d = (long)v%d", saveToReg, opReg);
                break;
            }
            case 135: {
                this.info(opcode, "v%d = (int)v%d", saveToReg, opReg);
                break;
            }
            case 137: {
                this.info(opcode, "v%d = v%d", saveToReg, opReg);
                break;
            }
            case 136: {
                this.info(opcode, "v%d = (long)v%d", saveToReg, opReg);
                break;
            }
            case 33: {
                this.info(opcode, "v%d = v%d.length", saveToReg, opReg);
            }
        }
        super.visitInInsn(opcode, saveToReg, opReg);
    }

    public void visitInInsn(int opcode, int saveToReg, int opReg, int opValueOrReg) {
        switch (opcode) {
            case 149: 
            case 160: {
                this.info(opcode, "v%d = v%d & v%d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 150: 
            case 161: {
                this.info(opcode, "v%d = v%d | v%d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 151: 
            case 162: {
                this.info(opcode, "v%d = v%d ^ v%d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 49: {
                this.info(opcode, "v%d = v%d - v%d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 146: 
            case 157: 
            case 168: 
            case 173: {
                this.info(opcode, "v%d = v%d * v%d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 147: 
            case 158: 
            case 169: 
            case 174: {
                this.info(opcode, "v%d = v%d / v%d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 144: 
            case 155: 
            case 166: 
            case 171: {
                this.info(opcode, "v%d = v%d + v%d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 145: 
            case 156: 
            case 167: 
            case 172: {
                this.info(opcode, "v%d = v%d - v%d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 148: 
            case 159: 
            case 170: 
            case 175: {
                this.info(opcode, "v%d = v%d %% v%d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 45: 
            case 47: {
                this.info(opcode, "v%d = v%d - v%d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 46: 
            case 48: {
                this.info(opcode, "v%d = v%d - v%d", saveToReg, opValueOrReg, opReg);
                break;
            }
            case 210: {
                this.info(opcode, "v%d = v%d * %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 211: {
                this.info(opcode, "v%d = v%d / %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 212: {
                this.info(opcode, "v%d = v%d %% %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 208: {
                this.info(opcode, "v%d = v%d + %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 213: {
                this.info(opcode, "v%d = v%d & %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 214: {
                this.info(opcode, "v%d = v%d | %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 215: {
                this.info(opcode, "v%d = v%d ^ %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 221: {
                this.info(opcode, "v%d = v%d & %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 216: {
                this.info(opcode, "v%d = v%d + %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 220: {
                this.info(opcode, "v%d = v%d %% %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 219: {
                this.info(opcode, "v%d = v%d / %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 218: {
                this.info(opcode, "v%d = v%d * %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 225: {
                this.info(opcode, "v%d = v%d >> %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 224: {
                this.info(opcode, "v%d = v%d << %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 226: {
                this.info(opcode, "v%d = v%d >>> %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 222: {
                this.info(opcode, "v%d = v%d | %d", saveToReg, opReg, opValueOrReg);
                break;
            }
            case 223: {
                this.info(opcode, "v%d = v%d ^ %d", saveToReg, opReg, opValueOrReg);
            }
        }
        super.visitInInsn(opcode, saveToReg, opReg, opValueOrReg);
    }

    public void visitInsn(int opcode) {
        switch (opcode) {
            case 14: {
                this.info(opcode, "return", new Object[0]);
            }
        }
        super.visitInsn(opcode);
    }

    public void visitJumpInsn(int opcode, Label label) {
        switch (opcode) {
            case 40: 
            case 41: {
                this.info(opcode, "goto L%s", this.labels(label));
            }
        }
        super.visitJumpInsn(opcode, label);
    }

    public void visitJumpInsn(int opcode, Label label, int reg) {
        switch (opcode) {
            case 56: {
                this.info(opcode, "if v%d == 0 goto L%s", reg, this.labels(label));
                break;
            }
            case 57: {
                this.info(opcode, "if v%d != 0 goto L%s", reg, this.labels(label));
                break;
            }
            case 58: {
                this.info(opcode, "if v%d <  0 goto L%s", reg, this.labels(label));
                break;
            }
            case 59: {
                this.info(opcode, "if v%d >= 0 goto L%s", reg, this.labels(label));
                break;
            }
            case 60: {
                this.info(opcode, "if v%d >  0 goto L%s", reg, this.labels(label));
                break;
            }
            case 61: {
                this.info(opcode, "if v%d <= 0 goto L%s", reg, this.labels(label));
            }
        }
        super.visitJumpInsn(opcode, label, reg);
    }

    public void visitJumpInsn(int opcode, Label label, int reg1, int reg2) {
        switch (opcode) {
            case 50: {
                this.info(opcode, "if v%d == v%d goto L%s", reg1, reg2, this.labels(label));
                break;
            }
            case 51: {
                this.info(opcode, "if v%d != v%d goto L%s", reg1, reg2, this.labels(label));
                break;
            }
            case 52: {
                this.info(opcode, "if v%d <  v%d goto L%s", reg1, reg2, this.labels(label));
                break;
            }
            case 53: {
                this.info(opcode, "if v%d >= v%d goto L%s", reg1, reg2, this.labels(label));
                break;
            }
            case 54: {
                this.info(opcode, "if v%d >  v%d goto L%s", reg1, reg2, this.labels(label));
                break;
            }
            case 55: {
                this.info(opcode, "if v%d <= v%d goto L%s", reg1, reg2, this.labels(label));
            }
        }
        super.visitJumpInsn(opcode, label, reg1, reg2);
    }

    public void visitLabel(Label label) {
        boolean find = false;
        for (TryCatch tc : this.trys) {
            if (!label.equals(tc.end)) continue;
            this.info(-1, " } // TC_%d", this.trys.indexOf(tc));
            find = true;
            break;
        }
        this.out.printf("%-20s|%5s:\n", "LABEL", "L" + this.labels(label));
        if (!find) {
            for (TryCatch tc : this.trys) {
                if (label.equals(tc.start)) {
                    this.info(-1, "try { // TC_%d ", this.trys.indexOf(tc));
                    break;
                }
                if (!label.equals(tc.handler)) continue;
                String t = tc.type;
                this.info(-1, "catch(%s) // TC_%d", t == null ? "all" : t, this.trys.indexOf(tc));
                break;
            }
        }
        super.visitLabel(label);
    }

    public void visitLdcInsn(int opcode, Object value, int reg) {
        if (value instanceof String) {
            this.info(opcode, "v%d=\"%s\"", reg, value);
        } else if (value instanceof Type) {
            this.info(opcode, "v%d=%s.class", reg, ((Type)value).getClassName());
        } else if (value instanceof Integer) {
            this.info(opcode, "v%d=0x%08x  // int:%d   float:%f", reg, value, value, Float.valueOf(Float.intBitsToFloat((Integer)value)));
        } else if (value instanceof Long) {
            this.info(opcode, "v%d=0x%016x  // long:%d   double:%f", reg, value, value, Double.longBitsToDouble((Long)value));
        } else {
            this.info(opcode, "v%d=%s  //", reg, value);
        }
        super.visitLdcInsn(opcode, value, reg);
    }

    public void visitLineNumber(int line, Label label) {
        super.visitLineNumber(line, label);
    }

    public void visitLocalVariable(String name, String type, String signature, Label start, Label end, int reg) {
        super.visitLocalVariable(name, type, signature, start, end, reg);
    }

    public void visitLookupSwitchInsn(int opcode, int reg, Label label, int[] cases, Label[] label2) {
        this.info(opcode, "switch(v%d)", reg);
        int i = 0;
        while (i < cases.length) {
            this.info(-1, "case %d: goto L%s", cases[i], this.labels(label2[i]));
            ++i;
        }
        this.info(-1, "default: goto L%s", this.labels(label));
        super.visitLookupSwitchInsn(opcode, reg, label, cases, label2);
    }

    public void visitMethodInsn(int opcode, Method method, int[] regs) {
        switch (opcode) {
            case 113: {
                int i = 0;
                StringBuilder sb = new StringBuilder();
                int j = 0;
                while (j < method.getType().getParameterTypes().length) {
                    sb.append('v').append(regs[i++]).append(',');
                    ++j;
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                if (method.getType().getReturnType().equals("V")) {
                    this.info(opcode, "%s.%s(%s)  //%s", DumpDexCodeAdapter.c(method.getOwner()), method.getName(), sb.toString(), method.toString());
                    break;
                }
                this.info(opcode, "TEMP=%s.%s(%s)  //%s", DumpDexCodeAdapter.c(method.getOwner()), method.getName(), sb.toString(), method.toString());
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 114: {
                int i = 1;
                StringBuilder sb = new StringBuilder();
                int j = 0;
                while (j < method.getType().getParameterTypes().length) {
                    sb.append(',').append('v').append(regs[i++]);
                    ++j;
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(0);
                }
                if (method.getType().getReturnType().equals("V")) {
                    this.info(opcode, "v%d.%s(%s)  //%s", regs[0], method.getName(), sb.toString(), method.toString());
                    break;
                }
                this.info(opcode, "TEMP=v%d.%s(%s)  //%s", regs[0], method.getName(), sb.toString(), method.toString());
            }
        }
        super.visitMethodInsn(opcode, method, regs);
    }

    public void visitTableSwitchInsn(int opcode, int reg, int first_case, int last_case, Label label, Label[] labels) {
        this.info(opcode, "switch(v%d)", reg);
        int i = 0;
        while (i < labels.length) {
            this.info(opcode, "case %d: goto L%s", first_case + i, this.labels(labels[i]));
            ++i;
        }
        this.info(opcode, "default: goto L%s", this.labels(label));
        super.visitTableSwitchInsn(opcode, reg, first_case, last_case, label, labels);
    }

    public void visitTryCatch(Label start, Label end, Label handler, String type) {
        TryCatch tc = new TryCatch(start, end, handler, type);
        this.trys.add(tc);
        int id = this.trys.indexOf(tc);
        if (type == null) {
            this.out.printf("TR_%d L%s ~ L%s > L%s all\n", id, this.labels(start), this.labels(end), this.labels(handler));
        } else {
            this.out.printf("TR_%d L%s ~ L%s > L%s %s\n", id, this.labels(start), this.labels(end), this.labels(handler), type);
        }
        super.visitTryCatch(start, end, handler, type);
    }

    public void visitTypeInsn(int opcode, String type, int toReg) {
        switch (opcode) {
            case 34: {
                this.info(opcode, "v%d=NEW %s", toReg, type);
                break;
            }
            case 28: {
                this.info(opcode, "v%d=%s.class", toReg, Type.getType((String)type).getClassName());
                break;
            }
            case 31: {
                this.info(opcode, "v%d=(%s) v%d", toReg, Type.getType((String)type).getClassName(), toReg);
            }
        }
        super.visitTypeInsn(opcode, type, toReg);
    }

    public void visitTypeInsn(int opcode, String type, int toReg, int fromReg) {
        switch (opcode) {
            case 32: {
                this.info(opcode, "v%d=v%d instanceof %s", toReg, fromReg, Type.getType((String)type).getClassName());
            }
        }
        super.visitTypeInsn(opcode, type, toReg, fromReg);
    }

    public void visitVarInsn(int opcode, int reg) {
        switch (opcode) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.info(opcode, "v%d=TEMP", reg);
                break;
            }
            case 39: {
                this.info(opcode, "throw v%d", reg);
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                this.info(opcode, "return v%d", reg);
                break;
            }
            case 29: {
                this.info(opcode, "lock v%d", reg);
                break;
            }
            case 30: {
                this.info(opcode, "unlock v%d", reg);
            }
        }
        super.visitVarInsn(opcode, reg);
    }

    public void visitFilledNewArrayIns(int opcode, String type, int[] regs) {
        this.info(opcode, "TEMP=new %s[%d]", Type.getType((String)type).getElementType().getClassName(), regs.length);
        int i = 0;
        while (i < regs.length) {
            this.info(opcode, "TEMP[%d]=v%d", i, regs[i]);
            ++i;
        }
        super.visitFilledNewArrayIns(opcode, type, regs);
    }

    private static class TryCatch {
        public Label start;
        public Label end;
        public Label handler;
        public String type;

        public TryCatch(Label start, Label end, Label handler, String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }
    }
}

