/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.reader;

import org.objectweb.asm.Type;
import pxb.android.dex2jar.DataIn;
import pxb.android.dex2jar.Dex;
import pxb.android.dex2jar.reader.Constant;
import pxb.android.dex2jar.visitors.DexAnnotationAble;
import pxb.android.dex2jar.visitors.DexAnnotationVisitor;

public class DexAnnotationReader {
    private Dex dex;
    private static final int VALUE_BYTE = 0;
    private static final int VALUE_SHORT = 2;
    private static final int VALUE_CHAR = 3;
    private static final int VALUE_INT = 4;
    private static final int VALUE_LONG = 6;
    private static final int VALUE_FLOAT = 16;
    private static final int VALUE_DOUBLE = 17;
    private static final int VALUE_STRING = 23;
    private static final int VALUE_TYPE = 24;
    private static final int VALUE_FIELD = 25;
    private static final int VALUE_METHOD = 26;
    private static final int VALUE_ENUM = 27;
    private static final int VALUE_ARRAY = 28;
    private static final int VALUE_ANNOTATION = 29;
    private static final int VALUE_NULL = 30;
    private static final int VALUE_BOOLEAN = 31;

    public DexAnnotationReader(Dex dex) {
        this.dex = dex;
    }

    public void accept(DataIn in, DexAnnotationAble daa) {
        int size = in.readIntx();
        int j = 0;
        while (j < size) {
            int field_annotation_offset = in.readIntx();
            in.pushMove(field_annotation_offset);
            int visible_i = in.readByte();
            int type_idx = (int)in.readUnsignedLeb128();
            String type = this.dex.getType(type_idx);
            DexAnnotationVisitor dav = daa.visitAnnotation(type, visible_i);
            if (dav != null) {
                int sizex = (int)in.readUnsignedLeb128();
                int k = 0;
                while (k < sizex) {
                    int name_idx = (int)in.readUnsignedLeb128();
                    String name = this.dex.getString(name_idx);
                    DexAnnotationReader.acceptAnnotation(this.dex, in, name, dav);
                    ++k;
                }
                dav.visitEnd();
            }
            in.pop();
            ++j;
        }
    }

    private static void acceptAnnotation(Dex dex, DataIn in, String name, DexAnnotationVisitor dav) {
        int b = in.readByte();
        int type = b & 0x1F;
        Object value = null;
        switch (type) {
            case 0: {
                value = new Byte((byte)Constant.x0246(in, b));
                break;
            }
            case 2: {
                value = new Short((short)Constant.x0246(in, b));
                break;
            }
            case 4: {
                value = new Integer((int)Constant.x0246(in, b));
                break;
            }
            case 6: {
                value = new Long(Constant.x0246(in, b));
                break;
            }
            case 3: {
                value = new Character((char)Constant.x3(in, b));
                break;
            }
            case 23: {
                value = dex.getString((int)Constant.x3(in, b));
                break;
            }
            case 16: {
                value = Float.valueOf(Float.intBitsToFloat((int)(Constant.xf(in, b) >> 32)));
                break;
            }
            case 17: {
                value = Double.longBitsToDouble(Constant.xf(in, b));
                break;
            }
            case 30: {
                value = Type.VOID_TYPE;
                break;
            }
            case 31: {
                value = new Boolean((b >> 5 & 3) != 0);
                break;
            }
            case 24: {
                int type_id = (int)Constant.x3(in, b);
                value = Type.getType((String)dex.getType(type_id));
                break;
            }
            case 27: {
                value = dex.getField((int)Constant.x3(in, b));
                break;
            }
            case 26: {
                int method_id = (int)Constant.x3(in, b);
                value = dex.getMethod(method_id);
                break;
            }
            case 25: {
                int field_id = (int)Constant.x3(in, b);
                value = dex.getField(field_id);
            }
        }
        if (value != null) {
            if (dav != null) {
                dav.visit(name, value);
            }
            return;
        }
        switch (type) {
            case 28: {
                int size = in.readByte();
                DexAnnotationVisitor _dav = null;
                if (dav != null) {
                    _dav = dav.visitArray(name);
                }
                int i = 0;
                while (i < size) {
                    DexAnnotationReader.acceptAnnotation(dex, in, null, _dav);
                    ++i;
                }
                if (_dav != null) {
                    _dav.visitEnd();
                }
                return;
            }
            case 29: {
                int _type = (int)in.readUnsignedLeb128();
                String _typeString = dex.getType(_type);
                DexAnnotationVisitor _dav = dav.visitAnnotation(name, _typeString);
                int size = (int)in.readUnsignedLeb128();
                int i = 0;
                while (i < size) {
                    int nameid = (int)in.readUnsignedLeb128();
                    DexAnnotationReader.acceptAnnotation(dex, in, dex.getString(nameid), _dav);
                    ++i;
                }
                break;
            }
            default: {
                throw new RuntimeException("Not support yet.");
            }
        }
    }
}

