/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.v3;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import pxb.android.dex2jar.ClassVisitorFactory;
import pxb.android.dex2jar.reader.DexFileReader;
import pxb.android.dex2jar.v3.V3;
import pxb.android.dex2jar.v3.V3AccessFlagsAdapter;

public class Main {
    public static void main(String ... args) {
        if (args.length == 0) {
            System.out.println("dex2jar file1.dex file2.dex ...");
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            File dex = new File(file);
            File gen = new File(String.valueOf(file) + ".dex2jar.jar");
            try {
                Main.doFile(dex, gen);
            }
            catch (IOException e) {
                throw new RuntimeException("\u5904\u7406\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38:" + dex, e);
            }
            ++n2;
        }
    }

    public static void doFile(File srcDex) throws IOException {
        Main.doFile(srcDex, new File(srcDex.getParentFile(), String.valueOf(srcDex.getName()) + ".dex2jar.jar"));
    }

    public static void doFile(File srcDex, File destJar) throws IOException {
        final ZipOutputStream zos = new ZipOutputStream(FileUtils.openOutputStream((File)destJar));
        byte[] data = FileUtils.readFileToByteArray((File)srcDex);
        DexFileReader reader = new DexFileReader(data);
        V3AccessFlagsAdapter afa = new V3AccessFlagsAdapter();
        reader.accept(afa);
        reader.accept(new V3(afa.getAccessFlagsMap(), new ClassVisitorFactory(){

            public ClassVisitor create(final String name) {
                return new ClassWriter(0){

                    public void visitEnd() {
                        super.visitEnd();
                        try {
                            byte[] data = this.toByteArray();
                            ZipEntry entry = new ZipEntry(String.valueOf(name) + ".class");
                            zos.putNextEntry(entry);
                            zos.write(data);
                            zos.closeEntry();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
            }
        }));
        zos.finish();
        zos.close();
    }
}

