/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.v3;

import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pxb.android.dex2jar.Field;
import pxb.android.dex2jar.Method;
import pxb.android.dex2jar.v3.Ann;
import pxb.android.dex2jar.visitors.DexAnnotationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V3AnnAdapter
implements DexAnnotationVisitor {
    Ann ann;
    private static final Logger logger = LoggerFactory.getLogger(V3AnnAdapter.class);

    public static void accept(List<Ann.Item> items, AnnotationVisitor av) {
        if (av == null) {
            return;
        }
        for (Ann.Item item : items) {
            Object v = item.value;
            if (v instanceof Ann) {
                AnnotationVisitor av1;
                Ann a = (Ann)v;
                if (a.type != null) {
                    av1 = av.visitAnnotation(item.name, a.type);
                    V3AnnAdapter.accept(a.items, av1);
                    av1.visitEnd();
                    continue;
                }
                av1 = av.visitArray(item.name);
                V3AnnAdapter.accept(a.items, av1);
                av1.visitEnd();
                continue;
            }
            if (v instanceof Field) {
                Field e = (Field)v;
                av.visitEnum(item.name, e.getType(), e.getName());
                continue;
            }
            if (v instanceof Method) {
                logger.warn("Find Method Annotation:{}", v);
                continue;
            }
            av.visit(item.name, v);
        }
    }

    public V3AnnAdapter(Ann ann) {
        this.ann = ann;
    }

    @Override
    public void visit(String name, Object value) {
        this.ann.items.add(new Ann.Item(name, value));
    }

    @Override
    public DexAnnotationVisitor visitAnnotation(String name, String desc) {
        Ann ann = new Ann(desc, -1);
        this.ann.items.add(new Ann.Item(name, ann));
        return new V3AnnAdapter(ann);
    }

    @Override
    public DexAnnotationVisitor visitArray(String name) {
        Ann ann = new Ann(null, -1);
        this.ann.items.add(new Ann.Item(name, ann));
        return new V3AnnAdapter(ann);
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
    }
}

