@start rule: main
<project name="@project_name" default="help">

  <!-- This build file was automatically generated at @time on @date by @generator -->

  <!-- BUILD PROPERTIES ADJUST THESE FOR YOUR ENVIRONMENT -->
  <property name="tmp.dir" value="/tmp" />
  <property name="dist.dir" value="${tmp.dir}/dist"/>
  <property name="app.name" value="@project_name" />
  <property name="ear" value="${dist.dir}/${app.name}.ear"/>
  <property name="ear.exploded" value="${dist.dir}/${app.name}_exploded"/>
  <property name="verbose" value="true" />
  <property name="user" value="@user" />
  <property name="password" value="@password" />
  <property name="servername" value="myserver" />
  <property name="adminurl" value="@adminurl" />
  

  <property name="src.dir" value="@srcdir" />
  <property name="dest.dir" value="${tmp.dir}/${app.name}" />

  <!-- Print's out the project help -->
  <target name="help">
    <java fork="no" classname="org.apache.tools.ant.Main">
      <arg line="-projecthelp"/>
    </java>
  </target>



  <!-- Builds the entire @project_name application -->
  <target name="build" depends="compile, appc" description="Compiles @project_name application and runs appc"  />

  <!-- Only compiles @project_name application, no appc -->
  <target name="compile" description="Only compiles @project_name application, no appc">
    <wlcompile srcdir="${src.dir}" destdir="${dest.dir}" />
  </target>

  <!-- Runs weblogic.appc on your application -->
  <target name="appc" description="Runs weblogic.appc on your application">
    <wlappc source="${dest.dir}" verbose="${verbose}"/>
  </target>

   @build_components

  <!-- Deploys the entire @project_name application -->
  <target name="deploy" description="Deploys (and redeploys) the entire @project_name application">
    <wldeploy user="${user}" password="${password}" adminurl="${adminurl}"
              action="deploy" source="${dest.dir}"
              name="@project_name" />
  </target>

  <!-- UnDeploys the entire @project_name application -->
  <target name="undeploy" description="UnDeploys the entire @project_name application">
    <wldeploy user="${user}" password="${password}"
              action="undeploy" name="@project_name" />
  </target>

  @redeploy_components

 <!-- Generates descriptors for applicaiton and modules 
    Only required if your application does not have any descriptors.  Only required to run once -->
 <target name="descriptors" depends="compile" description="Generates application and module descriptors">
    <ddcreate dir="${dest.dir}" />
  </target>
 
 <!-- Package a standard J2EE ear for distribution  -->
  <target name="ear" depends="build" description="Package a standard J2EE EAR for distribution">
    <mkdir dir="${dist.dir}"/>
    <wlpackage srcdir="${src.dir}" destdir="${dest.dir}"
               toFile="${ear}" />
  </target>

 <!-- Package a standard exploded J2EE ear for distribution  -->
  <target name="ear.exploded" depends="build" description="Package a standard exploded J2EE EAR">
    <mkdir dir="${dist.dir}"/>
    <wlpackage srcdir="${src.dir}" destdir="${dest.dir}"
               toDir="${ear.exploded}" />
  </target>



  <target name="clean" description="Deletes the build and distribution directories">
    <delete dir="${dest.dir}" />
    <delete dir="${dist.dir}" />
  </target>

</project>

@end rule: main

@start rule: build_component

  <!-- Builds just @component_name of the application -->
  <target name="compile.@component_name" description="Compiles just the @component_name module of the application">
    <wlcompile srcdir="${src.dir}" destdir="${dest.dir}"
               includes="@component_name" />
  </target>
@end rule: build_component

@start rule: redeploy_component

  <!-- Redeploys just @component_name of the application -->
  <target name="redeploy.@component_name" description="Redeploys just the @component_name module of the application">
    <wldeploy user="${user}" password="${password}"
              action="redeploy"  targets="@target_name"
              name="@project_name" />
  </target>
@end rule: redeploy_component


