@start rule: simpleLoadCheckForField
      if (!(@isLoadedVarForField @perhapsOrTermForIsModified)) {
        @callLoadMethodForField
      }
@end rule: simpleLoadCheckForField


@start rule: cmpGetMethod
  public @fieldClassForCmpField @getMethodNameForField()
  {
    try {
      @simpleLoadCheckForField
      return @fieldNameForField;
    @standardCatch
  }
@end rule: cmpGetMethod


@start rule: cmpSetMethod
  public void @setMethodNameForField(
    @fieldClassForCmpField @fieldNameForField)
  {
    @cmpSetMethodGuard
  }
@end rule: cmpSetMethod

@start rule: cmpSetMethodBody
    @cmpSetMethodCheck
    this.@fieldNameForField = @fieldNameForField;
    @isModifiedVarForField = true;
    @perhapsSetTableModifiedVarForCmpField
    @registerModifiedBean
@end rule: cmpSetMethodBody

@start rule: cmpSetMethodBodyForOptimistic
    if(! __WL_beanIsLoaded()) {
	try {
          @callLoadMethodForField
	@standardCatch
    }

    @cmpSetMethodBody
@end rule: cmpSetMethodBodyForOptimistic


@start rule: oneToOneGetterBody_fkOwner
    try {
      @loadCheckForCmrField

      if (@fieldVarForField==null) {
        if (!@fkVarForFieldIsNull) {
          @perhapsDeclareFkVar
          @perhapsAllocateFkVar
          @perhapsAssignFkVar
          Transaction orgTx =
            TransactionHelper.getTransactionHelper().getTransaction();
          try {
             @readOnlyOneToOneGetterBody_fkOwner
           }finally {
              @readOnlyResumeTx
           } 
        }
      }


      return @fieldVarForField;
    @standardCatch
   
@end rule: oneToOneGetterBody_fkOwner


@start rule: oneToOneGetterBody
    try {
      if (!@isCmrLoadedVarNameForField) {
         if (@verboseVar) {
            Debug.say("calling @finderVarForField with value of " +
              @ctxVar.getPrimaryKey());
         }
         Transaction orgTx =
           TransactionHelper.getTransactionHelper().getTransaction();
         try {
           @readOnlyFinderOneToOneGetterBody
          }
         catch (InternalException ie) {
           if (ie.detail!=null && ie.detail instanceof ObjectNotFoundException)
             @fieldVarForField = null;
           else
             throw ie;
         }
         finally {
           @readOnlyResumeTx
         } 
         @isCmrLoadedVarNameForField = true;
         if (@verboseVar) {
           if (@fieldVarForField == null)
             Debug.say("bean not found.");
           else
             Debug.say("bean was found.");
         }
      }
      return @fieldVarForField;
    @standardCatch
          
@end rule: oneToOneGetterBody


@start rule: oneToOneSetNullBody_fkOwner
    try {
      @loadCheckForCmrField

      if (!@fkVarForFieldIsNull) {
        @perhapsDeclareFkVar
        @perhapsAllocateFkVar
        @perhapsAssignFkVar

        @relInterfaceNameForField @beanVar =
           (@relInterfaceNameForField)@bmVarForField.lookup(@fkVarForField);
        int oldState = @beanVar.__WL_getMethodState();
        try {
          @beanVar.__WL_setMethodState(WLEnterpriseBean.STATE_BUSINESS_METHOD);
          @beanVar.@relatedDoSetForField(null);
        } finally {
          @beanVar.__WL_setMethodState(oldState);
        }
        if (ejbStore) {
          @beanVar.ejbStore();
        }
      }
    @standardCatch
@end rule: oneToOneSetNullBody_fkOwner


@start rule: oneToOneSetNullBody
    try {
      @getMethodNameForField();
      if (@fieldVarForField !=null) {
        @relInterfaceNameForField @beanVar =
        (@relInterfaceNameForField)@bmVarForField.lookup(
           @fieldVarForField.getPrimaryKey());
        int oldState = @beanVar.__WL_getMethodState();
        try {
          @beanVar.__WL_setMethodState(WLEnterpriseBean.STATE_BUSINESS_METHOD);
          @beanVar.@relatedDoSetForField(null);
        }
        finally {
          @beanVar.__WL_setMethodState(oldState);
        }
        if (ejbStore) {
          @beanVar.ejbStore();
        }
      }
    @standardCatch
@end rule: oneToOneSetNullBody


@start rule: oneToManySetBody_local_fkOwner
    try {
      @oneToManySetBody_fkOwner_preSetCheck

      @doSetMethodNameForField(@fieldNameForField);

      @perhapsCallPostSetMethodForField

      if (ejbStore) ejbStore();
    @standardCatch
@end rule: oneToManySetBody_local_fkOwner


@start rule: oneToManySetBody_remote_fkOwner
    if (__WL_method_state==STATE_EJB_CREATE) {
      Loggable l = EJBLogger.logsetCheckForCmrFieldDuringEjbCreateLoggable();
      throw new IllegalStateException(l.getMessage());
    }

    try {
      @doSetMethodNameForField(@fieldNameForField);
    @standardCatch
@end rule: oneToManySetBody_remote_fkOwner


@start rule: oneToManySetBody_fkOwner_preSetCheck
    @loadCheckForCmrField

    if (!@fkVarForFieldIsNull) {
      @perhapsDeclareFkVar
      @perhapsAllocateFkVar
      @perhapsAssignFkVar

      @relInterfaceNameForField @beanVar =
        (@relInterfaceNameForField)@bmVarForField.lookup(@fkVarForField);
      int oldState = @beanVar.__WL_getMethodState();
      try {
        @beanVar.__WL_setMethodState(WLEnterpriseBean.STATE_BUSINESS_METHOD);
        RDBMSSet @colVar = (RDBMSSet)
          @beanVar.@getRelatedMethodNameForField();
        @colVar.doRemove(@ctxVar.@getEJBObject(), remove);
      } finally {
        @beanVar.__WL_setMethodState(oldState);
      }
    }
@end rule: oneToManySetBody_fkOwner_preSetCheck


@start rule: oneToOnePostSetBody_fkOwner
    if (!@fkVarForFieldIsNull) {
      @perhapsDeclareFkVar
      @perhapsAllocateFkVar
      @perhapsAssignFkVar
      @relInterfaceNameForField @beanVar = (@relInterfaceNameForField)
        @bmVarForField.lookup(@fkVarForField);

      int oldState = @beanVar.__WL_getMethodState();
      if (oldState == WLEnterpriseBean.STATE_EJB_POSTCREATE) {
        @beanVar.@relatedIsCmrLoadedVarNameForField(true);
      }
      try {
        @beanVar.__WL_setMethodState(WLEnterpriseBean.STATE_BUSINESS_METHOD);
        @beanVar.@relatedSetRestForField(
          (@componentInterfaceForBean)@ctxVar.@getEJBObject());
      } finally {
        @beanVar.__WL_setMethodState(oldState);
      }
    }
@end rule: oneToOnePostSetBody_fkOwner


@start rule: oneToOnePostSetBody
    if (@fieldVarForField !=null) {
      @relInterfaceNameForField @beanVar = (@relInterfaceNameForField)
      @bmVarForField.lookup(@fieldVarForField.getPrimaryKey());

      int oldState = @beanVar.__WL_getMethodState();
      try {
        @beanVar.__WL_setMethodState(WLEnterpriseBean.STATE_BUSINESS_METHOD);
        @beanVar.@relatedSetRestForField((@componentInterfaceForBean)
          @ctxVar.@getEJBObject());
      } finally {
        @beanVar.__WL_setMethodState(oldState);
      }
    }
@end rule: oneToOnePostSetBody


@start rule: checkRelatedExistsOneMany
    if ((@beanVar.__WL_beanIsLoaded() && @beanVar.__WL_getIsRemoved()) ||
        (!@beanVar.__WL_beanIsLoaded() && !@beanVar.__WL_exists(@fkVarForField))) {
      Loggable l = EJBLogger.logillegalAttemptToAssignRemovedBeanToCMRFieldLoggable(
        @fkVarForField.toString());
      throw new IllegalArgumentException(l.getMessage());
    }
@end rule: checkRelatedExistsOneMany


@start rule: oneToManyPostSetBody
    if (!@fkVarForFieldIsNull) {
      @perhapsDeclareFkVar
      @perhapsAllocateFkVar
      @perhapsAssignFkVar
      @relInterfaceNameForField @beanVar = (@relInterfaceNameForField)
        @bmVarForField.lookup(@fkVarForField);

      int oldState = @beanVar.__WL_getMethodState();
      try {
        @beanVar.__WL_setMethodState(WLEnterpriseBean.STATE_BUSINESS_METHOD);
	      
        @perhapsCheckRelatedExistsOneMany

        RDBMSSet @colVar = (RDBMSSet)
          @beanVar.@getRelatedMethodNameForField();
        @colVar.doAdd(@ctxVar.@getEJBObject());
      } finally {
        @beanVar.__WL_setMethodState(oldState);
      }
    }
@end rule: oneToManyPostSetBody


@start rule: oneToManySetBody
    if (@fieldNameForField==null) {
      Loggable l = EJBLogger.lognullAssignedToCmrFieldLoggable();
      throw new IllegalArgumentException(l.getMessage());
   
    }

    try {
      @getMethodNameForField();

      if (@fieldNameForField==@fieldVarForField)
        return;

      @fieldVarForField.clear();
      @fieldVarForField.addAll(@fieldNameForField);
    @standardCatch
@end rule: oneToManySetBody


@start rule: oneToOneDoSetBody_fkOwner
    try {
      @loadCheckForCmrField
      if (@verboseVar) {
        Debug.say("[" + @ctxVar.getPrimaryKey() +
                  "]called @doSetMethodNameForField...");
      }
      @fieldVarForField = @fieldNameForField;
      if (@fieldVarForField == null) {
        if (@verboseVar) {
          Debug.say("setting field variable to null.");
        }
        @assignFkVarsNull_forField
      }
      else {
        if (@verboseVar) {
          Debug.say("setting field variable to new value.");
        }
        @assignFkVarsFkField_forField
      }
      @registerModifiedBean
    @standardCatch
@end rule: oneToOneDoSetBody_fkOwner


@start rule: oneToManyGetterBody_fkOwner
    try {
      @loadCheckForCmrField

      if (@fieldVarForField==null) {
        @perhapsDeclareFkVar
        @perhapsAllocateFkVar
        @perhapsAssignFkVar
        if (!@fkVarForFieldIsNull) {
          Transaction orgTx = 
            TransactionHelper.getTransactionHelper().getTransaction();
          try {
            @readOnlyOneToManyGetterBody_fkOwner
          } finally {
            @readOnlyResumeTx
          }       
        }
      }

      return @fieldVarForField;
    @standardCatch
@end rule: oneToManyGetterBody_fkOwner


@start rule: oneToManyGetterBody
    try {
      if (@fieldVarForField==null) {
         if (@verboseVar) {
            Debug.say("\t@fieldVarForField was null.");
         }

         @fieldVarForField = @allocateOneToManySet
      }
      Transaction currentTx =
        TransactionHelper.getTransactionHelper().getTransaction();
      if(currentTx != null && ((RDBMSSet)@fieldVarForField)
                         .checkIfCurrentTxEqualsCreateTx(currentTx)) {
        return @fieldVarForField;
      } else {
        @fieldVarForField = (Set)(((@collectionClassForField)
                 @fieldVarForField).clone());
        ((RDBMSSet)@fieldVarForField).setTransaction(currentTx);
        return @fieldVarForField;
      }
       
    @standardCatch
@end rule: oneToManyGetterBody


@start rule: ManyToManyGetterBody
    try {
      if (@fieldVarForField==null) {
        if (@verboseVar) {
          Debug.say("\t@fieldVarForField was null.");
        }

        @fieldVarForField = @allocateManyToManySet
      }
      Transaction currentTx = 
        TransactionHelper.getTransactionHelper().getTransaction();
      if(currentTx != null && ((RDBMSSet)@fieldVarForField)
                         .checkIfCurrentTxEqualsCreateTx(currentTx)) {
        return @fieldVarForField;
      } else {
        @fieldVarForField = (Set)(((@collectionClassForField)
                 @fieldVarForField).clone());
        ((RDBMSSet)@fieldVarForField).setTransaction(currentTx);
        return @fieldVarForField;
      }
      
    @standardCatch
@end rule: ManyToManyGetterBody


@start rule: manyToManyGetSQL
  if (cmrf.equals("@fieldNameForField")) {
    @getMethodNameForField();
    if (operation == DDConstants.INSERT) {
      String @queryVar = ((RDBMSM2NSet) @fieldVarForField).getAddJoinTableSQL();
      if (@verboseVar) {
        Debug.say("__WL_getM2NSQL() produced sqlString: " + @queryVar);
      }
      return @queryVar;
    }
    else {
      throw new AssertionError("Unknown request for Many To Many Get SQL: "+
	operation);
    }
  }
@end rule: manyToManyGetSQL


@start rule: getCmrBeansForCmrField
  if (cmrf.equals("@fieldNameForField")) {
    return @getMethodNameForField();
  }
@end rule: getCmrBeansForCmrField


@start rule: oneToOneSetRestBody_fkOwner
    try {
      @loadCheckForCmrField

      if (@verboseVar) {
        Debug.say("[" + @ctxVar.getPrimaryKey() +
                  "]called @setRestMethodNameForField...");
      }
      if (!(@fkVarForFieldIsNull)) {
        if (@verboseVar) { Debug.say("\tvariable for field is not null."); }
        @perhapsDeclareFkVar
        @perhapsAllocateFkVar
        @perhapsAssignFkVar

        @relInterfaceNameForField @beanVar =
         (@relInterfaceNameForField) @bmVarForField.lookup(@fkVarForField);
        int oldState = @beanVar.__WL_getMethodState();
        try {
          @beanVar.__WL_setMethodState(WLEnterpriseBean.STATE_BUSINESS_METHOD);
          @beanVar.@relatedDoSetForField(null);
        } finally {
          @beanVar.__WL_setMethodState(oldState);
        }
      }
      @doSetMethodNameForField(@fieldNameForField);
    @standardCatch
@end rule: oneToOneSetRestBody_fkOwner


@start rule: checkExistsOneOne
    if ((@beanIsLoadedVar && __WL_getIsRemoved()) ||
        (!@beanIsLoadedVar && !__WL_exists(@ctxVar.getPrimaryKey()))) {
      Loggable l = EJBLogger.logillegalAttemptToAssignRemovedBeanToCMRFieldLoggable(
        @ctxVar.getPrimaryKey().toString());
      throw new IllegalArgumentException(l.getMessage());
    }
@end rule: checkExistsOneOne


@start rule: oneToOneSetRestBody
    try {
      @perhapsCheckExistsOneOne

      @getMethodNameForField();
      if (@fieldVarForField !=null) {
        @relInterfaceNameForField @beanVar = (@relInterfaceNameForField)
          @bmVarForField.lookup(@fieldVarForField.getPrimaryKey());
        int oldState = @beanVar.__WL_getMethodState();
        try {
          @beanVar.__WL_setMethodState(WLEnterpriseBean.STATE_BUSINESS_METHOD);
          @beanVar.@relatedDoSetForField(null);
        } finally {
          @beanVar.__WL_setMethodState(oldState);
        }
      }

      @doSetMethodNameForField(@fieldNameForField);
    @standardCatch
@end rule: oneToOneSetRestBody















