@start rule: main
@textPackageDeclaration

import java.text.MessageFormat;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import weblogic.i18n.Localizer;
import weblogic.i18ntools.L10nLookup;
 
/** 
 * Copyright (c) @year by BEA Inc. All Rights Reserved.
 * @exclude
 */
public class @className {
  private Localizer l10n;
  private boolean format=false;
  // constructors

  public @className() {
    l10n = L10nLookup.getLocalizer(Locale.getDefault(), "@formatterClass");
  }

  public @className(Locale l) {
    l10n = L10nLookup.getLocalizer(l, "@formatterClass");
  }

  public static @className getInstance() {
    return new @className();
  }

  public static @className getInstance(Locale l) {
    return new @className(l);
  }

  public void setExtendedFormat(boolean fmt) {
    format = fmt;
  }

  public boolean getExtendedFormat() { return format; }


@textMessages
}
@end rule: main

@start rule: textMessage
  /**
   * @textMessageDescription
   */
  public String @textMethodName(@textArguments) @textExceptions {
    String fmt  = "";
    String id = "@textMessageId" ;
    String subsystem = "@messageCatalogSubsystem" ;
    Object [] args = { @textArgumentClasses };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }
@end rule: textMessage
