DROP TABLE JMSState;
DROP TABLE JMSStore;
DROP TABLESPACE JMSMSGT;

CREATE TABLE JMSState (recordHandle int, recordState int, recordGeneration int);
CREATE TABLE JMSStore (recordHandle int, recordState int,
   record_row ROWID NOT NULL GENERATED ALWAYS,
   record BLOB(10M));

CREATE LOB TABLESPACE JMSMSGT LOG NO;
CREATE AUXILIARY TABLE JMSState_T
         IN JMSMSGT
         STORES JMSStore
         COLUMN  RECORD;

CREATE UNIQUE INDEX JMSMSG_TX ON JMSState_T;
CREATE INDEX JMSMSG_X ON JMSState (recordHandle);
CREATE INDEX JMSMSGQ_X ON JMSStore (recordHandle);
commit
