@start rule: package
package @packageName;

@end rule: package

@start rule: import
import @importName;

@end rule: import

@start rule: attributeTypeDoc
        // Type:         @attributeType
@end rule: attributeTypeDoc

@start rule: attributeMinDoc
        // Min:          @attributeMin
@end rule: attributeMinDoc

@start rule: attributeMaxDoc
        // Max:          @attributeMax
@end rule: attributeMaxDoc

@start rule: attributeDefaultDoc
        // Default:      @attributeDefault
@end rule: attributeDefaultDoc

@start rule: attributeLegalValuesDoc
        // Legal values: @attributeLegalValues
@end rule: attributeLegalValuesDoc

@start rule: attributeValidatorDoc
        // Validator:    @attributeValidator
@end rule: attributeValidatorDoc

@start rule: attributeDeprecatedDoc
        // deprecated
@end rule: attributeDeprecatedDoc

@start rule: operationParamDoc
         * @@param @paramName - @paramDescription
@end rule: operationParamDoc

@start rule: operationExceptionDoc
         * @@exception @exceptionName
@end rule: operationExceptionDoc

@start rule: operationReturnValueDescriptionDocRule
         * @@return @returnValueDescription
@end rule: operationReturnValueDescriptionDocRule

@start rule: attributeMinJavaDoc
         * @@legalMin @attributeMin
@end rule: attributeMinJavaDoc

@start rule: attributeMaxJavaDoc
         * @@legalMax @attributeMax
@end rule: attributeMaxJavaDoc

@start rule: attributeDefaultJavaDoc
         * @@default @attributeDefault
@end rule: attributeDefaultJavaDoc

@start rule: attributeLegalValuesJavaDoc
         * @@legalValues @attributeLegalValues
@end rule: attributeLegalValuesJavaDoc

@start rule: attributeValidatorJavaDoc
         * @@validator @attributeValidator
@end rule: attributeValidatorJavaDoc

@start rule: deprecatedJavaDoc
         * @@deprecated
@end rule: deprecatedJavaDoc

@start rule: mBeanDeprecatedJavaDoc
 * @@deprecated
@end rule: mBeanDeprecatedJavaDoc

@start rule: attributeGetter

        /**
         * @description
         * 
@attributeJavaDocComments
         *
         */

        public @attributeType @attributeGetterName ();

@end rule: attributeGetter

@start rule: attributeSetter

        /**
         * @description
         *
@attributeJavaDocComments
         * @@param newValue - new value for attribute @objectName
         * @@exception InvalidAttributeValueException
         */

        public void set@objectName (@attributeType newValue)
                throws InvalidAttributeValueException;

@end rule: attributeSetter

@start rule: attributeArrayIndexGetter

        /**
         * Array index getter method for array attribute @objectName
         *
         * @description
         *
@attributeJavaDocComments
         * @@param index- index of entry being returned
         */

        public @attributeTypeSimple @attributeArrayIndexGetterName (int index);

@end rule: attributeArrayIndexGetter

@start rule: attributeArrayIndexSetter

        /**
         * Array index setter method for array attribute @objectName
         *
         * @description
         *
@attributeJavaDocComments
         * @@param index- index of entry being set
         * @@param newValue - new value for attribute @objectName at provided index
         * @@exception InvalidAttributeValueException
         */

        public void @attributeArrayIndexSetterName (int index, @attributeTypeSimple newValue)
                throws InvalidAttributeValueException;

@end rule: attributeArrayIndexSetter

@start rule: attribute

        //******************************************************************************************
        // Attribute: @objectName
        //
        // @description
        //
@attributeComments
        //******************************************************************************************
@attributeMethods

@end rule: attribute

@start rule: operation

        // *****************************************************************************************
        //  Operation: @objectName
        // *****************************************************************************************

        /**
         * @description
         *
@operationParamsDoc
@returnValueDescriptionDoc
@operationExceptionsDoc
         */

        public @operationReturnType @objectName ( @operationParams )
                @operationExceptions;

@end rule: operation

@start rule: main
@packageDescriptor
import javax.management.*;

@imports

/**
 * @description
 *
@mBeanJavaDocComments
 */
public interface @mBeanIntfFileName extends weblogic.management.commo.StandardInterface@extendsSpec
{
    // **********************************************************************************************
    // **********************************************************************************************
    // ********************************** A T T R I B U T E S ***************************************
    // **********************************************************************************************
    // **********************************************************************************************
        @attributeList

    // **********************************************************************************************
    // **********************************************************************************************
    // **********************************  O P E R A T I O N S  *************************************
    // **********************************************************************************************
    // **********************************************************************************************
        @operationsList

}
@end rule: main
