@start rule: package
package @packageName;

@end rule: package

@start rule: import
import @importName;

@end rule: import

@start rule: mBeanListenerRegistration
      addNotificationListener (new MBeanListener (objName,  // &&& per Listen directive
                                             new MBeanListenerFilter(), null);
@end rule: mBeanListenerRegistration

@start rule: mBeanListenerSupport
   // generic listener (per Listen directive)
   class MBeanListener implements NotificationListener
   {
        ObjectName objName = null;
        MBeanListener (ObjectName objName)
        {
            this. objName = objName;
        }

        public void handleNotification(javax.management.Notification note, Object handback)
        {
            // &&&  ADD YOUR CODE HERE &&&
        }
   }

   // generic notification filter per Listen directive
   class MBeanListenerFilter implements NotificationFilter
   {
        ObjectName objName = null;

        MBeanListener (ObjectName objName)
        {
            this. objName = objName;
        }

        public boolean isNotificationEnabled(Notification notification);
        {
            // &&&  ADD YOUR CODE HERE &&&
            return true;
        }
   }
@end rule: mBeanListenerSupport

@start rule: main
//@@packageDescriptor
import javax.management.*;
import javax.management.modelmbean.*;
import weblogic.management.commo.CommoModelMBeanInfoSupport;
import weblogic.management.commo.CommoModelMBeanAttributeInfo;
import weblogic.management.commo.CommoModelMBeanOperationInfo;
import weblogic.management.commo.CommoModelMBeanNotificationInfo;
import weblogic.management.commo.CommoModelMBeanConstructorInfo;
import java.lang.reflect.*;
import java.io.*;

@imports
public @checkAbstract class @mBeanMBIFileName
  implements java.io.Serializable
{
   static final long serialVersionUID = @versionID;

   //static public void main (String[] args)
   public @mBeanMBIFileName(String path) throws Exception
   {
      ModelMBeanInfo  info = makeModelMBeanInfo();
      FileOutputStream fos = new FileOutputStream(path + "@mBeanName.mbi", false);
      ObjectOutputStream oos = new ObjectOutputStream(fos);
      oos.writeObject(info );
      oos.flush();
      oos.close();
    }

   static public ModelMBeanInfo makeModelMBeanInfo()
        throws ClassNotFoundException, MBeanException, NoSuchMethodException
   {
      ModelMBeanInfo mmbiSuper = null; //@superInfo;
      Class cl = null;
      try { cl = Class.forName("@packageName.@delegateClassName"); }
      catch (ClassNotFoundException cnfx) {} // ignore - impl not required
      CommoModelMBeanInfoSupport mmi=null;
      javax.management.Descriptor descr = null;

      // ***** ATTRIBUTES INFO

@attributeDefinitions

       CommoModelMBeanAttributeInfo infoAttributesOld[] = (mmbiSuper!=null) ? (CommoModelMBeanAttributeInfo[]) mmbiSuper.getAttributes() : null;
       CommoModelMBeanAttributeInfo infoAttributesNew[] = new CommoModelMBeanAttributeInfo[]
       {
@attributeVariableList
       };
       CommoModelMBeanAttributeInfo infoAttributes[] = infoAttributesNew;
       if ( infoAttributesOld != null )
       {
           infoAttributes = new CommoModelMBeanAttributeInfo [infoAttributesOld.length + infoAttributesNew.length];
           System.arraycopy (infoAttributesOld, 0, infoAttributes, 0, infoAttributesOld.length);
           System.arraycopy (infoAttributesNew, 0, infoAttributes, infoAttributesOld.length, infoAttributesNew.length);
       }

      // ***** OPERATIONS INFO

@operationDefinitions

@operationDefinitionsPerAccessors

       CommoModelMBeanOperationInfo infoOperationsOld[] = (mmbiSuper!=null) ? (CommoModelMBeanOperationInfo[]) mmbiSuper.getOperations() : null;
       CommoModelMBeanOperationInfo infoOperationsNew[] = new CommoModelMBeanOperationInfo []
       {
@operationVariableList
       };
       CommoModelMBeanOperationInfo infoOperations[] = infoOperationsNew;
       if ( infoOperationsOld != null )
       {
           infoOperations = new CommoModelMBeanOperationInfo [infoOperationsOld.length + infoOperationsNew.length];
           System.arraycopy (infoOperationsOld, 0, infoOperations, 0, infoOperationsOld.length);
           System.arraycopy (infoOperationsNew, 0, infoOperations, infoOperationsOld.length, infoOperationsNew.length);
       }

      // ***** CONSTRUCTORS INFO
//@@constructorDefinitions

//       ModelMBeanConstructorInfo infoConstructorsOld[] = (mmbiSuper!=null) ? (ModelMBeanConstructorInfo[]) mmbiSuper.getConstructors() : null;
//       ModelMBeanConstructorInfo infoConstructorsNew[] = new ModelMBeanConstructorInfo []
//       {
//@@constructorVariableList
//       };
//       ModelMBeanConstructorInfo infoConstructors[] = infoConstructorsNew;
//       if ( infoConstructorsOld != null )
//       {
//	   infoConstructors = new CommoModelMBeanConstructorInfo [infoConstructorsOld.length + infoConstructorsNew.length];
//	   System.arraycopy (infoConstructorsOld, 0, infoConstructors, 0, infoConstructorsOld.length);
//	   System.arraycopy (infoConstructorsNew, 0, infoConstructors, infoConstructorsOld.length, infoConstructorsNew.length);
//       }

      // ***** NOTIFICATIONS INFO
@notificationDefinitions

       CommoModelMBeanNotificationInfo infoNotificationsOld[] = (mmbiSuper!=null) ? (CommoModelMBeanNotificationInfo[]) mmbiSuper.getNotifications(): null;
       CommoModelMBeanNotificationInfo infoNotificationsNew[] = new CommoModelMBeanNotificationInfo []
       {
@notificationVariableList
       };
       CommoModelMBeanNotificationInfo infoNotifications[] = infoNotificationsNew;
       if ( infoNotificationsOld != null )
       {
           infoNotifications = new CommoModelMBeanNotificationInfo [infoNotificationsOld .length + infoNotificationsNew.length];
           System.arraycopy (infoNotificationsOld, 0, infoNotifications, 0, infoNotificationsOld.length);
           System.arraycopy (infoNotificationsNew, 0, infoNotifications, infoNotificationsOld.length, infoNotificationsNew.length);
       }


      // ***** MBEAN INFO

      //mmi = new ModelMBeanInfoSupport("@packageName.@delegateClassName",  		// class
      mmi = new CommoModelMBeanInfoSupport("weblogic.management.commo.CommoModelMBean",  // class
                                      "", 				// description
                                      infoAttributes,                   // attributes
                                      null,// infoConstructors,                 // constructors
                                      infoOperations,                   // operations
                                      infoNotifications);               // notifications

      //Descriptor descriptors[] = (mmbiSuper!=null) ? mmbiSuper.getDescriptors("mbean") : null;
      //if ( (descriptors==null) || ((descr = descriptors[0])==null ))
      //        descr = Commo.makeMBeanDescriptorSupport();
      descr = CommoModelMBeanInfoSupport.makeMBeanDescriptorSupport();
      descr.setField ("descriptorType", "mbean"); // required
      descr.setField ("interfaceClassName", "@packageName.@interfaceClassName");
      descr.setField ("delegateClassName", "@packageName.@delegateClassName");
@mBeanDescriptors
      mmi.setMBeanDescriptorNoClone (descr);
      mmi.removeDefaultData();

      return mmi;
   }
}

@end rule: main

@start rule: attributeVariableElem
            @attributeVariable,
@end rule: attributeVariableElem

@start rule: attributeDefinition

      //        ***  @objectName ***

      CommoModelMBeanAttributeInfo @attributeVariable
            = new CommoModelMBeanAttributeInfo (
                    "@objectName",  // name
                    "@typeDescriptor",  // type
                    "@description",  // description
                     @attributeIsReadable, // readable
                     @attributeIsWriteable, // writeable
                     @attributeIsIs );  // boolean with is form

      descr = @attributeVariable.getDescriptorNoClone();

      descr.setField ("descriptorType", "attribute"); // required
@attributeDescriptors
      //@attributeVariable.setDescriptorNoClone (descr);
@end rule: attributeDefinition

@start rule: descriptorOther
      descr.setField("@tagName", @tagValue);
@end rule: descriptorOther

@start rule: descriptorDefaultValueString
      descr.setField("default", "@tagValue");
@end rule: descriptorDefaultValueString

@start rule: descriptorString
      descr.setField("@tagName", "@tagValue");
@end rule: descriptorString

@start rule: attributeVariable
mmai_@objectName
@end rule: attributeVariable

@start rule: operationGetterDefinition
      //        ***  generated getter operation for @objectName ***

      Method @attributeGetMethodName@count =
        cl.getMethod ("@attributeGetterName",new Class[]{});
      CommoModelMBeanOperationInfo mmoi_@attributeGetMethodName@count =
        new CommoModelMBeanOperationInfo ("", @attributeGetMethodName@count);

      descr = mmoi_@attributeGetMethodName@count.getDescriptorNoClone();
      descr.removeField ("class");
      //mmoi_@attributeGetMethodName@count.setDescriptorNoClone (descr);

@end rule: operationGetterDefinition

@start rule: operationSetterDefinition
      //        ***  generated setter operation for @objectName ***

      Method @attributeSetMethodName@count =
        cl.getMethod ("@attributeSetterName",new Class[]{ @attributeTypeType });
      CommoModelMBeanOperationInfo mmoi_@attributeSetMethodName@count =
        new CommoModelMBeanOperationInfo ("", @attributeSetMethodName@count );

      descr = mmoi_@attributeSetMethodName@count.getDescriptorNoClone();
      descr.removeField ("class");
      //mmoi_@attributeSetMethodName@count.setDescriptorNoClone (descr);

@end rule: operationSetterDefinition

@start rule: operationElementAcessorDefinitions
      //        ***  extended index get method for array @objectName ***

      Method @attributeArrayIndexGetterName@count =
        cl.getMethod ("@attributeArrayIndexGetterName",new Class[]{ Integer.TYPE });
      CommoModelMBeanOperationInfo mmoi_@attributeArrayIndexGetterName@count =
        new CommoModelMBeanOperationInfo ("", @attributeArrayIndexGetterName@count );

      descr = mmoi_@attributeArrayIndexGetterName@count.getDescriptorNoClone();
      descr.removeField ("class");
      //mmoi_@attributeArrayIndexGetterName@count.setDescriptorNoClone (descr);

      //        ***  extended index set method for array @objectName ***


      Method @attributeArrayIndexSetterName@count =
        cl.getMethod ("@attributeArrayIndexSetterName",new Class[]{ Integer.TYPE, @attributeTypeTypeSimple });
      CommoModelMBeanOperationInfo mmoi_@attributeArrayIndexSetterName@count =
        new CommoModelMBeanOperationInfo ("", @attributeArrayIndexSetterName@count );

      descr = mmoi_@attributeArrayIndexSetterName@count.getDescriptorNoClone();
      descr.removeField ("class");
      //mmoi_@attributeArrayIndexSetterName@count.setDescriptorNoClone (descr);

@end rule: operationElementAcessorDefinitions

@start rule: operationDefinition

      //        ***  @objectName  ***

      CommoModelMBeanOperationInfo mmoi_@objectName@count = null;
      {
        Class[] params = new Class[]
        {
            @operationParamTypeList
        };
        Method @objectName =
          cl.getMethod ("@objectName",params);
        mmoi_@objectName@count =
          new CommoModelMBeanOperationInfo ("", @objectName );

        descr = mmoi_@objectName@count.getDescriptorNoClone();

        descr.setField ("descriptorType", "operation"); // required
        descr.setField ("role","operation"); // required
@operationDescriptors
        descr.removeField ("class");
        //mmoi_@objectName@count.setDescriptorNoClone (descr);
      }
@end rule: operationDefinition

@start rule: operationVariable
mmoi_@objectName@count
@end rule: operationVariable

@start rule: operationGetterVariable
mmoi_@attributeGetMethodName@count
@end rule: operationGetterVariable

@start rule: operationSetterVariable
mmoi_@attributeSetMethodName@count
@end rule: operationSetterVariable

@start rule: operationIndexSetterVariable
mmoi_@attributeArrayIndexSetterName@count
@end rule: operationIndexSetterVariable

@start rule: operationIndexGetterVariable
mmoi_@attributeArrayIndexGetterName@count
@end rule: operationIndexGetterVariable

@start rule: constructorVariableElem
            @constructorVariable,
@end rule: constructorVariableElem

@start rule: operationVariableElem
            @operationVariable,
@end rule: operationVariableElem

@start rule: operationGetterVariableElem
            @operationGetterVariable,
@end rule: operationGetterVariableElem

@start rule: operationSetterVariableElem
            @operationSetterVariable,
@end rule: operationSetterVariableElem

@start rule: operationIndexAccessorVariableElems
            @operationIndexGetterVariable,
            @operationIndexSetterVariable,
@end rule: operationIndexAccessorVariableElems

@start rule: constructorDefinition

      //        ***  constructor @count for @mBeanMBIFileName  ***

      CommoModelMBeanConstructorInfo mmci_@mBeanMBIFileName@count = null;
      {
        Class[] params = new Class[]
        {
            @operationParamTypeList
        };
        Constructor @mBeanMBIFileName =
          cl.getConstructor (params);
        mmci_@mBeanMBIFileName@count =
          new CommoModelMBeanConstructorInfo ("", @mBeanMBIFileName );

        descr = mmci_@mBeanMBIFileName@count.getDescriptorNoClone();

        descr.setField ("descriptorType", "operation"); // required
        descr.setField ("role","constructor"); // required
@constructorDescriptors
        //mmci_@mBeanMBIFileName@count.setDescriptorNoClone (descr);
      }
@end rule: constructorDefinition

@start rule: constructorVariable
mmci_@mBeanMBIFileName@count
@end rule: constructorVariable

@start rule: notificationDefinition

      //        ***  Notification: [@notificationTypes] ***

      CommoModelMBeanNotificationInfo @notificationVariable
            = new CommoModelMBeanNotificationInfo (
                    new String[]{"@notificationTypes"},  // type strings xxxx
                    "@className", // class
                    "@description" );  // description

      descr = @notificationVariable.getDescriptorNoClone();

      descr.setField ("descriptorType", "notification"); // required
@notificationDescriptors
      //@notificationVariable.setDescriptorNoClone (descr);
@end rule: notificationDefinition

@start rule: notificationClassDefinition
//notificationclass_TBD
@end rule: notificationClassDefinition

@start rule: getterMethodDefinition

        // *****************************************************************************************
        //    Get Method for Attribute @objectName
        // *****************************************************************************************

        /**
         * Get method for attribute @objectName
         */

        public @attributeType @attributeGetterName ()
        {
                @attributeType returnValue = @attributeValue;

                // &&& add your code here

                return returnValue;
        }

@end rule: getterMethodDefinition

@start rule: setterMethodDefinition

        // *****************************************************************************************
        //    Set Method for Attribute @objectName
        // *****************************************************************************************

        /**
         * Set method for attribute @objectName
         *
         * @@param newValue - new value for attribute @objectName
         * @@exception InvalidAttributeValueException
         */

        public void @attributeSetterName (@attributeType newValue)
                throws InvalidAttributeValueException
        {

                // &&& add your code here

        }

@end rule: setterMethodDefinition

@start rule: arrayIndexGetterMethodDefinition

        // *****************************************************************************************
        //    Array Index Get Method for Attribute @objectName
        // *****************************************************************************************

        /**
         * Array index getter method for array attribute @objectName
         *
         * @@param index- index of entry being returned
         */

        public @attributeTypeSimple @attributeArrayIndexGetterName (int index)
        {
                try
                {
                        @attributeType array = (@attributeType)getAttribute ("@objectName");
                        return array[index];
                }
                catch ( ReflectionException rx ) { rx.printStackTrace(); }
                catch ( MBeanException mx ) { mx.printStackTrace(); }
                catch ( AttributeNotFoundException mx ) { mx.printStackTrace(); }
                return null;
        }

@end rule: arrayIndexGetterMethodDefinition

@start rule: arrayIndexSetterMethodDefinition

        // *****************************************************************************************
        //    Array Index Set Method for Attribute @objectName
        // *****************************************************************************************

        /**
         * Array index setter method for array attribute @objectName
         *
         * @@param index- index of entry being set
         * @@param newValue - new value for attribute @objectName at provided index
         * @@exception InvalidAttributeValueException
         */

        public void @attributeArrayIndexSetterName (int index, @attributeTypeSimple newValue)
                throws InvalidAttributeValueException
        {
                try
                {
                        @attributeType array = (@attributeType)getAttribute ("@objectName");
                        array [index] = newValue;
                        Attribute attribute = new Attribute ("@objectName", array);
                        setAttribute (attribute);
                }
                catch ( ReflectionException rx ) { rx.printStackTrace(); }
                catch ( MBeanException mx ) { mx.printStackTrace(); }
                catch ( AttributeNotFoundException mx ) { mx.printStackTrace(); }
      }

@end rule: arrayIndexSetterMethodDefinition

@start rule: operationMethodDefinition

        // *****************************************************************************************
        //    Operation: @objectName
        // *****************************************************************************************

        /**
         * @description
         *
@operationParamsDoc
@operationExceptionsDoc
         */

        public @operationReturnType @objectName( @operationParams )
                throws MBeanException @operationExceptions
        {
                @operationReturnType returnValue = @operationReturnValue;

                // &&& add your code here

                return returnValue;
        }

@end rule: operationMethodDefinition

@start rule: constructorMethodDefinition

        // *****************************************************************************************
        //    Constructor for @mBeanMBIFileName
        // *****************************************************************************************

        /**
         * @description
         *
@operationParamsDoc
@operationExceptionsDoc
         */

        public @mBeanMBIFileName ( @operationParams )
                throws MBeanException,
                ClassNotFoundException, MBeanException,
                NoSuchMethodException, InvalidTargetObjectTypeException,
                InstanceNotFoundException @operationExceptions
        {
                super();
                init_@mBeanMBIFileName ();

                // &&& add your code here

        }

@end rule: constructorMethodDefinition

@start rule: operationParamDoc
         * @@param @paramName - @paramDescription
@end rule: operationParamDoc

@start rule: operationExceptionDoc
         * @@exception @exceptionName
@end rule: operationExceptionDoc
