

@start rule: main
@genPackageDeclaration

import java.io.Serializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.NotificationListener;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanException;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.management.MBeanHome;
import weblogic.management.internal.MBeanProxy;
import weblogic.management.WebLogicMBean;
import weblogic.management.WebLogicObjectName;
import weblogic.management.ManagementRuntimeException;;

/**
 * @genAuthor Copyright (c) @year by BEA. All Rights Reserved.
 * @@exclude
 */
public final class @genClassName
  extends MBeanProxy
  implements @genInterfaceName, NotificationListener, Serializable, InteropWriteReplaceable
{
  @genOptionalSVUID
  private @genInterfaceName delegate;

  //Enable Caching ONLY for localConfig mbeans
  private boolean enableCaching;

  @constructor

  @genAccessors

  @genOperations

  @notificationHandler

  public WebLogicMBean getDelegate() { return delegate; }


  private void writeObject(ObjectOutputStream stream)
    throws IOException, ClassNotFoundException
  {
    super.writeObjectForCachingStubs(stream);
  }

  private void readObject(ObjectInputStream stream)
    throws IOException, ClassNotFoundException
  {
    super.readObjectForCachingStubs(stream);
    //No caching for remote clients(for admin/config/runtime)
    enableCaching = false;
  }

  public String toString() {
    return "[Caching Stub]" + super.toString();
  }

  /**
   * Always replace with delegate upon serialization.  Don't worry
   */
   /*
  private Object writeReplace() throws java.io.ObjectStreamException
  {
    // return delegate;
    return new @genClassName(super.objectName, super.mbeanHome );
  }
  */

}

@end rule: main

@start rule: constructor
  public @genClassName(ObjectName name, MBeanHome home)
  {
    super(name,home);
    enableCaching = WebLogicObjectName.isConfig(name);
    if (enableCaching) addNotificationListener(this, null, null);
  }
@end rule: constructor

@start rule: attributeDeclaration
  /*
   * Declaration of @genAttributeName
   */
  private boolean @genAttributeIsCached = false;
  private @genAttributeType @genAttributeFieldName;
@end rule: attributeDeclaration

@start rule: getter
  /**
   * Getter for @genAttributeName
   */
  public @genAttributeType @genMethodName()
    @genThrowsClause
  {
    try {
      if (!enableCaching || !@genAttributeIsCached) {
        Object returnedObject = invokeForCachingStub("@genMethodName",null);
        @genAttributeFieldName = @genTypeCastedExpressionforReturnedObject;
        if (isCachable("@genMethodName")) @genAttributeIsCached = true;
      }
    } catch (Throwable thr) {
      if (thr instanceof RuntimeException) throw (RuntimeException)thr;
      @genThrowException
    }
    return @genAttributeFieldName;
  }
@end rule: getter

@start rule: setter
  /**
   * Setter for @genAttributeName
   */
  public void @genMethodName(@genAttributeType arg0)
    @genThrowsClause
  {
    try {
      invokeForCachingStub("@genMethodName",new Object[]{  @genParameters });
      @genAttributeFieldName = arg0;
      @genAttributeIsCached = true;
    } catch (Throwable thr) {
      if (thr instanceof RuntimeException) throw (RuntimeException)thr;
      @genThrowException
    }
  }
@end rule: setter

@start rule: operation
  /**
   * Operation @genMethodName
   */
  public @genReturnType @genMethodName(
    @genParameterList
  )
    @genThrowsClause
  {
  @genOperationBody
  }
@end rule: operation

@start rule: operationBody
    Object returnedObject=null;
    try {
      returnedObject = invokeForCachingStub("@genMethodName", new Object[]{ @genParameters });
    } catch (Throwable thr) {
      if (thr instanceof RuntimeException) throw (RuntimeException)thr;
      @genThrowException
    }
    return @genTypeCastedExpressionforReturnedObject;

@end rule: operationBody

@start rule: voidOperationBody
   try {
      invokeForCachingStub("@genMethodName", new Object[]{ @genParameters });
    } catch (Throwable thr) {
      if (thr instanceof RuntimeException) throw (RuntimeException)thr;
      @genThrowException
    }
@end rule: voidOperationBody

@start rule: notificationHandler
  /**
   * Invalidates attribute value cache if the value has changed
   */
  public void handleNotification(Notification notification, Object handback)
  {
    if (notification instanceof AttributeChangeNotification) {
      @genAttributeCacheInvalidatorFragment
    }
  }
@end rule: notificationHandler

// NOTE reto@bea.com 2001-Nov-13 -- Flush the cache of all attributes
// whenever any attribute changes.  This is so that derived attributes,
// that do not have the setX ever call (e.g. custom impl getX) are
// not stuck with stale values (since setX is never called on those).
@start rule: attributeCacheInvalidator
  @genAttributeIsCached = false;
@end rule: attributeCacheInvalidator











